---
layout: post
title:  第54期
---

# C++ 中文周刊 第54期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-321.html)摘抄一些c++动态


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-03-16 第141期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-03-16.md)



## 文章

- [Optimizing Oklab gradients](https://aras-p.info/blog/2022/03/11/Optimizing-Oklab-gradients/)

看不懂说的啥

- [To Save C, We Must Save ABI](https://thephd.dev/to-save-c-we-must-save-abi-fixing-c-function-abi)

讨论了ABI带来的兼容问题

- [Optimizing code to darken a bitmap, part 5](https://devblogs.microsoft.com/oldnewthing/20220311-00/?p=106340)

第五版优化用上了arm的sse指令重写

- [New C++23 range adaptors](https://mariusbancila.ro/blog/2022/03/16/new-cpp23-range-adaptors/)

学习一下

join_view

```cpp
using namespace std::ranges;
auto l_as_string = []<typename R>(R range){
   return std::string(std::begin(range), std::end(range));
};
std::vector<std::string> words{"this", "is", "a", "demo"};
auto text = l_as_string(words | views::join_with(' '));
std::cout << text << '\n'; // "this is a demo"
```

zip_view

先看个zip
```cpp
std::array<int, 4> n{ 1, 2, 3, 4 };
std::vector<std::string> w{ "one","two","three" };
auto z1 = views::zip(n, w) // { (1, "one"), (2, "two"), (3, "three") }
for(auto t : z1)
   std::cout << std::get<0>(t) << '-' 
             << std::get<1>(t) << '\n';
```

zip_view

```cpp
auto l_concat = [](int n, std::string const& s) {
   return std::to_string(n) + "-" + s;
};
auto z2 = views::zip_transform(l_concat, n, w); // {"1-one", "2-two", "3-three"}
for (auto e : z2) 
   std::cout << e << '\n';
```

- [overload 167](https://accu.org/journals/overload/30/167/overload167.pdf)
  这是个期刊，每期都会录入几篇文章，文章很长。内容标题是
    - What are you optimizing for? 没啥说的
    - Revisiting Data-Oriented Design
    - An Associative Container for Non-bash Shell Scripts
    - C++20 Benefits: Consistency With Ranges
  

没啥值得说的

- [PartialExecuter: Reducing WebAssembly size by exploring all executions in LLVM](https://medium.com/leaningtech/partialexecuter-reducing-webassembly-size-by-exploring-all-executions-in-llvm-f1ee295e8ba)

讲llvm给wasm减少体积

- [libriscv: Multiprocessing for Compute Functions](https://fwsgonzo.medium.com/multiprocessing-in-a-risc-v-emulator-ce910122f4f1)

开发simulater遇到的问题 代码在[这里](https://github.com/fwsGonzo/libriscv/tree/multiprocessing)


- [The Discovery and Exploitation of CVE-2022-25636](https://nickgregory.me/linux/security/2022/03/12/cve-2022-25636/)

讲作者怎么发现的这个缺陷以及复现过程，做安全的朋友可以看看。简单来说就是数组边界没检查，但触发这个场景构造了挺多东西

## 视频

- [C++ Weekly- Ep 315 - constexpr vs static constexpr](https://www.youtube.com/watch?v=IDQ0ng8RIqs)

尽量用static constexpr，编译期。快。有人用压测挑战了up主，说static constexpr并不比constexpr快，并给了一个bench链接，这个视频是作者的调试过程。简单来说，那个bench场景有问题，数据小，数据局部性太高，constexpr默认是栈变量，cache友好的结果，实际上数据量一大 static constexpr明显优于constexpr

### 更新一波cppcon 2021

- [Using Clang LibASTMatchers for Compliance in Codebases - Jonah Jolley - CppCon 2021](https://www.youtube.com/watch?v=icvNkYextOo)

对clang感兴趣的可以看看

- [Back to Basics: Smart Pointers and RAII - Inbal Levi - CppCon 2021](https://www.youtube.com/watch?v=07rJOzFRs6M)

讲所有权的。感兴趣的可以看看

- [Code Size Compiler Optimizations and Techniques for Embedded Systems - Aditya Kumar - CppCon 2021](https://www.youtube.com/watch?v=JOBs3l1jAkw)

嵌入式场景编译器优化减小程序体积
体积影响分发。从二进制角度观测/评估哪里可以省掉，用[bloaty](https://github.com/google/bloaty)查
比如strip 减少内联 (`__attribute__((noinline))`)/模板实例化以及二进制工具修改
编译选项，-Os -flto -Wl,--strip-all (不要-g) -fno-unroll-loops -fno-exception -fno-rtti
以及编译器本身提供的减少体积的选项，比如thin-lto(llvm) -fmerge-all-constant -mllvm hot-cold-split

代码组织上，不要继承不要类不要lambda，不要复制，实现移出头文件，数据结构简单就好，算法用简单的，不需要考虑性能问题，够用，拷贝尽量用memcpy

还有一些邪魔外道我没有列出。后面直接贴出ppt链接，有兴趣的可以点视频看看

- [Debugging Assembly Language and GPU Kernels in Visual Studio Code - Julia Reid - CppCon 2021](https://www.youtube.com/watch?v=A1Pu1yXfI94)

谁用vscode调代码啊，你用吗，我不用。

- 推荐观看 [Embracing `noexcept` Operators and Specifiers Safely - John Lakos - CppCon 2021](https://www.youtube.com/watch?v=3GwNjGMKBtI)

如果一个类只声明不实现，不能保证成员函数是noexpect(true)的（析构函数除外），之前咱们也聊过zero cost exception相关
这个视频讨论了noexcept的方方面面。比较深入。值得一看。

- [Embracing (and also Destroying) Variant Types Safely - Andrei Alexandrescu - CppCon 2021](https://www.youtube.com/watch?v=va9I2qivBOA&t=94s)

实现variant/访问需要注意一些问题。AA手把手带你写代码

- [Cool New Stuff in Gdb 9 and Gdb 10 - Greg Law - CppCon 2021](https://www.youtube.com/watch?v=xSnetY3eoIk)

介绍gdb新特性，新命令，和python更好的交互等等。没细看

- [Finding Bugs Using Path-Sensitive Static Analysis - Gabor Horvath - CppCon 2021](https://www.youtube.com/watch?v=B3kUHgTsbxc)

VS的静态检测工具，分析分支，跟踪指针生命周期

- [Up to Code - David Sankel - CppCon 2021](https://www.youtube.com/watch?v=r_U9YFPWxEE&t=157s)

讲哲学的，太抽象了。没看

- [C++20’s ＜chrono＞ Calendars and Time Zones in MSVC - Miya Natsuhara - CppCon 2021](https://www.youtube.com/watch?v=Dq7rqjatxz8)

msvc的chrono实现。如何支持date timezone等等，API走读(评论区评论非常多。难道是妹子解说就人多吗)

- [Custom Views for the Rest of Us - Jacob Rice - CppCon 2021](https://www.youtube.com/watch?v=P9XXJuAYhMQ) 

讲range view的。对相关概念感兴趣的可以看看

- [Back To Basics: Debugging Techniques - Bob Steagall - CppCon 2021](https://www.youtube.com/watch?v=M7fV-eQwxrY)

手把手教你解bug

- ["unit"_test: Implementing a Macro-free Unit Testing Framework from Scratch in C++20 - Kris Jusiak](https://www.youtube.com/watch?v=-qAXShy1xiE)

介绍boostext.ut 这个库用用户自定义前缀 UDL来实现单测的模型，而不是用宏展开。比较优雅。之前也介绍过

- [Zen and the Art of Code Lifecycle Maintenance - Phil Nash - CppCon 2021](https://www.youtube.com/watch?v=qGnF4O5nUF4)

讲哲学的我是真听不进去

### cppp

- [Exceptional C++ - Victor Ciura - CPPP 2021](https://www.youtube.com/watch?v=PSgY2ZLSrY0)

介绍SEH的

- [Just Enough Assembly for Compiler Explorer - Anders Schau Knatten - CPPP 2021](https://www.youtube.com/watch?v=188ACW-efHE)

手把手带你看汇编。这个视频好像推了好几次了。真的值得一看


## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

-   [Simple 3D math study ](https://github.com/oWASDo/3DMath)

## 工作招聘

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/054.html)
