---
layout: post
title:  第52期
---

# C++ 中文周刊 第52期



从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-319.html)摘抄一些c++动态


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-03-02 第139期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-03-02.md)


## 文章

- [Curious lack of sprintf scaling](https://aras-p.info/blog/2022/02/25/Curious-lack-of-sprintf-scaling/)

数字转字符串 sprintf性能，非常垃圾，使用`fmt`或者`std::to_chars`

- [Did you know wrapping an unqualified function name in parentheses suppresses argument-dependent lookup? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/266.md)

```c++
namespace adl {
    struct foo {};
    void bar(foo) {}
}

int main() {
    adl::foo foo;
    bar(foo);   // OK,    ADL
    (bar)(foo); // error: no ADL
}
```
就是名字空间内的查找
- [Did you know that C++23 added std::unreachable?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/267.md)

```c++
#include <utility>

int main() {
    std::unreachable();
    return 42; // invokes undefined behavior
}
```
没啥说的，类似`assert(false)`

- [Did you know that C++20 added std::erase_if for std::map and std::vector?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/268.md)

```c++
int main() {
  std::vector v{1, 2, 3, 4};
  assert(4 == std::size(v));
  std::erase_if(v, [](const auto& e) { return e % 2;} );
  assert(2 == std::size(v));
  assert(v[0] == 2 and v[1] == 4);
}
```
没啥说的

- [Image Sharpening Convolution Kernels](https://blog.demofox.org/2022/02/26/image-sharpening-convolution-kernels/)
  
手把手教你图像过滤，看不懂
- [Picking Fairly From a List of Unknown Size With Reservoir Sampling](https://blog.demofox.org/2022/03/01/picking-fairly-from-a-list-of-unknown-size-with-reservoir-sampling/)

图像sample 看不懂

- [Mocking virtual functions with gMock](https://www.sandordargo.com/blog/2022/03/02/mocking-non-virtual-and-free-functions)

手把手教你gmock
- [wordlexpr: compile-time wordle in c++20](https://vittorioromeo.info/index/blog/wordlexpr.html)

几个需求，编译期打印字符串，编译期生成随机数
第一个简单，就是fixed_string+static assert

```c++
struct ct_str
{
    char        _data[512]{};
    std::size_t _size{0};

    template <std::size_t N>
    constexpr ct_str(const char (&str)[N]) : _data{}, _size{N - 1}
    {
        for(std::size_t i = 0; i < _size; ++i)
            _data[i] = str[i];
    }
};

template <ct_str> struct print;

constexpr ct_str test()
{
    ct_str s{"Welcome to Wordlexpr!"};
    s._data[0] = 'w';
    s._data[11] = 'w';
    s._data[20] = '.';
    return s;
}

print<test()> _{};
```

第二个就是用fixed_string来做生成随机数的生成器，让外部指定seed和字符串，然后编译的时候改一改就行了

- [What if vector<T>::iterator were just T*?](https://quuxplusone.github.io/blog/2022/03/03/why-isnt-vector-iterator-just-t-star/)

语言律师新活，如果itor是T*，会有一大堆冲突问题，后面是一大堆列举。这里不提了

  
- [Zero-cost exceptions aren’t actually zero cost](https://devblogs.microsoft.com/oldnewthing/20220228-00/?p=106296)

感谢@LH_Mouse 纠正。这里指的是是实现的不可见导致的开销。实现的不可见(不内联场景)，编译器可能假定抛出异常，假定不是const。所以这里不是zero cost。即使你不用异常也会有类似的问题

- [3 interesting behaviors of C++ casts](https://belaycpp.com/2022/03/02/3-interesting-behaviors-of-c-casts/)
介绍cast

- [C++ header files and inter-class connections](https://rachelbythebay.com/w/2022/02/26/include/)

c++编译依赖和头文件的问题。属于老生常谈的讨论

- [C++ Benchmarking Tips for Beginners](https://unum.cloud/post/2022-03-04-gbench/)

google benchmark教程，几个案例

基本的阻止优化
```c++
static void i32_addition_semirandom(bm::State &state) {
    int32_t a = std::rand(), b = std::rand(), c = 0;
    for (auto _ : state)
        bm::DoNotOptimize(c = (++a) + (++b));
}
```

一个简单的数学算法对比
```c++
static void f64_sin(bm::State &state) {
    double argument = std::rand(), result = 0;
    for (auto _ : state)
        bm::DoNotOptimize(result = std::sin(argument += 1.0));
}

static void f64_sin_maclaurin(bm::State &state) {
    double argument = std::rand(), result = 0;
    for (auto _ : state) {
        argument += 1.0;
        result = argument - std::pow(argument, 3) / 6 + std::pow(argument, 5) / 120;
        bm::DoNotOptimize(result);
    }
}
static void f64_sin_maclaurin_powless(bm::State &state) {
    double argument = std::rand(), result = 0;
    for (auto _ : state) {
        argument += 1.0;
        result = argument - (argument * argument * argument) / 6.0 +
                 (argument * argument * argument * argument * argument) / 120.0;
        bm::DoNotOptimize(result);
    }
}

[[gnu::optimize("-ffast-math")]]
static void f64_sin_maclaurin_with_fast_math(bm::State &state) {
    double argument = std::rand(), result = 0;
    for (auto _ : state) {
        argument += 1.0;
        result = argument - (argument * argument * argument) / 6.0 +
                 (argument * argument * argument * argument * argument) / 120.0;
        bm::DoNotOptimize(result);
    }
}
```
注意这个attrbute用法。最后一种非常快

整数除法

```c++
static void i64_division(bm::State &state) {
    int64_t a = std::rand(), b = std::rand(), c = 0;
    for (auto _ : state)
        bm::DoNotOptimize(c = (++a) / (++b));
}

static void i64_division_by_const(bm::State &state) {
    int64_t money = 2147483647;
    int64_t a = std::rand(), c;
    for (auto _ : state)
        bm::DoNotOptimize(c = (++a) / *std::launder(&money));
}
static void i64_division_by_constexpr(bm::State &state) {
    constexpr int64_t b = 2147483647;
    int64_t a = std::rand(), b;
    for (auto _ : state)
        bm::DoNotOptimize(c = (++a) / b);
}

```
constexpr非常快

硬件加速

```c++
[[gnu::target("default")]] static void u64_population_count(bm::State &state) {
    auto a = static_cast<uint64_t>(std::rand());
    for (auto _ : state)
        bm::DoNotOptimize(__builtin_popcount(++a));
}
[[gnu::target("popcnt")]] static void u64_population_count_x86(bm::State &state) {
    auto a = static_cast<uint64_t>(std::rand());
    for (auto _ : state)
        bm::DoNotOptimize(__builtin_popcount(++a));
}
```
如果硬件支持popcnt指令，有优化提升

- [History of non-standard-layout class layouts](https://quuxplusone.github.io/blog/2022/03/04/non-standard-layout-guarantees/)

里面有个表格概括，就不截图了


## 视频

- [C++ Weekly - Ep 313 - The `constexpr` Problem That Took Me 5 Years To Fix!](https://www.youtube.com/watch?v=ABg4_EV5L3w&t=218s)

还是模板 + fixed_string/array 这种场景，如果fixed_string/array是相同的，由于模板实例化相同的实例会合并，所以说这就是一种压缩效果，复用数据段。

- [SwedenCpp YT - Arno Lepisk: Testing non-compiling code](https://www.youtube.com/watch?v=02Hu0amx-5Y&feature=emb_title)

就是static assert + type traits没啥说的

- [Petter Holmberg: Functional parsing in C++20](https://www.youtube.com/watch?v=5iXKLwoqbyw&t=901s)

又介绍个parser generator




## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线




---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/052.html)
