---
layout: post
title:  第51期
---

# C++ 中文周刊 第51期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-318.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[标准委员会二月份邮件列表](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/#mailing2022-02)

推荐阅读 [C++ exceptions are becoming more and more problematic](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/p2544r0.html)

异常，太坑了

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-02-23 第138期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-02-23.md)



## 文章

- [Linux's getrandom() Sees A 8450% Improvement With Latest Code](https://git.kernel.org/pub/scm/linux/kernel/git/crng/random.git/log/)

替换了算法，使用black而不是sha1

- [Chrome V8 源码 解读系列](https://www.zhihu.com/people/v8blink/posts)

这个人写了很多文章。对浏览器感兴趣的/业界人士可以关注一波。我不太懂就不多说了

- [My favorite C++20 feature](https://schneide.blog/2022/02/21/my-favorite-c20-feature/)

这玩意, 确实挺方便

```c++
auto request = http_request{
  .method = http_method::get,
  .uri = "localhost:7634",
  .headers = { { .name = "Authorization", .value = "Bearer TOKEN" } },
};
```

- [c++反射深入浅出 - 1. ponder 反射实现分析总篇](https://zhuanlan.zhihu.com/p/471396674)
- [c++反射深入浅出 - 2. property 实现分析](https://zhuanlan.zhihu.com/p/472265782)

解析ponder这个库。对于想学习反射的值得一看

- [A Good Way to Handle Errors Is To Prevent Them from Happening in the First Place](https://www.fluentcpp.com/2022/02/25/a-good-way-to-handle-errors-is-to-prevent-them-from-happening-in-the-first-place/)

尽可能把错误处理掉或者用optional /expect / outcame包装处理掉

- [Returning values and errors](https://rachelbythebay.com/w/2022/02/20/return/)

```c++
string* UserIP(); //1
string UserIP(string* errmsg); //2
bool GetUserIP(string* ip); //3
bool GetUserIP(string* ip, string* errmsg); //4
Result<string> UserIP(); //5
ResultString UserIP(); //6
string UserIP(); //7
```

大家觉得哪个接口好？

1肯定不行，2 3 4都需要传进个string处理，比较脏， 5是不是太复杂了，6是简单版本，但是会不会又有ResultDouble之类的东西？7简单，只有ip，errmsg不放进去，也许这个才是最优解？

开放题，没有答案

- [Implementing the FLIP algorithm](https://www.jeremyong.com/color%20theory/2022/02/19/implementing-the-flip-algorithm/)

图形学的东西，不太懂，这里标记TODO

- [Ways to Refactor Toggle/Boolean Parameters in C++](https://www.cppstories.com/2017/03/on-toggle-parameters/)

```c++
DoImportantStuff(true, false, true, false);
```

我们都知道这种参数会有莫名其妙的问题，丢失值的信息，一个两个倒还好，多了难免眼花，怎么重构，封装成enum

```c++
enum class UseCacheFlag    { False, True };
enum class DeferredFlag    { False, True };
enum class OptimizeFlag    { False, True };
enum class FinalRenderFlag { False, True };

// and call like:
RenderGlyphs(glyphs,
             UseCacheFlag::True, 
             DeferredFlag::False, 
             OptimizeFlag::True, 
             FinalRenderFlag::False);
```

使用bit flag

```c++
#include <type_traits>

struct Glyphs { };

enum class RenderGlyphsFlags
{
    useCache = 1,
    deferred = 2, 
    optimize = 4,
    finalRender = 8,
};

// simplification...
RenderGlyphsFlags operator | (RenderGlyphsFlags a, RenderGlyphsFlags b) {
    using T = std::underlying_type_t <RenderGlyphsFlags>;
    return static_cast<RenderGlyphsFlags>(static_cast<T>(a) | static_cast<T>(b));
    // todo: missing check if the new value is in range...
}

constexpr bool IsSet(RenderGlyphsFlags val, RenderGlyphsFlags check) {
    using T = std::underlying_type_t <RenderGlyphsFlags>;
    return static_cast<T>(val) & static_cast<T>(check);
    // todo: missing additional checks...
}

void RenderGlyphs(Glyphs &glyphs, RenderGlyphsFlags flags)
{
    if (IsSet(flags, RenderGlyphsFlags::useCache)) { }
    else { }

    if (IsSet(flags, RenderGlyphsFlags::deferred)) { }
    else { }

    // ...
}

int main() {
    Glyphs glyphs;
    RenderGlyphs(glyphs, RenderGlyphsFlags::useCache | RenderGlyphsFlags::optimize);                                      
}

```

结构体

```c++
struct RenderGlyphsParam
{
    bool useCache;
    bool deferred;
    bool optimize;
    bool finalRender;
};
void RenderGlyphs(Glyphs &glyphs, const RenderGlyphsParam &renderParam);

// the call:
RenderGlyphs(glyphs,
             {/*useCache*/true, 
             /*deferred*/false, 
             /*optimize*/true, 
             /*finalRender*/false});

```

c++20我们有了字段构造，字段信息终于有了

```c++
struct RenderGlyphsParam
{
    bool useCache;
    bool deferred;
    bool optimize;
    bool finalRender;
};
void RenderGlyphs(Glyphs &glyphs, const RenderGlyphsParam &renderParam);

// the call:
RenderGlyphs(glyphs,
             {.useCache = true, 
              .deferred = false, 
              .optimize = true, 
              .finalRender = false}); 

```

这个更完美一些

- [Supervising in C++: how to make your programs reliable](https://basiliscos.github.io/blog/2022/02/20/supervising-in-c-how-to-make-your-programs-reliable/) 

介绍c++一些Supervise管理策略以及actor框架使用，比较少用。基本上都是糊一个taskflow模型，不用什么let it crash。这种东西放在背后的管理系统来做。不在业务进程里做

## 视频

- [C++ Weekly - Ep 312 - Stop Using `constexpr` (And Use This Instead!) ](https://www.youtube.com/watch?v=4pKtPWcl1Go)

constexpr修饰函数，没问题

constexpr修饰值，这个值未必是编译期计算(用const可以)，取决于编译器，且 constexpr修饰的值肯定在堆栈，所以要注意作用域问题 

- [Keynote: C++'s Superpower - Matt Godbolt - CPPP 2021](https://www.youtube.com/watch?v=0_UttFDnV3k)

介绍周边生态

- [Introduction to memory exploitation - Patricia Aas - Meeting C++ 2021](https://www.youtube.com/watch?v=s18lHhN-NXc)

讲fuzzer的工作原理

- [Design of a C++ reflection API - Matúš Chochlík - Meeting C++ online](https://www.youtube.com/watch?v=BP0gsVy502w)

介绍他写的一个反射库

- [The Basics of Profiling - Mathieu Ropert - CppCon 2021](https://www.youtube.com/watch?v=dToaepIXW4s)

没啥意思。讲window profile的

- [Design and Implementation of Highly Scalable Quantifiable Data Structures in C++ - CppCon 2021](https://www.youtube.com/watch?v=ECWsLj0pgbI&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=74)

这讲的是个啥啊？论文在Parallel Computing Technologies这本书里，谁能搞个电子版，原版太贵了。愣是没听明白。这里标记TODO，有机会再看吧

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [raw pdb](https://github.com/MolecularMatters/raw_pdb) c++17一个解析pdb的库
- [ledit](https://github.com/liz3/ledit) 一个编辑器
- [HFSM2 development might slow down](https://www.reddit.com/r/cpp/comments/t0od6u/hfsm2_development_might_slow_down/) 乌克兰正在打仗，作为当地人无心工作
- [thread-pool](https://github.com/DeveloperPaul123/thread-pool) 又一个线程池实现

实现线程池我们真正需要的是什么？是一个干活线程还是任务的投递/管理？纯纯一个线程池轮子也就看看，用处不大

## 工作招聘

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/051.html)
