---
layout: post
title:  第48期
---

# C++ 中文周刊 第48期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

春节快乐各位，年前最后一更，下周也不更，安心过年吧

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新OSDT Weekly 2022-01-26 第134期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-01-26.md)

## 文章

- [**Did you know that C++23 added Monadic operations for std::optional**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/261.md)

```c++
int main() {
  auto opt = std::optional{42};
  opt.and_then([](auto o)->std::optional<int>{ std::cout << o;; return std::nullopt; });// prints 42
}
```

没啥说的，以前说过，早就该加了

- [**Did you know that type_info equality operator is constexpr in C++23?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/262.md)

```c++
#include <typeinfo>
#include <type_traits>

static_assert(std::is_same_v<int, int>);
static_assert(typeid(int) == typeid(int));

static_assert(typeid(int) == typeid(const int));
static_assert(not std::is_same_v<int, const int>);

static_assert(typeid(int) == typeid(const int&));
static_assert(not std::is_same_v<int, const int&>);
```

这东西总算不是运行时了。不然真没人用

- [`const` all the things?](https://quuxplusone.github.io/blog/2022/01/23/dont-const-all-the-things/)

出于值语意以及编译器优化角度考虑，不建议const成员，不方便move/swap，但是如果你是单例就忽略

```c++
struct Employee {
    std::string name_;  // an employee's name may change...
    const std::string id_;  // ...but never their unique ID
};

Employee e1 = {"Alice", "12345"};
Employee e2 = {"Bob", "24601"};
e1 = e2; // oops
std::swap(e1, e2); // oops
```



返回值也不建议const， 拿了不能改，图啥呢

```c++
struct Widget {
    std::string name_;
    const std::string name() const { return name_; }
};
```



局部不变量，用constexpr

```c++
constexpr size_t chunkStart = sizeof(BlockHeader) + sizeof(ChunkHeader);
```

局部返回值，不const，可能会阻止优化

```c++
std::string g(bool early) {
    if (early)
        return "";
    const std::string result = "hello";
    return result; // oops
}
```

其他场景，比如const引用传参数（大对象）该用用，没问题

- [Design and evolution of constexpr in C++](https://pvs-studio.com/en/blog/posts/cpp/0909/)

介绍constexpr的演化

- [Span - making C arrays fun since 2020](https://joshpeterson.github.io/span-making-c-arrays-fun-since-2020)

能用std::span就用，std::span做接口可以兼容std::array 内置c数组，std::vector，且前两个，最终效果一致，大大的隐藏了内置数组的坑爹效应

- [Micro C, Part 1: Parsing](https://blog.josephmorag.com/posts/mcc1/) 教你用llvm和haskell写c编译器
- [Writing a simple 16 bit VM in less than 125 lines of C](https://www.andreinc.net/2021/12/01/writing-a-simple-vm-in-less-than-125-lines-of-c)

一百行代码让你看懂VM，代码在[这里](https://github.com/nomemory/lc3-vm/blob/main/vm.c)

- [Linux 5.17 To Boast A Big TCP Performance Optimization](https://git.kernel.org/pub/scm/linux/kernel/git/netdev/net-next.git/commit/?id=6fcc06205c15bf1bb90896efdf5967028c154aba)

linux的一个patch ，TCP有性能提升

- [Simple generic parallelism idiom & C++17 specifics](https://berthub.eu/articles/posts/simple-parallelism-idiom/)

```c++
std::for_each(std::execution::par, input.cbegin(), input.cend(),
                doStuff);
```

没啥说的，c++17的东西

## 视频

- [Branchless Programming in C++ - Fedor Pikus - CppCon 2021](https://www.youtube.com/watch?v=g-WPhYREFjk)

讨论省分支的技巧，其实主要是省cpu，利用cpu的pipeline，所以循环可以展开，分支可以尽量省掉

用冒号表达式，用bool 做index的jump table

```c++
term[2] = {expr1, epxr2};
sum += term[bool(cond)];
```

likely也可以用

其实更多是演示，值得看一看

作者写了本新书The Art of Writing Efficient Program，有机会可以读读

- [Automatically Process Your Operations in Bulk With Coroutines - Francesco Zoffoli - CppCon 2021](https://www.youtube.com/watch?v=3R_Z5RO1AH4)

教你用协程来把单个操作聚合成pipeline，更高效

- [Discovering a User-Facing Concept - Christopher Di Bella - CppCon 2021](https://www.youtube.com/watch?v=T4cODK8UnXc)

没有PPT啊，这个视频讲了很多实用的concept设计

- [In-memory and Persistent Representations of C++ - Gabriel Dos Reis - CppCon 2021](https://www.youtube.com/watch?v=39wlNRk-nAg)

代码https://github.com/GabrielDosReis/ipr, https://github.com/microsoft/ifc-spec TODO没看懂干嘛的

- [Documentation in the Era of Concepts and Ranges - Christopher Di Bella & Sy Brand - CppCon 2021](https://www.youtube.com/watch?v=nm45t2fnUms)

看开源项目的文档，学学人家怎么写代码文档的

- [Design Patterns: Facts and Misconceptions - Klaus Iglberger - CppCon 2021](https://www.youtube.com/watch?v=KGX6zhOWGAc)

讲设计模式的，这名字，典型德国人

- [Implementing static_vector: How Hard Could it Be? - David Stone - CppCon 2021](https://www.youtube.com/watch?v=I8QJLGI0GOE)

手把手教你写static_vector

- [The Unit Tests Strike Back: Testing the Hard Parts - Dave Steffen - CppCon 2021](https://www.youtube.com/watch?v=t5qCxp7PJ0Q)

写单测，要写就写最难的

- [Just Enough Assembly for Compiler Explorer - Anders Schau Knatten - CppCon 2021](https://www.youtube.com/watch?v=QLolzolunJ4&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=30)

手把手教你学汇编，值得一看

- [C++20 ❤ SQL - John Bandela - CppCon 2021](https://www.youtube.com/watch?v=-P9FyevnL6U&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=73)

手把手教你用c++描述sql

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [metacpp](https://github.com/RamblingMadMan/metacpp) 一个反射库，依赖libclang

## 工作招聘

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/048.html)
