---
layout: post
title:  第47期
---

# C++ 中文周刊 第47期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-313.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 20220119 第133期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-01-19.md)

- [A simple **`defer`** feature for C](http://www.open-std.org/jtc1/sc22/wg14/www/docs/n2895.htm) 一个给c加defer的提案。。

[标准委员会一月份邮件汇总](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/#mailing2022-01)

function_ref还在讨论中 std::execution 还在讨论中

## 文章

- [The mystery of the crash that seems to be on a `std::move` operation](https://devblogs.microsoft.com/oldnewthing/20220120-00/?p=106178)
- [Fixing the crash that seems to be on a `std::move` operation](https://devblogs.microsoft.com/oldnewthing/20220121-20/?p=106182)

哈哈，一个有意思的bug，之前咱们也提过

```c++
void polarity_test(std::shared_ptr<Test> test)
{
    test->harness->callAndReport([test2 = std::move(test)]() mutable
    {
        test2->reverse_polarity();
        ::resume_on_main_thread([test3 = std::move(test2)]()
        {
            test3->reverse_polarity();
        });
    });
}

```

挂在test2 = std::move(test)，move本身啥都不干，为啥会挂？

注意这个test，外面有->访问，里面有 = 访问，谁先谁后呢？c++17约定了调用顺序，所以升级c++17就解决了，保证外面的先里面的后

那c++17 之前，怎么解决？摆脱这个依赖就能修好了,比如

```c++
    auto& original_test = *test; // get this before we std::move(test)
    original_test.harness->callAndReport([test2 = std::move(test)]() ...);
```

再比如

```c++
    auto test_ptr = test.get(); // get this before we std::move(test)
    test_ptr->harness->callAndReport([test2 = std::move(test)]() ...);
```

再比如

```c++
  auto& harness = test->harness; // get this before we std::move(test)
    harness->callAndReport([test2 = std::move(test)]() ...);
```



- [低延迟场景下的性能优化实践                ](https://mp.weixin.qq.com/s/2drIFihDSBLkhklPuSmZkQ) 没啥说的
- [编译优化 - 循环优化](https://zhuanlan.zhihu.com/p/458079943) 这个文章介绍的内容咱们也介绍过，忘记的可以再看看
- [folly学习（一）：C++中如何实现一个通用迭代器](https://zhuanlan.zhihu.com/p/458712167) [folly学习(二)：如何实现一个declval](https://zhuanlan.zhihu.com/p/459582396) 介绍folly小组件
- [Bare Metal C++ Register Access API](https://allthingsembedded.com/post/bare-metal-register-access-api/)

一些嵌入式相关的c++使用案例，抽象gpio寄存器之类的

- [On proposed `status_value`](https://oliora.github.io/2022/01/20/On-proposed-status_value.html)

又是和status类似的东西，但是有个optional value，怎么说，有点像expect和optional的孩子

```c++
enum class queue_op_status {success = 0, empty, full, closed, busy};

// Returns either queue_op_status::success and value or an error status and no value
template<class T>
auto queue<T>::pop() -> status_value<queue_op_status, T>;
```

真的需要这个value么？

- [Three C++23 features for common use](https://mariusbancila.ro/blog/2022/01/17/three-cpp23-features-for-common-use/)

介绍三个比较常用的c++23特性

**Literal suffixes for size_t** uz 直接200uz，-1z，比size_t a = 200; std::ptrdiff_t b = -1;要更直观

c++20已经有

```c++
std::vector<int> v {1, 1, 2, 3, 5, 8};
for(auto i = 0u; i < v.size(); ++i)
{
   std::cout << v[i] << '\n';
}
```

为啥又来个uz，主要是因为容器的size()返回值是size_t，这就又造成了类型不匹配。

**多维数组支持**

以前只能复用operator functor

```c++
template <typename T, size_t R, size_t C>
struct matrix {
   T& operator()(size_t const r, size_t const c) noexcept {
      return data_[r * C + c];
   }
   T const & operator()(size_t const r, size_t const c) const noexcept {
      return data_[r * C + c];
   }
   static constexpr size_t Rows = R;
   static constexpr size_t Columns = C;
private:
   std::array<T, R* C> data_;
};
int main() {
   matrix<int, 2, 3> m;
   for (size_t i = 0; i < m.Rows; ++i) {
      for (size_t j = 0; j < m.Columns; ++j) {
         m(i, j) = i * m.Columns + (j + 1);
      }
   }
   for (size_t i = 0; i < m.Rows; ++i) {
      for (size_t j = 0; j < m.Columns; ++j) {
         std::cout << m(i, j) << ' ';
      }
      std::cout << '\n';
   }
}
```

c++23可以这样

```c++
T& operator[](size_t const r, size_t const c) noexcept {
   return data_[r * C + c];
}
T const & operator[](size_t const r, size_t const c) const noexcept {
   return data_[r * C + c];
}

int main() {
   matrix<int, 3, 2> m;
   for (size_t i = 0; i < m.Rows; ++i) {
      for (size_t j = 0; j < m.Columns; ++j) {
         m[i, j] = i * m.Columns + (j + 1);
      }
   }

   for (size_t i = 0; i < m.Rows; ++i) {
      for (size_t j = 0; j < m.Columns; ++j) {
         std::cout << m[i, j] << ' ';
      }
      std::cout << '\n';
   }    
}
```

可读性更高了

**contains()** string string_view方法。挺离谱这个一直没有，要用find

## 视频

- [Back to Basics: Designing Classes (part 1 of 2) - Klaus Iglberger - CppCon 2021](https://www.youtube.com/watch?v=motLOioLJfg) 复习设计模式
- [Roi Barkan - Argument Passing, Core Guidelines and Aliasing - Meeting C++ 2021](https://www.youtube.com/watch?v=apAahC2TyMA) 这个咱们之前好像讲过，[ppt在这里](https://docs.google.com/presentation/d/1FwWq4XwYc-adY3fOu1X29U8-uUkuAue8qrZJUirDVtM/preview#slide=id.gb26ab9aef4_0_1054)

小对象尽量传值别用引用指针，或者把c的restrict用起来，一些坑，比如需要用std::ref的场景，需要用decay_copy的场景（c++23 auto(x)可以有类似的效果）

```c++
#include <iostream>

template<class T> 
constexpr std::decay_t<T>
decay_copy(T&& v)
    noexcept(std::is_nothrow_convertible_v<T, std::decay_t<T>>)           // exposition only
{
     return std::forward<T>(v);
}

int main() {
  std::vector<int> v1{1, 2, 1, 1, 1};
  auto v2 = v1;
  v1.erase(
      std::remove(begin(v1), end(v1), *std::max_element(begin(v1), end(v1))),
      v1.end());
  v2.erase(std::remove(
               begin(v2), end(v2),
               decay_copy(*std::max_element(begin(v2), end(v2)))),
           v2.end());
  std::cout << "v1.size()=" << v1.size() << std::endl 
            << "v2.size()=" << v2.size()
            << std::endl;
  return 0;
}
```

- [Dawid Zalewski - to pass and return, the story of functions, values and compilers - Meeting C++ 2021](https://www.youtube.com/watch?v=lxg-HWZvHEI) 从汇编角度讲传参/返回值

- [[MUC++] Ofek Shilon - Viewing Clang Optimizations with OptView2](https://www.youtube.com/watch?v=nVc439dnMTk) 不懂，clang周边工具



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [实现一个简单的变长栈上数组](https://godbolt.org/z/j9vvW6z8v)

原理就是初始化N个对象，记住第一个地址和对象大小/偏移，来自己定位。挺闲的这个玩意

- [ecal](https://github.com/continental/ecal/tree/v5.9.4) 一个简单的pubsub组件

## 工作招聘

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/047.html)
