---
layout: post
title:  第45期
---

# C++ 中文周刊 第45期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-311.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

标准委员会动态/一些比较出名的项目release/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-01-05 第131期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-01-05.md)

## 文章

- [2021 C++ Standardization Highlights](https://botondballo.wordpress.com/2022/01/03/2021-c-standardization-highlights/)

介绍了2023的各种提案亮点

之前也说过，比如**[Deducing `this`](https://wg21.link/p0847)**，比如多维数组 operator , auto代替decay_copy ，123uz后缀 stack_trace库,加强的optional，move_only_function(function_ref), string的细致支持 resize_and_overwrite

- [Almost Always Unsigned ](https://graphitemaster.github.io/aau/#almost-always-unsigned) 

  这个观点不一定对 但各种index之类的尽可能的用unsigned，毕竟signed各种溢出问题太坑爹了

  感谢lh_mouse补充

  signed和unsigned区别就是信息，unsigned少一部分信息，这个信息在比较中可能是非常重要的。另外对于编译器而言，这俩最终的优化效果是一样的

- [Named parameters for C++11 with variadic templates vs a language feature ](http://ib-krajewski.blogspot.com/2020/05/named-params-for-c11-using-varaidic.html)

来段python解释下

```python
 parser.add_argument(
        '-f', metavar='FILE', type=argparse.FileType('r'), default=sys.stdin,
        dest='file', help='path to file containing the csv benchmark data')
```

这种字段名=值的用法，怎么在c++中实现？

猥琐方法，c

```c++
struct Named 
{ 
  int size; int defaultValue; bool forced; bool verbose; 
  Named() : size(0), defaultValue(0), forced(false), verbose(false) {};
};
 
void foo(Named);
 
void bar()
{
  foo({ .size = 44, .forced = true});
}
```

但是我们想要这样

```c++
void bar()
{
  foo(size: 44, forced: true);
}
```

只能说，有提案了 [D2288R0 Proposal of Designated Arguments DRAFT 2](https://docs.google.com/document/d/14sQA95BVz8F7y-tqXxqXiRENvEusn8MzZgoBXMu4UbI/edit) 如果能用上确实挺爽的，尤其是构造函数，语意更清晰

这种指定也能解决构造函数默认参数的顺序引入的问题，比如f(int a=1,b=1,c=1,d=1,e=1), 我想指定b/d这两个值，当前只能把前面的ac都补上，这就非常难受

- [The Evolution of Functions in Modern C++](https://mariusbancila.ro/blog/2022/01/01/the-evolution-of-functions-in-modern-cpp/)

​		讲了c++函数近年来的变化，比如各种关键字修饰

```c++
template <typename T>
T add(T a, T b)
{
    return a + b;
}
template <>
int add<int>(int a, int b) = delete;
int main()
{
    add(1, 2); // error, this specialization is deleted
}
```



返回值推导

```c++
template <typename T, typename U>
auto add(T a, U b)
{
   return a + b;
}
```



以及最新的consteval，concept限制等等

```c++
auto add(std::integral auto a, std::integral auto b)
{
   return a + b;
}
```

甚至虚函数也能consteval

```c++
struct magic
{
    constexpr virtual int def() const { return 0; }
};
struct programming_magic : public magic
{
    constexpr int def() const override { return 42; }
};
constexpr int initval(magic const & m)
{
    return m.def() + 1;
}
int main()
{
   constexpr programming_magic pm;
   int arr[initval(pm)] = {0};
}
```



以及最新的协程

```c++
#include <cppcoro/task.hpp>

cppcoro::task<> consume_items(int const n)
{
  int i = 1;
  for(auto const& s : produce_items())
  {
     print_time();
     std::cout << "consumed " << s << '\n';
     if (++i > n) break;
  }

  co_return;
}
```

- [Two Deterministic Build Bugs](https://randomascii.wordpress.com/2022/01/04/two-deterministic-build-bugs/)
- [Determinism Bugs, Part Two, Kernel32.dll](https://randomascii.wordpress.com/2022/01/06/determinism-bugs-part-two/)

这俩我愣没看明白到底啥bug

- [YYMMDDHHMM just overflowed a signed 32 bit int](https://rachelbythebay.com/w/2022/01/01/baddate/)

32位时间戳现在已经不可用了

December 31, 2021 at 23:59 表示成 2112312359.  32位最大是 2147483647)

 January 1, 2022 at 00:00, 表示成 220101000 已经溢出了

- [Test an expression for constexpr-friendliness](https://quuxplusone.github.io/blog/2022/01/04/test-constexpr-friendliness/)

TODO:看不懂兄弟们

- [OpenPPL 月刊  2021 12](https://zhuanlan.zhihu.com/p/453601036)

## 视频

- [C++ Weekly - Ep 305 - Stop Using `using namespace` ](https://www.youtube.com/watch?v=MZqjl9HEPZ8)

可能有第三方实现的冲突。所以别打开命名空间



## 项目

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群128705139和作者对线
- Taskflow v3.3 released! 这个库非常牛逼
- [fmt](https://github.com/fmtlib/fmt/releases/tag/8.1.0)  更新8.1版本，chrone相关打印更快，提升十倍。使用到的朋友们尽可能升级
- [CXXIter: A chainable c++20 LINQ-like iterator library](https://github.com/seijikun/CXXIter)

又一个linq库，作者认为range还是很难用

几个使用例子

```c++
std::vector<int> input1 = {1337, 42, 128};
std::vector<std::string> input2 = {"1337", "42", "128"};
std::unordered_map<int, std::string> output = CXXIter::from(input1)
	.copied()
	.zip(CXXIter::from(input2).copied())
	.collect<std::unordered_map>();
// output == { {1337, "1337"}, {42, "42"}, {128, "128"} }
```

- [fmtlog](https://github.com/MengRao/fmtlog) 一个基于fmt库的log库，极致低延迟速度快，由于设计原因（消费队列），log速度过快会导致log丢失，不过点子还是很有意思的。nanolog之类的想法，但做的更快
- [KDBindings](https://github.com/KDAB/KDBindings) 一个把signal-slot剥离出来成一个组件的库，可以方便桌面编程，尤其是不方便用qt的场景
- [fuss](https://github.com/andsmedeiros/fuss) 一个简单的pubsub实现，没啥特别的，就function存调用
- [libsigcplusplus](https://github.com/libsigcplusplus/libsigcplusplus) c++17信号处理库 现在不会还有人没用c++17吧
- [compile time bounded integers    ](https://github.com/modanashar/cbi) 编译期计算库

```c++
   constexpr cbi::Bounded<int32_t, 1, 10> fst{ 2 };
   constexpr cbi::Bounded<int32_t, 1, 6> sec{ 2 };
   auto res = fst + sec;

   // Bounds are calculated automatically based on the operation
   using expected_t = cbi::Bounded<int32_t, 2, 16>;
   static_assert(std::same_as<expected_t, decltype(res)>);

   assert(res.get() == 4); // extract runtime value

   const std::optional shrinked = res.shrink_bounds<1, 5>(); // shrink bounds
   assert(shrinked.has_value());
```

不过真的有人用的到吗



## 工作招聘

这个是之前发过的招聘信息，再挂一周

- [商汤科技OpenPPL招聘](https://www.zhihu.com/pin/1458834090074472449) 高性能深度学习推理平台建设，直接给高工投简历
- [pincap做mpp数据引擎的](https://zhuanlan.zhihu.com/p/451809358)

> 我们是 [TiDB](https://link.zhihu.com/?target=https%3A//docs.pingcap.com/zh/tidb/stable/overview) 与 [TiFlash](https://link.zhihu.com/?target=https%3A//docs.pingcap.com/zh/tidb/stable/tiflash-overview) 的 compute engine team，包含了基于 Go 的 OLTP 执行引擎与基于 C++ 的 MPP 执行引擎，感兴趣的同学请私信联系（成员分布在上海、广州、杭州、北京、深圳）。（全日制实习生可能得晚点才有 HC）
>
> 这里是jd：
>
> - [分布式存储系统研发工程师-分析引擎](https://link.zhihu.com/?target=https%3A//careers.pingcap.com/apply/pingcap/39950/%23/job/1bc7946f-8ccd-422c-99b8-9be998b95b14)
> - [数据库引擎研发专家工程师（执行引擎方向）](https://link.zhihu.com/?target=https%3A//careers.pingcap.com/apply/pingcap/39950/%23/job/c242f559-e543-4048-8d8f-424500962967)
> - [数据库引擎研发工程师](https://link.zhihu.com/?target=https%3A//careers.pingcap.com/apply/pingcap/39950/%23/job/6914dba4-c0e2-4fd9-96d5-52219679bbfe)
>

看着挺有意思，感兴趣的可以看看

- [我们决定在鹤岗招人了！](https://zhuanlan.zhihu.com/p/435265036)

昆仑数据库，魔改mysql的，还支持远程工作，友情推荐一波

现在mysql的代码已经很现代c++了

- [疯狂热爱技术的你为什么应该加入OneFlow?](https://zhuanlan.zhihu.com/p/346358679)

 开发深度学习编译器，而且他们也支持远程工作，c++的，友情推荐一波

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/045.html)
