---
layout: post
title:  第44期
---

# C++ 中文周刊 第44期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-310.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)



 说句题外话 fortran居然还在更新，https://fortran-lang.org/还挺新的

最后一天工作日，说实话不太想更了朋友们

提前祝大家新年快乐

---

## 资讯

标准委员会动态/一些比较出名的项目release/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2021-12-29 第130期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-12-29.md)

## 文章

我的某个水友V某分享了一个用错API的案例，opencv里的fastAtan2和cmath里的atan2单位不一样，但是返回值都是float，所以这是一个经典的基本类型丢失类型信息的案例。使用库api，遇到基本类型的返回值，一定要明白类型含义

- [OpenPPL 中的卷积优化技巧](https://zhuanlan.zhihu.com/p/450310581) 没看懂

- [GCC 12 Adds Support For Using The Mold Linker](https://www.phoronix.com/scan.php?page=news_item&px=GCC-12-Mold-Linker) 

使用`-fuse-ld=mold` 低版本的gcc别想了，mold你都编译不过

- [glibc is still not Y2038 compliant by default](https://ariadne.space/2021/12/29/glibc-is-still-not-y2038-compliant-by-default/)

time_t是32位的，2038年就溢出了，glibc修了，不过不是默认的, 使用这个宏-D_TIME_BITS=64来指定

说的挺吓人的实际上不用担心，你要担心的是自定义的时间戳，比如用了int32的，得改成int64了

不过也不用担心，还有十多年你干不干程序员还不一定呢

- [The Usual Arithmetic Confusions](https://shafik.github.io/c++/2021/12/30/usual_arithmetic_confusions.html)

c++的int互相转化，太坑爹了

```c++
std::cout << (-1L < 1U); // What will this output?
```

猜猜是几？不同的编译选项表现还不同[obtain different output using -m32 Vs -m64 compiler command line options](https://godbolt.org/z/83qfWh3vr).

```c++
uint16_t x1 = 1;
uint16_t x2 = 2;
std::cout << x1 - x2 << "\n"; // What will this output?
```

猜猜是几？-1，因为x1 - x2 的类型是int

```c++
uint32_t x3 = 1;
uint32_t x4 = 2;
std::cout << x3 - x4 << "\n"; // What will this output?

```

再猜猜是几？

4294967295 

```c++
unsigned short x=0xFFFF;
unsigned short y=0xFFFF;
auto z=x*y; 
```

猜猜是不是UB？ 用-fsanitize=undefined编译下

```bash
// runtime error: signed integer overflow: 65535 * 65535 cannot be represented
// in type 'int'
// SUMMARY: UndefinedBehaviorSanitizer: undefined-behavior /app/example.cpp:7:13 in
```

遇到整型计算问题一定要考虑坑爹的转换问题



- [Debugging For Graphics Programmers](https://www.jeremyong.com/graphics/2021/12/27/debugging-for-graphics-programmers/)

作为一个图形学程序员，这里给你提供了一份查bug清单，我不懂图形学这里的事儿，就不班门弄斧了，建议点开看下

> 浮点数精度是不是存在问题？
>
> pipeline渲染管线是不是不对？
>
> - Is it possible that your binding the incorrect resource?
> - The wrong shader module?
> - Draw constants/uniforms correct?
> - Are sample counts what you expect?
> - Correct winding order? Topology?
> - Correct blend function?
> - Correct depth state (depth bounds, test operation, etc.)?
> - Is your shader compiler emitting code that is actually incorrect  (possible with bleeding edge versions or when using newer compiler  features)?

- [co_resource<T>: An RAII coroutine](https://vector-of-bool.github.io/2021/12/30/co_resource.html)

先看一段python

```python
from contextlib import contextmanager

@contextmanager
def printing(msg: str):
  print(f'Entering: {str}')
  # Yield a value, making this into a coroutine function
  yield 1729
  print(f'Exiting: {str}')


with printing('coro context example') as val:
  print(f'Got value: {val}')

```

c++有了协程，也可以了，作者手把手教你实现一个co_resource，代码在[这里](https://github.com/vector-of-bool/neo-fun/blob/develop/src/neo/co_resource.hpp)



## 视频

cppcon 2021最近没啥时间看，我先鸽，后面慢慢更新

- [C++ Weekly - Ep 304 - C++23's 'if consteval'](https://www.youtube.com/watch?v=AtdlMB_n2pI)

介绍if consteval的。没啥说的，consteval能简单计算了。math基本上都是consteval



## 项目
- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群128705139和作者对线
- [wasmblr](https://github.com/bwasti/wasmblr) 头文件级别的wasm小库，不错，Emscripten太复杂了
- [treefrog](https://github.com/treefrogframework/treefrog-framework/releases/tag/v2.3.0)  新版本，一个mvc web框架
- [webtoolkit](https://www.webtoolkit.eu/wt/news/2021/12/27/wt___jwt_4_6_1_released)  新版本，一个web框架

## 工作招聘

这里列的招聘都是我时间线上出现的有意思的，发一下

相关公司看到了别忘了给我打钱（五毛一条）

- [商汤科技OpenPPL招聘](https://www.zhihu.com/pin/1458834090074472449) 高性能深度学习推理平台建设，直接给高工投简历
- [pincap做mpp数据引擎的](https://zhuanlan.zhihu.com/p/451809358)

我们是 [TiDB](https://link.zhihu.com/?target=https%3A//docs.pingcap.com/zh/tidb/stable/overview) 与 [TiFlash](https://link.zhihu.com/?target=https%3A//docs.pingcap.com/zh/tidb/stable/tiflash-overview) 的 compute engine team，包含了基于 Go 的 OLTP 执行引擎与基于 C++ 的 MPP 执行引擎，感兴趣的同学请私信联系（成员分布在上海、广州、杭州、北京、深圳）。（全日制实习生可能得晚点才有 HC）

这里是jd：

- [分布式存储系统研发工程师-分析引擎](https://link.zhihu.com/?target=https%3A//careers.pingcap.com/apply/pingcap/39950/%23/job/1bc7946f-8ccd-422c-99b8-9be998b95b14)
- [数据库引擎研发专家工程师（执行引擎方向）](https://link.zhihu.com/?target=https%3A//careers.pingcap.com/apply/pingcap/39950/%23/job/c242f559-e543-4048-8d8f-424500962967)
- [数据库引擎研发工程师](https://link.zhihu.com/?target=https%3A//careers.pingcap.com/apply/pingcap/39950/%23/job/6914dba4-c0e2-4fd9-96d5-52219679bbfe)

看着挺有意思，感兴趣的可以看看



---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/044.html)
