---
layout: post
title:  第41期
---

# C++ 中文周刊 第41期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-309.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

[cppnow也快开始了](https://cppnow.org/announcements/2021/12/2022-CfS/)

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 OSDT Weekly 2021-12-08 第128期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-12-08.md)

[boost 1.78版本发布](https://www.boost.org/users/history/version_1_78_0.html) asio支持io_uring

## 文章

- [c++ execution 与 coroutine (四)：数据类型与then](https://zhuanlan.zhihu.com/p/441299563)
- [c++ execution 与 coroutine (五)：异步](https://zhuanlan.zhihu.com/p/441741987)

没啥说的，代码走读

- [3 Ways To Parse Command Line Arguments in C++: Quick, Do-It-Yourself, Or Comprehensive](https://mostsignificant.github.io/c++/2021/11/03/3-ways-to-parse-command-line-arguments-in-C++-quick-do-it-yourself-or-comprehensive.html)

手把手教你写参数解析（直接用getopt/cli11得了）

- [`view_interface` types are boolean-testable](https://quuxplusone.github.io/blog/2021/12/06/views-are-boolish/)

range有bool语义

```c++
namespace rv = std::views;

std::vector<int> v = {1,2,3,4,5};
auto isOdd = [](int x) { return (x % 2) != 0; };
if (v | rv::filter(isOdd)) {
    puts("v contains at least one odd number");
}
```



前提是有view_interface接口，有些view并没有这个接口。挺坑的

```c++
if (auto r = "foo"sv | rv::reverse)               // OK, r is reverse_view<string_view>
if (auto r = "foo"sv | rv::reverse | rv::reverse) // Error, r is string_view

if (auto r = v | rv::drop(1))             // OK, r is drop_view<ref_view<vector<int>>>
if (auto r = std::span(v) | rv::drop(1))  // Error, r is span<int>
```



- [Breaking promises with LD_PRELOAD](https://zakaria.org/posts/breaking_promises.html)

一个测试，pledge是openbsd的一个权限API限制接口，LD_PRELOAD 能hook系统调用pledge, 导致pledge失效，从而绕过

- [pinned_vec - invalidating iterator invalidation](https://wheybags.com/blog/pinned.html)

vector push_back导致迭代器失效，很让人烦恼。作者想到了一个绕过的办法，你猜猜是不是mmap [代码实现](https://github.com/wheybags/vmhax/#pinnedh) 

主要是避免搬迁，在mmap基础上进行扩展/缩小空间，作者的性能测试表示，在大量内存的场景下，比vector要好，小对象不如

- [A note on `namespace __cpo`](https://quuxplusone.github.io/blog/2021/12/07/namespace-cpo/)

CPO之前讲过，可以理解成接口对象， 不同的库为了实现这玩意，弄了一层命名空间，把这玩意隐藏起来，避免影响库本身的同名函数

```c++
namespace std::ranges {
  namespace __iter_swap {
    struct __fn {
      auto operator()(~~~) const { ~~~ }
    };
  }
  inline namespace __cpo {
    inline constexpr auto iter_swap = __iter_swap::__fn{};
  }
}

namespace std::ranges {
  template<~~~>
  struct counted_iterator {
    friend void iter_swap(counted_iterator, counted_iterator) { ~~~ }
  };
}
```

这个是libc++的代码，gcc用的`__cust` msvc用的`_Cpos`大同小异

- [Fast CSV processing with SIMD](https://nullprogram.com/blog/2021/12/04/)

作者实现了一版[csvquote](https://github.com/skeeto/scratch/tree/master/csvquote) ,简单一测比[原版](https://github.com/dbro/csvquote)快20倍，用上了SIMD

感兴趣的可以看看实现。我没有研究

- [C++17: Abusing side effects of static_assert around template types to implement "anonymous" static initialization  ](https://gist.github.com/JAJames/11ab5af1bf5beecfff72387188692933)

创造一个没有名字的全局单例，怎么做？

最简单的想法

```c++
struct some_class {
	inline static some_class s_instance{}; // Invalid; some_class is not a complete type
}
```

肯定不行，作者给了个非常骚的操作，static_assert

```c++
namespace static_initializer {

template<typename T>
struct instance_container {
	static constexpr T* instance() {
		return &s_instance;
	}

	inline static T s_instance{};
};

} // namespace static_initializer

// ... Some .cpp file
struct some_class {
	some_class() {
		std::cout << "test text" << std::endl;
	}
};

static_assert(static_initializer::instance_container<some_class>::instance() != nullptr);
// Neither some_class nor instance_container<some_class> are referenced anywhere else
```

这个东西的用处可能是防止反编译，且绝对意义上的全剧唯一单例，缺点，你这么写没人愿意改，可能很难合入

- [Modernizing your code with C++20](https://blog.sonarsource.com/modernizing-your-code-with-cpp20)

sonarsource他们是做静态检查分析的

快速把代码改成c++20的

使用各种c++20 api，比如

```c++
auto operator<=>( const Swallow& ) const = default;
```

比如string的start_with end_with接口

bit_cast

Std::remove换成std::erase

中位数？

```c++
auto m = a + (b - a) / 2; //换成std::midpoint
auto i = a + (b - a) * 0.3f; //换成std::lerp
```

- [BOLT Close To Merging Into LLVM For Optimizing Performance Of Binaries](https://www.phoronix.com/scan.php?page=news_item&px=BOLT-Inches-To-LLVM)

使用facebook的BOLT来做的二进制优化比clang自身的LTO优化，要快。这个后面会合入llvm

但是没有和gcc LTO的比较

- [Add a Developer Console to your C++ Game in 20 Lines of Code](https://kevch.in/blog/how-to-add-console-to-game/)

给自己的游戏加一个控制台 [控制台代码在这里](https://github.com/kevinmkchin/noclip)

- [Why Standard C++ Math Functions Are Slow](https://medium.com/@ryan.burn/why-standard-c-math-functions-are-slow-d10d02554e33)

sqrt有点慢，加上-fno-math-errno就快了，这个flag之前咱们也讲过。这个优化会导致malloc 的errno也不处理。这个bug好像还没修

- [Modern C++ in Advent of Code: Day2](https://itnext.io/modern-c-in-advent-of-code-day2-ca0af5bf0182)

Advent of Code解题记录，[这个活动仍在进行](https://adventofcode.com/2021)，感兴趣的可以玩玩

- [The Type-Traits Library: std::is_base_of](http://www.modernescpp.com/index.php/the-type-traits-library-std-is-base-of)

介绍了is_base_of的用法

## 视频

[cppcon2021视频列表](https://www.youtube.com/playlist?list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6) 之前讲过的就不说了,一共90多个，真是看不完

- [From Problem to Coroutine: Reducing I/O Latency - Cheinan Marks - CppCon 2021](https://www.youtube.com/watch?v=N__eTyrLAF0&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=14)

协程在网络编程使用上非常省事

- [Implementing C++ Modules: Lessons Learned, Lessons Abandoned - Cameron DaCamara & Gabriel Dos Reis](https://www.youtube.com/watch?v=9OWGgkuyFV8&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=10)

这个讲的module的细节，比如要满足One Define Rule之类的。

- [Evolving an Actor Library Based on Lessons Learned from Large-Scale Deployments - Benjamin Hindman](https://www.youtube.com/watch?v=vx2UPjhLZUw&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=11)

又一个实现erlang actor模型的库 [代码在这里](https://github.com/3rdparty/eventuals)

- [Typescripten: Generating Type-safe JavaScript Bindings for emscripten - Sebastian Theophil](https://www.youtube.com/watch?v=CLuhogat6aY&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=14)

讲emscripten的。不懂相关概念，就没看

- [Type-and-resource safety in modern C++ - Bjarne Stroustrup - CppCon 2021](https://www.youtube.com/watch?v=l3rvjWfBzZI&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=12)

讲一些最佳实践，老大讲的我昏昏欲睡

- [Exceptional C++ - Victor Ciura - CppCon 2021](https://www.youtube.com/watch?v=SjlfhyZn2yA&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=15)

这个有点back to basic的感觉了，讲异常以及各种平台的表现

- [Law of Demeter: A Practical Guide to Loose Coupling - Kris Jusiak - CppCon 2021](https://www.youtube.com/watch?v=aalgibaC6Vs&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=16)

讲代码设计的，api设计的尽可能强类型之类的，老生常谈了

- [“Constexpr Everything” - The Standard Library, Microkernel, Apps, and Unit Tests - Rian Quinn](“Constexpr Everything” - The Standard Library, Microkernel, Apps, and Unit Tests - Rian Quinn)

没啥看的

- [Understanding and Mastering C++'s Complexity - Amir Kirsh - CppCon 2021](https://www.youtube.com/watch?v=KcTHZrK4HzI&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=18)

这哥们T恤还行，想整一件。讲的没啥意思

- [Your New Mental Model of constexpr - Jason Turner - CppCon 2021](https://www.youtube.com/watch?v=afc6WEJV6VE&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=19)

constexpr的点子，比如constexpr compression constexpr alloctor

- [Failing Successfully: Reporting and Handling Errors - Robert Leahy - CppCon 2021](https://www.youtube.com/watch?v=KJ3jWZryl2A&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=20)

这个讲的是错误码，使用std::error_code来维护整体状态，不用goto/errno/全局状态，以及怎么用std::error_code这套设施写代码

- [Configuration, Extension, Maintainability - Titus Winters - CppCon](https://www.youtube.com/watch?v=WGIpK7C4kro&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=21)

讲配置可维护性

- [Lessons Learned from Packaging 10,000+ C++ Projects - Bret Brown & Daniel Ruoso - CppCon 2021](https://www.youtube.com/watch?v=R1E1tmeqxBY&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=22)

讲编译系统库依赖相关的问题

- [C++11/14 at Scale: What Have We Learned? - Vittorio Romeo - CppCon 2021](https://www.youtube.com/watch?v=7Mfbpbyq6fs&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=24)

讲他们公司c++技术演进，如何让代码更安全(多用override/auto/constexpr之类的)

- [Compile-Time Compression and Resource Generation with C++20 - Ashley Roll - CppCon 2021](https://www.youtube.com/watch?v=tBZ0Z9CVHAM&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=25)

黑科技，constexpr来做编译期压缩/编译期crc32  编译期计算 虽然这个演讲者讲的让人困，但是这个创意是真有意思 [PPT在这里](https://github.com/AshleyRoll/cppcon21)

- [C++20 Templates: The next level: Concepts and more - Andreas Fertig - CppCon 2021](https://www.youtube.com/watch?v=vGMPYkSLkUc&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=26)

讲concept的没啥说的

- [Just Enough Assembly for Compiler Explorer - Anders Schau Knatten - CppCon 2021](https://www.youtube.com/watch?v=QLolzolunJ4&list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6&index=27)

这个演讲者是cppquiz的站长, 手把手带你看汇编

好了朋友们，虽然还有很多没看完，下期再更



## 项目

- [binary_log](https://github.com/p-ranav/binary_log) 又一个log库，和nanalog/binlog 那些日志库差不多，都是ns级别

## 工作招聘

这俩招聘暂时放一个月。主要是没新的

- [我们决定在鹤岗招人了！](https://zhuanlan.zhihu.com/p/435265036)

昆仑数据库，魔改mysql的，还支持远程工作，友情推荐一波

现在mysql的代码已经很现代c++了

- [疯狂热爱技术的你为什么应该加入OneFlow?](https://zhuanlan.zhihu.com/p/346358679)

 开发深度学习编译器，而且他们也支持远程工作，c++的，友情推荐一波

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/041.html)
