---
layout: post
title:  第40期
---

# C++ 中文周刊 第40期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-308.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

最近有点忙cppcon视频没看完

---

## 资讯

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 OSDT Weekly 2021-12-01 第126期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-12-01.md)

[**Qt Creator 6 released**](https://www.qt.io/blog/qt-creator-6-released)

## 文章

- [c++ execution 与 coroutine (三)：最简单的receiver与最简单的sender](https://zhuanlan.zhihu.com/p/438192977)

手把手教你写sender/receiver

- [I spent some time optimizing memset and memcpy in x86 assembly. Here are a few interesting things about memset and memcpy. ](https://mobile.twitter.com/nadavrot/status/1464364566117191685) 代码地址在这里https://github.com/nadavrot/memset_benchmark

核心想法就是[这个](https://msrc-blog.microsoft.com/2021/01/11/building-faster-amd64-memset-routines/)

- [Uninitialized Stack Variables 栈变量不初始化一个bug](https://www.netmeister.org/blog/stack-vars.html)

这个看个乐，代码

```c
$ cat a.c
#include <arpa/inet.h>
#include <sys/socket.h>

#include <netinet/in.h>

#include <err.h>
#include <stdlib.h>

#define PORT 12345

int
main() {
	int sock;
  // 加这行就不报错了	socklen_t length, s_size;
	struct sockaddr_storage server;
	struct sockaddr_in6 *sin = (struct sockaddr_in6 *)&server;
  // 加这行也不报错 memset(sin, 0, sizeof(*sin));
	if ((sock = socket(PF_INET6, SOCK_STREAM, 0)) < 0) {
		err(EXIT_FAILURE, "socket");
		/* NOTREACHED */
	}

	if (inet_pton(PF_INET6, "::1", &(sin->sin6_addr)) != 1) {
		err(EXIT_FAILURE, "inet_pton");
		/* NOTREACHED */
	}

	sin->sin6_family = PF_INET6;
	sin->sin6_port = htons(PORT);

	if (bind(sock, (struct sockaddr *)sin, sizeof(*sin)) != 0) {
		err(EXIT_FAILURE, "bind");
		/* NOTREACHED */
	}

	return 0;
}
$ cc a.c
$ ./a.out
a.out: bind: Can't assign requested address
$ 
```

这个问题定位下来就是未初始化，解错了数据

- [一种永远不会忘记写break的switch case写法](https://belaycpp.com/2021/11/30/prettier-switch-cases/)

```c++
switch (f)
{
    break; case Foo::Alpha:
        s += "is nothing";
    break; case Foo::Beta:
        s += "is important";
        f = Foo::Alpha;
    break; case Foo::Gamma:
        s += "is very important";
        f = Foo::Alpha;
    break; case Foo::Delta:
        s += "is not very important";
        f = Foo::Alpha;
}
```

哈哈，给我看笑了

- [c++ tip of week **Did you know about static reflection proposal for C++2X?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

  简单反射，可以这里体验一下https://godbolt.org/z/x55GPdTxE。虽然在clang reflect分支里，但是没合并到主干。这个反射到提案进度也不知道鸽成什么样子了

```c++
#include <experimental/reflect>
#include <iostream>

namespace meta = std::experimental::reflect;

template<class... Ts>
struct print_enum {
  void operator()() {
    ((std::cout << meta::get_name_v<meta::get_type_t<Ts>> << ':' << meta::get_name_v<Ts> << std::endl), ...);
  }
};

enum class Trading { Quant, Lab };

int main() {
  std::cout << meta::get_name_v<reflexpr(Trading)> << std::endl; // prints Trading
  std::cout << meta::get_name_v<reflexpr(Trading::Quant)> << std::endl; // prints Quant
  std::cout << meta::get_name_v<reflexpr(Trading::Lab)> << std::endl; // prints Lab

  meta::unpack_sequence_t<print_enum, meta::get_enumerators_t<reflexpr(Trading)>>{}(); // prints Trading::Quant, Trading::Lab
}
```

- [什么是过度优化](https://johnysswlab.com/what-are-premature-optimizations/)

之前说过，这个人的博客权重很高，讲了很多性能优化相关的东西

这里简单列一下

> - 只优化热点，冷的地方没必要花时间
> - 工程实践，比如能用stl算法不用，能用range -for不用

- [那些年解的疑难性能问题 --- ext4_fsync优化](https://zhuanlan.zhihu.com/p/339703328)

值得一看。看思路

- [I accidentally wrote a Turing-complete parsing library](https://www.foonathan.net/2021/11/lexy-turing/)

作者说自己的parser库多么多么图灵完备

- [The libc++ implementation of the STL deque push_front function has O(log n) amortized time complexity](https://1f604.blogspot.com/2021/11/the-libc-implementation-of-stl-deque.html)

clang的libc++的deque的push_front在糟糕场景下可能会有O(logN)的效率，注意使用

博客内容是从代码汇编来分析到底耗时在哪里。没有展开看



- [Some obscure C features](https://multun.net/obscure-c-features.html)

介绍一些c的莫名其妙的细节，比如include可以当函数，数组是指针别名等等。这里就不展开了。还是不要知道的好

- [An `Attempt` to avoid C++ exceptions](https://genodians.org/nfeske/2021-11-26-attempt-no-exceptions)

就是实现一个Status错误类型，所有函数都走这个不走异常 	[接口比较简单,点击直达](https://github.com/genodelabs/genode/blob/staging/repos/base/include/util/attempt.h)

## 视频

### cppcon2021出了个[视频列表](https://www.youtube.com/playlist?list=PLHTh1InhhwT6vjwMy3RG5Tnahw0G9qIx6)

太多了胖友们，根本看不完。我慢慢消化，可能放在下一期

- [Denis Yaroshevskiy & Joel Falcou - EVE: A new, powerful open source C++20 SIMD library](https://www.youtube.com/watch?v=ImMkbmgyW8o)

一个simd实现的算法库，包括find(可以和下面那个简单的比一比)，[仓库地址](https://github.com/jfalcou/eve)





## 项目

- [用 C++20 撸了一个模仿 python 的 asyncio 协程库](https://www.zhihu.com/question/332778359/answer/2251060182) 可以看下协程怎么用的，[仓库地址](https://github.com/netcan/asyncio)
- [又一个match库](https://github.com/groundswellaudio/strm)
- [**C++ Compile Time Parser Generator**](https://github.com/peter-winter/ctpg)

- [用simd实现find](https://github.com/SungJJinKang/std_find_simd) 思路参考这个[文档](https://gms.tf/stdfind-and-memchr-optimizations.html)
- [casbin](https://github.com/casbin/casbin-cpp) 一个acl库

## 工作招聘

这俩招聘暂时放一个月。主要是没新的

- [我们决定在鹤岗招人了！](https://zhuanlan.zhihu.com/p/435265036)

昆仑数据库，魔改mysql的，还支持远程工作，友情推荐一波

现在mysql的代码已经很现代c++了

- [疯狂热爱技术的你为什么应该加入OneFlow?](https://zhuanlan.zhihu.com/p/346358679)

 开发深度学习编译器，而且他们也支持远程工作，c++的，友情推荐一波

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/040.html)
