---
layout: post
title:  第39期
---

# C++ 中文周刊 第39期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-306.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

本周内容不多

---

## 资讯

[编译器信息最新动态推荐关注hellogcc公众号  本周更新 Weekly 2021-11-24 第125期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-11-24.md)

[标准委员会邮件，11月](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2021/#mailing2021-11)

## 文章

- [**Did you know that C++20 extends support for data time utilities?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/253.md/)

这个time相关的支持，应该就是[date库](https://github.com/HowardHinnant/date)的实现。这个一直在推进标准，不知道进展如何

```c++
constexpr auto thanksgiving = November / 25 / 2021y;

static_assert(year(2021) == thanksgiving.year());
static_assert(month(11)  == thanksgiving.month());
static_assert(day(25)    == thanksgiving.day());
```



- [正确使用cpu提供的TSC](https://zhuanlan.zhihu.com/p/437178265)

能得到比**gettimeofday**更快的速度，但rdtsc也有代价，这里做个小科普

- [A footnote on “Three reasons to pass `std::string_view` by value”](https://quuxplusone.github.io/blog/2021/11/19/string-view-by-value-ps/)

之前说到，尽量用string_view代替const string_view& 补充一点，在msvc上，没啥差别 msvc的实现的原因

- [Designated Initializers in C++20](https://www.cppstories.com/2021/designated-init-cpp20/)

就是c的结构初始化

```c++
struct Point { 
    double x { 0.0 };
    double y { 0.0 };
};

const Point p { .x = 10.0, .y = 20.0 };
 
const Point offset { .x { 100.0 }, .y { -100.0 } };

// mix also possible:
const Point translation { .x = 50.0, .y { -40.0 } };

```



- [Underseeding `mt19937`; introducing `xoshiro256ss`](https://quuxplusone.github.io/blog/2021/11/23/xoshiro/)

mt19937太慢了，实现了个[Xoshiro256ss](https://github.com/Quuxplusone/Xoshiro256ss)替代

- [Conditional Members](https://brevzin.github.io/c++/2021/11/21/conditional-members/)

介绍c++20这些场景如何处理

如何让成员根据条件生成 [[no_unique_address]] + std::conditional_t

如何让成员函数根据条件生成/限制 concept

如何让类中的类型根据条件生成/限制 继承std::conditional_t

- [What if I told you, you don't have to run your unit tests ?](https://baduit.github.io/2021/10/24/compile-time-unit-test.html)

就是简单的接口用编译期测试来组合，尽可能constexpr，然后直接static_assert测试

```c++
#include <vector>
#include <string_view>
#include <numeric>

// std::isdigit is not constexpr
constexpr bool is_digit(char c)
{
    return c >= '0' && c <= '9';
}

constexpr unsigned int accumulate_string_digits(std::string_view str)
{
    std::vector<unsigned int> digits;
    for (auto c: str)
    {
        if (is_digit(c))
            digits.push_back(c - 48);
    }
    return std::accumulate(digits.begin(), digits.end(), 0);
}
static_assert(accumulate_string_digits("") == 0);
static_assert(accumulate_string_digits("1") == 1);
static_assert(accumulate_string_digits("12345") == 15);
static_assert(accumulate_string_digits("1a23c45c") == 15);
static_assert(accumulate_string_digits("Hello, World!") == 0);
```



- [Constructors and evil initializers in C++](https://jmmv.dev/2021/11/cpp-ctors-vs-init.html)

讨论构造函数的异常安全，比如构造出错，解决方案是拆分，把构造函数拆出init，单独执行，但是可能init会漏掉

最后的合适方案是隐藏构造函数，用create来代替构造生成

```c++
class Rectangle {
    // ...

    Rectangle(int w, int h) : width(w), height(h), area(w * h) {
        assert(width > 0 && height > 0);
    }

public:
    static std::optional<Rectangle> create(int w, int h) {
        if (w <= 0 || h <= 0) {
            return std::nullopt;
        }
        return Rectangle(w, h);
    }

    // ...
};
```



## 视频

- [Jeff Garland - C++23 Standard Library Preview - Meeting C++ 2021](https://www.youtube.com/watch?v=rTVQe7zVQUw)

介绍一些c++23的小特性

string

- string支持contains方法
- string从nullptr构造会直接报错

module ~~话说module发音是妈桌我一直发音成麻豆~~

- 一些速度提升

io支持

- std::print 干掉iostream，比printf快，三倍cout
- std::format的一些运行时匹配错误转移到编译期来判定 //这个cppcon 2021也有讲，目前还没放出来

range的一堆fix以及新接口，range更函数式

constexpr 各种 比如unique_ptr cmath接口 optional 等等，内存分配甚至也是可以constexpr的

杂项

- monadic optional 让optional更好用，and_then之类的小接口
- std::expected 这个很经典了，就是rocksdb的status类那种形式
- stacktrace 应该就是boost哪个库
- byteswap 这个是std::endian之后的引入
- to_underlying对枚举拿到背后的值，不用cast，标准库工具帮你cast

## 项目

- [Oof (omnipotent output friend)](https://github.com/s9w/oof) 一个终端图形库
- **[shadesmar](https://github.com/Squadrick/shadesmar)**     Fast C++ IPC using shared memory    也可以用[这个](https://github.com/eclipse-iceoryx/iceoryx)
- [cmake-init](https://github.com/friendlyanon/cmake-init) 一个最小化cmake模版
- 给crc库加上github CI https://github.com/stbrumme/crc32/pull/11
- [cutlass](https://github.com/NVIDIA/cutlass) CUDA矩阵计算库

## 工作招聘

偶尔看见的招聘信息会放到这里

- [我们决定在鹤岗招人了！](https://zhuanlan.zhihu.com/p/435265036)

昆仑数据库，魔改mysql的，还支持远程工作，友情推荐一波

现在mysql的代码已经很现代c++了

- [疯狂热爱技术的你为什么应该加入OneFlow?](https://zhuanlan.zhihu.com/p/346358679)

 开发深度学习编译器，而且他们也支持远程工作，c++的，友情推荐一波

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/039.html)
