---
layout: post
title:  第37期
---

# C++ 中文周刊 第37期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)摘抄一些c++动态

每周更新

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[OSDT Weekly 2021-11-10 第123期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-11-10.md)

VS 2022出了 [Visual Studio 2022 now available](https://devblogs.microsoft.com/visualstudio/visual-studio-2022-now-available/)

## 文章

- [Instruction scheduling in LLVM](https://zhuanlan.zhihu.com/p/360364235)

llvm工作的原理，值得看看，了解一下

- [大家觉得C++23的目标能顺利达成吗？](https://www.zhihu.com/question/475282755/answer/2209455717)

这个回答不错，展望了一下最新进展，可以看看

- [百度C++工程师的那些极限优化（内存篇）](https://mp.weixin.qq.com/s?__biz=Mzg5MjU0NTI5OQ==&mid=2247489076&idx=1&sn=748bf716d94d5ed2739ea8a9385cd4a6&chksm=c03d2648f74aaf5e11298cf450c3453a273eb6d2161bc90e411b6d62fa0c1b96a45e411af805&token=1987775079&lang=zh_CN&scene=21#wechat_redirect)

文章中的点子有点意思，比如string的resize_uninitialized ，各种字符串操作的零拷贝优化，pb零拷贝优化，应用控制内存碎片等等

零拷贝优化要扣细节，不然干嘛用c++

- [**Did you know that C++20 added `type_identity` which implements the identity metafunction?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

type_identity不会丢类型信息

```c++
template <class T>
void print1() {
  std::cout << typeid(T).name() << std::endl;
}

template <class T>
void print2() {
  std::cout << typeid(std::type_identity<T>).name() << std::endl;
}

int main() {
  print1<int const&>();  // 'int'
  print2<int const&>();  // 'type_identity<int const &>'
}
```

- [How to learn compilers: LLVM Edition](https://lowlevelbits.org/how-to-learn-compilers-llvm-edition/)

总结了一些学llvm的资料

- [Three reasons to pass std::string_view by value](https://quuxplusone.github.io/blog/2021/11/09/pass-string-view-by-value/)

对于小对象，比如string_view int span function_ref之类的对象，传值比传引用效率高。

要知道，引用是指针语法糖，会引入指针的问题，编译器可能优化的不是那么好

- [.init, .ctors, and .init_array](https://maskray.me/blog/2021-11-07-init-ctors-init-array)

介绍链接段 以及如何设定attribute限定到这些段里。这几个段是c++实现私货了属于

## 视频

- [Six Impossible Things - Kevlin Henney - CppCon 2021](https://www.youtube.com/watch?v=YoaZzIZFErI)

又是这种抽象的东西

- [Burkhard Stubert - Hexagonal Architecture: The Standard for Qt Embedded Applications](https://www.youtube.com/watch?v=zveTF5AuFYI) 讲qt的，没看

- [Bob Steagall - Debugging Techniques](https://www.youtube.com/watch?v=LBs3RqyKI5c) 说了一大堆，还是处理编译警告 assert 二分定位之类的东西



### 回忆一波cppcon2020

- [Template Metaprogramming: Type Traits (part 1 of 2) - Jody Hagins - CppCon 2020](https://www.youtube.com/watch?v=tiAVWcjIF6o&list=PLHTh1InhhwT6DdPY3CPxayypP5DXek_vG)

介绍各种tratis以及实现以及使用，算是back to basics的一部分

- [Back to Basics: Class Layout - Stephen Dewhurst - CppCon 2020](https://www.youtube.com/watch?v=SShSV_iV1Ko&list=PLHTh1InhhwT6DdPY3CPxayypP5DXek_vG&index=4)

这个值得一看，是<深入c++对象模型>这本书的内容+[[no_unique_address]]介绍

- [Calling Functions: A Tutorial - Klaus Iglberger - CppCon 2020](https://www.youtube.com/watch?v=GydNMuyQzWo&list=PLHTh1InhhwT6DdPY3CPxayypP5DXek_vG&index=7)

讲函数调用结合作用域的问题

- [Fuzzing Class Interfaces for Generating and Running Tests with libFuzzer - Barnabás Bágyi - CppCon](https://www.youtube.com/watch?v=TtPXYPJ5_eE)

更好的使用libfuzzer，作者写了个库，很好用，仓库地址在[这里](https://gitlab.com/wilzegers/autotest/)

这里说一下 fuzzer，AFL不是很好用，libfuzzer比较基础，面向API级别的。但是接口很简单。这个库主要是补充一些数据生成相关的东西

## 项目

- [Small Extremely Powerful Header Only C++ Lexical Analyzer/String Parser Library ](https://github.com/Jaysmito101/lexpp ) 一个lex库
- [meta-value-list](https://github.com/netcan/meta-value-list) 一个c++20元编程库
- [nanobench](https://github.com/martinus/nanobench) 一个benchmark库
- 有人弄了个[Roadmap for C++ developer](https://github.com/salmer/CppDeveloperRoadmap/blob/main/English/README.md) 可以看看。可以查缺补漏，但不必逐个学。逐个学总会放弃。会一点算一点
- [PcapPlusPlus](https://github.com/seladb/PcapPlusPlus/tree/v21.11) 是一个pcap封装库
- [bbai-mem](https://github.com/rnburn/bbai-mem) allocator aware 的智能指针
- [json_struct](https://github.com/jorgen/json_struct) json struct互相转换库

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/037.html)

