---
layout: post
title:  第35期
---

# C++ 中文周刊 第35期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-304.html)摘抄一些c++动态

每周更新

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[OSDT Weekly 2021-10-27 第121期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-09-22.md)

[标准会十月邮件列表](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2021/#mailing2021-10)

## 文章

- [c++ tip of week **Did you know that C++23 allows extended init-statement with alias-declaration in the for loop?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/249.md)

```c++
#include <initializer_list>
#include <iostream>

int main() {
  for (using T = int; T e : {1, 2}) {
    std::cout << e; // prints 1,2
  }

  for (struct T { int x; int y; }; T e : {T{1,2}, T{3,4}}) {
    std::cout << "{" << e.x << ',' << e.y << '}'; // prints {1,2}{3,4}
  }
}
```

if里面啥花活都能整了属于是

[godbolt体验](https://godbolt.org/z/Y3nvPafec)



- [Don’t reopen `namespace std`](https://quuxplusone.github.io/blog/2021/10/27/dont-reopen-namespace-std/)

```c++
struct Widget {};

namespace std {  // Danger!
    template<>
    struct hash<Widget> {
        size_t operator()(const Widget&) const;
    };
}

//这样写，不要上面那种写法
struct Widget {};

template<>
struct std::hash<Widget> {
    size_t operator()(const Widget&) const;
};

```

- [Functions to be called only once in C++](https://www.sandordargo.com/blog/2021/10/27/functions-to-call-only-once)

怎么保证一个函数只被调用一次呢，这里有个点子，Destructive separation: move away and call [Matt Godbolt and his talk at C++ On Sea 2020](https://youtu.be/nLSm3Haxz0I?t=2523).



```c++
#include <iostream>

class CostlyResult{};

class MyClass {
public:
  // ...
  [[nodiscard]] CostlyResult getCostly() && {
    return {};
  }
private:
};

int main() {
  MyClass mc;
  auto r = mc.getCostly();
}

```

这样调用会报错，因为你不是move的不能调用

于是就可以这样调用

```c++
auto r = std::move(mc).getCostly();
```

从而保证了一次调用，和生命周期同步了

但是，你要是这样调用

```c++
auto r = std::move(mc).getCostly();
auto r2 = std::move(mc).getCostly();
```

也拦不住。不过后面有篇文章继续讨论了这个话题

- [The Self-Growing Builder](https://marcoarena.wordpress.com/2021/10/25/the-self-growing-builder/)

```c++
void DoSomething(const Configuration& p)
{
   // ...
}
 
class ConfigurationBuilder
{
public:
   ConfigurationBuilder& SetName(string name)
   {
       m_data.name = move(name);
       return *this;
   }
 
   ConfigurationBuilder& SetFolderPath(path folderPath)
   {
       m_data.folderPath = move(folderPath);
       return *this;
   }
   // ...
 
   Configuration Build()
   {
      return m_data;
   }
private:
   Configuration m_data;
};
 
//...
 
auto conf = ConfigurationBuilder{}.
                  SetName("marco").
                  Build();
DoSomething(conf);
```

这段代码的问题在于，不能保证别人执行了Build这行代码，也不能保证所有代码都只执行一次，怎么做？加上类型判定 + move

完整代码[在这里](https://wandbox.org/permlink/xqaVo4yZGTylPpUJ)

首先，有个全局的标记数组，这个数组可以编译期算值

```c++
namespace utils
{
    template<typename... Pack>
    struct pack
    {
         template<typename T>
         static constexpr ssize_t index_of = []{ 
                constexpr array<bool, sizeof...(Pack)> bits {{ is_same<T, Pack>::value... }};
                const auto it = find(begin(bits), end(bits), true);
                return it != end(bits) ? distance(begin(bits), it) : -1;
         }();
          
         template<typename T>
         static constexpr bool has = []{ 
                return index_of<T> != -1;
         }();
    };
}
```

直接has判断这个类型对应的flag是不是标记了

然后，定义各种tag类型

```c++
namespace tags
{
    struct set_name_called{};
    struct set_folder_called{};
}
 
struct Configuration
{
    std::string name;
    std::filesystem::path folderPath;
};
 
template<typename... Tags>
class ConfigurationBuilder
{
public:
    ConfigurationBuilder<tags::set_name_called, Tags...> SetName(string name) &&
    {
       static_assert(utils::pack<Tags...>::template index_of<tags::set_name_called> == -1, "'SetName' has already been called!");
       m_data.name = move(name);
       return {move(m_data)};
    }
     
    ConfigurationBuilder<tags::set_folder_called, Tags...> SetFolderPath(path folderPath) &&
    {
       static_assert(utils::pack<Tags...>::template index_of<tags::set_folder_called> == -1, "'SetFolderPath' has already been called!");
       m_data.folderPath = move(folderPath);
       return {move(m_data)};
    }
 
    Configuration Build() &&
    {
        static_assert(utils::pack<Tags...>::template index_of<tags::set_name_called> != -1, "'SetName' is mandatory");
        static_assert(utils::pack<Tags...>::template index_of<tags::set_folder_called> != -1, "'SetFolderPath' is mandatory");
        return move(m_data);
    }
private:
    ConfigurationBuilder() = default;
 
    ConfigurationBuilder(Configuration c)
       : m_data(move(c))
    {
    }
     
    template<typename... K>
    friend class ConfigurationBuilder;
 
    friend ConfigurationBuilder<> BuildConfiguration();
 
    Configuration m_data;
};
 
ConfigurationBuilder<> BuildConfiguration(){ return{}; }
```

第一次调用，没问题，标记，第二次调用，不满足条件，static_assert报错

不过，这个措施，有点点复杂



然后tag，有各种分类，在用继承之类的扩展


- [Microsoft C++ Code Analysis with GitHub Actions](https://devblogs.microsoft.com/cppblog/microsoft-cpp-code-analysis-with-github-actions/)

设置github项目支持微软代码分析工具

- [There is no 'printf'.](https://www.netmeister.org/blog/return-printf.html)

作者看汇编发现原来printf是puts实现/替换的

- [Strange behavior with NaN and -ffast-math](https://kristerw.github.io/2021/10/26/fast-math-ub/)

一个向量化优化策略

```c++
if (x > y) {
  do_something();
} else {
  do_something_else();
}
```

优化成

```c++
if (x > y) {
  do_something();
}
if (x <= y) {
  do_something_else();
}
```

当 x y不是NaN就可以这样优化

`-ffinite-math-only`告诉编译器，没有NaN，大胆去优化，但是如果x y恰巧是NaN，那就完了

一个汇编例子 [godbolt](https://godbolt.org/z/cj51aaddn)

```c++
float a[1024];
float b[1024];

void foo(void) {
  for (int i = 0; i < 1024; ++i) {
    if (b[i] > 42.0f) {
      a[i] = b[i] + 1.0f;
    } else {
      b[i] = a[i] + 1.0f;
    }
  }
}
```

如果开了优化，b[i] 恰巧是NaN，那就完了，哪个if都不走

怎么处理这种问题？没有优雅的办法，这样也许可以

```c
feenableexcept(FE_OVERFLOW | FE_INVALID | FE_DIVBYZERO);
```

但不优雅。如果开启这个优化，务必了解你的代码会不会有NaN。能精细的控制优化的前提是扣掉某些场景。如果你的场景包含NaN，就别用这个优化



- [`operator<=>` doesn’t obsolete the hidden friend idiom](https://quuxplusone.github.io/blog/2021/10/22/hidden-friend-outlives-spaceship/)

实现<=>也得用friend惯用法，和其他的比较操作符类似，不然可能会有找不到调用的问题

```c++
struct Good {
    friend auto operator<=>(const Good&, const Good&) = default;
};

struct Bad {
    auto operator<=>(const Bad&) const = default;
};

static_assert(std::totally_ordered<Good>);
static_assert(std::totally_ordered<Bad>);

static_assert(std::totally_ordered<std::reference_wrapper<Good>>);
static_assert(not std::totally_ordered<std::reference_wrapper<Bad>>); // !!
```

- [In C++, is empty() faster than comparing the size with zero?](https://lemire.me/blog/2021/10/26/in-c-is-empty-faster-than-comparing-the-size-with-zero/)

简单来说是的 deque的empty就要比size快

但是有些自己实现的empty可能不一定比size == 0快。实现可能有问题 

- [Moves in Returns](https://artificial-mind.net/blog/2021/10/23/return-moves)

讨论了一些场景的返回值是否会被优化掉，[copy elision](https://en.cppreference.com/w/cpp/language/copy_elision)的生效场景

- [Stringy Templates](https://vector-of-bool.github.io/2021/10/22/string-templates.html)

讨论NTTP(Non-Type Template Parameters) 的用处，比如

```c++
template <size_t Length>
struct fixed_string {
    char _chars[Length+1] = {}; // +1 for null terminator
};
template <size_t N>
fixed_string(const char (&arr)[N])
    -> fixed_string<N-1>;  // Drop the null terminator
```

- [Row Polymorphism in C++20](https://caddi.tech/archives/2846)

实现ts里类型检查，类似

```typescript
type foo = { first: string, last: string };

const o = { first: "Foo", last: "Oof", age: 30 };
const p = { first: "Bar", last: "Rab", age: 45 };
const q = { first: "Baz", last: "Zab", gender: "m" };

const main = <T extends foo>(o: T) => (p: T) => o.first + o.last

main(o) (p); // type checks
main(o) (q); // type error
```

基本想法

```c++
import Mitama.Data.Extensible.Record;
#include <iostream>
#include <format>

using namespace mitama::literals;
using namespace std::literals;

void print(mitama::has<"name"_, "age"_> auto person) {
    std::cout << std::format("name = {}, age = {}\n", person["name"_], person["age"_]);
}

int main() {
    using mitama::as;
    // declare record type
    using Person = mitama::record
                   < mitama::named<"name"_, std::string>
                   , mitama::named<"age"_,  int>
                   >;

    // make record
    Person john = Person{
        "name"_v = "John"s,
        "age"_v  = 42,
    };

    // access to rows
    john["name"_]; // "John"
    john["age"_];  // 42

    print(john); // OK

    auto tom = mitama::empty
             += as<"name"_>("Tom"s)
             ;

    print(tom); // ERROR: constraints not satisfied
}
```



考虑如何实现？代码在[这里](https://github.com/LoliGothick/Mitama/blob/master/extensible/record_internal.ixx)

基本上是UDL实现name_ age_ ，然后用fix_string装起来，然后再判断不同的fix_string类型



- [Borrowing Trouble: The Difficulties Of A C++ Borrow-Checker](https://docs.google.com/document/d/e/2PACX-1vSt2VB1zQAJ6JDMaIA9PlmEgBxz2K5Tx6w2JqJNeYCy0gU4aoubdTxlENSKNSrQ2TXqPWcuwtXe6PlO/pub)

google实现c++上的borrow checker遇到的困难

- [Porting Takua Renderer to 64-bit ARM- Part 1](https://blog.yiningkarlli.com/2021/05/porting-takua-to-arm-pt1.html)

写移植Renderer遇到的问题，文章很长。这方面我不太懂，这里标记个TODO，后面补充

- [Automatic Return Type (C++11/14/20)](http://www.modernescpp.com/index.php/automatic-return-type-c-11-14-20)

还是讨论可变返回类型

```c++
#include <iostream>
#include <typeinfo>
#include <type_traits>

template <typename T, typename T2>
auto sum(T t, T2 t2) -> decltype(t + t2) {
    return t + t2;
}


int main() {

    std::cout << '\n';

    std::cout << typeid(sum(5.5, 5.5)).name() << '\n';     // double
    std::cout << typeid(sum(5.5, true)).name() << '\n';    // double
    std::cout << typeid(sum(true, 5.5)).name() << '\n';    // double
    std::cout << typeid(sum(true, false)).name() << '\n';  // int

    std::cout << '\n';

}
```



c++20

```c++
#include <iostream>
#include <typeinfo>
#include <type_traits>

template<typename T>
concept Arithmetic = std::is_arithmetic<T>::value;

Arithmetic auto sum(Arithmetic auto t, Arithmetic auto t2) {
    return t + t2;
}


int main() {

    std::cout << '\n';

    std::cout << typeid(sum(5.5, 5.5)).name() << '\n';     // double
    std::cout << typeid(sum(5.5, true)).name() << '\n';    // double
    std::cout << typeid(sum(true, 5.5)).name() << '\n';    // double
    std::cout << typeid(sum(true, false)).name() << '\n';  // int

    std::cout << '\n';

}
```



## 视频

- [C++ Weekly - Ep 295 - API Design: Principle of Least Surprise](https://www.youtube.com/watch?v=Qs4nje3KaFw)

在线评价别人的代码中的API设计是不是合理

- [Meeting C++ online - Andreas Reischuck - Using C++20 coroutines for asynchronous parsers](https://www.youtube.com/watch?v=u41EhjrqdGc)

教你用协程写个parser，[代码在这里](https://github.com/arBmind/co_parser_livecoding/)



## 项目

- [Yet Another C/C++ Package Manager](https://github.com/Calbabreaker/yacpm/) 又一个包管理，基于git和cmake的。（那我为什么不直接用cmake的fetchcontent）
- [static_vector](https://github.com/alekstheod/static_vector) 用vector实现了static_vector，有点意思

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/035.html)
