---
layout: post
title:  第33期
---

# C++ 中文周刊 第33期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/摘抄一些c++动态

这周周末有事，发的比较早

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[OSDT Weekly 2021-10-13 第119期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-10-13.md)

[QT 6出beta版本了](https://www.qt.io/blog/qt-creator-6-beta-released)

## 文章

- [C++ is faster and safer than Rust: benchmarked by Yandex](https://pvs-studio.com/en/blog/posts/0733/)

大概内容，rust并没有比c++快和安全。唯一优点就是生命周期检查

很多代码场景下c++的灵活性要高于强制安全检查，且一些场景下rust生成的汇编不如c++少

- [SerenityOS: Year 3 in review](https://serenityos.org/happy/3rd/)

serenity是一个c++写的操作系统，分享了一些开发记录/采访

- [Tutorial: the CRTP Interface Technique](https://www.foonathan.net/2021/10/crtp-interface/)

一篇CRTP示例。主要解决的问题，基本接口实现，不需要virtual

- [When can glibc be built with Clang?](https://zhuanlan.zhihu.com/p/421374967)

TODO：看不懂讲的啥

- [Lisp in a weekend](https://github.com/fragglet/yoctolisp/blob/master/yoctolisp.md)

用c写个lisp

- [[History of C++] The genesis of casting.](https://belaycpp.com/2021/10/14/history-of-c-the-genesis-of-casting/)

讲各种各样的cast

这里着重介绍一下bit_cast，这个就是强制解释的memcpy版本，对于内建基础类型使用的，比如

```c++
#include <cstdint>
#include <bit>
#include <iostream>
 
constexpr double f64v = 19880124.0;
constexpr auto u64v = std::bit_cast<std::uint64_t>(f64v);
 
constexpr std::uint64_t u64v2 = 0x3fe9000000000000ull;
constexpr auto f64v2 = std::bit_cast<double>(u64v2);
 
int main()
{
    std::cout
        << std::fixed <<f64v << "f64.to_bits() == 0x"
        << std::hex << u64v << "u64\n";
 
    std::cout
        << "f64::from_bits(0x" << std::hex << u64v2 << "u64) == "
        << std::fixed << f64v2 << "f64\n";
}
```

实现就是memcpy硬拷，其实这种需求用union不就搞定了。多个copy换安全吗

-  [Preventing an optimising compiler from removing or reordering your code.](https://theunixzoo.co.uk/blog/2021-10-14-preventing-optimisations.html)

考虑benchmark一段代码

```c++
bench_input = 42;
start_time = time();
bench_output = run_bench(bench_input);
result = time() - start_time;
```

这段代码的问题在于，编译器可能会重排time()导致run_bench的时间不准确

要保证，run_bench必须在两条time计算之间，不会被优化/重排 如何做？

google benchmark已经做过类似的工作`DoNotOptimize()`

```c++
bench_input = 42;
start_time = time();
DoNotOptimize(bench_input)
bench_output = run_bench(bench_input);
DoNotOptimize(bench_output)
result = time() - start_time;
```

`DoNotOptimize()`的作用是如何实现的？

```c++
inline BENCHMARK_ALWAYS_INLINE void DoNotOptimize(Tp& value) {
    asm volatile("" : "+r,m"(value) : : "memory");
}
```

这个asm可能看不懂，根据[GNU extended inline asm syntax](https://gcc.gnu.org/onlinedocs/gcc/Extended-Asm.html)，是这个意思

```txt
asm asm-qualifiers ( AssemblerTemplate
                 : OutputOperands
                 [ : InputOperands
                 [ : Clobbers ] ])
```

针对这行asm，volatile暗示会变，让编译器不优化，AssemblerTemplate是空的，也就是明显是空的无作用的汇编也不要删掉？

"memory" 也就是 ["clobbers memory"](https://gcc.gnu.org/onlinedocs/gcc/Extended-Asm.html#Clobbers-and-Scratch-Registers) 明示直接内存读，也就是暗示这个值经常变

[output constraints](https://gcc.gnu.org/onlinedocs/gcc/Extended-Asm.html#OutputOperands) (`"+r,m"(value)`  明示读写这个value



是不是必须要用clobber memory？

有个类似的实现

```c++
inline BENCHMARK_ALWAYS_INLINE void EnsureMaterialise(Tp& value) {
    asm volatile("" : "+r,m"(value) : :); // Doesn't clobber memory.
}

```

也是暗示value会变，也是暗示value不被优化，但是不能保证value的全局副作用，还是会被重排，这个用来测试比如jit优化constant propagation优化之类的场景，看差异



我们要保证，value的计算是影响周围的调用的，所以，要标记value是可变只能从内存读/寄存器读读（clobber memory）这样就有全局副作用，对于相关的函数调用，能保证不被重排。

所以重新回顾一下上面这段代码

```c++
bench_input = 42;

// May have global side-effects.
start_time = time();

// Also may have global side-effects.
// Needs to observe any side-effects of `time()`, so can't be re-ordered before it.
// Forces `bench_input` to be materialized, despite it being a constant.
DoNotOptimize(bench_input)
// Here the compiler must assume that `bench_input` has now been mutated.

// Is expected to observe the potentially mutated value of `bench_input`, therefore
// cannot be reordered before `DoNotOptimize()`.
bench_output = run_bench(bench_input);

// May have global side-effects.
// Depends on `bench_output` so cannot be reordered above `run_bench()`.
DoNotOptimize(bench_output)

// Also may have global side-effects.
// Needs to observe any potential side effects of `DoNotOptimize(bench_output)`, so
// cannot be reordered before it.
result = time() - start_time;

```

- [ffmpeg av1编码器哪家强？libaom-av1 librav1e libsvtav1实测](https://zhuanlan.zhihu.com/p/403982824) 看个乐

## 视频

### [Core C++ 2021](https://www.youtube.com/watch?v=b7LAtvFakBc&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5)

有一些不是英语还没有字幕，实在看不懂，跳过

- [Video Rendering on Frontend and Backend](https://www.youtube.com/watch?v=fXIheI4cDJc&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=4)介绍视频rendering相关技术栈 ffmpeg opengl之类的 相当于业内知识分享。有做这方面的可以看看

- [C++17 key features](https://www.youtube.com/watch?v=3gGhP0C-xOY&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=6) 介绍c++17特性的。没啥看头
- [Generators, Coroutines and Other Brain Unrolling Sweetness](https://www.youtube.com/watch?v=xOWV4i8Zaq4&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=7) 一个协程的介绍

介绍了协程的几个猥琐用法

比如用于树的遍历，协程的栈比函数栈要省

- [C++ 20 Overview: The Big Four](https://www.youtube.com/watch?v=emcC_Cv8EpQ&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=11)还是介绍c++20四大特性，concept coroutine module range
- [Design Patterns for Hardware Packet Processing on FPGAs](https://www.youtube.com/watch?v=TIAn5oSIacE&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=12) 英伟达员工，介绍一些fpga结合的经验 HLS啥的，这个也有点业内知识相关了。这里不懂就没继续看
- [opt-viewer: Inspecting compiler optimizations in high-level code](https://www.youtube.com/watch?v=BJ_yxTmZQbc&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=13)

Clang/gcc 用-Rpass可以看到优化的具体细节，不方便看？想要其他细节？借助工具，opt-viewer就是这么个工具，llvm组件里带的

但是有一定的缺点，CPU占用/内存之类的，作者改了一个[optview2](https://github.com/OfekShilon/optview2)

并展示了一些用法示例，这个工具对于编译器分析有点帮助。

- [Argument Passing, Core Guidelines, and Aliasing](https://www.youtube.com/watch?v=ZIwzy-5uDmE&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=14)

介绍了参数传递对性能的影响，列了一些极端场景。这里贴例子

传值比传引用重？传引用比传值轻？一般来说是，也有反例

STL中的场景

拷贝不可避免，比如accumulate，也更安全，比如transform

下面是几个好玩的例子(坑爹的用法)

const T&不一定是不可变的

```c++
void scale_down(vector<double>& v, const double& a) {
	for(auto&i : v) i /= a;
}
std::vector<double> a1{2, 2, 2};
scale_douw(a1,a1[0]);
// 1 2 2

```

我感觉这代码不喝两瓶啤酒写不出来

但是这种代码是有可能写出来的

```c++
#include <vector>
#include <iostream>
#include <iterator>
#include <string>
#include <sstream>
#include <cstdio>
using namespace std;

void inline print_vector(const std::vector<int> & v)
{
    ostringstream oss;
    copy(v.begin(), v.end(), std::ostream_iterator<int>(oss, " "));
    printf("%s\n", oss.str().c_str());
}
int main()
{
    vector<int> vec {1,2,3,4,5,6,1,2,3,4,5,6,1,2,3,4,5,6};
    vec.erase(std::remove(
        begin(vec), end(vec), 
                      *std::max_element(begin(vec), end(vec))),
          end(vec));
    print_vector(vec);
  // 1 2 3 4 5 1 2 3 4 5 6 2 3 4 5 6 
}
```

引用的位置对应的值变了，第一组1 2 3 4 5 6删掉了6，第二组的1补位，逻辑变成remove 1，然后2 3 4 5 6没删除，然后第三组 1 2 3 4 5 6，找到了1，最终就是这个效果

只能说，写代码的的时候少喝点酒

如何解决这个问题？把指针转换成值，强转一下，去掉指针信息，或者用decay_copy，原理都是一样的

```c++
template <class T>
  typename std::decay<T>::type
    decay_copy (T&& t) {
    return std::forward<T>(t);
  }
```



传引用反而比传值慢 [godbolt](https://godbolt.org/z/qo7o4e)

计算，传引用，寄存器利用效率不高，性能差, 用不上向量化

```c++
void byRef(std::vector<double>& v, const double& coeff) {
  for (auto& i : v) i *= std::sinh(coeff);
}

void byVal(std::vector<double>& v, double coeff) {
  for (auto& i : v) i *= std::sinh(coeff);
}

```

其实这背后有个问题，就是指针暗示着可能改动，所以不能尽可能 的优化，所以c中有restrict关键字，告诉你，这个指针在这个范围内不会被改，让编译器大胆做优化

作者还介绍了herb的一些实践，使用concept约束参数，以及思考std::ref stdx::val的用法等等。不过上面的代码例子是比较有意思值的看的了

- [Obfuscation and beyond: securing your binary](https://www.youtube.com/watch?v=6_8CkDWz3XQ&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=16) c++代码混淆的一些实践，以及一些安全实践
- [C++ on the Edge – Machine Learning + Microcontrollers + C++](https://www.youtube.com/watch?v=OePjufXudgE&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=17)介绍c++在32MCU上的实践，单片机用c++
- [The many faces of Number -- String conversions](https://www.youtube.com/watch?v=mq-DTBPkGc4&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=18) 讨论字符串数字转换的错误处理
- [ Latency Observability](https://www.youtube.com/watch?v=cxWKRAKZfuE&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=19) 其实这个我比较感兴趣，大概是讲怎么处理时间的RDTSC之类的，可惜不是英语，ppt也没有，这个标记TODO，后面找找ppt看看
- [ Implementing C++ Semantics in Python](https://www.youtube.com/watch?v=U74sqQGqZzk&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=21)

python实现RAII

```python
class Greeter:
  def __init__(self, name):
    self.name = name
    print(f"hello, {self.name}!")
    
  def __enter__(self):
    return self

  def __exit__(self, e_type, e_val, e_tb):
    print(f"goodbye, {self.name}!")

    
def main():
  with Greeter(1):
    print("we have a greeter")

main()
```

有了RAII，一个scopeguard就有了

```python
class DtorScope:
  def __init__(self):
    self.stack = []

  def __enter__(self):
    return self
  
  def __exit__(self, e_type, e_val, e_tb):
    while self.stack:
      self.stack.pop().__exit__(e_type, e_val, e_tb)
      
  def push(self, cm):
    self.stack.append(cm)
```

然后可以结合闭包，装饰器模式

```python
def cpp_function(f):
  def _wrapper(*args, **kwargs):
    with DtorScope():
      return f(*args, **kwargs)
    return _wrapper
```

这样就直接装饰main就行了

```python
main = cpp_function(main)
main()
```

或者直接

```python
@cpp_function
def main():
  ...
```



等一下，我们是c++周报,后面不展开了

PPT在[这里](https://github.com/tmr232/cpppy-talk)，代码在[这里](https://github.com/tmr232/cpppy)

- [C++ Integer Promotion is Completely Broken](https://www.youtube.com/watch?v=b0VjS0OKTmQ&list=PLn4wYlDYx4bt5jDwyOleg6J4kTtAu2rU5&index=23) 吐槽整型提升的。没啥说的
- [Runtime Reflection in C++](https://www.youtube.com/watch?v=60z_YlJtWYU) 介绍一种reflect实现，还是传统的宏+记录类型信息

## 项目

- [weggli](https://github.com/googleprojectzero/weggli) rust写的一个程序，能够搜索代码中的代码块。不是简单的关键字搜索，是模式搜索

看官方的例子

![](https://raw.githubusercontent.com/googleprojectzero/weggli/main/example.gif)

虽然是rust写的，但是是c++代码分析工具，所以放在这里了

TODO:有没有可能用c++重写？

-  [Discontinue Sourcetrail ](https://sourcetrail.com/blog/discontinue_sourcetrail/)sourcetrail是一个c++写的代码浏览工具，类似source insight，团队放弃开发了。不过现在这个领域没有人能搞的过jetbrains，开源用爱发电+社区推动确实疲惫。祝好
- [laugh Light Actor Framework](https://github.com/tyckesak/laugh)一个轻量的actor实现
- [tkrzw](https://github.com/estraier/tkrzw) 一个数据库实现，重写Tokyo Cabinet，文档在[这里](https://dbmx.net/tkrzw/) 也有个dbserver[文档](https://dbmx.net/tkrzw-rpc/) 其实之前我还真有过重写tokyocabinet的点子。不过搁置了
- [ttauri](https://github.com/ttauri-project/ttauri/) 一个c++20 GUI库
- [CrowCpp](https://github.com/CrowCpp/Crow/tree/v0.3%2B3) 是一个c++ http库框架，0.3版本发布

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/033.html)
