---
layout: post
title:  第31期
---

# C++ 中文周刊 第31期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-299.html)摘抄一些c++动态

每周更新

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[OSDT Weekly 2021-09-22 第116期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-09-22.md)

标准委员会九月邮件列表[直达](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2021/#mailing2021-09)

## 文章

- [Binary Banshees and Digital Demons](https://thephd.dev/binary-banshees-digital-demons-abi-c-c++-help-me-god-please)

讨论了各种各样新方案以及相关的abi-break问题，ABI-break这个问题必须要面对了，标准委员会还在拖

感觉未来要做ABI-break支持的准备的了

- [Borrowing Trouble: The Difficulties Of A C++ Borrow-Checker](https://docs.google.com/document/d/e/2PACX-1vSt2VB1zQAJ6JDMaIA9PlmEgBxz2K5Tx6w2JqJNeYCy0gU4aoubdTxlENSKNSrQ2TXqPWcuwtXe6PlO/pub)

直接看结论吧

> We attempted to represent ownership and borrowing through the C++ type  system, however the language does not lend itself to this. Thus memory  safety in C++ would need to be achieved through runtime checks. 

试验了实现borrow-checker库，但是语言库层面有局限实现不了rust那种功能（可能需要编译器开洞？）

- [c++ tip of week **Did you know about compiler predefined macros assosicated with the compilation date/time?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/244.md)

```c++
static_assert(std::string_view{"07:36::22"} == std::string_view{__TIME__}); // will only pass at certin time
static_assert(std::string_view{"Sep 19 2021"} == std::string_view{__DATE__}); // will only pass at certin date
```

没什么卵用的知识

- [C++20 Coroutine Iterators](https://blog.feabhas.com/2021/09/c20-coroutine-iterators/)

借助coroutine实现iterator生成器

- [Async stack traces in folly: Introduction](https://developers.facebook.com/blog/post/2021/09/16/async-stack-traces-folly-Introduction/)
- [Async stack traces in folly: Synchronous and asynchronous stack traces](https://developers.facebook.com/blog/post/2021/09/23/async-stack-traces-folly-synchronous-asynchronous-stack-traces/)

异步调用的堆栈分析一直是个麻烦的问题 这里介绍folly在这方面做的一些工作，如何实现打印异步的堆栈

使用coroutine来搞。很有意思

coroutine相关的概念在现在来说，需要面对并且掌握了，不然后面的文章可能看不懂

- [std::optional and non-POD C++ types](http://blog.felipe.rs/2021/09/19/std-optional-and-non-pod-types-in-cpp/)

std::optional和非POD类型的结合可能有点问题

```c++
class Object {
 private:
  std::string _s;

 public:
  Object() { puts("default-constructed"); }
  ~Object() { puts("destroyed"); }

  explicit Object(const std::string &s) : _s(s) { puts("constructed"); }

  Object(const Object &m) : _s(m._s) { puts("copy-constructed"); }
  Object &operator=(const Object &m) {
    puts("copy-assinged");
    _s = m._s;
    return *this;
  }

  Object(Object &&m) : _s(std::move(m._s)) { puts("move-constructed"); }
  Object &operator=(Object &&m) {
    puts("move-assigned");
    _s = std::move(m._s);
    return *this;
  }

  void dump() const { puts(_s.c_str()); }
};
std::optional<Object> maybe(const std::string &s) {
  if (s.empty()) {
    return std::nullopt;
  }
  return Object(s);
}

```

看起来没啥问题

但31行的return会多两次复制

改成

```c++
Object makeObject(const std::string &s);

std::optional<Object> maybe(const std::string &s) {
  if (s.empty()) {
    return std::nullopt;
  }
  return makeObject(s);
}
```

但更多场景是这样的的

```c++
std::optional<Object> maybe(const std::string &s) {
  if (s.empty()) {
    return std::nullopt;
  }
  Object o(s);
  doSomething(o);
  return o;
}
```

导致拷贝不可避免

一个小弊端，但是optional的收益不是特别高，仅仅一个语法糖

不过不必过于纠结这个问题

- [C++ Return: std::any, std::optional, or std::variant?](https://www.cppstories.com/2021/sphero-cpp-return/)

给`std::expected`做铺垫的。都没有`std::expected`好

- [A class without a copy constructor](https://quuxplusone.github.io/blog/2021/09/17/a-class-without-a-copy-constructor/)

也许你会说delete拷贝构造函数不就行了，其实delete了也是存在的(present)，不过被标记成了delete ,代码意义上的存在，虽然无法使用

那么有没有真正的解决办法呢？

```c++
template<class T>
struct C {
    C(const C&) requires (sizeof(T) != 1);
}
```

由于require不满足条件，拷贝构造不会生成，char不满足条件，也就是说`C<char>`没拷贝构造

这里有个msvc的[例子](https://godbolt.org/z/bYr8YhvjT)

```c++
struct FromC { FromC(const C<char>&); };
void f(C<char>);
void f(FromC);
void test(const C<char>& c) {
    f(c);
        // C<char>没有拷贝构造函数，不应该匹配上，应该匹配FromC
}
```

从`const C<char>& c`转换为`C<char>`需要拷贝构造但`C<char>`没有，所以匹配FromC

当前clang和gcc还没有实现类似的场景，匹配了C\<char>

## 视频

- [C++ Weekly - Ep 290 - C++14's Digit Separators and Binary Literals ](https://www.youtube.com/watch?v=Yop9D3V2KBk)

~~这个视频有三分钟的内嵌广告，有没有懂的说下这个广告值多少钱~~

实际上就是这段代码

```c++
auto a = 0xFF'AA;
auto num = 1'000'000'000'000;
```

注意这个分号的用法，增加代码可读性

实际上现在新的语言都加了这个小语法糖，分隔符，比如[rust](https://kaisery.github.io/trpl-zh-cn/ch03-02-data-types.html)

| 数字字面值                    | 例子          |
| ----------------------------- | ------------- |
| Decimal (十进制)              | `98_222`      |
| Hex (十六进制)                | `0xff`        |
| Octal (八进制)                | `0o77`        |
| Binary (二进制)               | `0b1111_0000` |
| Byte (单字节字符)(仅限于`u8`) | `b'A'`        |



### 把cpp on sea的视频总结一下

- [CI Your Presentation for Fun and Profit](https://www.youtube.com/watch?v=lIKKocTWZZU&list=PL5XXu3X6L7jtLi9qqEAfVfcas5inGLbk9&index=1)

写了一个reavel.js和compile explorer结合的npm包，这样代码演示片段可以直接跳转到complie explore里面去看，很有意思

使用方法在[npm包详情页](https://www.npmjs.com/package/reveal-compiler-explorer)

- [Bitmaps! Or "Images and Animations Without Linking External Libraries" - Mariusz Różycki C++ on Sea](Bitmaps! Or "Images and Animations Without Linking External Libraries" - Mariusz Różycki C++ on Sea)

把代码打印成图，用imagemagick的convert来转，[代码在这里](https://github.com/mrozycki/bitmaps)



## 项目

- [btop](https://github.com/aristocratos/btop)一个top实现，类似htop那种ui界面
- [stralgo](https://github.com/arturbac/stralgo) 一个string算法库，各种转换小工具，header-only

## 工作

[亚马逊redshift招c++工程师开发数据库](https://www.meetingcpp.com/jobs/items/-Senior--Software-Development-Engineer-for-Amazon-Redshift--Database--Cpp-.html)

国内的招聘太多了列不过来。先放放

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/031.html)
