---
layout: post
title:  第29期
---

# C++ 中文周刊 第29期



从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-297.html)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-09-08.md)

## 文章

- [Safer Usage Of C++](https://docs.google.com/document/d/e/2PACX-1vRZr-HJcYmf2Y76DhewaiJOhRNpjGHCxliAQTBhFxzv1QTae9o8mhBmDl32CRIuaWZLt5kVeH9e9jXv/pub)

众所周知c++有很多安全问题，整形溢出提升，内存泄漏，使用已经释放的指针(UAF)

google chrome团队介绍了一些让c++代码更安全的方法,

> - 删掉/减少裸指针的使用，这里有一篇文档来说明减少裸指针的方案，google已经在实施中
> - 生命周期控制 `[clang::lifetimebound]]`但这个有点缺陷，google还没开始，但这个是可行的
> - 自动内存管理 引用计数或者GC 这里google内部有个[Oilpan Garbage Collector](https://bugs.chromium.org/p/pdfium/issues/detail?id=1563) 使用后还是有一定效果的
> - 实现所有权分析 google没说怎么实现，但是是类似rust的方案，类似refcell
> - 使用`-Wdangling-gsl` 虽然有误报但效果还行
> - 确认标准库函数的所有表现，确定行为 abseil组在做
>   - 迭代器访问安全，有CheckedIterator
> - 整型语义确定清晰，避免各种溢出提升之类的坑爹问题 没用`-fwrapv`或者UBSan with trap-on-failure  直接用base/numerics里面的`Trapping<T>`
> - free的指针标记为nullptr `-fno-delete-null-pointer-check`
> - 代码的设计上规避生命周期控制问题
>   - `absl::variant`代替基于enum的状态机
>   - 禁止`std::unique_ptr::get`拿裸指针，使用`shared_ptr`
> - 所有用到内存的地方都得初始化 `-ftrivial-auto-var-init=pattern`
> - 移除原生数组，换成`std::array`
> - 避免共享
> - DCHECK NOTREACHED都收纳到CHECK宏里面实现
> - 避免MOVE后使用 类似UAF的问题



介绍一下[一些减少裸指针的方案](https://docs.google.com/document/d/1qsPh8Bcrma7S-5fobbCkBkXWaAijXOnorEqvIIGKzc0/edit#heading=h.j7d3wg2h6goh)

> - [Scan](https://source.chromium.org/chromium/chromium/src/+/master:base/allocator/partition_allocator/starscan/README.md) 其实和GC一样的扫描标记 [MarkUS](https://www.cl.cam.ac.uk/~tmj32/papers/docs/ainsworth20-sp.pdf)的论文实现
> - MiraclePtr 其实是各种各样的智能指针实现，满足不同需求，但核心都是RAII，有各种旁门左道的实现，硬件支持之类

文档中列举了各种小组件的优缺点

关于miracleptr，这里有个[资料汇总](https://docs.google.com/document/d/1pnnOAIz_DMWDI4oIOFoMAqLnf_MZ2GsrJNb_dbQ3ZBg/edit)没有细看。感觉值得单独抽出来讲讲

- [C-ing the Improvement: Progress on C23](https://thephd.dev/c-the-improvements-june-september-virtual-c-meeting)

介绍了一下c最新的提案(发展)

> - N2645 - `#elifdef` and `#elifndef` 没啥意思
> -  N2626 - Digit Separators `const unsigned magical_number = 1'633'902'946;`方便近视眼
> - N2630 - Formatted input/output of binary integer numbers 支持%b
> - N2680 - Specific Width Length Modifiers 还是标识符`printf("%w128d", my_128bit_integer);`
> - N2683 - Towards Integer Safety 加了几个函数帮助查溢出问题，`-fwrapv`的语言层支持
> - N2709 - Adding a Fundamental Type for N-bit Integers `_BitInt(N)`
> - N2713 - Integer Constant Expressions (and their use for Arrays) `int x[(int)+1.0];`????谁这么写代码
> - N2686 - #warning directive 好功能 这玩意cmake里用message。语言级别支持肯定更好
> - N2728 - char16_t & char32_t String Literals Shall be UTF-16 and UTF-32 不懂
> - N2799 - __has_include 这个c++也有

- [Yet another reason to not use printf (or write C code in general)](https://belaycpp.com/2021/08/31/yet-another-reason-to-not-use-printf-or-write-c-code-in-general/)

![](https://pbs.twimg.com/media/E9zxFEfUYAIv9-B?format=jpg&name=medium)

一个坑爹的未定义行为

> If a conversion specification is invalid, the behavior is undefined.

具体的原因可以看原博客

指定标识符的缺陷就在这里。所以说，能用fmt用fmt

- [Build glibc with LLD 13    ](https://maskray.me/blog/2021-09-05-build-glibc-with-lld)

TODO: 看不懂

- [Arthur O'Dwyer - Bit patterns of `float`](https://quuxplusone.github.io/blog/2021/09/05/float-format/)

TODO: 网页打不开

- [A compile-time benchmark for `enable_if` and `requires`](https://quuxplusone.github.io/blog/2021/09/04/enable-if-benchmark/)

比较了enable_if和require实现同等功能的编译速度。结论，各种编译器表现不一，但是差不太多

> - On Clang, C++20 `requires` is significantly *worse* than the rest.
> - On GCC 10.3, the extra-value-parameter method is significantly *better* than the rest.
> - On MSVC, the extra-type-parameter method seems *worse* than the other two SFINAE methods,  and C++20 `requires` seems to be operating on a different polynomial from the rest.

- [C++20 Modules — Complete Guide](https://medium.com/@happy.cerberus/c-20-modules-complete-guide-ae741ddbae3d)

手把手教你用module



## 视频

- [C++ Weekly - Ep 288 - Quick Perf Tip: Prefer `auto` ](https://www.youtube.com/watch?v=PJ-byW33-Hs)

如果用auto 尽量用const auto 或者const auto &

## 项目

- [yad](https://github.com/v1cont/yad) Yet Another Dialog 用gtk实现的图形库(GUI)

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/029.html)
