---
layout: post
title:  第28期
---

# C++ 中文周刊 第28期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-296.html)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-09-01.md)

## 文章

- [Bungie C++ Guidelines & Razors ](https://www.bungie.net/en/News/Article/50666)

一个游戏公司使用c++的经验分享

> 1. 可读性
>
>    1. 使用snake_case
>    2. 不用简写
>    3. 注释
>
>    例子
>
>    ```c++
>    int32 new_held_milliseconds= update_context->get_timestamp_milliseconds() - m_start_hold_timestamp_milliseconds;
>    
>    set_output_property_value_and_accumulate(
>        &m_current_held_milliseconds,
>        new_held_milliseconds,
>        &change_flags,
>        FLAG(_input_event_listener_change_flag_current_held_milliseconds));
>    
>    bool should_trigger_hold_event= m_total_hold_milliseconds > NONE &&
>        m_current_held_milliseconds > m_total_hold_milliseconds &&
>        !m_flags.test(_flag_hold_event_triggered);
>    
>    if (should_trigger_hold_event)
>    {
>        // Raise a flag to emit the hold event during event processing, and another
>        // to prevent emitting more events until the hold is released
>        m_flags.set(_flag_hold_event_desired, true);
>        m_flags.set(_flag_hold_event_triggered, true);
>    }
>    ```
>
>    
>
> 2. 格式统一
>
>    1. 英语拼写用美式英语 color colour的区别
>    2. 用i++而不是++i
>    3. *和&靠近变量而不是靠近类型
>
>    ~emmm啥品味啊这个~
>
> 3. 还是格式
>
>    1. 宏大写
>    2. 赋值不留空格
>
>    ```c++
>    void c_screen_manager::render()
>    {
>        bool ui_rendering_enabled= true;
>    
>    #ifdef UI_DEBUG_ENABLED
>        const c_ui_debug_globals *debug_globals= ui::get_debug_globals();
>    
>        if (debug_globals != nullptr && debug_globals->render.disabled)
>        {
>            ui_rendering_enabled= false;
>        }
>    #endif // UI_DEBUG_ENABLED
>    
>        if (ui_rendering_enabled)
>        {
>            // ...
>        }
>    }
>    ```
>
>    ~emmmm啥品味啊这~
>
> 4. 充分利用名字符号
>
>    1. ‪c_ 表示class, ‪e_ 表示枚举 m_ 表示成员变量, ‪k_表示常量
>    2. 函数名，get_blank()，try_get_blank要有如名字一样稳定的表现，让使用者放心
>
> 5. 维护性
>
>    1. 声明直接初始化
>    2. 函数一个return
>    3. 有assert保证状态正确性
>    4. 不用默认数组类型用其他实现的容器
>
>    ~emmm最后一条不明白缘由~
>
> 6. 资源管理中心话
>
>    1. 内部内存分配器，不直接调用malloc
>    2. 不用stl

- [c ++ tip of the week 241**Did you know about different ways of accessing C-style arrays by index?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/241.md)

```c++
int main() {
  constexpr int array[] = {1, 2, 3};
  assert(2[array] == array[2]);
  assert(*(array+1) == array[1]);
}
```

这学c的没有不知道的吧。没啥用反正。注意这个坑吧

- [Turning C++ metaprogramming inside-out with boost::hana](https://thecodepad.com/cpp/turning-c-metaprogramming-inside-out-with-boost-hana/)

介绍boost::hana的使用这里有个[cheatsheet](https://www.boost.org/doc/libs/1_61_0/libs/hana/doc/htmlindex.html#tutorial-quickstart-cheatsheet) 元编程，编译器计算，类型和值混起来保存，类似场景，boost::hana是一个好用的现代的库

- [[C++] The Flat Mixin](https://groundswellaudio.github.io/posts/cpp_the_flat_mixin/)

介绍继承模式

作者遇到的场景

```c++
struct heart {

	void pump_blood(){ std::cout << "baboom, baboom\n"; }
	
	bool consume_sugar(){ 
		if (sugar_level < 0)
			return false;
		--sugar_level;
		return true;
	}
	
	int sugar_level = 100;
};

template <class Base>
struct legs : Base {
	void move_legs(){ 
		this->pump_blood();
		std::cout << "legs are moving...\n"; 
	}
};

template <class Base>
struct body : Base {
	
	// hopefully Base has all the methods we need
	void move(float dx, float dy){
		if (not this->consume_sugar())
			return;
		this->move_legs();
		position[0] += dx;
		position[1] += dy;
	}
	
	float position[2] = {0, 0};
};
using final_body = body<legs<heart>>;
```

`using final_body = body<legs<heart>>;`这种是单向的依赖，如何抽出一套组合模版？

这里直接放代码

```c++
include <utility>
#include <type_traits>

template <class... Ts>
struct typelist{};

struct mixin_tag{};

template <class T>
inline constexpr bool is_mixin = std::is_base_of_v<mixin_tag, T>;

template <std::size_t Idx, class Mxn>
struct mixin_base {
	Mxn& root(){ return *static_cast<Mxn*>(this); }
	const Mxn& root() const { return *static_cast<const Mxn*>(this); }
};

template <class Seq, class Mxn, class Core, template <class...> class... Frags>
struct mixin_impl;

template <std::size_t... Idx, class Mxn, class Core, template <class...> class... Frags>
struct mixin_impl<std::integer_sequence<std::size_t, Idx...>, Mxn, Core, Frags...>
	: Core, Frags<mixin_base<Idx, Mxn>>...
{
	using frags_list = typelist<Core, Frags<mixin_base<Idx, Mxn>>...>;
};

template <class Core, template <class...> class... Frags>
struct mixin : 
	mixin_impl
	< 
		std::make_index_sequence<sizeof...(Frags)>, 
		mixin<Core, Frags...>,
		Core,
		Frags...
	>, 
	private mixin_tag
{
};

template <class F>
void invoke_all_one(auto& mxn, auto&& fn){
	if constexpr ( requires  { fn(static_cast<F&>(mxn)); } )
		fn(static_cast<F&>(mxn));
}

template <class... Frags>
void invoke_all_impl(auto&& mxn, auto&& fn, typelist<Frags...>){
	(invoke_all_one<Frags>(mxn, fn), ...);
}

template <class Mxn, class Fn>
	requires is_mixin<std::decay_t<Mxn>>
void invoke_all(Mxn&& mxn, Fn&& fn){
    using list = typename std::decay_t<Mxn>::frags_list;
	invoke_all_impl(mxn, fn, list{});
}

```



以及使用案例

```c++
enum class state {
	happy,
	angry,
	sad, 
	asleep
};

template <state State>
struct tag{};
	
template <class R>
struct brain : R {
	
	template <class Tag>
	void set_state(Tag){
		constexpr auto impl = [] (auto& frag)
			requires requires { frag.change_state(Tag{}); }
			{ frag.change_state(Tag{}); };
		invoke_all(this->root(), impl);
	}
	
	enum state state;
};

template <class R>
struct mouth : R {
	void change_state(tag<state::angry>){
		std::cout << "SKREEEEEEEEEEEEEEEE\n";	
	}
};

template <class R>
struct claws : R {
	void change_state(tag<state::angry>){
		std::cout << "protracting claws...\n";
	}
};

template <class R>
struct tail : R {
	void change_state(tag<state::angry>){
		std::cout << "unfolding tail...\n";
	}
};


struct feet{};

using creature = mixin<feet, tail, claws, mouth, brain>;

int main(){
	creature c;
	c.set_state( tag<state::angry>{} );
}
/*
unfolding tail...
protracting claws...
SKREEEEEEEEEEEEEEEE
*/
```

- [在LLVM中实现GPGPU Vector/Scalar Memory指令](https://zhuanlan.zhihu.com/p/404466911)

作者文章写的不错，了解LLVM的可以看一看

- [The Little Things: Comparing Floating Point Numbers](https://codingnest.com/the-little-things-comparing-floating-point-numbers/)

介绍浮点数怎么比较，一般来说都是精度比较，给定一个精度，误差范围内决定大小，[知乎这里也有个讨论](https://www.zhihu.com/question/37207811)值得一看

另外，这篇[文章,英文](https://bitbashing.io/comparing-floats.html)介绍要更详细一些

这里有一系列[讨论，英文]([Comparing Floating Point Numbers, 2012 Edition](https://randomascii.wordpress.com/2012/02/25/comparing-floating-point-numbers-2012-edition/))

这里多说一下ULP这种方法，wiki看[这里](https://zh.wikipedia.org/wiki/%E6%9C%80%E5%90%8E%E4%B8%80%E4%BD%8D%E4%B8%8A%E7%9A%84%E5%8D%95%E4%BD%8D%E5%80%BC)

代码

```c++
/* See
https://randomascii.wordpress.com/2012/01/11/tricks-with-the-floating-point-format/
for the potential portability problems with the union and bit-fields below.
*/

#include <stdint.h> // For int32_t, etc.

union Float_t
{
    Float_t(float num = 0.0f) : f(num) {}
    // Portable extraction of components.
    bool Negative() const { return i < 0; }
    int32_t RawMantissa() const { return i & ((1 << 23) - 1); }
    int32_t RawExponent() const { return (i >> 23) & 0xFF; }

    int32_t i;
    float f;
#ifdef _DEBUG
    struct
    {   // Bitfields for exploration. Do not use in production code.
        uint32_t mantissa : 23;
        uint32_t exponent : 8;
        uint32_t sign : 1;
    } parts;
#endif
};

bool AlmostEqualUlps(float A, float B, int maxUlpsDiff)
{
    Float_t uA(A);
    Float_t uB(B);

    // Different signs means they do not match.
    if (uA.Negative() != uB.Negative())
    {
        // Check for equality to make sure +0==-0
        if (A == B)
            return true;
        return false;
    }

    // Find the difference in ULPs.
    int ulpsDiff = abs(uA.i - uB.i);
    if (ulpsDiff <= maxUlpsDiff)
        return true;
    return false;
}
```

- [constexpr vector and string in C++20 and One Big Limitation](https://www.cppstories.com/2021/constexpr-vecstr-cpp20/)

constexpr和vector可以结合使用

```c++
#include <vector>
#include <numeric>
#include <algorithm>

struct Point {
    float x, y;
    constexpr Point& operator+=(const Point& a) noexcept {
        x += a.x;
        y += a.y;
        return *this;        
    }
};

constexpr bool testVector(int n) {
    std::vector<Point*> vec(n);
    for (auto& pt : vec) {
        pt = new Point;
        pt->x = 0.0f;
        pt->y = 1.0f;
    }
    Point sumPt { 0.0f, 0.0f};
    for (auto &pt : vec)
        sumPt += *pt;
    for (auto& pt : vec)
        delete pt;
    return static_cast<int>(sumPt.y) == n;
}

int main() {
	static_assert(testVector(10));
}
```

缺点，不能这么用

```c++
constexpr std::vector vec = compute();
```

分配内存不是constexpr的，所以后面要allocator来支持

用array绕过还是可以的

- [Asynchronous Stacks and Scopes](https://ericniebler.com/2021/08/29/asynchronous-stacks-and-scopes/)

讲异步抽象的对象生命周期问题

- [Synchronized output streams in C++20](https://mariusbancila.ro/blog/2021/09/01/synchronized-output-streams-in-c20/)

讲std::osyncstream的

这段代码

```c++
int main()
{
   std::vector<std::jthread> threads;
   for (int i = 1; i <= 10; ++i)
   {
      threads.push_back(
         std::jthread([](const int id)
            {
               std::cout << "I am thread [" << id << "]" << '\n';
            }, i));
   }
}
```

打印可能是乱的，但这段代码不是

```c++
int main()
{
   std::vector<std::jthread> threads;
   auto worker = [](std::string text) { std::cout << text; };
   auto names = { "Alpha", "Beta", "Gamma", "Delta", "Epsilon" };
   using namespace std::string_literals;
   for (auto const& name : names)
      threads.push_back(std::jthread(worker, "Hello, "s + name + "!\n"));
}
```



首先std::cout是线程安全的(除非设置`sync_with_stdio(false)`) 问题出在哪里？`operator<<`

怎么保证`operator<<`的原子性呢？用`std::osyncstream` 我怎么感觉是为了填坑补充的东西。

怎么用我就不介绍了。我觉得这套东西，别用，也别搞多线程printf的需求，这种需求一般log库都会去实现，加个队列来搞

## 视频

- [C++ Weekly - Ep 287 - Understanding `auto` ](https://www.youtube.com/watch?v=tn69TCMdYbQ)

讲auto的没啥说的



## 项目

- [skybison](https://github.com/facebookexperimental/skybison) Instagram放出了他们的一个激进 python实现不过没使用也不会在支持修改，已经全力切入到[Cinder](https://github.com/facebookincubator/cinder/)另一个python实现上了，这里开源出来放出一些设计的点子，建议点开[doc](https://github.com/facebookexperimental/skybison/tree/trunk/doc)看一下
- [cachelib](https://github.com/facebook/CacheLib) facebook分享了他们的一个cachelib实现，相当于cache引擎，对应redis的内部输出结构实现那种形式,FB还发了论文。值得研究一下
- [swl-optional](https://github.com/groundswellaudio/swl-optional) 用c++20重新实现optional

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/028.html)
