---
layout: post
title:  第23期
---

# C++ 中文周刊 第23期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-291.html)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-07-28.md)

- [c++委员会七月提案汇总](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2021/#mailing2021-07)

语言律师有没有关注的

## 文章

- [使用 C++20 Ranges 标准库实现日历程序](https://zhuanlan.zhihu.com/p/394454479)

可以看这个学一点range，挺有趣的

- [c++ tip of week **Did you know about `__builtin_dump_struct` clang-extension which can nicely print a struct?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/236.md)

介绍一个clang builtin扩展

```c++
#include <cstdint>
#include <cstdio>
#include <utility>

struct trade {
  [[no_unique_address]] double price{42.};
  [[no_unique_address]] std::size_t size{1'000};
};

int main() {
  constexpr auto t = trade{};
  __builtin_dump_struct(std::addressof(t), std::addressof(std::printf));
}
```

效果

```
const struct trade {
double price : 42.000000
std::size_t size : 1000
}
```



- [Docker4c: portable C++ development environment](https://arne-mertz.de/2021/07/docker4c-portable-c-development-environment/)

作者弄了个docker环境，方便c++开发 https://github.com/arnemertz/docker4c ~~不过一般都有自己的docker/编译机环境吧，这东西很难通用~~

- [Memory profiling on windows for C++](https://thatonegamedev.com/cpp/memory-profiling-on-windows-for-c/)

windows平台上的内存分析方案介绍

winrt本土方案

```c++
#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>

int main()
{
    //...
    _CrtSetDbgFlag ( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF ); // This is used to auto output memory information about leaks before closing the application
    _CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_DEBUG ); // Set to output into your IDE's debug window
    //...
}

//...
_CrtMemState oldState;
_CrtMemState newState;
_CrtMemState stateDiff;

_CrtMemCheckpoint(&oldState);

// ... Do some memory action

_CrtMemCheckpoint(&newState);

if (_CrtMemDifference(&stateDiff, &oldState, &newState))
{
    // Simple statistics between the state
    _CrtMemDumpStatistics(&stateDiff);

    // Dump all created objects
    _CrtMemDumpAllObjectsSince(&oldState);

    // Dump the memory leaks up until now
    _CrtDumpMemoryLeaks();
}
```

vs工具 Diagnostic Tools

 MTuner

- [Measuring memory usage: virtual versus real memory](https://lemire.me/blog/2021/07/29/measuring-memory-usage-virtual-versus-real-memory/)

画了个图，分配内存和系统用内存比，基本一致，代码在这https://github.com/lemire/Code-used-on-Daniel-Lemire-s-blog/tree/master/2021/07/29

- [Hotspot: How const Can Improve Performance](https://www.kdab.com/hotspot-to-fix-string-copy/)

用perf + hotspot打印火焰图，发现性能问题(其实就是perf加了个可视化gui)

-  [Finding Windows HANDLE leaks, in Chromium and others](https://randomascii.wordpress.com/2021/07/25/finding-windows-handle-leaks-in-chromium-and-others/)

用handle简单确认`handle -s -p 13360`

然后用[Event Tracing for Windows](https://randomascii.wordpress.com/2015/09/24/etw-central/) 然后就是确认问题出在哪里然后抓WaitableEvent信息了。这个东西我不了解，不过思路有点意思

- [Counting in Iteration Models](https://brevzin.github.io/c++/2021/07/26/counted-iterator/)

介绍[counted_iterator](https://en.cppreference.com/w/cpp/iterator/counted_iterator)的缺陷，简单来说 counted_iterator的逻辑是这样的

```
loop:
    // advance
    --count;
    ++it;
    // done?
    if (count != 0 && it != end) {
        // read
        use(*it);
        goto loop;
    }
```

这里有个问题，count是后面it判断的前提条件，这里不应该并列，假如有个无限大的view，it一时半会不会到end，这里就一直循环了

比如这样一段代码

```c++
#include <ranges>
#include <iostream>
namespace rn = std::ranges;
namespace rv = rn::views;
int main()
{
    for (auto i  : rv::iota(0)
        | rv::filter([](auto i) { return i < 10; })
        | rv::take(10))
    {
        std::cout << i << '\n';
    }
}
```

这里满足不了，take(10)会永远循环，改成<10就没问题

恰好是因为这个if (count != 0 && it != end) ，it不满足条件，导致一直跑下去

所以这里的逻辑要改成

```
loop:
    --count;
    if (count != 0) {
        ++it; // guarded
        if (it != end) {
            use(*it);
            goto loop;
        }
    }
```



## 视频

- [C++ Weekly - Ep 282 - Quick Perf Tip: Don't Repeat Your Work ](https://www.youtube.com/watch?v=IcoNGRL-K5c)

在线点评别人的benchmark代码写的不行。没啥看的

## 项目

[Triton: Open-Source GPU Programming for Neural Networks](https://github.com/openai/triton) 一个python调用c++库的一个神经网络库，这有个[教程](https://triton-lang.org/getting-started/tutorials/01-vector-add.html#sphx-glr-getting-started-tutorials-01-vector-add-py)

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/023.html)
