---
layout: post
title:  第21期
---

# C++ 中文周刊 第21期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-289.html)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-07-14.md)

- [论文 Model Checking C++Programs](https://arxiv.org/pdf/2107.01093.pdf)

大概是程序验证的东西，看不懂

- [Vs2022 预览版出了](https://devblogs.microsoft.com/visualstudio/visual-studio-2022-preview-2-is-out/)里面有下载链接
- [HPX 1.7发布，更新c++最新特性支持](https://hpx.stellar-group.org/2021/07/14/hpx-1-7-0-released/)
- [Thriving in a crowded and changing world: C++ 2006-2020    ](https://www.pldi21.org/prerecorded_hopl.5.html)

Bjarne Stroustrup在PLDI上发表了重要讲话，总结了c++近年来的飞速发展

这有个[pdf](https://www.stroustrup.com/hopl20main-p5-p-bfc9cd4--final.pdf)

## 文章

- [max\<uint64>的实现与编译器优化](https://zhuanlan.zhihu.com/p/387794521)

需要了解simd sse 汇编

- [ An `iterator` IS-NOT-A `const_iterator`](https://quuxplusone.github.io/blog/2021/07/14/an-iterator-is-not-a-const-iterator/)

   语言律师Arthur O’Dwyer 又给我们整新活了。

  ```c++
  template<class C>
  struct Wrap {
      Wrap(C&);
      operator C::iterator() const;
  };
  
  template<class C>
  void f(C&, typename C::const_iterator);
  
  int main() {
      std::list<int> v;
      f(v, Wrap(v));
  }
  
  ```

  这段代码在不同的libc++下表现不一致，msvc能编过([Godbolt](https://godbolt.org/z/GEzWPrcKM)). 

  之前也有讨论const iterator的实现

  https://quuxplusone.github.io/blog/2018/12/01/const-iterator-antipatterns/

- [Faster sorted array unions by reducing branches](https://lemire.me/blog/2021/07/14/faster-sorted-array-unions-by-reducing-branches/)

[Daniel Lemire](https://lemire.me/blog/) 新活, 场景是合并两个排好序的数组，伪代码这样

```c
    v1 = first value in input 1
    v2 = first value in input 2
    while(....) {
        if(v1 < v2) {
            output v1
            advance v1
        } else if (v1 > v2) {
            output v2
            advance v2
        } else {
           output v1 == v2
           advance v1 and v2
        }
    }
```

如何减少分支？用`?:`

```c
while ((pos1 < size1) & (pos2 < size2)) {
    v1 = input1[pos1];
    v2 = input2[pos2];
    output_buffer[pos++] = (v1 <= v2) ? v1 : v2;
    pos1 = (v1 <= v2) ? pos1 + 1 : pos1;
    pos2 = (v1 >= v2) ? pos2 + 1 : pos2;
 }
```

看生成的汇编，效果很好很多move [godbolt](https://godbolt.org/z/sTWzn35Pd)

他的测试代码在这里https://github.com/lemire/Code-used-on-Daniel-Lemire-s-blog/blob/master/2021/07/14/union2by2.cpp

简单压测的数据

| system             | conventional union | ‘branchless’ union |
| ------------------ | ------------------ | ------------------ |
| Apple M1, LLVM 12  | 2.5                | 2.0                |
| AMD Zen 2, GCC 10  | 3.4                | 3.7                |
| AMD Zen 2, LLVM 11 | 3.4                | 3.0                |

但是我用quickbench的到的数据，gcc场景不快，clang场景快了一点

https://quick-bench.com/q/tNdjEe-55p6zPjDGF-jBIgDYJAQ

<img src="https://wanghenshui.github.io/assets/unionby2.png" alt=""  width="100%">

- [Five Awesome C++ Papers for the Q2 2021 and C++23 Status](https://www.cppstories.com/2021/q2-cpp-papers/)

来看看第二季度c++提案有什么好看的

**Making std::unique_ptr constexpr**[P2273R1](https://wg21.link/P2273R1)

让unique_ptr更灵活，不必要的RAII去掉,比如这种

```c++
constexpr auto fun() {
    auto p = std::make_unique <int>(4);
    return *p;
}

constexpr auto i = fun();
static_assert(4 == i);

```



**Support for UTF-8 as a portable source file encoding**[P2295R3](https://wg21.link/P2295R3) 统一一下utf编码

 **Stacktrace from exception** [P2370R0](https://wg21.link/P2370R0) 抛异常会丢堆栈信息，这也是很多人不愿意用std::thread的原因，旧版本有问题，会丢堆栈，这里加个补丁

**std::expected** [P0323R10](https://wg21.link/P0323R10) 终于有了，这个就是rocksdb那种status类的泛式封装，像这样

```c++
std::expected<Object, error_code> PrepareData(inputs...);
```

**Mark all library static cast wrappers as [[nodiscard]] ** [P2351R0](https://wg21.link/P2351R0) 还是补丁，static_cast右值会告警，但是std::move不会，但std::move是static_cast简单包了一层，所以把static_cast也标记上

```c++
val; 
static_cast<T &&>(val); // gives warning
std::move(val);         // no warning!
```

还有这些也建议加上[[nodiscard]]

> - `to_integer`
> - `forward`
> - `move` - yep, `move()` doesn’t move :) it’s a cast to r-value reference.
> - `move_if_noexcept`
> - `as_const`
> - `to_underlying`
> - `identity`
> - `bit_cast`

- [手把手教你配置github c++项目的覆盖率](https://about.codecov.io/blog/how-to-set-up-codecov-with-c-plus-plus-and-github-actions/)

- [c++ tip of week 234 **Did you know about function-try-block and that exceptions caught inside that block are implicitly rethrown?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/234.md)

  注意下面的代码中try catch的用法，[godbolt体验](https://godbolt.org/z/Y4efK573f)

```c++
struct foo {
  foo() { throw 0; }
};

struct bar {
  bar() try : foo_{} {
    // constructor body
  }
  catch (...)
  {
    // exceptions from the initializer list are caught here
    // but also re-thrown after this block (unless the program is aborted)
  }

private:
  foo foo_;
};

int main() try {
  bar b{};
}
catch(...) {
  // okay, exception cought here!
}
```

- [Writing a Bash Builtin in C to Parse INI Configs      ](https://mbuki-mvuki.org/posts/2021-07-12-writing-a-bash-builtin-in-c-to-parse-ini-configs/)

可能有人不知道cd命令实际上是bash内建(builtin)的命令,这里带你了解bash builtin函数的面纱以及手把手教你写一个builtin函数

完整代码在这里 https://github.com/lollipopman/bash-ini-builtin-blog-post

- [Running advanced C++ software on MCUs](https://www.embedded.com/running-advanced-c-software-on-mcus/)

在嵌入式平台，比如stm32之类的小芯片上跑c++的代码。大概意思是实现了一个库，把c++代码翻译成c

- [All rotations of a string with ranges – #thatsarotate](https://marcoarena.wordpress.com/2021/07/14/all-rotations-of-a-string-with-ranges-thatsarotate/)

旋转字符串的几种写法

## 视频

- [C++ Weekly - Ep 280 - A Quick Look At The Source To Amazon's O3DE Game Engine (constexpr surprises!) ](https://www.youtube.com/watch?v=IndGlm2uZCU)

代码简单走读O3DE，一个游戏引擎 https://github.com/o3de/o3de 简单总结-读起来有点费劲

- [One Friend Ain't Enough - Jody Hagins [CppNow 2021]](https://www.youtube.com/watch?v=zvWCgiVvpPU)

这人想要变参friend，苦于不懂编译器，到cppnow来找人帮忙来了，老哥很幽默



## 项目

- 一个配置加载库 https://github.com/netcan/config-loader/blob/master/README_CN.md
- 一个wc -l的c++实现 https://github.com/p-ranav/lc，要比wc快，为什么呢？用了mmap
- 一个游戏引擎 https://github.com/o3de/o3de
- 一个shader？ https://github.com/GPUOpen-Effects/FidelityFX-FSR 作者在[这里](https://www.zhihu.com/people/xziar) 这个我不太懂
- 感知智能指针分配的allocatorhttps://github.com/rnburn/bbai-mem

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/021.html)
