---
layout: post
title:  第18期
---

# C++ 中文周刊 第18期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-06-23.md)

- fmtlib发布8.0，性能提升，各种功能下沉到编译期计算 https://github.com/fmtlib/fmt/releases/tag/8.0.0

## 文章

- [control dependency](https://zhuanlan.zhihu.com/p/383702555)

由于指令重排而导致的多线程问题主要是两个，数据依赖与控制依赖，数据依赖就是可见性

控制依赖类似这段代码

```c
int x = a
if x > 10
   y = b
else
   z = b
```

引入volatile_if来解决，非常暴力

```c
#define barier_true() ({ barrier(); 1; })
#define volatile_if(x) if ((x) && barrier_true())

#define barrier() __asm__ __volatile__("": : :"memory")
```



- [c++ tip of week 231 **Did you know about C++17 variadic using declaration?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/231.md)

注意using的用法

```c++
template<class... TEvents>
struct ihandler : ihandler<TEvents>... {
  virtual ~ihandler() noexcept = default;
  using ihandler<TEvents>::on...;
};

template<class TEvent> struct ihandler<TEvent> {
  virtual ~ihandler() noexcept = default;
  virtual auto on(const TEvent&) -> bool = 0;
};

int main() {
  struct foo {};
  struct bar {};

  struct handler : ihandler<foo, bar> {
    auto on(const foo&) -> bool override { return true; }
    auto on(const bar&) -> bool override { return false; }
  };

  std::unique_ptr<ihandler<foo, bar>> h = std::make_unique<handler>();
  assert(h->on(foo{}));
  assert(not h->on(bar{}));
}
```

- [The big STL Algorithms tutorial: merge and inplace_merge](https://www.sandordargo.com/blog/2021/06/23/stl-alogorithms-tutorial-part-21-merge-inplace_merge) 

介绍inplace_merge 归并算法

- [iOS SSID format string bug is preventable](https://www.zverovich.net/2021/06/22/preventing-format-string-bugs.html)

最近苹果IOS系统出现一个bug，如果把wifi名字改成%p%s%s%s%s%n，苹果手机连上就会出现wifi挂掉永远连不上。这种字符串初始化是比较原始的设计里。在c++现在的代码，如何避免这种问题呢？ fmt库以及std::format

- [Reversing words of a string with ranges -#thatsarotate](https://marcoarena.wordpress.com/2021/06/23/reversing-words-of-a-string-with-ranges-thatsarotate/)

介绍了使用range反转字符串的几种写法：



## 视频

- [C++ Weekly - Ep 277 - Quick Perf Tip: Avoid Integer Conversions ](https://www.youtube.com/watch?v=jKpIZ4UcaNw)

<iframe width="560" height="315" src="https://www.youtube.com/embed/jKpIZ4UcaNw" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

使用恰当的值类型，避免转换造成的效率低下，另外编译器警告都开开, 用  -Wsign-conversion，别用-Wconversion

> For signed <-> unsigned conversion gcc has a -Wsign-conversion flag. For some reason -Wconversion is not working there. According to gcc docs: "Warnings about conversions between signed and unsigned integers are disabled by default in C++ unless -Wsign-conversion is explicitly enabled."

- 意大利cppcon进行中！这是他们的ppt https://github.com/italiancpp/itcppcon21

我觉得就不如直接看ppt

简单概括这些视频内容

<iframe width="560" height="315" src="https://www.youtube.com/embed/NO5wHzI_oug" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>



std::find_if std::remove_if传进去 的lambda不能有状态，必须是regular的，还讲了一大堆其他的东西，大概意思是注意把函数写对之类的

<iframe width="560" height="315" src="https://www.youtube.com/embed/qwnJWPuLNwo" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

介绍静态分析的原理 类型系统等等

<iframe width="560" height="315" src="https://www.youtube.com/embed/uvVN3L1sjyw" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

介绍windows错误分析的，这个我不懂，就没看



<iframe width="560" height="315" src="https://www.youtube.com/embed/VNwm_9QaQHI" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>



介绍wasm的，没有细看



<iframe width="560" height="315" src="https://www.youtube.com/embed/aWGrp992Iy4" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>





## 项目

- https://github.com/YarikTH/ureact 一个react库
- https://github.com/sammycage/lunasvg 一个svg库

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/018.html)
