---
layout: post
title:  第17期
---

# C++ 中文周刊 第17期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-06-16.md)



- VS 2022预览版出了 https://devblogs.microsoft.com/visualstudio/visual-studio-2022-preview-1-now-available/

## 文章

-  [C++ folly库解读（二） small_vector —— 小数据集下的std::vector替代方案](https://zhuanlan.zhihu.com/p/353485606)

介绍small_vector, small_vector有很多实现，算是一个小对象优化

- [c++ tip of week 230 **Did you know that C++23 added `if consteval`?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/230.md)

```c++
#include <cassert>

consteval int f(int i) { return i; }

constexpr int g(int i) {
    if consteval {
        return f(i) + 1; // ok: immediate function context
    } else {
        return 42;
    }
}

consteval int h(int i) {
    return f(i) + 1; // ok: immediate function context
}

static_assert(42 + 1 == h(42));

int main() {
  int i = 42;
  //h(i); // error: the value of 'i' is not usable in a constant expression
  assert(42 == g(i));
}
```

https://godbolt.org/z/rjeodeMoP

- [Using C++20's concepts as a CRTP alternative: a viable replacement?    ](https://joelfilho.com/blog/2021/emulating_crtp_with_cpp_concepts/)

用concept来实现CRTP模式，遇到了很多阻碍，如果有[Unified Function Call Syntax , UFCS](https://brevzin.github.io/c++/2019/04/13/ufcs-history/)说不定能解决，当前不推荐，可以当做一个拓展眼界的思路看一看

- [一篇文章带你读懂 io_uring 的接口与实现](https://zhuanlan.zhihu.com/p/380726590) 介绍io_uring设计的，算c吧

总结整理写的挺好

> - `io_uring` 大致可以分为默认、`IOPOLL`、`SQPOLL`、`IOPOLL + SQPOLL` 四种模式。可以根据操作是否需要轮询选择开启 `IOPOLL`。如果需要更高实时性、减少 syscall 开销，可以考虑开启 `SQPOLL`。
> - 如果只是使用 Buffered I/O，`io_uring` 相比于用户态直接调用 syscall，通常不会有特别大的性能提升。`io_uring` 内部通过 io-wq 执行 Buffered I/O 操作，和直接在用户态调用 syscall 在本质上没有太大区别，只能减小用户态内核态切换的开销。`io_uring` 提交任务要走一遍 `io_uring_enter`syscall，延迟和吞吐量应该比不上 mmap 之类的文件 I/O 操作方法。
> - 如果不想在提交时立刻尝试执行一次任务（比如之前提到的文件内容已经在 page cache 的情况），可以加上 `IOSQE_ASYNC` flag，强制走 io-wq。
> - 使用 `IO_SQE_LINK`, `IOSQE_IO_DRAIN` 和 `IOSQE_IO_HARDLINK` 可以控制任务的依赖关系。

- [Can memcpy be implemented in LLVM IR?](http://nhaehnle.blogspot.com/2021/06/can-memcpy-be-implemented-in-llvm-ir.html) 

TODO 不懂LLVM IR，后面了解一下

- [[llvm-dev] [RFC] Introducing a byte type to LLVM](https://lists.llvm.org/pipermail/llvm-dev/2021-June/151199.html) 
- [Using black magic to make a fast circular buffer.](https://lo.calho.st/posts/black-magic-buffer/)

介绍一个快的循环队列，其实技巧就是mmap + bip buffer类似的技术 代码在[这里](https://github.com/tmick0/toy-queue/)

- [Notes: brpc DoublyBufferedData](https://zhuanlan.zhihu.com/p/331640435)

介绍brpc的小组件，brpc的小技巧很多，文档也很详细，值得一看

- 开源数据库OceanBase代码导读 和代码相关的不多，这个建议攒一起看
  - https://zhuanlan.zhihu.com/p/379789426
  - https://zhuanlan.zhihu.com/p/380681441
  - https://zhuanlan.zhihu.com/p/381020426
- [The Unfair Mutex](https://www.ttauri-project.org/2021/06/15/the-unfair-mutex.html)

用原子量自旋来实现的mutex，代码在[这里](https://github.com/ttauri-project/ttauri/blob/48cf9213a751d5a95cf61fd9bb8dd9462c4d98e7/src/ttauri/unfair_mutex.hpp)

TODO: 阅读 [Futexes Are Tricky](https://www.akkadia.org/drepper/futex.pdf)

- [Template Arguments](http://www.modernescpp.com/index.php/template-arguments)

介绍了模版参数的一些场景

- [DuckDB:  Row-Group Based Storage](https://zhuanlan.zhihu.com/p/382131436)

介绍duckdb数据结构设计的，有点意思

- [LevelDB: Write Path](https://zhuanlan.zhihu.com/p/382034971)

leveldb写路径代码走读

## 视频

- [C++ Weekly - Ep 276 - C++20's Conditionally `explicit` Conversions](https://www.youtube.com/watch?v=CMmkoy24XhU) 



## 项目

- 实现match https://github.com/BowenFu/matchit.cpp

```c++
#include "matchit/core.h"
#include "matchit/patterns.h"
#include "matchit/expression.h"
using namespace matchit;

constexpr int32_t factorial(int32_t n)
{
    assert(n >= 0);
    return match(n)(
        pattern(0) = expr(1),
        pattern(_) = [n] { return n * factorial(n - 1); }
    );
}
```

- https://github.com/Tencent/yadcc 腾讯开源分布式编译系统 编译加速缓存二进制
- https://github.com/Tencent/TBase 腾讯开源分布式PG数据库tbase c的实现，复用了PG的代码

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/017.html)
