---
layout: post
title:  第十六期
---

# C++ 中文周刊 第16期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-06-09.md)

一些软件的更新，clion/qt等等不多说了

- [Trip report: Summer 2021 ISO C++ standards meeting (virtual)](https://herbsutter.com/2021/06/09/trip-report-summer-2021-iso-c-standards-meeting-virtual/)

最近c++的提案进展

修正if constexpr的bug [P1938](http://wg21.link/p1938)，比如这段代码 `if constexpr (std::is_constant_evaluated())`

```c++
constexpr size_t strlen(char const* s) {
    if constexpr (std::is_constant_evaluated()) {
        for (const char *p = s; ; ++p) {
            if (*p == '\0') {
                return static_cast<std::size_t>(p - s);
            }
        }    
    } else {
        __asm__("SSE 4.2 insanity");        
    }
}
```

修复string从nullptr构造的错误 [P2166](http://wg21.link/p2166) 

out_ptr and inout_ptr 帮助指示指针所有权 [P1132](http://wg21.link/p1132) 

加上 `ranges::starts_with`and` ranges::ends_with`让string操作更流畅 [P1659](http://wg21.link/p1659) 

让static_assert中的值默认为bool [P1401](http://wg21.link/p1401)

> | Today                                      | If accepted                         |
> | ------------------------------------------ | ----------------------------------- |
> | `if constexpr(bool(flags & Flags::Exec))`  | `if constexpr(flags & Flags::Exec)` |
> | `if constexpr((flags & Flags::Exec) != 0)` | `if constexpr(flags & Flags::Exec)` |
> | `static_assert(bool(N));`                  | `static_assert(N);`                 |
> | `static_assert(N % 4 != 0);`               | `static_assert(N % 4);`             |

Concurrency TS:又开始了， [P1121](https://wg21.link/p1121) and [P1122](http://wg21.link/p1122)  hazard pointers read-copy-update (RCU) 这终于要进入大众视野里，好事一件



## 文章

- [效能优化实践：C/C++单元测试万能插桩工具](https://zhuanlan.zhihu.com/p/379605663)

这篇文章里提到了一个方法，帮助测试代码的

> 可以使用-fno-access-control 编译你的测试代码，可以使 g++关闭 c++成员的访问控制（即 protected 及 private 不再生效）

从来没注意过，很有意思

- [c++ tip of week 229 **Did you know about python's named tuples?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/229.md)

如何实现python中的namedtuple？

```python
from collections import namedtuple

nt = namedtuple("price", "size")

nt.price = 42;
nt.size = 100;

assert 42 == nt.price and 100 == nt.size
```

看起来像map，但是和tuple无缝衔接

最简单的思路就是记住name到index的映射，再从index拿到tuple的元素，也就是map+tuple的组合

比如[Poco.NamedTuple.h](https://pocoproject.org/docs/Poco.NamedTuple.html) 这个name是有限的

现在2021了，都是变参模版了，用这个方法也不是不可以，但是从tuple本身的角度来考虑

name 字符串本身可以封装成tuple，一个最简单的一个元素的name tuple也是tuple，所以name tuple就是普通tuple的二倍了

现在的问题是如何get，但是tuple只支持type定位，而name 是字符串，一个tuple有很多string就不能保证唯一性了，所以通过模版封装name成一个新类型，模版，每个类型都不一样，就解决了这个问题，能定位到name_type，当然就能找到下一个元素

类似的实现思路，见这个仓库 https://github.com/erez-strauss/named_tuples

- [Debugging a Dynamic Library that Wouldn't Unload](https://www.forrestthewoods.com/blog/debugging-a-dynamic-library-that-wouldnt-unload/)

一个windows下动态库加载失败的问题定位

- [Another `requires`-clause syntax pitfall](https://quuxplusone.github.io/blog/2021/06/09/another-concepts-chest-mimic/)

require里混着require，各种编译器行为不一致(没有展示过这个例子之前我没想过可以这么写)

```c++
template<class T>
concept HasAButNotB = requires (T t) {
    t.a();
    !requires { t.b(); };
};

struct S1 {};
struct S2 { void a(); };
struct S3 { void b(); };
struct S4 { void a(); void b(); };

static_assert(!HasAButNotB<S1>);  // as expected
static_assert(HasAButNotB<S2>);   // as expected
static_assert(!HasAButNotB<S3>);  // as expected
static_assert(HasAButNotB<S4>);   // ...oops!
```



- [Three Myths About Floating-Point Numbers](https://www.cppstories.com/2021/06/floating-point-myths/)

简单介绍了浮点型的坑

- [Tag dispatch versus concept overloading](https://quuxplusone.github.io/blog/2021/06/07/tag-dispatch-and-concept-overloading/)

讨论了几种匹配重载，tag dispatch技巧和enable_if/concept 

- float exposed https://float.exposed/0x000993d518d1e7e3 一个计算器，显示二进制的

## 视频

- [C++ Weekly - Ep 275 - Trust Your Standard Library in 3 Simple Steps](https://www.youtube.com/watch?v=atAd8gzaM1g) 

上一期讨论了某种场景下pair可能还不如普通的struct效果好，这里讲了几个技巧来确认这种问题，通过关键字 平凡构造之类的。tldr: 能用标准库就用，一般不是热点

- https://pages.jetbrains.com/cppnow2021 jetbrains又更新了一些c++now的视频，看样子是每个月一更的节奏，上个月只发了六个  这次更新非常的多 三十多个，我不可能看得完。后面有时间再看吧，有看了的朋友可以分享一下总结的内容



## 项目

- https://github.com/snej/tails 一个forth 语言的c++实现
- https://github.com/Stiffstream/arataga 用sobjecter实现的一个socks/http server，[这里](https://sourceforge.net/p/sobjectizer/news/2021/06/arataga-a-real-world-example-of-using-actors-in-c-project-for-serving-thousands-of-connections-in-a-proxy-server/)有详细介绍

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/016.html)
