---
layout: post
title:  第十三期
---

# C++ 中文周刊 第13期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-05-19.md)

- zstd 1.5发布，性能提升巨大 https://github.com/facebook/zstd/releases/tag/v1.5.0

## 文章

- [Modules介绍](https://zhuanlan.zhihu.com/p/373457208)

- [GCC 的整体架构](https://zhuanlan.zhihu.com/p/372526494) 

  介绍了gcc的架构以及处理流程，值得一看，拓展眼界

- [tuple实现](https://zhuanlan.zhihu.com/p/356954012)

  介绍了tuple中的空基类优化

- [Practical Design Patterns: Opaque Pointers and Objects in C](https://interrupt.memfault.com/blog/opaque-pointers)

  看代码

  Ringbuffer.h

  ```c++
  #pragma once
  
  #include <stdint.h>
  #include <stdbool.h>
  
  // Opaque pointer type to represent a ringbuffer instance
  // 作者管这个叫opaque pointer
  typedef struct ringbuffer_instance_t* ringbuffer_t;
  
  // Functions that operate on an instance
  ringbuffer_t ringbuffer_create(uint32_t capacity);
  uint32_t ringbuffer_capacity(ringbuffer_t instance);
  bool ringbuffer_enqueue(ringbuffer_t instance, uint8_t item);
  bool ringbuffer_dequeue(ringbuffer_t instance, uint8_t* item);
  void ringbuffer_destroy(ringbuffer_t instance);
  
  ```

  ringbuffer.c

  ```c++
  #include "ringbuffer.h"
  #include <stdlib.h>
  
  // Private struct, only accessible from within this file
  struct ringbuffer_instance_t {
      volatile uint32_t wr_pos;
      volatile uint32_t rd_pos;
      uint8_t* data;
      uint32_t capacity;
  };
  
  ringbuffer_t ringbuffer_create(uint32_t capacity) {
      ringbuffer_t inst = calloc(1, sizeof(struct ringbuffer_instance_t));
      inst->data = calloc(capacity, sizeof(uint8_t));
      inst->capacity = capacity;
      inst->wr_pos = 0;
      inst->rd_pos = 0;
      return inst;
  }
  
  uint32_t ringbuffer_capacity(ringbuffer_t instance) {
      return instance->capacity;
  }
  
  bool ringbuffer_enqueue(ringbuffer_t instance, uint8_t item) {
      // implementation omitted
      return true;
  }
  
  bool ringbuffer_dequeue(ringbuffer_t instance, uint8_t* item) {
      // implementation omitted
      return true;
  }
  
  void ringbuffer_destroy(ringbuffer_t instance) {
      if (instance) {
          if (instance->data) {
              free(instance->data);
          }
          free(instance);
      }
  }
  ```

   作者管这个ringbuffer_t叫opaque pointer实际上就是一层不透明封装，当handle用。这个不是什么新的技巧了

  > [暮无井见铃](https://www.zhihu.com/people/Kurenai_Misuzu)06-02 评论补充
  >
  > Opaque pointer 就是 pImpl 的另一种习惯说法……其实很古老了，例如 C 标准都是允许 FILE 在头文件中仅声明不定义的。

- [Ambiguity in template parameters](https://brevzin.github.io/c++/2021/05/12/template-ambiguity/)

  讨论了一下模版NTTP和其他类型和concept一锅烩等场景，看个乐

- [Porting Intel Intrinsics to Arm Neon Intrinsics](https://www.codeproject.com/Articles/5301747/Porting-Intel-Intrinsics-to-Arm-Neon-Intrinsics) 

  手把手教你写sse移植代码(从x86到arm)

-   [c++ tip of week 226 **Did you know about C++23 feature which adds support for inheriting from std::variant?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/226.md)

std::variant支持继承，再实现operator()更方便std::visit 在线演示[godbolt](https://godbolt.org/z/oez6McKzn)

```c++
struct value : std::variant<int, double> {
  using variant::variant;

  constexpr auto operator()(const auto& value) {
    std::clog << value << '\n';
  }
};

int main(){
  std::visit(value{}, std::variant<int, double>(42));  // prints 42
  std::visit(value{}, std::variant<int, double>(99.)); // prints 99
}
```

- [How to build high DPI aware native Windows desktop applications](https://mariusbancila.ro/blog/2021/05/19/how-to-build-high-dpi-aware-native-desktop-applications/)

  手把手教你写c++感应dpi的应用所需要的代码

- [A general state rollback technique for C++](https://www.jfgeyelin.com/2021/02/a-general-state-rollback-technique-for-c.html)

  介绍了一种管理状态的技巧，snapshot(数据库中常见)

- [C++20: Building a Thread-Pool With Coroutines](https://blog.eiler.eu/posts/20210512/)

  手把手教你写基于协程的线程池

  代码

  <script src="https://gist.github.com/MichaEiler/b13771a9e0e403d8a0a082072fd14d68.js"></script>

   建议直接看[cppcoro](https://github.com/lewissbaker/cppcoro) / [libcoro](https://github.com/jbaldwin/libcoro)

- [A metaprogramming puzzle: Overly interoperable libraries](https://quuxplusone.github.io/blog/2021/05/19/after-you-no-after-you/)

## 视频

- [C++ Weekly - Ep 272 - Hello World, Hello Commodore](https://www.youtube.com/watch?v=w2L3Vz5X8JU)

讲的代码设计重构之类的。没有仔细看

<iframe width="560" height="315" src="https://www.youtube.com/embed/w2L3Vz5X8JU" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>



## 项目

- https://github.com/eliaskosunen/scnlib 替代scanf的c++库


---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/013.html)
