---
layout: post
title:  第十期
---

# C++ 中文周刊 第10期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

祝大家五一节日快乐

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-04-28.md)

- gcc 11.1 发布 https://gcc.gnu.org/pipermail/gcc/2021-April/235922.html
- cppcheck支持c++17 https://sourceforge.net/p/cppcheck/news/2021/04/c17-support-in-cppcheck/

## 文章

-   [Throw，然后掉进二进制边界陷阱](https://zhuanlan.zhihu.com/p/367772341)

讨论抛异常出二进制在不同编译器下的行为，以及链接不同的libstd 的行为，结果居然不一致。可以扩展一下眼界

- [c++ tip of week 223 **Did you know about the proposal to add json support to the standard library?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/223.md)

  介绍json库的。这个我感觉进不了

- [SIMD for C++ Developers](http://const.me/articles/simd/simd.pdf) 一本书，介绍simd，值得一看(我没看)

-  [How to Implement std::conjunction and std::disjunction in C++11](https://www.fluentcpp.com/2021/04/30/how-to-implement-stdconjunction-and-stddisjunction-in-c11/)

首先功能和可能的实现可以看[这个链接](https://zh.cppreference.com/w/cpp/types/conjunction) 从c++17开始支持,链接里的可能的实现是递归方案，讨论非递归方案

看代码

```c++
template<bool...> struct bool_pack{};

template<bool... Bs>
using conjunction = std::is_same<bool_pack<true,Bs...>, bool_pack<Bs..., true>>;

template <bool B>
using bool_constant = std::integral_constant<bool, B>; // redefining C++17 bool_constant helper

template<bool... Bs>
struct disjunction : bool_constant<!conjunction<!Bs...>::value>{};
```

很巧妙的利用is_same来推定true=B1=B2=...Bn=true，不用递归，但类型的判定由编译器来判定

- [The Little Things: everyday efficiencies](https://codingnest.com/the-little-things-everyday-efficiencies/)

讨论了两种场景对性能的影响

range for 如果你不需要index信息，range for生成的汇编更简单 更高效

vector先分配好空间再pushback比直接pushback要更高效

- [Ideal divisors: when a division compiles down to just a multiplication](https://lemire.me/blog/2021/04/28/ideal-divisors-when-a-division-compiles-down-to-just-a-multiplication/)

除法指令是慢的，优化除法指令的一个方法就是改写成乘法。作者写了个论文，讨论了一种数学场景，费马数除法，如何除更高效

其实就是这段代码

```c++
// computes n % 274177
uint64_t div1(uint64_t n) {
    return n % 274177;
}

// computes n % 274177
uint64_t div2(uint64_t n) {
    return (uint64_t( n * 67280421310721 ) 
              * __uint128_t(274177)) >> 64;
}
```

第二种写法更高效



## 视频

- [Jason Turner YT - C++ Weekly - Ep 269 - How To Use C++20's constexpr std::vector and std::string](https://www.youtube.com/watch?v=cuFILbHp-RA)

讨论了怎么用constexpr的std::vector 一种很猥琐的方式，一口气分配好，不传出来，在constexpr函数内部来处理

## 项目

- https://github.com/atollk/copper 一个golang channel c++实现，文档详细，值得学习


---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/010.html)
