---
layout: post
title:  第九期
---

# C++ 中文周刊 第9期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-04-21.md)

- vs2022要来了 https://devblogs.microsoft.com/visualstudio/visual-studio-2022/ 合了c++20的大部分功能
- cppnow 2021五月份开始 安排在这里 https://cppnow2021.sched.com/ 无尽的视频轰炸又要来了(之前还没有看完)

- cpp开发者调研报告 https://isocpp.org/files/papers/CppDevSurvey-2021-04-summary.pdf
- 四月提案汇总 http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2021/#mailing2021-04

- godot 3.3发布 一个游戏引擎 https://godotengine.org/article/godot-3-3-has-arrived

## 文章

-   [Optimizing `string::append` is harder than it looks](https://quuxplusone.github.io/blog/2021/04/17/pathological-string-appends/)

讨论append的各种场景，以及其中的拷贝策略

-  [c++ tip of week 222 **Did you know that C++23 added contains function to string_view??** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/222.md)
可以在[这里](https://godbolt.org/z/jqoWq36Pe)试一下，就是string_view的substr判定
```c++
int main() {
  using std::literals::string_view_literals::operator""sv;
  std::cout << "trade.price"sv.contains("order"); // prints 0
  std::cout << "trade.price"sv.contains("");      // prints 1
  std::cout << "trade.price"sv.contains("price"); // prints 1
}
```

- [c++中函数返回的过程是什么样的？](https://www.zhihu.com/question/455599343/answer/1848364211)

讨论了很多场景，想要了解的话可以看下

- [How to implement a producer-consumer queue](https://vorbrodt.blog/2021/04/22/how-to-implement-a-producer-consumer-queue/)

非常简单的实现，用mutex，代码看这里https://github.com/mvorbrodt/blog/blob/master/src/lesson_queue_how_to.cpp

- [A Macro-Based Terse Lambda Expression](https://vector-of-bool.github.io/2021/04/20/terse-lambda-macro.html)

lambda语句比较啰嗦，这里设计了一个语法，把lamdba改写的简单一些 代码在这里 https://github.com/Quincunx271/TerseLambda

```c++
std::sort(my_vector.begin(), my_vector.end(),
    [](std::string const& lhs, std::string const& rhs) {
        return lhs.size() < rhs.size();
    });

std::sort(my_vector.begin(), my_vector.end(),
    [] TL(_1.size() < _2.size());
    });
```

思路， 绑定参数到placeholder上，利用宏展开来绑定

如何绑定？用模版来转发arg，arg是变参，利用抓发绑定到具体的placeholder上，nth_arg\<N> 匹配具体的placeholder

- [Parsing Protobuf at 2+GB/s: How I Learned To Love Tail Calls in C](https://blog.reverberate.org/2021/04/21/musttail-efficient-interpreters.html)

clang最近有个新的优化点 tailcall (尾递归调用优化) [实现在这里](https://reviews.llvm.org/D99517) 不过其他的编译器没实现这个，也就是说，不可移植

作者写的upb是一个pb的parser，为了用上tailcall优化，手写了一套优化的代码，然后编译器新增了这个优化，原来写的代码就可以不用了

这里讨论了写tailcall代码的技巧 代码提交在这里 https://github.com/protocolbuffers/upb/pull/310

针对clang，就用编译器提供的优化 https://github.com/protocolbuffers/upb/pull/390

主要技术就是这段代码

```c
#include <stdint.h>
#include <stddef.h>
#include <string.h>

typedef void *upb_msg;
struct upb_decstate;
typedef struct upb_decstate upb_decstate;

// The standard set of arguments passed to each parsing function.
// Thanks to x86-64 calling conventions, these will be passed in registers.
#define UPB_PARSE_PARAMS                                          \
  upb_decstate *d, const char *ptr, upb_msg *msg, intptr_t table, \
      uint64_t hasbits, uint64_t data
#define UPB_PARSE_ARGS d, ptr, msg, table, hasbits, data

#define UNLIKELY(x) __builtin_expect(x, 0)
#define MUSTTAIL __attribute__((musttail))

const char *fallback(UPB_PARSE_PARAMS);
const char *dispatch(UPB_PARSE_PARAMS);

// Code to parse a 4-byte fixed field that uses a 1-byte tag (field 1-15).
const char *upb_pf32_1bt(UPB_PARSE_PARAMS) {
  // Decode "data", which contains information about this field.
  uint8_t hasbit_index = data >> 24;
  size_t ofs = data >> 48;

  if (UNLIKELY(data & 0xff)) {
    // Wire type mismatch (the dispatch function xor's the expected wire type
    // with the actual wire type, so data & 0xff == 0 indicates a match).
    MUSTTAIL return fallback(UPB_PARSE_ARGS);
  }

  ptr += 1;  // Advance past tag.

  // Store data to message.
  hasbits |= 1ull << hasbit_index;
  memcpy((char*)msg + ofs, ptr, 4);

  ptr += 4;  // Advance past data.

  // Call dispatch function, which will read the next tag and branch to the
  // correct field parser function.
  MUSTTAIL return dispatch(UPB_PARSE_ARGS);
}

```

生成的汇编

```asm
upb_pf32_1bt:                           # @upb_pf32_1bt
        mov     rax, r9
        shr     rax, 24
        bts     r8, rax
        test    r9b, r9b
        jne     .LBB0_1
        mov     r10, r9
        shr     r10, 48
        mov     eax, dword ptr [rsi + 1]
        mov     dword ptr [rdx + r10], eax
        add     rsi, 5
        jmp     dispatch                        # TAILCALL
.LBB0_1:
        jmp     fallback                        # TAILCALL
```

可以https://godbolt.org/z/K8Mo6hcGa 在godbolt上看一看

注意return fallback，如果没有return，这里就不会优化，解决方法，使用 [`__attribute__((preserve_most))`](https://clang.llvm.org/docs/AttributeReference.html#preserve-most)

- [Creating Async Blueprint Nodes to fetch JSON data](https://www.tomlooman.com/async-blueprint-http-json/)

TODO: 这个文章是UE相关的，不太了解

-  [Five Awesome C++ Papers for the Q1 2021 and C++23 Status](https://www.cppstories.com/2021/q1-cpp-papers/) 列了几个作者喜欢的提案

## 视频

- [Jason Turner YT - C++ Weekly - Ep 268 -Top 10 C++ Resources You MUST Know About!](https://www.youtube.com/watch?v=eSDVVrjFh54)

国外up主也水视频啊，列举一些网址

> Links:
>
> https://www.reddit.com/r/cpp/
> https://isocpp.org/
> https://leanpub.com/bookstore?type=all&category=c_and_cpp
> https://cppinsights.io/
> https://wg21.link/
> https://eel.is/c++draft/
> https://compiler-explorer.com/ - https://godbolt.org/ - https://gcc.godbolt.org/
> https://en.cppreference.com/w/
>
> Blogs
> https://www.fluentcpp.com/
> https://www.cppstories.com/
> https://herbsutter.com/
> https://randomascii.wordpress.com/
> https://www.modernescpp.com/
> https://devblogs.microsoft.com/oldnewthing/
>
> YouTube
> https://www.youtube.com/user/TheChernoProject
> https://www.youtube.com/user/CppCon
> https://www.youtube.com/c/Bisqwit/videos
> https://www.youtube.com/channel/UC-yuWVUplUJZvieEligKBkA - one lone coder
> https://www.youtube.com/c/MeetingCPP/videos

- [Andreas Fertig - C++ Insights - How stuff works, C++20 and more!](https://www.youtube.com/watch?v=3M77F-u3mjI)

介绍c++insight的使用以及局限。你只要知道他能把c++展开的让人容易理解就行了。原理没有涉及

- [Guy Davidson - Everything you know about colour is wrong - Meeting C++ online](https://www.youtube.com/watch?v=_zQ_uBAHA4A)

讲color的表示以及各种库相关的实现




---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/009.html)
