---
layout: post
title:  第五期
---

# C++ 中文周刊 第5期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

###  编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-03-24.md)

### [三月提案汇总](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2021/#mailing2021-03)

其中，有个std::colony提案，就是https://github.com/mattreecebentley/plf_colony，设计了一个更大的容器。未见的能进，不过设计的挺有意思的。有时间可以看看设计文档



## 文章

- [GotW #101 Solution: Preconditions, Part 2 (Difficulty: 7/10)](https://herbsutter.com/2021/03/25/gotw-101-solution-preconditions-part-2-difficulty-7-10/)

没啥说的，解释概念

- [ticket_map](https://www.justsoftwaresolutions.co.uk/cplusplus/ticket-maps.html) 
一个map，给插入的成员分配ticket。代码在[这里](https://github.com/anthonywilliams/ticketmap)，效果看这个[godbolt连接](https://godbolt.org/z/369nvfqb9)

<img src="https://wanghenshui.github.io/assets/image-20210326174659250.png" alt=""  width="100%">



- [Using C++17 to Create Composable, Recursive Data Types](https://davidgorski.ca/posts/recursive-data-types-cpp/)

看代码

<script src="https://gist.github.com/dgski/d00303b4a8be2d3c109d7a97d77106a3.js"></script>

gist这个脚本嵌入非常优雅，方便写博客但是可能会有访问问题。所以后面还是会贴源码

- [Reflecting Over Members of an Aggregate](https://bitwizeshift.github.io/posts/2021/03/21/reflecting-over-members-of-an-aggregate/)

还是magic_get/boost.pfr的技巧。温故知新一下。可能未来reflection就这么实现了

- [constexpr new in c++20](https://www.cppstories.com/2021/constexpr-new-cpp20/)

看这段代码

<script src="https://gist.github.com/wanghenshui/c835c9cac3cbb6deee7856d5699852ed.js"></script>

这里的new会转到编译期检查！！

如果遗漏了delete会报错！

这样就可以写个非常安全的类了，有点像rust那种初级检查了，很不错

```c++
template <typename T>
class Buffer {
public:
    constexpr Buffer(size_t n) noexcept : size_(n), mem_(new T[n]) { }
    constexpr ~Buffer() noexcept { delete [] mem_; }

    constexpr Buffer(const Buffer& other) noexcept : size_(other.size_) {
          // ...
    }

    constexpr Buffer(Buffer&& other) noexcept {
        // ...
    }

    constexpr Buffer& operator=(const Buffer& other) noexcept {
        // ...
    }

    constexpr Buffer& operator=(Buffer&& other) noexcept {
        // ...
    }

    constexpr T& operator[](size_t id) noexcept { return mem_[id]; }
    constexpr const T& operator[](size_t id) const noexcept{ return mem_[id]; }

    constexpr T* data() const noexcept { return mem_; }
    constexpr size_t size() const noexcept { return size_; }

private:
    T *mem_ { nullptr };
    size_t size_ { 0 };
};

//使用
constexpr int naiveSumBuffer(unsigned int n) {
    Buffer<int> buf(n); // almost a vector class!
    std::iota(buf.data(), buf.data()+n, 1);
    return std::accumulate(buf.data(), buf.data()+n, 0);
}
```

缺点是constexpr相关的内存，别的操作不能直接用，只能拷贝

-  [并发吹剑录（二）：指令重排序与内存屏障](https://zhuanlan.zhihu.com/p/359093580)

qsort在glibc2.13之前不是线程安全的。针对这个场景，作者讨论了一下glibc的修改方案

要注意这个坑，以及理解memory_barrier



- [Making Your Own Container Compatible With C++20 Ranges](https://www.reedbeta.com/blog/ranges-compatible-containers/)

  自己的container除了要适配iterater之外(begin/end/size/difference_type和value_type也得有)，还要适配range的需求，要定义一个range(可以是input_range也可以是forward_range总之要定义一个)，要有input_iterator output_iterator

  

- [c++ tip of week 218  **Did you know about different ways of constructor Dependency Injection?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/218.md)

就是这段代码

```c++
class iapi {
 public:
  virtual ~iapi() = default;
  virtual auto call() const -> int { return 42; }
};

class app_interface {
 public:
  constexpr explicit(true) app_interface(const iapi& api) : api_{api} {}
  auto run() const -> int { return api_.call(); }

 private:
  const iapi& api_;
};

template<class TApi>
class app_template {
 public:
  constexpr explicit(true) app_template(const TApi& api) : api_{api} {}
  auto run() const -> int { return api_.call(); }

 private:
  const TApi& api_;
};

template<class T>
concept api = requires(T t) {
  t.call();
};

template<api TApi>
class app_concept {
 public:
  constexpr explicit(true) app_concept(const TApi& api) : api_{api} {}
  auto run() const -> int { return api_.call(); }

 private:
  const TApi& api_;
};

int main() {
  // interface injection
  {
    struct : iapi {
      auto call() const -> int override { return 42; }
    } fake_api;
    app_interface app{fake_api};
    assert(42 == app.run());
  }

  // template injection
  {
    iapi api{};
    app_template app{api};
    assert(42 == app.run());
  }

  // concept injection
  {
    iapi api{};
    app_concept app{api};
    assert(42 == app.run());
  }
}
```



- [ An Infinite Data Stream with Coroutines in C++20](http://www.modernescpp.com/index.php/an-infinite-data-stream-with-coroutines-in-c-20)

利用co_yield 来做generator，如果你了解python的yield，可以类比一下，概念是一样的

## 视频

- [Jason Turner YT - C++ Weekly - Ep 264 - Covariant Return Types and Covariant Smart Pointers](https://www.youtube.com/watch?v=tvGCQmE5-Fs)

考虑这段代码

```c++
struct base {
  virtual base* get() = 0;
};

struct derived : public base {
  virtual derived* get() {
    return &d;
  }
  derived d;
};
```

如果改成返回共享指针怎么修改接口？

已知std::shared_ptr\<base>和std::shared_ptr\<derived>完全是不同的类型，不能互相转, 下面这样写肯定编不过的

```c++
struct base {
  virtual std::shared_ptr<base> get() = 0;
};

struct derived : base {
  std::shared_ptr<derived> get() override{
    return d;
  }
  std::shared_ptr<derived> d;
};
```



通过引入一个转换层，实现统一的接口

```c++
template <typename Contained, typename Base=void> 
struct covariant_ptr : public covariant_ptr<Base, void>{
  std::shared_ptr<Contained> value;
};

// 给基类用的特化
template <typename Contained> 
struct covariant_ptr<Contained, void>{
};

struct base {
  virtual covariant_ptr<base> get() = 0;
};

struct derived : base {
  covariant_ptr<derived, base> get() override{
    return d;
  }
  covariant_ptr<derived, base> d;
};
```



- [ACCU YT - Safer C++: MISRA-C++ : 202X Rules and Beyond - Peter Sommerlad  ACCU 2021](https://www.youtube.com/watch?v=SAK2IyYtMBE)

讲静态检查的，非常长

- [ACCU YT - A Practical Introduction to C++20's Modules - Hendrik Niemeyer ACCU 2021 ](https://www.youtube.com/watch?v=tOjZtodXqNQ) 
- [ACCU YT - Keynote: It Depends.. - Kevlin Henney  ACCU 2021 ](https://www.youtube.com/watch?v=rNSVZs66o48) 
- [Meeting C++ YT - Paul Bendixen - No raw loops with no OS - Meeting Embedded 2020](https://www.youtube.com/watch?v=ey4MTtirDxQ)

讲嵌入式场景，作者实现了avr芯片上的libcxx

- [Meeting C++ YT - Clare Macrae - Quickly and Effectively Testing Qt Desktop Applications](https://www.youtube.com/watch?v=jwixAjDH2Ik)

讲qt 测试的

## 问题

1 ~~用discord还是飞书做讨论组？~~

主要需求

- 自由加入退出
- webhook通知github仓库消息



~~我之前调研发现discord支持webhook，所以使用discord，但是国内被屏蔽，登不上~~

~~现在发现飞书也支持，所以加上了飞书~~

~~哪种更通用一些？qq群微信群？据我了解qq不支持webhook通知，可能需要自己搞机器人。微信个人版不提供webhook~~

目前用qq频道。交流群基本半死不活。所以不折腾了.webhook我问腾讯的说2022年底支持，他妈的都2023了还不支持

飞书和discord用过一段时间，根本没人加。可能是传播广度不够或者没人用

2 ~~代码片用gist托管还是直接贴出来？~~

~~gist可能被屏蔽，就看不到代码，但是比较好整理~~

直接贴链接。godbolt还好，如果挂了就再见了。没办法

欢迎讨论

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/005.html)
