---
layout: post
title:  第二期
---

# C++ 中文周刊 第2期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

每周更新

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

### 编译器信息最新动态推荐关注hellogcc公众号

[本周周报github直达](https://github.com/hellogcc/osdt-weekly/blob/master/weekly/2021-03-03.md)



### llvm weekly

http://llvmweekly.org/issue/374



## 文章

- [你也可能会遇到](https://www.mattkeeter.com/blog/2021-03-01-happen/)

最近有一篇文章，介绍GTA 5 online为什么那么慢，以及解决办法，[详情见这里](https://www.zhihu.com/question/265453795/answer/1758424108) ，主要原因 1 sscanf每次读都会检查长度, 对于大文件性能太差 2 数据用hashmap存而不是if判断

作者反思自己的库用到了sscanf，会不会遇到类似的问题？

作者的场景是解析STL格式的文件，如果是大文件，也会很慢，最终使用strtof替换sscanf，解决了问题，这里也有个问答用strtok替换sscanf

还有个14年的[bug单](https://sourceware.org/bugzilla/show_bug.cgi?id=17577)

结论，**sscanf的性能指标文档没给，要注意这个函数有很大问题，尽量用替换方案**



- [不要无脑使用emplace_back](https://quuxplusone.github.io/blog/2021/03/03/push-back-emplace-back/)

emplace_back接受的是右值，如果为了省掉拷贝，尽量传右值，无脑替换是没有意义的



- [Creating a co_await awaitable signal that can be awaited multiple times](https://devblogs.microsoft.com/oldnewthing/20210301-00/?p=104914) 

  用co_wait处理signal挺有意思。涉及到win32相关的东西，不了解没有细看



- [C++20 Range Adaptors and Range Factories](https://brevzin.github.io/c++/2021/02/28/ranges-reference/)

 介绍range的adaptor和factor。range还是比较好学的

一个简单例子

```c++
#include <ranges>
#include <fmt/format.h>
#include <fmt/ranges.h>

int main() {
    using namespace std;

    auto squares_under_200 =
        views::iota(0)
        | views::transform([](int i){ return i*i;})
        | views::take_while([](int i){ return i < 200; });

    // {0, 1, 4, 9, 16, 25, 36, 49, 64, 81, 100, 121, 144, 169, 196}
    fmt::print("squares under 200: {}\n", squares_under_200);
}
```



- [std::index_sequence and its Improvement in C++20](https://www.fluentcpp.com/2021/03/05/stdindex_sequence-and-its-improvement-in-c20/)

  介绍了用std::index_sequence实现for_each在c++20之前和之后写法上的区别，c++20有了支持模版的lambda，所以写起来省了一些

  之前的写法，封一层

  ```c++
  template <class Tuple, class F, std::size_t... I>
  F for_each_impl(Tuple&& tuple, F&& f, std::index_sequence<I...>)
  {
      (f(std::get<I>(tuple)), ...);
      return f;
  }
  
  template <class Tuple, class F>
  constexpr decltype(auto) for_each(Tuple&& tuple, F&& f)
  {
      return for_each_impl(std::forward<Tuple>(tuple), std::forward<F>(f),
                           std::make_index_sequence<std::tuple_size<std::remove_reference_t<Tuple>>::value>{});
  }
  ```

  c++20写法，lambda

  ```c++
  template <class Tuple, class F>
  constexpr decltype(auto) for_each(Tuple&& tuple, F&& f)
  {
      return [] <std::size_t... I>
      (Tuple&& tuple, F&& f, std::index_sequence<I...>)
      {
          (f(std::get<I>(tuple)), ...);
          return f;
      }(std::forward<Tuple>(tuple), std::forward<F>(f),
        std::make_index_sequence<std::tuple_size<std::remove_reference_t<Tuple>>::value>{});
  }
  ```

  

## 视频

- [c++weekly C++20's New consteval Keyword](https://www.youtube.com/watch?v=b22cKntJslU)

理解成constexpr严格版本，只能编译期计算。使用场景，hash 计算，不泄漏符号

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/002.html)
