---
layout: post
title:  第一期
---

# C++ 中文周刊 第1期

每周日推送从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/)摘抄一些c++动态。

周刊项目地址 [github](https://github.com/wanghenshui/cppweeklynews)，[在线地址](https://wanghenshui.github.io/cppweeklynews/) | [知乎专栏](https://www.zhihu.com/column/jieyaren)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

- **herb发了[trip report](https://herbsutter.com/2021/02/22/trip-report-winter-2021-iso-c-standards-meeting-virtual/)**

关于c++标准会的最新进展 c++23

herb介绍了几个他感兴趣的小补丁

  - lambda可以省略括号()，但是如果有mutable又不可以省略括号了，需要修订
  - range使用：std::views::join迭代器返回有问题，引入新组件修复
  - 加强std::visit处理继承std::variant 的场景

  - 引入std::to_underlying代替 `std::underlying_type_t<T>`

涉及到语法细节我也不懂，可以看trip report中引用的论文看详细细节



- [**c++20 运行时拿到函数名，使用lambda和std::source_location**](https://www.reddit.com/r/cpp/comments/lp40ag/c20_gcc_trunk_getting_constexpr_usable_caller/)

感觉能用在反射上

之前c++ weekly也讨论了std::source_location  [链接](https://www.youtube.com/watch?v=TAS85xmNDEc) 很有用处



### 编译器信息最新动态推荐关注hellogcc公众号

github也有更新，见https://github.com/hellogcc/osdt-weekly

## 文章

[**实现并行的copy_if**](https://www.cppstories.com/2021/par-copyif/)

c++17已经实现了一些并行算法，实现比较粗暴

```c++
std::sort(std::execution::par, ...);
std::for_each(std::execution::par, ...);
```

 std::execution::parallel_policy不要求顺序，这样可能有线性的性能提升，但是对于sort，可能需要同步

对于copy_if来说，返回新的对象，这个返回结果，多线程写入，必然需要同步。作者给出了几种实现方案

1 简单加锁 2 利用算法规避锁，3 分块 其中某些场景下多线程并没有起到加速的作用。

第二种方法 用到了[std::exclusive_scan](https://zh.cppreference.com/w/cpp/algorithm/exclusive_scan) 可以了解下，类似haskell map+scanl



[**clang的一个编译告警**-Wsuggest-override](https://quuxplusone.github.io/blog/2021/02/19/virtual-final-silences-override-warning/)

这里讲了一个场景

```c++
struct B {
    virtual int f() = 0;
    virtual int g() = 0;
};

struct C : B {
    int f() override;

    virtual int g() final;  // overrides
    virtual int h() final;  // doesn't
};
```

一个函数同时被virtual和final修饰，可能看不清本身的含义，通过这个编译能让不清楚的接口语义提前暴露出来

并推荐基类 virtual，继承用override/final 尽可能别混用，当然也存在这个基类是另外一个基类的子类的场景，导致同时有virtual和final，尽量避免



[**一个协程的教程**](https://www.scs.stanford.edu/~dm/blog/c++-coroutines.html)



[**concept**](https://www.sandordargo.com/blog/2021/02/24/cpp-concepts-with-classes)

简单来说，就是这段代码

```c++
template <typename T>
concept Number = std::integral<T> || std::floating_point<T>;

template <typename T>
requires Number<T>
class WrappedNumber {
public:
  WrappedNumber(T num) : m_num(num) {}
private:
  T  m_num;
};

template <typename T>
requires Number<T>
auto add(T a, T b) {
  return a+b;
}

```

注意这里concept和requirs的用法



[**Guru of the Week #100  Preconditions, Part 1** ](https://herbsutter.com/2021/02/25/gotw-100-solution-preconditions-part-1-difficulty-8-10/)

这里在介绍断言的两种语义，在前面校验还是在后面校验，类似gsl::Expect gsl::Ensure的区别，写的非常长

> - A **precondition** is a predicate that should hold upon **entry into** a function. It expresses a function's **expectation** on its **arguments** and/or the state of objects that may be used by the function.
> - A **postcondition** is a predicate that should hold upon **exit from** a function. It expresses the **conditions** that a function should ensure for the **return value** and/or the state of objects that may be used by the function.

hurb是constract 提案的作者，所以对这些概念解释的比较细致。文章我没有仔细看。



[**同步的outputstream**](http://www.modernescpp.com/index.php/synchronized-outputstreams)

std::cout多线程写是会乱序的，c++20引入了std::osyncstream，这样所有的都会同步

ps: stream这套东西应该没人用吧



[**cpp tips of week #214  Did you know about variadic aggregate initialization?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/214.md) 

介绍variadic aggregate initialization的 数组初始化可以变参模版初始化，这个例子太魔鬼了，可以看这个[博客](https://jgreitemann.github.io/2018/09/15/variadic-expansion-in-aggregate-initialization/) 理解一下



## 视频

[**cpp weekly**](https://www.youtube.com/watch?v=ByKf_foSlXY)

老生常谈，讲的 C++'s Most Vexing Parse 



[**Meeting C++ YT - Jonathan Müller - The Static Initialization Order Fiasco**](https://www.youtube.com/watch?v=6EOSRKMYCTc)

借着实现一个logger库的例子，讨论各种初始化的顺序。



[**Timur Doumler - How C++20 changes the way we write code - Meeting C++ 2020**](https://www.youtube.com/watch?v=VK-16tpFQVI)

介绍c++20的四个概念coroutine/concept/module/range，以及如何改善c++代码



[**cppcast** 每周更新](https://cppcast.libsyn.com/)



## 开源项目

[一个用c++实现的lisp](https://github.com/naver/lispe) wiki丰富



[**mold** 一个现代的linker](https://lobste.rs/s/t9gvtg/mold_modern_linker) 解决的问题是当前编译环境的瓶颈容易在链接上，没有充分利用并行化优势

mold的目标是要比cat还快，首先并发做文件拷贝，比单线程cat快，其次文件拷贝瓶颈在IO，可以用空闲的cpu做其他事情

llvm 的lld其实在这方面已经做了优化，但作者认为还是慢

还有很多设计可以在readme中看到

[讨论](https://lobste.rs/s/t9gvtg/mold_modern_linker)



## 工具

[toolchain](https://www.toolchains.net/) 介绍周边工具

[hacking cpp](https://hackingcpp.com) 有很多c++的资料，比如https://hackingcpp.com/cpp/std/containers.html



---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/001.html)
