# Install smolOS on ESP8266EX

## Requiments
```
$ python3 -m venv venv
$ source venv/bin/activate
$ pip install esp-tool adafruit-ampy
```

## Flashing MicroPython on ESP8266
Remember to ground PIN 0 for flash mode. I've added a push button to the UART-to-USB dongle for that. I then push it while plugging in.

Get the latest firmware from [MicroPython Download Page for ESP8266 1MB](https://micropython.org/download/esp8266-1m/). That's the chip I got.

In the time of writeing this was the latest file: esp8266-1m-20230426-v1.20.0.bin.

As super user.

```
$ su
$ esptool.py chip_id
$ esptool.py --port /dev/ttyUSB0 erase_flash
$ esptool.py --port /dev/ttyUSB0 --baud 115200 write_flash --flash_size=detect -fm dout 0 esp8266-1m-20230426-v1.20.0.bin
```

- chip_id lists specs and confirms that everything works
- erase_flash clears everything
- write_flash flashes the MicroPython firmware

## pushing OSs
**Rename downloaded sources to main.py**
### Prepare Envronment
Do this once
```
$ python3 -m venv venv
$ source venv/bin/activate
$ pip install ampy
```

Next time
```
$ source venv/bin/activate
$ ampy --port /dev/ttyUSB0 put main.py
$ ampy --port /dev/ttyUSB0 put hello.txt
```
- main.py is the smolOS, this file name will run at boot
- hello.txt is just a test file so you have something to play with
- put your own files the same way
- **do not** ovevrite the system boot.py file!
