package main

import (
	"log"
	"os"
	"path/filepath"
	"regexp"
	"testing"

	"github.com/chromedp/chromedp"

	chromedpHelper "github.com/vugu/vugu/testing/chromedp"
	"github.com/vugu/vugu/testing/pkg"
	"github.com/vugu/vugu/testing/tmpl"
)

func Test021Slots(t *testing.T) {

	pkgName := pkg.PkgName(t)
	tmpl.CreateIndexHtml(t, pkgName)

	url := "http://vugu-nginx/" + pkgName
	log.Printf("URL: %s", url)

	ctx, cancel := chromedpHelper.MustChromeCtx()
	defer cancel()

	var tmplparentInnerHTML string
	chromedpHelper.Must(chromedp.Run(ctx,
		chromedp.Navigate(url),
		chromedp.WaitVisible("#tmplparent"), // make sure things showed up
		chromedp.InnerHTML("#tmplparent", &tmplparentInnerHTML),
		chromedpHelper.WaitInnerTextTrimEq("#table2 #another_slot", "another slot"),
		chromedpHelper.WaitInnerTextTrimEq("#table2 #mapidx_slot", "mapidx slot"),
	))

	if tmplparentInnerHTML != "simple template test" {
		t.Errorf("tmplparent did not have expected innerHTML, instead got: %s", tmplparentInnerHTML)
	}
	fullPkgPath, err := os.Getwd()
	if err != nil {
		t.Fatal(err)
	}
	// BE VERY CAREFUL - see the comment in the generate.go file. We must ensure that the file "root_gen.go" is generated by the "vugugen" command
	rootvgengo, err := os.ReadFile(filepath.Join(fullPkgPath, "root_gen.go"))
	chromedpHelper.Must(err)
	if !regexp.MustCompile(`var mydt `).Match(rootvgengo) {
		t.Errorf("missing vg-var reference in root_gen.go")
	}

}
