# vugufmt

gofmt, but for vugu and html files.

## Goals

* Match args and output as closely as possible to the original gofmt's general usecase.
* Wrap around the actual gofmt; don't copy its code here.
* Format HTML5 in addition to go source.
* Report correct absolute line numbers and file names in the output.
* Pure go implementation.

## Non-Goals

* Support versions of HTML other than HTML5.

## Stretch-Goals

* Pretty fmt'ing CSS. A lot of CSS these days is generated by a preprocessor like SASS or LESS.

## Implementation

1. Use `golang.org/x/net/html` to parse the vugu file. This will probably need a tweak to handle the lack of a single root element, missing body, etc. This package has a Render function which re-prints the HTML parse tree, which we will use as the formatted output.
2. Pass in text data for `<script type="application/x-go">` tags into gofmt. Capture its output.

## Sources

This project took a lot of its code from [gofmt](https://golang.org/src/cmd/gofmt/gofmt.go) and Go's Token file. As such, I'm using the same license as gofmt.