---
home: true
actionText: Get Started →
actionLink: /guide/
---

# Vetur

[![](https://vsmarketplacebadge.apphb.com/version-short/octref.vetur.svg?style=flat-square)](https://marketplace.visualstudio.com/items?itemName=octref.vetur)
[![](https://vsmarketplacebadge.apphb.com/installs-short/octref.vetur.svg?style=flat-square)](https://marketplace.visualstudio.com/items?itemName=octref.vetur)
[![](https://vsmarketplacebadge.apphb.com/rating-short/octref.vetur.svg?style=flat-square)](https://marketplace.visualstudio.com/items?itemName=octref.vetur)

Vue tooling for VS Code, powered by [vls](https://github.com/vuejs/vetur/tree/master/server).

Try it out with [Veturpack](https://github.com/octref/veturpack)!

🎉 VueConf 2017 [Slide](https://www.dropbox.com/sh/eb4w8k3orh0j391/AAB3HaJexbGLa2tCP14BI8oJa?dl=0) & [Video](https://www.youtube.com/watch?v=05tNXJ-Kric) 🎉

This extension is under heavy development.
You can [open an issue](https://github.com/vuejs/vetur/issues/new) for bugs or feature requests.

## Features

- [Syntax-highlighting](./guide/highlighting.md)
- [Semantic-highlighting](./guide/semantic-highlighting.md)
- [Snippet](./guide/snippet.md)
- [Emmet](./guide/emmet.md)
- [Linting / Error Checking](./guide/linting-error.md)
- [Formatting](./guide/formatting.md)
- [IntelliSense](./guide/intellisense.md)
- [Debugging](./guide/debugging.md)
- [Component Data](./guide/component-data.md): auto-completion and hover-information for popular Vue frameworks and your own custom components
- [Experimental Interpolation Features](./guide/interpolation.md): auto-completion, hover information and type-checking in Vue template
- [VTI](./guide/vti.md): Surface template type-checking errors on CLI
- [Global components](./guide/global-components.md): support define global components.

## Quick Start

- Install [Vetur](https://marketplace.visualstudio.com/items?itemName=octref.vetur).
- Try it with [Veturpack](https://github.com/octref/veturpack), a pre-configured Vue boilerplate based on [Vuepack](https://github.com/egoist/vuepack).
- Refer to [setup](/guide/setup.md) page for setting up.
- Refer to each feature's own page for setting up specific features.

## Contributing

[Contribution Guide](https://github.com/vuejs/vetur/blob/master/.github/CONTRIBUTING.md).

## License

MIT © [Pine Wu](https://github.com/octref)
