---
outline: deep
---
# Introduction

Vue-Bridge is a project aiming to make it easier for Vue-Library Authors to write, test and build libraries that support both Vue 2 and Vue 3. The end goal is to help move the Vue ecosystem forward - move tried and true libraries that support. We aim to do so by providing Vue Library authors multiple tools to help them write, build and test their libraries.

* Our eslint keeps you from making mistakes when writing your libray
* Our lightweight runtime plugin, combined  with our helpful build-time plugin, reduces the amount of work you put into ensuring [interoperability](#).
* Our testing library takes that same experience to your tests. Write once, run for both versions.
* Templates let you set up a project quickly.

::: warning Work in Progress

The VueBridge Project still is very much a work in progress and not usable in production. Features might not work as expected, pages in these docs might be outdated, missing or incomplete.

Proceed accordingly. If you are interested in contributing, [contact us](https://twitter.com/VueBridge)

:::

## How can I get started?

* If you just want to get started, head over to our Quickstart guide and set up a new project for your interoperable Vue library.

* If want to get a guided tour through all of the things VueBridge can do for you and experience them first-hand, head over to our [tutorial](https://vuebridge.com/tutorial).

Or you read on and get a better understanding about the bigger picture first.
## Features

::: tip Why Vue-Bridge?

If you want to learn more about the why and how of Vue-Bridge and decide wether or not this might actually helpful to you or your project, we recommend visiting the Introduction in our Topics section before getting started with a template:

["Bridging the gap" - Why Vue-Bridge?](../topics/introduction-why-vue-bridge.md)

:::

* 

## About this documentation

This documentation tries to follow the principles of [Diataxis](https://diataxis.fr/). Consequently, this documentation is split into 4 main sections:

<dl>
  <dt>
  Getting Started / Tutorial
  </dt>
  <dd>
    This section is all about getting you up and running, either in form of a <a href="/getting-started/quickstart">Quickstart</a> with one of our project templates, or by following the <a href="/getting-started/tutorial">tutorial</a>
  </dd>
  <dt>
  Topics
  </dt>
  <dd></dd>
  <dt>
  How-To Guides
  </dt>
  <dd>If you need help with a specific problem, chances are you will find a recipe about it in this section</dd>
  <dt>
  References
  </dt>
  <dd></dd>
</dl>

* If you are already working on an interoperable library, and need help with a specific problem, check our [How-To Guides](). We also have a [Topics] section more geared towards learning and understanding the broader concepts and underlying ideas of Vue-Bridge as a project and interoperable Vue libraries in general.
