<a name="readme-top"></a>

<div align="center">
  <a href="https://linkedin.com/in/voaneves">
    <img src="https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555" alt="Acesse meu LinkedIn">
  </a>
  <a href="https://stackoverflow.com/users/10596901/voaneves">
    <img src="https://img.shields.io/badge/-Stack%20Overflow-black.svg?style=for-the-badge&logo=stackoverflow&colorB=555" alt="Acesse meu Stack Overflow">
  </a>
  <a href="https://github.com/voaneves">
    <img src="https://img.shields.io/badge/-GitHub-black.svg?style=for-the-badge&logo=github&colorB=555" alt="Acesse meu GitHub">
  </a>
  <a href="https://voaneves.com">
    <img src="https://img.shields.io/badge/-Meu%20Site-black.svg?style=for-the-badge&logo=pinboard&colorB=555" alt="Acesse meu YouTube">
  </a>
  <a href="https://youtube.com/voaneves">
    <img src="https://img.shields.io/badge/-YouTube-black.svg?style=for-the-badge&logo=youtube&colorB=555" alt="Acesse meu YouTube">
  </a>
  <a href="https://github.com/voaneves/voaneves">
    <img src="https://komarev.com/ghpvc/?username=voaneves&style=for-the-badge&color=cc0000" alt="Contador de visitantes">
  </a>
  <hr>
  <a href="https://github.com/voaneves/voaneves">
    <img src="https://readme-typing-svg.herokuapp.com?font=Mouse+Memoirs&size=65&pause=500&color=cc0000&center=true&vCenter=true&width=600&height=70&lines=Hello,+World!;Me+chamo+Victor,+ou+@voaneves;Vamos+colaborar!" alt="Header">
  </a>
  <br />
  <h3 align="center">@voaneves</h3>
  <p align="center">
    Transformando negócios através da Inovação e Inteligência Artificial!
    <br />
    <a href="https://github.com/voaneves/calendario-de-aniversarios"><strong>Veja meu site »</strong></a>
    <br />
    <br />
    <a href="https://voaneves.com">Ver a documentação</a>
    ·
    <a href="https://github.com/voaneves/voaneves/issues">Reporte um bug</a>
  </p>
</div>

<br /><br />

<details>
  <summary>Sumário</summary>
  <ol>
    <li><a href="#sobre-mim">Sobre o projeto</a></li>
    <li><a href="featured-projects">Featured projects</a></li>
    <li>
      <a href="#habilidades">Habilidades</a>
      <ul>
        <li><a href="#soft-skills">Soft skills</a></li>
        <li><a href="#soft-skills">Hard skills</a></li>
      </ul>
    </li>
    <li><a href="#stats">Stats</a></li>
    <li><a href="#run-my-profile-">Run my profile 🤣</a></li>
    <li><a href="#lets-colab-">Let's colab 🚀</a></li>
  </ol>
</details>

<br /><br />

## Sobre mim

Motivado por transformar pequenos negócios através da inovação e Inteligência Artificial, trabalho atualmente no SEBRAE e adoro contribuir em projetos opensource. Sou formado em Engenharia Mecânica pela UNICAMP e estudante de Sistemas de Informação na XP Educação, sempre fui fascinado por tecnologia, iniciando minha jornada ao programar meu primeiro blog aos 11 anos.

Minhas habilidades incluem Gestão de Projetos (Agile, Scrum, kanban, lean six sigma), IA (Reinforcement Learning, NLP, LLMs, MoE), Business Intelligence (PowerBI, Tableau, Python), Big Data (Hadoop, MongoDB), Gestão Empresarial, Desenvolvimento Web (Figma, HTML5, CSS3, Vanilla Javascript, Angular, Flutter), Transformação Digital (CRM, Slack, Zoom, Teams), Marketing Strategy (SWOT, BCG Matrix), Excel Avançado (dashboards, VBA), Planejamento Estratégico (SWOT, OKRs, Porter's Five Forces, Design Thinking) e Data Science (TensorFlow, scikit-learn).

<br />

<div align="center">
  <img src="https://readme-jokes.vercel.app/api" alt="Jokes Card" />
</div>

<br />

Sou também um life-long language learner! Saiba mais abaixo ⮟

<br />

<details>
  <summary>Vida pessoal</summary>

  > Nasci em Araguaína, Tocantins, e cresci em uma família extensa e unida. Meu interesse por tecnologia floresceu aos 11 anos, quando comecei a experimentar com HTML e CSS, avançando para Python aos 15. O ensino médio foi uma época de determinação, onde me empenhei nos estudos para os vestibulares. Morei em diversos estados do Brasil, e hoje, faço minha residência em Dianópolis/TO. Embora a expectativa fosse seguir Direito, me formei Engenheiro Mecânico na UNICAMP e hoje curso Sistemas de Informação na XP Educação. Aprecio profundamente as conexões humanas, a jornada da vida, e as experiências que me moldaram.

</details>
<details>
  <summary>Minhas paixões</summary>

  > A tecnologia e inovação têm sido constantes em minha vida, especialmente a Inteligência Artificial. Meu amor por mangás, manhwas e animes se entrelaça com meu gosto por jogos online, os quais também contribuíram para o meu aprendizado de inglês. Além disso, sou comprometido com a aprendizagem contínua, explorando novas fronteiras em IA e me dedicando à leitura e ao exercício físico. A jornada de descoberta e crescimento pessoal é algo que valorizo imensamente, juntamente com as relações humanas que enriquecem minha existência.

</details>
<details>
  <summary>Experiências profissionais</summary>

  > - **Iniciação Científica na UNICAMP (2º ao 5º semestre):** Pesquisa em engenharia de materiais, uso de Python, gestão de tempo e colaboração com pesquisadores. Apresentação no Congresso de Iniciação Científica.
  > - **Mercado de Trabalho de Engenharia (MTE) na UNICAMP:** Marketing (SWOT, Design Thinking), parcerias com empresas, reestruturação de imagem, liderança e comunicação.
  > - **Estágios na Coca-Cola FEMSA e Krones (Alemanha):** Manutenção, gerenciamento de projetos com Agile e Lean Six Sigma, uso de Excel, SAP, Python, e liderança de projetos DMAIC.
  > - **Trainee na Coca-Cola FEMSA:** Planejamento Estratégico (SWOT, BSc, PEST, OKRs), Business Intelligence (PowerBI, Tableau), inovação e colaboração com executivos C-level.
  > - **Gestor de Carteira no Damásio Educacional:** Transformação Digital (CRM, Slack, Zoom, Microsoft Teams), liderança, gestão empresarial, marketing (Business Model Canvas, Design Thinking) e inovação na gestão.
  > - **Web Developer - Freelancer:** Desenvolvimento web (HTML5, CSS3, Vanilla Javascript, Angular, Flutter), consultoria em TI, estratégia de marketing e negócios.
  > - **Agente Local de Inovação (ALI) - SEBRAE:** Trabalho com MPEs usando Big Data (Hadoop, MongoDB), otimização de negócios, inovação, inteligência artificial (Reinforcement Learning, NLP), tudo através do programa “Brasil Mais”.
  > - **Analista Técnico - SEBRAE:** Empoderamento feminino, desenvolvimento territorial, políticas públicas, Educação Empreendedora, inovação (VBA/Dashboards) em pequenas e médias empresas, uso de metodologias ágeis (Scrum, Kanban), desenvolvimento de Plano de Negócios e PE nesses negócios. Experiência também em fornecimento de consultorias/instrutorias na área de gestão/inovação.

</details>
<details>
  <summary>What's next</summary>

  > À medida que avanço em minha jornada profissional, estou entusiasmado em explorar novos horizontes que unam tecnologia, inovação, liderança e impacto social. Minha paixão pela Inteligência Artificial, aprendizado contínuo e empreendedorismo continuará a ser o motor de minha carreira.
  >
  > - **Engenheiro de Prompt:** Planejo aprofundar minha expertise em IA, especialmente nos SotA da RL (GDI e MuZero) e também em aplicações para os LLMs, buscando soluções que promovam eficiência, sustentabilidade e crescimento em diversos setores da economia.
  > - **Liderança e Gestão:** Como alguém que valoriza a colaboração e a capacitação, aspira a liderar equipes inovadoras, incentivando a criatividade e a resolução de problemas complexos, com foco em metodologias ágeis e tomada de decisão orientada por dados.
  > - **Impacto Social e Desenvolvimento Territorial:** Inspirado por meu trabalho no SEBRAE, pretendo continuar contribuindo para o desenvolvimento de comunidades, promovendo a educação empreendedora e apoiando a inclusão através da tecnologia.
  > - **Cultura e Entretenimento:** Minha paixão por mangás, manhwas e animes também encontrará espaço em meus planos futuros. Talvez explorar o desenvolvimento de plataformas interativas, educativas e de entretenimento que unam essa paixão à tecnologia.
  > - **Aprendizado Contínuo:** A educação sempre foi uma parte vital de minha vida, e planejo continuar meu crescimento acadêmico e profissional, participando de conferências, cursos e colaborações internacionais.
  > - **Empreendedorismo:** Com uma visão holística de negócios e vasta experiência em diferentes campos, estou animado para, eventualmente, embarcar em uma jornada empreendedora, unindo tecnologia, inovação e impacto social em uma empresa que reflita minhas paixões e valores.
  >
  > Minha jornada até agora tem sido incrivelmente enriquecedora, e estou ansioso para ver onde essas aspirações me levarão. Seja em um novo papel desafiador, um projeto pioneiro ou uma aventura empreendedora, estou preparado e motivado para o que vem a seguir.

</details>
<details>
  <summary>Voluntariado e participação na comunidade</summary>

  > O voluntariado tem sido uma parte fundamental da minha vida, ensinando-me sobre compaixão, colaboração e a diferença que um indivíduo pode fazer. Seja brincando com crianças, ajudando idosos, melhorando a experiência de usuários do Google Maps ou avaliando propostas inovadoras, cada experiência fortaleceu minha conexão com a comunidade e reforçou meu compromisso com a mudança positiva.
  >
  > - **Sonhar Acordado:** Iniciei minha jornada com a ONG Sonhar Acordado em 2013, dedicando seis anos à causa. Participando de atividades recreativas e de arrecadação com crianças carentes, aprendi a importância da empatia e do engajamento social, enquanto trabalhava em instituições como o Centro Social Romília Maria e a Creche Tia Léa.
  > - **Boas Obras:** Em 2016, me engajei com a ONG Boas Obras, ajudando casas de idosos e moradores de rua. Além de participar de eventos e campanhas, usei minhas habilidades técnicas para criar o site da organização, facilitando a adesão de novos membros e aumentando a conscientização.
  > - **Google Local Guide:** Como Local Guide de Nível 6, contribuo para melhorar a qualidade e precisão das informações no Google Maps. Minhas atividades incluem avaliações de estabelecimentos, envio de fotos, melhorias de rotas e atualização de informações, conectando-me com guias ao redor do mundo.
  > - **Avaliador - Programa Centelha:** Atualmente, atuo como Avaliador no Programa Centelha, uma iniciativa que visa estimular a criação de empreendimentos inovadores. Meu papel é avaliar e selecionar propostas de novos negócios, apoiando empreendedores na transformação de suas ideias em realidade. Isso alinha-se com minha paixão por inovação e empreendedorismo, permitindo-me contribuir para o crescimento e sucesso de startups promissoras.

</details>

<br />

Acesse minha timeline também no modelo Super Mario World [no link](https://voaneves.com/timeline).

[![Minha timeline de Super Mario](img/timeline.png)](https://voaneves.com/timeline)

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Featured projects

<div align="center">
  <a href="https://github.com/voaneves/voaneves.github.io">
    <picture>
      <source
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=voaneves.github.io&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=voaneves.github.io"
        media="(prefers-color-scheme: light), (prefers-color-scheme: no-preference)"
      />
      <img src="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=voaneves.github.io" />
    </picture>
  </a>
  <a href="https://github.com/voaneves/snake-on-pygame">
    <picture>
      <source
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=snake-on-pygame&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=snake-on-pygame"
        media="(prefers-color-scheme: light), (prefers-color-scheme: no-preference)"
      />
      <img src="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=snake-on-pygame" />
    </picture>
  </a>
  <a href="https://github.com/voaneves/colab-rl">
    <picture>
      <source
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=colab-rl&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=colab-rl"
        media="(prefers-color-scheme: light), (prefers-color-scheme: no-preference)"
      />
      <img src="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=colab-rl" />
    </picture>
  </a>
  <a href="https://github.com/voaneves/color-picker">
    <picture>
      <source
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=color-picker&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=color-picker"
        media="(prefers-color-scheme: light), (prefers-color-scheme: no-preference)"
      />
      <img src="https://github-readme-stats.vercel.app/api/pin/?username=voaneves&repo=color-picker" />
    </picture>
  </a>
</div>

<p align="right">(<a href="https://github.com/voaneves?tab=repositories">see more</a>)(<a href="#readme-top">back to top</a>)</p>

## Habilidades

Ao longo da minha carreira, tive a oportunidade de explorar e desenvolver uma variedade de habilidades que se estendem por várias disciplinas. Desde a minha formação em engenharia mecânica pela UNICAMP até os estudos em Sistemas de Informação na XP Educação, sempre fui motivado por uma curiosidade genuína e um desejo de aprender. Em cada etapa, busquei entender os princípios fundamentais e aplicá-los de maneira prática, desenvolvendo assim as seguintes habilidades abaixo.

### Soft skills 

Já fiz inúmeros testes de perfil e, dentre eles, um que gostei bastante foi o teste do ([mindsight](https://mindsight.com.br/), que me permitiu encontrar minhas forças que estão abaixo.

<p>
  <img alt="Execution (Planning and Organization)" src="https://img.shields.io/badge/Execution%20(Planning%20and%20Organization)-%23007BFF?style=flat-square" />
  <img alt="Scientific, Critical and Creative Thinking (Analytical Ability)" src="https://img.shields.io/badge/Scientific,%20Critical%20and%20Creative%20Thinking%20(Analytical%20Ability)-%239C27B0?style=flat-square" />
  <img alt="Knowledge (Conceptual Thinking)" src="https://img.shields.io/badge/Knowledge%20(Conceptual%20Thinking)-%234CAF50?style=flat-square" />
  <img alt="Adaptability" src="https://img.shields.io/badge/Adaptability-%23FFC107?style=flat-square" />
  <img alt="Emotional Intelligence" src="https://img.shields.io/badge/Emotional%20Intelligence-%23009688?style=flat-square" />
</p>

### Hard skills

#### Fullstack webdev

<p>
  <img alt="React" src="https://img.shields.io/badge/-React-45b8d8?style=flat-square&logo=react&logoColor=white" />
  <img alt="Webpack" src="https://img.shields.io/badge/-Webpack-8DD6F9?style=flat-square&logo=webpack&logoColor=white" /> 
  <img alt="TypeScript" src="https://img.shields.io/badge/-TypeScript-007ACC?style=flat-square&logo=typescript&logoColor=white" />
  <img alt="Sass" src="https://img.shields.io/badge/-Sass-CC6699?style=flat-square&logo=sass&logoColor=white" />
  <img alt="angular" src="https://img.shields.io/badge/-Angular-DD0031?style=flat-square&logo=angular&logoColor=white" />
  <img alt="html5" src="https://img.shields.io/badge/-HTML5-E34F26?style=flat-square&logo=html5&logoColor=white" />
  <img alt="css3" src="https://img.shields.io/badge/-CSS3-FB542B?style=flat-square&logo=css3&logoColor=white" />
  <img alt="Prettier" src="https://img.shields.io/badge/-Prettier-F7B93E?style=flat-square&logo=prettier&logoColor=white" />
  <img alt="Bootstrap" src="https://img.shields.io/badge/-Bootstrap-7952B3?style=flat-square&logo=bootstrap&logoColor=white" />
  <img alt="Google Analytics" src="https://img.shields.io/badge/Google%20Analytics-E37400?style=flat-square&logo=google%20analytics&logoColor=white" />
  <img alt="Python" src="https://img.shields.io/badge/-Python-3776AB?style=flat-square&logo=python&logoColor=white" />
  <img alt="Node.js" src="https://img.shields.io/badge/-Node.js-339933?style=flat-square&logo=node.js&logoColor=white" />
  <img alt="MySQL" src="https://img.shields.io/badge/-MySQL-4479A1?style=flat-square&logo=mysql&logoColor=white" />
  <img alt="Git" src="https://img.shields.io/badge/-Git-F05032?style=flat-square&logo=git&logoColor=white" />
  <img alt="GitHub" src="https://img.shields.io/badge/-GitHub-181717?style=flat-square&logo=github&logoColor=white" />
  <img alt="Docker" src="https://img.shields.io/badge/-Docker-2496ED?style=flat-square&logo=docker&logoColor=white" />
</p>

#### Artificial Intelligence

<p>
  <img alt="Keras" src="https://img.shields.io/badge/Keras-D00000?style=flat-square&logo=keras&logoColor=white" />
  <img alt="TensorFlow" src="https://img.shields.io/badge/TensorFlow-FF6F00?style=flat-square&logo=tensorflow&logoColor=white" />
  <img alt="scikit-learn" src="https://img.shields.io/badge/scikit--learn-F7931E?style=flat-square&logo=scikit-learn&logoColor=white" />
  <img alt="OpenCV" src="https://img.shields.io/badge/OpenCV-5C3EE8?style=flat-square&logo=opencv&logoColor=white" />
  <img alt="Pandas" src="https://img.shields.io/badge/Pandas-150458?style=flat-square&logo=pandas&logoColor=white" />
  <img alt="NumPy" src="https://img.shields.io/badge/NumPy-013243?style=flat-square&logo=numpy&logoColor=white" />
  <img alt="Jupyter" src="https://img.shields.io/badge/Jupyter-F37626?style=flat-square&logo=jupyter&logoColor=white" />
  <img alt="Reinforcement Learning" src="https://img.shields.io/badge/Reinforcement%20Learning-3498db?style=flat-square&logoColor=white" />
  <img alt="Natural Language Processing" src="https://img.shields.io/badge/NLP-1abc9c?style=flat-square&logoColor=white" />
  <img alt="Large Language Models" src="https://img.shields.io/badge/LLMs-f39c12?style=flat-square&logoColor=white" />
  <img alt="Mixture of Experts" src="https://img.shields.io/badge/MoE-8e44ad?style=flat-square&logoColor=white" />
</p>

#### Project Management

<p>
  <img alt="Agile" src="https://img.shields.io/badge/Agile-008080?style=flat-square&logo=agile&logoColor=white" />
  <img alt="Scrum" src="https://img.shields.io/badge/Scrum-4A90E2?style=flat-square&logo=scrum&logoColor=white" />
  <img alt="Waterfall" src="https://img.shields.io/badge/Waterfall-7E57C2?style=flat-square&logo=waterfall&logoColor=white" />
  <img alt="PMBOK" src="https://img.shields.io/badge/PMBOK-009688?style=flat-square&logo=pmbok&logoColor=white" />
  <img alt="Lean Six Sigma" src="https://img.shields.io/badge/Lean%20Six%20Sigma-43A047?style=flat-square&logo=lean-six-sigma&logoColor=white" />
  <img alt="Kanban" src="https://img.shields.io/badge/Kanban-F9A825?style=flat-square&logo=kanban&logoColor=white" />
</p>

#### Strategic Planning

<p>
  <img alt="SWOT" src="https://img.shields.io/badge/SWOT-FF5733?style=flat-square&logo=swot&logoColor=white" />
  <img alt="BSc (Balanced Scorecard)" src="https://img.shields.io/badge/BSc-8E44AD?style=flat-square&logo=bsc&logoColor=white" />
  <img alt="PEST" src="https://img.shields.io/badge/PEST-3498DB?style=flat-square&logo=pest&logoColor=white" />
  <img alt="Ansoff" src="https://img.shields.io/badge/Ansoff-1ABC9C?style=flat-square&logo=ansoff&logoColor=white" />
  <img alt="OKRs (Objectives and Key Results)" src="https://img.shields.io/badge/OKRs-F1C40F?style=flat-square&logo=okrs&logoColor=white" />
  <img alt="Porter's Five Forces" src="https://img.shields.io/badge/Porter's%20Five%20Forces-E74C3C?style=flat-square&logo=porter's&logoColor=white" />
</p>

#### Collaboration and cloud

<p>
  <img alt="Google Cloud Platform" src="https://img.shields.io/badge/-Google_Cloud_Platform-1a73e8?style=flat-square&logo=google-cloud&logoColor=white" />
  <img alt="AWS" src="https://img.shields.io/badge/-AWS-232F3E?style=flat-square&logo=amazon-aws&logoColor=white" />
  <img alt="Trello" src="https://img.shields.io/badge/-Trello-0079BF?style=flat-square&logo=trello&logoColor=white" />
  <img alt="Asana" src="https://img.shields.io/badge/-Asana-FC636B?style=flat-square&logo=asana&logoColor=white" />
  <img alt="Slack" src="https://img.shields.io/badge/-Slack-4A154B?style=flat-square&logo=slack&logoColor=white" />
  <img alt="Microsoft Teams" src="https://img.shields.io/badge/-Microsoft%20Teams-6264A7?style=flat-square&logo=microsoft-teams&logoColor=white" />
  <img alt="Notion" src="https://img.shields.io/badge/-Notion-000000?style=flat-square&logo=notion&logoColor=white" />
  <img alt="GitLab" src="https://img.shields.io/badge/-GitLab-FCA121?style=flat-square&logo=gitlab&logoColor=white" />
  <img alt="Microsoft Planner" src="https://img.shields.io/badge/-Microsoft%20Planner-01787C?style=flat-square&logo=microsoftplanner&logoColor=white" />
</p>

#### Design & Marketing Strategy

<p>
  <img alt="Figma" src="https://img.shields.io/badge/Figma-12AA59?style=flat-square&logo=figma&logoColor=white" />
  <img alt="Adobe XD" src="https://img.shields.io/badge/Adobe%20XD-450135?style=flat-square&logo=adobexd&logoColor=white" />
  <img alt="Adobe Photoshop" src="https://img.shields.io/badge/Adobe%20Photoshop-001d34?style=flat-square&logo=adobephotoshop&logoColor=white" />
  <img alt="Adobe Illustrator" src="https://img.shields.io/badge/Adobe%20Illustrator-330000?style=flat-square&logo=adobeillustrator&logoColor=white" />
  <img alt="Canva" src="https://img.shields.io/badge/Canva-4165ec?style=flat-square&logo=canva&logoColor=white" />
  <img alt="SWOT Analysis" src="https://img.shields.io/badge/SWOT%20Analysis-2c3e50?style=flat-square&logoColor=white" />
  <img alt="GE-McKinsey Matrix" src="https://img.shields.io/badge/GE-McKinsey%20Matrix-8e44ad?style=flat-square&logoColor=white" />
  <img alt="BCG Matrix" src="https://img.shields.io/badge/BCG%20Matrix-e74c3c?style=flat-square&logoColor=white" />
  <img alt="Business Model Canvas" src="https://img.shields.io/badge/Business%20Model%20Canvas-2980b9?style=flat-square&logoColor=white" />
  <img alt="Design Thinking" src="https://img.shields.io/badge/Design%20Thinking-27ae60?style=flat-square&logoColor=white" />
</p>

#### Business Intelligence

<p>
  <img alt="PowerBI" src="https://img.shields.io/badge/PowerBI-F2C811?style=flat-square&logo=power-bi&logoColor=white" />
  <img alt="Tableau" src="https://img.shields.io/badge/Tableau-E97627?style=flat-square&logo=tableau&logoColor=white" />
  <img alt="Python" src="https://img.shields.io/badge/Python-3776AB?style=flat-square&logo=python&logoColor=white" />
  <img alt="SAS" src="https://img.shields.io/badge/SAS-0092BE?style=flat-square&logo=sas&logoColor=white" />
  <img alt="Qlik" src="https://img.shields.io/badge/Qlik-8DC63F?style=flat-square&logo=qlik&logoColor=white" />
  <img alt="Apache Spark" src="https://img.shields.io/badge/Apache%20Spark-E25A1C?style=flat-square&logo=apache-spark&logoColor=white" />
  <img alt="Microsoft Excel" src="https://img.shields.io/badge/Microsoft%20Excel-217346?style=flat-square&logo=microsoft-excel&logoColor=white" />
  <img alt="Google Data Studio" src="https://img.shields.io/badge/Google%20Data%20Studio-4285F4?style=flat-square&logo=google&logoColor=white" />
</p>

#### Big Data

<p>
  <img alt="MongoDB" src="https://img.shields.io/badge/-MongoDB-13aa52?style=flat-square&logo=mongodb&logoColor=white" />
  <img alt="Hadoop" src="https://img.shields.io/badge/Hadoop-FF7B00?style=flat-square&logo=apache-hadoop&logoColor=white" />
  <img alt="Apache Spark" src="https://img.shields.io/badge/Apache%20Spark-E25A1C?style=flat-square&logo=apache-spark&logoColor=white" />
  <img alt="Neo4j" src="https://img.shields.io/badge/Neo4j-008CC1?style=flat-square&logo=neo4j&logoColor=white" />
</p>

#### Languages

<p>
  <img alt="Português (Nativo)" src="https://img.shields.io/badge/Português-Nativo-089e40?style=flat-square&logo=brazil&logoColor=white" />
  <img alt="English (Fluent)" src="https://img.shields.io/badge/English-Fluent-blue?style=flat-square&logo=united-kingdom&logoColor=white" />
  <img alt="Español (Experto)" src="https://img.shields.io/badge/Español-Experto-yellow?style=flat-square&logo=spain&logoColor=white" />
  <img alt="한국어 (기초)" src="https://img.shields.io/badge/한국어-기초-red?style=flat-square&logo=south-korea&logoColor=white" />
  <img alt="Deutsch (Anfänger)" src="https://img.shields.io/badge/Deutsch-Anfänger-yellow?style=flat-square&logo=germany&logoColor=black" />
</p>

#### Mechanical Engineering

<p>
  <img alt="AutoCAD" src="https://img.shields.io/badge/-AutoCAD-0078D7?style=flat-square&logo=autodesk&logoColor=white" />
  <img alt="SolidWorks" src="https://img.shields.io/badge/-SolidWorks-FF9900?style=flat-square&logo=solidworks&logoColor=white" />
  <img alt="MATLAB" src="https://img.shields.io/badge/-MATLAB-0076A8?style=flat-square&logo=mathworks&logoColor=white" />
  <img alt="ANSYS" src="https://img.shields.io/badge/-ANSYS-FF5757?style=flat-square&logo=ansys&logoColor=white" />
  <img alt="Creo" src="https://img.shields.io/badge/-Creo-ED8B00?style=flat-square&logo=creo&logoColor=white" />
</p>

#### Additional & Extra

<p>
  <img alt="Java" src="https://img.shields.io/badge/-Java-007396?style=flat-square&logo=oracle&logoColor=white" />
  <img alt="C" src="https://img.shields.io/badge/-C-007396?style=flat-square&logo=c&logoColor=white" />
  <img alt="C++" src="https://img.shields.io/badge/-C++-007396?style=flat-square&logo=cplusplus&logoColor=white" />
</p>

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Stats

<br /><br />

<div align="center">
  <picture>
    <source
      srcset="https://github-readme-stats.vercel.app/api?username=voaneves&icon_color=cc0000&show_icons=true&theme=dark"
      media="(prefers-color-scheme: dark)"
    />
    <source
      srcset="https://github-readme-stats.vercel.app/api?username=anuraghazra&show_icons=true"
      media="(prefers-color-scheme: light), (prefers-color-scheme: no-preference)"
    />
    <img src="https://github-readme-stats.vercel.app/api?username=anuraghazra&show_icons=true" />
  </picture>
</div>

<br />

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Run my profile 🤣

<details>
  <summary>in Python 👍</summary>

  ```python
  class Programmer:
      def __init__(self):
          self.languages = []
          self.frameworks = []
          self.tools = []
          self.soft_skills = []
  
      def aboutMe(self):
          return (f"I am skilled in various languages such as {', '.join(self.languages)}, "
                  f"and have experience with frameworks like {', '.join(self.frameworks)}. "
                  f"I often use tools like {', '.join(self.tools)}.")
  
  class Victor(Programmer):
      def __init__(self):
          super().__init__()
          self.name = "Victor Neves"
          self.title = "Tech Enthusiast, AI Lover & Mechanical Engineer"
          
          # Languages
          self.languages = [
              "Python", "Java", "SQL", "Javascript", "Julia",
              "R", "TypeScript", "HTML5", "CSS3", "C", "C++"
          ]
          
          # Frameworks and Libraries
          self.frameworks = [
              "React", "TensorFlow", "Angular", "Django", "Keras",
              "Node.js", "scikit-learn", "OpenCV", "Webpack", "Sass",
              "Pandas", "NumPy", "Bootstrap", "Git", "Docker"
          ]
          
          # Project Management, Cloud, and others
          self.tools = [
              "Agile", "Scrum", "Kanban", "AWS", "Google Cloud Platform",
              "Trello", "Asana", "Slack", "Microsoft Teams", "Notion",
              "Figma", "Adobe XD", "PowerBI", "Tableau", "MongoDB",
              "Hadoop", "Apache Spark", "Neo4j", "AutoCAD", "SolidWorks",
              "MATLAB", "ANSYS", "Creo", "MySQL", "GitHub"
          ]
          
          # Soft skills
          self.soft_skills = [
              "Planning and Organization",
              "Analytical Ability",
              "Emotional Intelligence",
          ]
  
      def aboutMe(self):
          title = str(self.title.title())
          about_text = (f"Hello! My name is {self.name} and I'm a {title}. "
                        f"{super().aboutMe()} "
                        f"My soft skills include {', '.join(self.soft_skills)}.")
          return about_text

      if __name__ == "__main__":
          victor = Victor()
          print(victor.aboutMe())
  ```
  
</details>

<details>
  <summary>in Javascript ❤️</summary>

  ```js
    class Programmer {
        constructor() {
            this.languages = [];
            this.frameworks = [];
            this.tools = [];
            this.soft_skills = [];
        }
    
        aboutMe() {
            return `I am skilled in various languages such as ${this.languages.join(', ')}, ` +
                `and have experience with frameworks like ${this.frameworks.join(', ')}. ` +
                `I often use tools like ${this.tools.join(', ')}.`;
        }
    }
    
    class Victor extends Programmer {
        constructor() {
            super();
            this.name = "Victor Neves";
            this.title = "Tech Enthusiast, AI Lover & Mechanical Engineer";
            
            this.languages = [
                "Python", "Java", "SQL", "Javascript", "Julia",
                "R", "TypeScript", "HTML5", "CSS3", "C", "C++"
            ];
            
            this.frameworks = [
                "React", "TensorFlow", "Angular", "Django", "Keras",
                "Node.js", "scikit-learn", "OpenCV", "Webpack", "Sass",
                "Pandas", "NumPy", "Bootstrap", "Git", "Docker"
            ];
            
            this.tools = [
                "Agile", "Scrum", "Kanban", "AWS", "Google Cloud Platform",
                "Trello", "Asana", "Slack", "Microsoft Teams", "Notion",
                "Figma", "Adobe XD", "PowerBI", "Tableau", "MongoDB",
                "Hadoop", "Apache Spark", "Neo4j", "AutoCAD", "SolidWorks",
                "MATLAB", "ANSYS", "Creo", "MySQL", "GitHub"
            ];
            
            this.soft_skills = [
                "Planning and Organization",
                "Analytical Ability",
                "Emotional Intelligence"
            ];
        }
    
        aboutMe() {
            const title = this.title.charAt(0).toUpperCase() + this.title.slice(1);
            return `Hello! My name is ${this.name} and I'm a ${title}. ` +
                `${super.aboutMe()} ` +
                `My soft skills include ${this.soft_skills.join(', ')}.`;
        }
    }
    
    const victor = new Victor();
    console.log(victor.aboutMe());
  ```
    
</details>

<details>
  <summary>in Julia 🔥</summary>

  ```julia
  abstract type Programmer end
  
  mutable struct Victor <: Programmer
      name::String
      title::String
      languages::Vector{String}
      frameworks::Vector{String}
      tools::Vector{String}
      soft_skills::Vector{String}
  end
  
  function aboutMe(p::Programmer)
      return "This function should be overridden in subclasses."
  end
  
  function aboutMe(v::Victor)
      title = uppercase(v.title[1]) * v.title[2:end]
      languages_str = join(v.languages, ", ")
      frameworks_str = join(v.frameworks, ", ")
      tools_str = join(v.tools, ", ")
      soft_skills_str = join(v.soft_skills, ", ")
      
      return "Hello! My name is $(v.name) and I'm a $title. " *
             "I am skilled in various languages such as $languages_str, " *
             "and have experience with frameworks like $frameworks_str. " *
             "I often use tools like $tools_str. " *
             "My soft skills include $soft_skills_str."
  end
  
  victor = Victor("Victor Neves",
      "Tech Enthusiast, AI Lover & Mechanical Engineer",
      ["Python", "Java", "SQL", "Javascript", "Julia", "R", "TypeScript", "HTML5", "CSS3", "C", "C++"],
      ["React", "TensorFlow", "Angular", "Django", "Keras", "Node.js", "scikit-learn", "OpenCV", "Webpack", "Sass", "Pandas", "NumPy", "Bootstrap", "Git", "Docker"],
      ["Agile", "Scrum", "Kanban", "AWS", "Google Cloud Platform", "Trello", "Asana", "Slack", "Microsoft Teams", "Notion", "Figma", "Adobe XD", "PowerBI", "Tableau", "MongoDB", "Hadoop", "Apache Spark", "Neo4j", "AutoCAD", "SolidWorks", "MATLAB", "ANSYS", "Creo", "MySQL", "GitHub"],
      ["Planning and Organization", "Analytical Ability", "Emotional Intelligence"])
  
  println(aboutMe(victor))
  ```
    
</details>

<details>
  <summary>in C++ 😲</summary>
  
  ```cpp
  #include <iostream>
  #include <vector>
  #include <string>
  
  class Programmer {
  public:
      virtual std::string aboutMe() {
          return "This function should be overridden in subclasses.";
      }
  };
  
  class Victor : public Programmer {
  public:
      std::string name;
      std::string title;
      std::vector<std::string> languages;
      std::vector<std::string> frameworks;
      std::vector<std::string> tools;
      std::vector<std::string> soft_skills;
  
      Victor(const std::string& _name, const std::string& _title,
             const std::vector<std::string>& _languages, const std::vector<std::string>& _frameworks,
             const std::vector<std::string>& _tools, const std::vector<std::string>& _soft_skills)
          : name(_name), title(_title), languages(_languages), frameworks(_frameworks),
            tools(_tools), soft_skills(_soft_skills) {}
  
      std::string aboutMe() override {
          std::string title = this->title;
          title[0] = std::toupper(title[0]);
          std::string languages_str = joinVector(languages, ", ");
          std::string frameworks_str = joinVector(frameworks, ", ");
          std::string tools_str = joinVector(tools, ", ");
          std::string soft_skills_str = joinVector(soft_skills, ", ");
          
          return "Hello! My name is " + name + " and I'm a " + title + ". " +
                 "I am skilled in various languages such as " + languages_str + ", " +
                 "and have experience with frameworks like " + frameworks_str + ". " +
                 "I often use tools like " + tools_str + ". " +
                 "My soft skills include " + soft_skills_str + ".";
      }
  
  private:
      std::string joinVector(const std::vector<std::string>& vec, const std::string& delimiter) {
          std::string result;
          for (size_t i = 0; i < vec.size(); ++i) {
              result += vec[i];
              if (i < vec.size() - 1) {
                  result += delimiter + " ";
              }
          }
          return result;
      }
  };
  
  int main() {
      std::vector<std::string> languages = {"Python", "Java", "SQL", "Javascript", "Julia", "R", "TypeScript", "HTML5", "CSS3", "C", "C++"};
      std::vector<std::string> frameworks = {"React", "TensorFlow", "Angular", "Django", "Keras", "Node.js", "scikit-learn", "OpenCV", "Webpack", "Sass", "Pandas", "NumPy", "Bootstrap", "Git", "Docker"};
      std::vector<std::string> tools = {"Agile", "Scrum", "Kanban", "AWS", "Google Cloud Platform", "Trello", "Asana", "Slack", "Microsoft Teams", "Notion", "Figma", "Adobe XD", "PowerBI", "Tableau", "MongoDB", "Hadoop", "Apache Spark", "Neo4j", "AutoCAD", "SolidWorks", "MATLAB", "ANSYS", "Creo", "MySQL", "GitHub"};
      std::vector<std::string> soft_skills = {"Planning and Organization", "Analytical Ability", "Emotional Intelligence"};
  
      Victor victor("Victor Neves", "Tech Enthusiast, AI Lover & Mechanical Engineer",
                    languages, frameworks, tools, soft_skills);
  
      std::cout << victor.aboutMe() << std::endl;
      
      return 0;
  }
```

</details>

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Let's colab 🚀

🌟 I'm always open to collaborating on exciting projects and ideas. If you share similar interests or have a project you'd like to work on together, feel free to reach out on the socials below!

<p>
  <a href="mailto:victorneves478@gmail.com" target="_blank"><img alt="E-mail" src="https://img.shields.io/badge/-Gmail-ea4335?style=flat-square&logo=Gmail&logoColor=white" /></a>
  <a href="wa.me/5563999999337" target="_blank"><img alt="WhatsApp" src="https://img.shields.io/badge/-WhatsApp-42e35f?style=flat-square&logo=whatsapp&logoColor=white" /></a>
  <a href="https://linkedin.com/in/voaneves" target="_blank"><img alt="LinkedIn" src="https://img.shields.io/badge/-LinkedIn-007ACC?style=flat-square&logo=linkedin&logoColor=white" />
</p>

<p align="right">(<a href="#readme-top">back to top</a>)</p>
