module iter

fn test_prod_simple_1() {
	data := [[1.0, 2.0], [3.0, 4.0]]
	expected := [[1.0, 3.0], [1.0, 4.0], [2.0, 3.0], [2.0, 4.0]]
	result := product(data)
	assert expected == result
}

fn test_prod_simple_2() {
	data := [[1.0, 2.0, 3.0], [3.0, 4.0]]
	expected := [[1.0, 3.0], [1.0, 4.0], [2.0, 3.0], [2.0, 4.0],
		[3.0, 3.0], [3.0, 4.0]]
	result := product(data)
	assert expected == result
}

fn test_prod_longer() {
	data := [[1.0, 2.0], [3.0, 4.0, 5.0], [1.0, 6.0, 11.0]]
	expected := [[1.0, 3.0, 1.0], [1.0, 3.0, 6.0], [1.0, 3.0, 11.0],
		[1.0, 4.0, 1.0], [1.0, 4.0, 6.0], [1.0, 4.0, 11.0], [1.0, 5.0, 1.0],
		[1.0, 5.0, 6.0], [1.0, 5.0, 11.0], [2.0, 3.0, 1.0], [2.0, 3.0, 6.0],
		[2.0, 3.0, 11.0], [2.0, 4.0, 1.0], [2.0, 4.0, 6.0], [2.0, 4.0, 11.0],
		[2.0, 5.0, 1.0], [2.0, 5.0, 6.0], [2.0, 5.0, 11.0]]
	result := product(data)
	assert expected == result
}
