module main

import math
import vsl.plot
import vsl.util

fn main() {
	x := util.lin_space(0.0, 5.0, 100)
	y := util.lin_space(0.0, 5.0, 100)

	mut z := [][]f64{cap: y.len}
	for y_val in y {
		mut row := []f64{cap: x.len}
		for x_val in x {
			row << math.sin(x_val) * math.cos(y_val)
		}
		z << row
	}

	mut plt := plot.Plot.new()
	plt.surface(
		x:          x
		y:          y
		z:          z
		colorscale: 'Viridis'
	)
	plt.layout(
		title: 'Surface Plot of sin(x) * cos(y)'
	)
	plt.show()!
}
