from virtool_core.models.history import History, HistorySearchResult


class ListHistoryResponse(HistorySearchResult):
    class Config:
        schema_extra = {
            "example": [
                {
                    "created_at": "2022-01-28T23:28:53.881000Z",
                    "description": "Removed Betaflexivirus from Camelia #1 (BFV_CAM1)",
                    "id": "1wfc5x6e.removed",
                    "index": {"id": "s7frhn8n", "version": 1},
                    "method_name": "remove",
                    "otu": {
                        "id": "1wfc5x6e",
                        "name": "Betaflexivirus from Camelia #1",
                        "version": 4,
                    },
                    "reference": {"id": "pat6xdn3"},
                    "user": {
                        "administrator": True,
                        "handle": "igboyes",
                        "id": "igboyes",
                    },
                }
            ]
        }


class HistoryResponse(History):
    class Config:
        schema_extra = {
            "example": {
                "created_at": "2022-01-28T23:28:53.881000Z",
                "description": "Removed Betaflexivirus from Camelia #1 (BFV_CAM1)",
                "diff": {
                    "_id": "1wfc5x6e",
                    "abbreviation": "BFV_CAM1",
                    "created_at": "2021-12-09T01:32:35.390000Z",
                    "imported": True,
                    "isolates": [
                        {
                            "default": False,
                            "id": "714d1ea9",
                            "sequences": [
                                {
                                    "_id": "eukvplhn",
                                    "accession": "16SP043_BFV_CAM1",
                                    "definition": "Betaflexivirus, complete genome",
                                    "host": "Camelia",
                                    "isolate_id": "714d1ea9",
                                    "otu_id": "1wfc5x6e",
                                    "reference": {"id": "pat6xdn3"},
                                    "remote": {"id": "g84vd2rm"},
                                    "segment": "",
                                    "sequence": "TTCAGAAATCAACTCAACCTGTTGTGAGTACCCATCACATCAAAGCAATGGCTTCAGTGATGATAAGAACTCCTATGGAAAAGTTTTTTTCAGCAAATGACAAGAATGATCAAAAAATAATTCTTACGTCTGGAGTGAATTATGTTAAAAAATTTTGTGATGAGCAGGGTTTACACTTTGCATACTCAGTGGATGAGAGGAAAAAGGCTGCACTGACCAATCTTGGCATTAATTTGCATCCAGTGCCCTTTTTACCTCATTCACACCCTTTTTGCAAAATTCTTGAAAATAACCAGCTCATCAACATCCTACCAGGGATATTAGGTAGTGGTAGATGGACATTTATGTCAATTAAAGAAGGAAAAGTAGAAAGTATTATAAAAAAAAGTGGAGGTGTAAATAATAATATTAGTTTAATTAATAGATGTATATGTGCAAAAGATTTTTCAAGGTATGATTTCACCCCTGAAGAAGTTGATTTGAGAACAAATGTTCTCTCTGAGGATCATTTATTTCCAGAGAATCTGATGAGAAGCCTCAAAGGGAAAAAGATTTTTATACATGATGAGGTTCATCACTGGAATTCAAAAATCATGATCAACTTTCTGGAGAAAGTCAAACCTAAGATAATCTTTTGTTCAGTCGTTTATCCGCCAGAATTATTGGCTGGAATATTGGAACCTCAAAATAAAAGTTTTTATGATTTTAAGGTTGATGGTGATAAATTATTTTTTTTTCCAGATGGCAATAGGAGTGAATTTTATGAGCAGCCAAAGGATCTTGGTTGGCTAATGCTTGCAAAGAAATTCAAGCTCAATGACTGCAATTACACTGTTAAATTAATCAGCAGCACTTACTGCCATCACTTATTTCAAATATCTAGAGGTGAGAAGATAACTGAATCAAAGAGATTCTTCTCAGACTTTGATACCATTGACCTCAAAGTTATACACAATGAGAGGTTCAGATACTACGATCACATCCCCATAAGAAGGGCACATCTTGAGAAAGTGTACACATACTTGATGTGTCTTAAAAAACCGGATGTTGAATCAGCCATTGCAAAACTACGCCAACTTATGGAGGATGAGCAGGACACCAGAGTTGTGGCTTTTTTCTGCAAATTTGCAAGGGATGTGATTGAGAAATTCAAGGGAAAGATACATCTGTATGAAACGGGGTGGTTGAGTCAAATTGGAGACAATTTCATACAGATGCTTCCAAATTTCTGGGGGAGGATATTGTCAAGGTGGCATGGATTGAATCTTTTTGACTTCTTGTTCAAGCTTGATAACTTGAGAATTGAGGTTGAGTTGATTGACGTGGATGCTGAGTACTCATCGAGAAGTGAGGTCCTTAAACGCTTGTTTAAGAAGGATCAATTTAGTGAAAATTTTGATGGGCTTAATGTTGAGTACCTCAGAACTATTGGTCTTGAGGTCGAGATGGATGACGCATGGAGCAAGGGTTTCTCATCAAAAAAAAATAACTCAATTCATGCCTGCATCTCAAAATTTGGTGTTGAGAGAGTATCCAGCAAGGCCTTTGAAAGTAAACTCATCTCAAGATTTCATCTCAAAGTTGGCATTCTTGCCTTACTGCACAGGAGAAATGGAAATGGGAAGTCCTTGTTGAAAGGAGCACCTGTGAACCCAGATTCTAAGCAGGAAAAGAAAGGTATTTTAATGATCAAGCTCAGGTCAGATGACAAGGTTGAATCATATCCAGAGCCTTTTTTCTTAAATTTGAGAAATTTTTCATCAAAAGAATGTCCATTTGAAGATTTACGATGGATGAGAGTTCATAACAAGATTTGGGGTGGAACTTTCGGCACCCCATTAATACCAAGTGACTCACCATTGGAAGGAGATGAGGATGTTGACGTTTGTGTCATGGTGGACGAATTAGGATATGATAATGATGTCCAAGATGAGCAATGTGTCAAAAATTTGGAAATTCTTGAGATGGATGAAATTTTGAATGATTCCAACCCCAATATGAATGTGACTTCAACTGAAGTCAAACAAGATGATAAAAGGGAAGATTGCCAGCTCAATTTGATTGAATCCAGCGAAGTGGAAACTTCCAAATTCATGTCAGAGCTTGAGGACTCTGTATATCTCAGTTTCCATGATGATGAAACATTTAATTACTCAAATGTGCCAATAATAGGAGATGGCAATTGTTTTTTTAGAGCCATTTGCATGTCAGTGCATGGAAATGACTTTGGTCATCTTGAAACTAGGAAAAAATTTTCTGAACATGCAAGAAAAATTGGATTCAAATTTAATGCTGAAATTGAGGAGGCAATCACCAAGGATGGCACTTTCTCTGACACATGGATGGTCAATCTCTTTGCAAATGTTATGAATGTTAGACTCTTCATTCATGAAACAGAGGATGGTCCTTACTATGAGATTCACCCAACAATCATCAAGTATGATGACCCCCCAGTGTTCACAGTTAGATTACTATTTAGGGACGCACACTTTACTCTTTTGAAAGAGGAAAAGAGTGAGACTTGTGAAACGCTTAAGAAAGAGTTTTTGATTGATTGGGGGGAGAATGAATTCAGAGCTCTTAATGAATTTGTTGACTTGATAGTGGCTGAGCAGCAAAGGTTCAAGGCCAATAACTTCAAATCAAGGAAGGCCTTCTTTTTCTCTGAGCACGAGGGCATTGACTATGGGCATGATAAAGTTAAGTACCATCGGAATCAGATTGATTCAATTGACAGTCTTCTGCCCAGAGGAATGAATTGTGGTTTCAATTCAATGCTTGTGCAGATCTACGCTGATGGTGCTGAATTGCCAATGCACAGAGATGATGAGAAGGTTTATGACAATGACAACATCCTTTCCATCAATCTCAGGGGAGACTGCAAATTCATAATTAATGAGTCAAAAAAAGGGGCTAGCAATGTCAGGTCAATTGAGATGAAGCAAGGGGCTTATATAGTAATGTTAAGTGGCTTTCAAAAAAAATTCAAACATGGGGTTTCTGAATGTAGAAATGGGCGTGTGAATGTCACATTCAGAAGGCATGTGAGAAGTATGAGGGGTCATGACTTGATTGATTTTGATCTTTCCAAAATTAAAAATGGGTGTTTAATAAGGTCAATTGCAAATGCTGAATGCAGAGGACTGAATCAAGTTGTCCAGGCCTTGATCAGAAAGGATAGAGCCTTTTGGAGTGATTGGATTCATTCAGGGCAGGGGGGGACGATAGATGATCTAGTCAAAGCTGCCACTGAACTTCATTTCTCATTTGATCTAATTACTGAAAAGGGGTGTGACTCTTTTAAAAATTCCGGGCCCAAATTCACATTCCAACTTAAAAATGGTCATTTTGAAAGTATTAATGAAAGACCTTCATGTGTGGAAATGACCTTCCTGAATATGAGATCAAAAGGAAAAAAAAGTGGGAAAGGCATTGAAAAGCTCAAGTTCGAGCACATGAATGAAACAAATTTTGAGATTGTCGGAGAATTTGCCGCAATCCTTAAAAGATCATTCATGGAGCGAACAACAGGTCTAATTCTCTCCGAATGTTATGGCTCTGCATGCAAGAATCTTGAAGATTTGCAAATAGATCCAAGCAGTCAATTTGAGAAGAGAATTGACTTTATCTGTGGCTTTGCGGGGTCAGGAAAGAGCTTTTCAATTCAGTGCAAACTTGCATCGGAGCCTAAAGCTGATTTCTTGGTTATATGTCCCAGGAATGAACTCAAAAAAGATTGGCTTGAAAAAATCAATTGCAGTGAGAAAAAAGTTAGGACATTTGAAGTAGCCTTAACGCTCAACCTTTCAAAGATTGAATTGATTGTGATAGATGAACTGGGCTTGTTTCCAAATGGGTATCTCGATTTGCTGTGTCTAATGCTAACAAACCAGGGCAATTACAATTGCCAAGTGGTATGTTTGTTCGACCCTTTACAAGCGAGGTACCACAGTGATCTTGATGATTCTCTTTTAGATTTTCAGCATGACTGTGATAGGCTGATTGCTGATTGTGAATATCTGTACCTTGCAGAAAGTAGGAGGTTATCAAGCAAGTTCTTTGGAGCTTTCTTTCCAGACATCCACCTGCACAATGAAGGGAAAGAAGATCTAAGCATAACAATATTTGATAGTGTTGTTGTGGCGATAAATGAAATGAAAAAGAAAGAAACTCCAATCGACTTGGTGCTGGTTGCCTCAAGAGATGAAAAAAAGGCGCTGGCAACATCTGTTCGAACATTAACATTTGGGGAAGCTCAAGGCCTCACAGTCAATTATGCTTGTATTGTACTCTCTGAGTACTCAGAAAAGCAAGACGACCTACGGTGGATGGTAGCACTGACAAGGGCAAGGATCAAAATAGTCTTTGTATGTATGTACAGGGGAGGTCCAAGTTGCTTTTTACAAAACAATACATCCAGGTTAATAGGTCTGTTTCTGAGACAATCACCCATGACTATAAACAGGATGAAATTGATGGTCAAGGGTGATTTGATACCTTTTAGAAAGACAATAGGTTGTTCAGATGAAATGGATAGAGAGGAGAGATTGGAAGGAGACCCTTTTCTTAAACCACTGATTTTTCTTGGTAGTAGGATCAATTCAGAACAGGTTGAAGTTCTGGAGCCAGAAGTTGTTGAACCAATTGAGATGACTCACATCCCATTACCCCCAAGCCATTTTGATCAAAGCATTAATTTTGACAGAATTAGAGCACGTGAGCATAGGGAGTTCAGGATGTATTCAATGTGTACAAAGCAGTTTTGTGAGGATTTTGAACATTCAAGAGCCTCGGGGAAGCAGATGACACCAGGTCCTATGAGATTCGAAGCAATCTACCCAAGACATAAAGCAGATGATGACCTGACCTTTTGGATGGCTGTCAAGAAGAGGTTGCGCTTTTCCGAGGAGTTTGTTGAAAGAGCAAAACTTAAAGAAGCAATGGGAGTTGGGGGTTTGTTGTATTCAAACTTCAAGGAGACATTGGGTTTGAAGTTCAATTGGGATCAGAAGCTCCTTGACGAGTGCGTCAATGACTTTGAAGAGAAGAAACTTAGCAAAAGCAAGGCAACTCTACAAGCTCATAGCTCAAGATCTGACTCAGACTGGAAATTGGATCATATCTTTCTGTTCATGAAATCCCAATTGTGCACAAAATTTGAAAAGCAGTATGTTGACGCAAAAGCCGGGCAAACATTGGCTTGTTTTGCACACTGCATTTTAGTCAAGTTTGCGCCTTATTGCAGATACATGGAAAAACAATTGAGAAATCAATTTCCAGATAACATATACATTCACTCAGGAAAGAACTTCAATGATCTTAATCAGTGGGTTAAAGAGAACATGAAGGGGAAGGAATGTATAGAGTCAGACTATGAAGCATTCGATGCGAGTCAAGATGAATACATACTGGCCTTTGAAATATGCCTCATGGAGGATATGGGGATGCCAACTTGGTTCATCAATGATTATATAGATCTTAAATGCACACTTGGGTGCAAATTGGGCCACTTTGCCATTATGAGATTCACTGGTGAGTTTAGCACCTTTCTATTCAACACATTGGCAAACATGGCCTTCACATATGCCAGATATGATTGTGATGCATCAACTCCAATTGCCTTTGCTGGAGATGACATGTGCATGCTTGACAATTGTGCCGAGACTGACAAATTCGAAGGAATTTTTGAGAAAATATCACTGAAGGCGAAGGTTTTGAGGTCATGTACACCTATGTTTTGTGGGTGGAATTTGTGCAAGTATGGAATCTTCAAGGAACCGGCTCTAGTTTATAATAGATTTATGGTTGCTCAGGAAAGGGGTAATGTAGAGGAGTGCCTTGAGAATTATGCAATAGAGGTTTCCTATGCTTACATGTTAGGTGAGAAGCTCTATGAATTTTTGAAAGAAGAAGAGAGAATTAACTATCATCAAAGCGTAGTGAGATTCATAATTAAAAGAGCATATAAACTCAAGACCAAAGTGCGGCTTCTGTACACCAGTGATGGCGAAAGCAATTAGAGTTAAGAGCCTCACCAATCGGCTAGAGGTTGACAAATCTCTGCTCAATTCAAATGAAGTCTCAGCTCTGTATGGTGGTGCCTTTGCACCACTAGTTTTTAAGGATGAGGTTAAAATGGTAATTCCTGGCAACCTACTGGGCGGGCCAATTCGTCTACAGGCAAACATACTCACAAAGTCAAGACTCGAAAAAATTCGCAGCCAAAAATTTAAAGGAAACTCATGTGCTTATCTGCATCTTGGGGTGGTCACCATTGTTATACAATCACTGCTGGTGTCTGGCAATGAAAATGTCAGAGGCAGGTGCTCATTGGTTGATCTTTCAAGGGGCTCTGAAATGACTGGGCTCATTGACAAATTCAAGTTCAGCTTTACTAAAAACGAACCTTTCGCTGCAAAAATGTTGACAATAAATGCAGCAATTGATATTGACTGCGAGGTGTCTGCTGGAAGTATTCAGGCTCTCCTTGAAGTTGAAGGCATTGATGTCAGATCTGAGAGGAGTGTTCTAGCCATCACCACTGGGATAACCTGTGTTCCAACTAACTCCATGGTAATGTTGCCAGGTCTGAAAAGAGAAACCCCGAAGTTTGCAATTGCGAATGTTTACAATGTTCCTGATGAAGATCCAACTGAATGCGAGGCGTTTAACAGATTATTTGGAGCCGCTAATCCAAAGTTGATTGATTTGGGTAGTGAGACTGTGTTGGAAGAAGGGAAGAGATTTGGCCTATGGGGACCTGTCGTTAAACCAGTACACAGAAGGAAGCTCGTGACAAAAGGCATTATCAAGGATCACATGAGCCAATTTATGTCAGGCCCTTCCAAAGATTTGAAAATAGAAGAAGGTTTGGAAAGGTCAAGCTCATTACGTGTTGAAAATGTCTGCGAAACTGGCAAAGAAGAGGCTGATACACGACGAAGTGTCGGAATGGATTTTCAGGAGTTTCGTGGACCAGATAATTCAATGGGGGTTGTTGCTGGTAAATGCTGGGAATCAGAGAGTTCAGCTGAATTTAAACCAACAGGAGCAGAAATCAAGAGTTCAGAACAGCAGACTCCGGACGATTTTTGGCAATATAGCAGATCACTCAGCAGGGCCAGCAACAGTGTACCCGTCAATCAGTGTAAGTTATCAGGTGATGAACATTCAGGGAATCGAAGGTGTTGCACAGATGGATGGAAATTTCAATCTGAGAACATTGGTGGAAAATCTGAAGACCTTCCTTCTGACCAGCCAGGATCCTCAGCTCAACACTGCAACATTAAGGGAGGTCTGCCGGAGCTTTGCAAACTACGCCCTTGAGTACTACATGGAAGACCCCGACAGGATGTCCAATCTAGCTGACAAAATGCCACAACTAGCTCTGCAGGCGAGGGAGGTCATGTTTGACTTTTCTGATGGAATAAGTCAGCAATATTTGAGGGGTTTTCCAATGAGGGCTAAGGTTATACAGGAATTGAATAGTAGGCTTCTGCAGTCCACTGGCACCAAGGCTGTGTTTGAAGCAAGGGGCACAGTTGAGTCCTCAGTTAATTTGATTGTTTAAGGAAACAATACAGGCTTTGTCATTTGAGTGCTGTGAGTTCAAATGATACCTTATAAGTCAGATTCATCTGCACAGGTAAGTTTCAACCTCTTTGTATTTAAAGAGTGGCCGAGTGAGTGTACGCTCATGTTCGGAGATTAGCTTCCCAGCTTTATCAAATATTATGACTTAAGTATTAATAGGGATGTCTTTTATGAAT",
                                }
                            ],
                            "source_name": "16SP043",
                            "source_type": "internal",
                        },
                        {
                            "default": True,
                            "id": "950197de",
                            "sequences": [
                                {
                                    "_id": "5oydqvv1",
                                    "accession": "16SP042_BFV_CAM1_B",
                                    "definition": "Betaflexivirus, complete genome",
                                    "host": "Camelia",
                                    "isolate_id": "950197de",
                                    "otu_id": "1wfc5x6e",
                                    "reference": {"id": "pat6xdn3"},
                                    "remote": {"id": "nkun91us"},
                                    "segment": "",
                                    "sequence": "GTTGAAAATAATATTAGTGTAGTAAATACGAAAACAAACACACATAACTAACACTTGAACTTGAATTCATCTCCCAACGGTACCCATCAGTGTAAGTCCAATGGCATCAGTGATGATAAGAACCCCTCTGGAGAAATTCTTTTCTGCCAATGATAAGGCTGACCAAAAGGTCATCCTTACATCTGGAGTTAGTTATGTAAAAAAATATTGTGATGATAAAGGTCTGCATTTTGCCTATTACCTTGATGAAAGGAAGAAAAAGGCAATCACAGATCTTGGAATTAATTTGCATCCCGTACCCTTTCTGGCACATTCACACCCATTCTGTAAAGTTCTTGAAAACAATCAGCTTGTCAACATTTTGCCAGGTCTGCTTGGCTCAGGCAAATGGGTATTTATGTCCATTAAAGAAGGAAAGGTGGAGCAAATTATTAAAAAAAGTGGAGGAGTTGAAAATAATATTAGTGTAGTAAATAGATGTATATGTGCTAAGGATTTCTCTAGATACGACTTCACACCTAATGAGGTCGATATTCGGCGAAACTCCATTAAAGGTGACCACCTTTTTCCAGAAAATTTAATGCGGAGCCTTAAAGGAAAGAAAATCTTCATTCATGATGAAGTTCATCATTGGAATTCCAAGCAGATGATTGATTTTTTGGAAAGGGTTTCACCTACAATATTATATTGTTCAGTAGTTTACCCACCTGAGCTTTTGGGTGGGATCACCACCCCTCAAAATAAGACCTTTTATGATTTTAAAGTTGAAGGGGACAAACTTTATTTTTTTCCTGACGGTAATCGGAGTGAATTCTATGAACAACCTGCTGATCTCAAATGGTTGCTCATGGCTAAAAGGTTCATTTTGAAGGACTCTGAGTACACTGTCAAAATGCTCAGTAGCACTTATTGTCATCACCTTATCCAAATTTCAAAAGGGGCCAAAATCACGGAATCAAAACGGTTTTTCTCAAACTTTGATACCATTGATTTGAAGGTCATACACAAAGAAAGGTTTAGGTATTATGATGACATTCCAATTCGGAAACTGCACCTTGAGAAGGTTTACACTTATTTGATGTGTCTTAAAAAACCAGATGTTGAATCAGCCATTGCTAAGCTGAGGCAGCTTATGGAGGATGAACAAGACACAAGGGTTGTTGCCTTTTTTTGCAAATTTGCAAAGGATATAATTGACAGATTCAAAGGCAAAATACATCTTTATGAAACTGGATGGTTTGAGCACATTAAAGACTCATTTGTAAAGATGTTGCCCAACTTTTGGGGTAGATTGCTCTCAAGGTGGCACGGCGTTAATCTTTTCGAGTTTCTATTTAAGCTGGAATGCTTATGCATAGAGGTTGAATTGATTGACGTTGATTCTAGTTTCTCAGTCAAGGAATCCCTCAAGGATAGAGTTTTGGGCAGATCTGAGGGATGCAGTGCCGAGCTACAAAATTTGTATATGCAGGAGTTTGGTCCTTCAGCCATGCTAGAAGTAGGCTGGCATGGCAATCTTAAAAAGGTCATGAAGGATGTTGAAGAGAAAAACTTGATTAAAAATGGCAGATTATCCATCCGTGAAAAAGCATATTCTTCAAAGTTACTAAGCAGGTTCCATTTGAGAGTTGGAATTCTTAAGTATATTGGTGTTCAAAATAGAATAGGGGAAAGGAATGAGTTAAAACTTAGAACACCAATGATCAAGATGCACAATTCTGATGGCATTTACTCCTATCCAGAACCTGAATTCATCAGAGATGAGGGGTTCACCTCATTTGAATGTGAGTACAGCAACCTTAGGTGGCTGAATGTTCATAGAAACCTTTGGTTCAACAATTTGGAATTAGGGGTTGACGTTTGTGATGTTCATGAGCCACAAGTCACCAATTCTGAGGACTTGTCTTCCGCTGAAAACCTTTTAGAGGTCATTGAAGTGGATGATGAGTTCTTTCCCTCAAACATGAAAGAGACTGTTGAGGTGGCTAAAGAAACTGGTACTCTCAGAGAGAAAAGTGACCCTATGAGGCAAAGTTCATCTGAAGTTTTGGATGATGAGCTGATTCGTGAACTTGATGGATCTGTGACCATAATTCACAATTTTACAGAGGAGTTGTTGGTTAAAAAAGATGTGCTTGGAGATGGTAACTGCTTTTACAGAGCACTGAGGCTCAAATTAACTGGGAGTCAGGAGGGCCATGAGGAGGTCAGATTGAAATTTGCAAATCATGCTAGTCATATTGGCTTTAATTTGTCTACAAACATGAGAAATATGATCATCACGCCAGGTGTTTTTACTGAGACGTGGATGGTGAATCTTTTTGTGAATGTTATGAATATAGACATCATGATTCATGAGGACATGAGTGGCAATTACTACTCAATCAAACCCAACCTGATTCATTATGATGAAACCCCAAAAATCCAAATAAGATTGCTTTTTGAAAATTCTCACTTTGCATTGCTGGAGTCAGCAGACAAGTATGAAGAGAAAATGGATTTGGACTCCAAATCTTTTGAGGCAAAGTATCTCATTAAAAGTGGGTTTGGAGATTTTGAAGCTATTAGAACTTTAGTTGAAGATCTTGTCAGCAGGGTGAAAGAATACAAATTCAATGAGTTTAAAGGAAGGAGGGCTTATTTCTTCTCTGAAAATGAAAGCATTGATTATGCACATGGGAAGACCAAATATTTGAGAAATCAATTTGACTCTGTCAACGAATTACTTCCCATTGAATTGAAAGGGAAATTCAATGCCTTTCTGCTCCAAATTTTTGAAGAGGATGGAGAGATAGGGTTCCATAGAGACAATGAAGGTGTGTATGACAATGACAACATTCTTTCAATCAATCTCAATGGTTGTGCATCCTTCATGATTGAAGACTGTGGCAGCAAGGAAATCTATGAAATCAAAATGACTGATGGTTTATTCATTTCAATGCTTCCTGGATTTCAAAAGAAGTTCCGTCACGGTGTCACCAATTGTTCGTCAAAAAGAGTTAATATCACTTTCCGAAACCATGTTAGATCGGTCAATGGCAGGCCTGTAATTGAAATTGACCTTTCTGAAATAAGAAATGGTTGCATGCTTAGAGCAATAGCTGATGCTGAAAAGCGCAGCTTAGGGCAGGTTGTGCATGCATTATTTAAAAAAGATCGTGACTTTTGGAAGATGTGGATTTCAGAAGCAAAGGGTGGCACAATTGAAGATATGATGAAAGCAGCCATTGACCTCAAATTTTCATTCGAACTTTTGAGTGATGGCAAGTGTGAAATCTTTGGAACTTCAGGTCCAAAACTCAATTTCGAGTTAAAGGGGGGACACTTTTCAGTCATGGATTCAAGACCTTCATGTGTAGAGAGGACCTTCTTAAATTCAAACACCTCAAGGAGAGGGTCATCTAAACATTTGGGTGAGATGGACCTTGAATATTTGAATAATACCAACTTTGAAGCAAAGGGAATTTTTGCGAACCAACTCCAGATATCCTTTCTGGAACGTACTACTGGTCTAATTTTGTCAGAGGTTTACGGTTCAGCTGGGAAAAATTTGGAATTGGTTAAGATCAACAGGGAGAACATGATTGAAAAGGAAATTAATTTTATGTGTGGATTTGCAGGATCTGGGAAGAGTTATTCCTTACAACAGAGGGTTAAACAGAGCCTGGATGCTGAATTCCTCATAATATGCCCAAGAAATGAGCTCAAGAAGGATTGGTTGAGTAAGTTGAATTGCAATGAGAAAAAAGTGAGAACATTTGAAGTTGCATTAACTCTCAATTTATCCAAATTGGACTTGATAATTATTGATGAGCTTGGCCTTTTCCCAAATGGTTATCTAGATTTAATTTGCTATATGCTTGCGGATCAAGGTAATCATGACTGTAAGATCATGTGTCTGTTCGACCCTTTGCAATCTAGATACCATAGCGACCTAGACAACCATCTTTTGGATTTTGACCATGAATGCGACAGATTGATAGATGGTCTTGATTTTAACTATTTGATGGAGAGTAGGAGAATGTCCAAATCATTCTTTGGAGCCTTCTTTAGAGATGTAACTTTATACAACGAGGGTGATCAAAACTTCAAATTGGAGGTGTATGATTCAGTCATCGTTGCCATAAATGAAGGAAAGAAAAAGGGCATTGAGGTCGATCTGATACTAGTTGCATCCAGAGATGAGAAAAGAGCATTATCTTGTTCTGTCAATACATTGACATTTGGAGAAGCACAAGGTTTGACGGTGAACCATGCATGCATTGTGCTTTCAGAATATGCAGAGAAACAAGATGATTTCAGATGGATGGTCGCATTAACTAGGTCCAGAATAAAGGTCAGCTTTGCGGTCATGTACAGAGGTGGATTAGTGAGTTTTGTTCAAAATAACTCAGCAAGATTGATTGGCCTGTTTATGGCTCAATCACCACTAACCATCAATCGAATGCAATTAATGCTCAAAGGAAACATTAATCCATGCATCAGAAGTCTAGGATGCTCTGATGAGATGGACAGGGAAGAAAGGCTTGAGGGTGATCCCTTTCTAAAACCGCATATATACCTTGGCCAGAGGATCAATGCTGAAGAGTTTGAGGTTTTTGAGCCAGAAGTTGTTGAGCCAATTTGTAGAACGCATATTGAACTACCTCCTGAAAACTTTGATCAAAGCATCAACTTTGATTTAATTAGAGCGAGGGAGTTTCGGGAAATGCGGATTGGAGGTGAGACAACTAAACAATTTTGCGAAGACTTTGAGCATTCTAGAGCAAATGGAAAAAGAATGACTTCAGGTCCAATGAGGTATGAAGCAATATACCCTAGGCACAAAGCCGATGATGATGTGACCTTTTGGATGGCAGTCAAGAAAAGATTGAGATTTTCCGAGGAGCATGTTGAGAGGGCCAAATTGAAAGATGCATTTGGGGTCGGAGGCTTGTTATACGAAAATTTCAAAAGTAAAATGGGACTCAAATTCAACTGGGATCAACAACTTTTGGATGAATGTGTTAACGACTTTGAAGTCAAAAAACTGAGTAAAAGTAAAGCCACTTTGCAAGCTCACAGCTCCAGGTCTGATTCTGACTGGAAGATTGACAACATATTTCTCTTCATGAAATCACAATTGTGCACAAAGTATGAAAAGCAATATGTAGATGCGAAGGCTGGCCAAACGTTGGCGTGCTTTGCTCACATGGTGTTGGTCAAATTTGCGCCATATTGTAGGTATATGGAGAAGCAGTTAAGAAATCAATTTCCAGAGAACATTTATATACATTCAGGGAAGAACTTCAATGACCTTAATGACTGGGTTAAAAGGCATATGTCAGACAATGAATGCATTGAATCGGATTATGAAGCATTTGATGCATGTCAAGATGAGTATATATTGGCATTTGAGGTACTTCTCATGGAAGATATGGGTATGCCAAATTGGTTCATTAATGACTACATTGATCTTAAATGTACTTTGGGTTGCAAATTGGGCCACTTTGCGATCATGAGATTTACTGGTGAGTTTAGCACCTTTTTGTTCAACACCTTGGCAAACATGGCATTTACTTTTGCCAAATATGATTGTGATGGGAAAACACCAATTGCTTTTGCTGGAGATGATATGTGCATGCTTTCAAAATGTGATGAAATCTCAAAATTTGAGAGCGTCTTTGAGAAGATATCACTAAAAGCAAAGGTGGTAATCTCAAAAAATCCAATGTTTTGTGGGTGGAATCTGTGTAAGTATGGAATTTTCAAAGAACCTGCATTGGTGTACAACAGGTTCATGGTTGCAGAGGAAAGGGGAAATGTCAATGAATGCTTAGAAAATTATGCAATTGAAGTTTCCTATGCTTACATGTTAGGTGAGAAGCTCTATGAATTTTTGAAAGAAGAGGATAGGGTCAATTATCATCAAATTGTGGTCAGATACATTGTTAAACACATCGACAAACTCAAAACGAAGGTAAAGGTTCTGTTCTCAGGGAAAGATGTCTAAGGCTGTCAAAGTTAAAAGCCTTGTACAGAGATTGGAAGTTGACAGGTCGTTATTGAACTCAAATGAGATATCCGCTCTGTATGGGGGTGCATTTGCGCCATTGGTCTTTAAAGATGAGGTCAAGATGGTCATCCCTGGTAATCTATTGGGTGGTCCGATTTGTTTGCAAACAAACATTCTAACCAAGTCAAGGCTTGAAAAAATAAGAAGTCAGAAATTCAAAGGGAAGAGCTGTGCTTATTTGCATTTAGGCGTTGTGACAGTCGCTATTCAATCCTTATTAGTTTCCGGCAATGAGAAAATTAAGGGTAGATGCTCGCTTGTTGATTTATCCAGAGGGTCAGAGGAGACTGGCTTAATAGACAGATTCAAGTTTTGCTTCACAAAATCTGAACCTTTTGCTGCAAAAATGTTGACCATCAATGCTGCAATCGATATCGACTGTGATGTATCTGCAGGGAGCTTGCAAGCTCTGCTCGAAGTTGAGGGAATAGATATTCGAACTGAAAGGAGTGTGCTTGCAGTTACTACAGGTATAACGTGTGTGCCAACCAATTCCATGGTGATGCTCCCTGGTTTGAAGAGAGAGACTCCCAAATTCGCAATTGCAAATGTTTATAATGTTTCTGATGAGGACCCGGAAGAACATGCTGCTTTCAATTCATTATTCAGTGCAGCAAATCCAAAGCTGATCGATTTGGGCCAAGAATGCATTTTGGAGGAAGGAAAAAGATTTGGCTTTTGGGGTCCAATGGTTAAGCCAGTTCATAGAAGGAAATTAACAACTCGCGGCTTGATCAGAACTCATATGGATCAAATTATGTCTGGTCCTGGAAAAGATTTGAAAGAAGAAGGAAATTCAAAGTTGTCCAGATCATACTTATCAAGAAATGTCTGCGAAATTGGCAAAGAAGAGGCTCATCCACGACGAAGTGTCGGAATGGCTATGGAGGAGCTTTGTGGACCCAGAAAATTCGATGGGAGTTTGGTTGGTGAATGCAGCAAATCAGCGGGTTCAGTTAAATCTGAATCAGCAGGAGCAAAAATCAAGGGTGCAAGTGAGTCGCCTAAGATCTATTTTTGGGAACATAGCAGATCACTCGGCAGGTCCAGCAACCGTGTACCCGTCAATCAATGTAAGCTTTCAAACTCTGAACATTCAGGGAATAGAAGGAGTTGCACAGATGGATGGGAATTTCAATCTGAGAACACTTGTCGAAAATCTGAAGATGTTTCTGATAACGAGTCAGGATCAGCAGCTGAGCACTGCAACATTGAGGGAGGTTTGCCGGAGCTTTGCAAATTACGCCCTTGAGTATTACTTGGAAGACCCCGACAGAATGTCAAATCTCGCTGACAAAATGCCTCAATTGGCACTGCAGGCTAGAGAAGTTATGTTTGACTTTTCTGATGGCATTAGTCAGCAATTCATAAGGGGTTTTCCAATGAGGGCAAAGGTAATCCAGGAGTTGAATAGCAGGTTGTTACAGTCATCTGGGACAAAAGCTGTGTTTGAAGCAAGGGGCACAGTTGAGTCTTCAGTTAATTTGATTGTTTAAGGAAACAATACAGGCTTTGTCATTTGAGTGCTGTGAGTTCAAATGATACCTTATAAGTCGCTTGCGCACAGGTAAGTTTCTATACCTCTTTGTATTTAAAGAGGAGTCACTTCCTTTGGTAGAATTGCTTTAATTAGCAGTGGGCCGCCAAACAGTGCATTAAGTACTCCCCAACTAAGTAAAATATTATGATATAACTATTAATAGGGATGCCTTTTCAATATTTAGG",
                                }
                            ],
                            "source_name": "16SP042_B",
                            "source_type": "internal",
                        },
                        {
                            "default": False,
                            "id": "eb4c1673",
                            "sequences": [
                                {
                                    "_id": "yymkrcpy",
                                    "accession": "16SP042_BFV_CAM1_A",
                                    "definition": "Betaflexivirus, complete genome",
                                    "host": "Camelia",
                                    "isolate_id": "eb4c1673",
                                    "otu_id": "1wfc5x6e",
                                    "reference": {"id": "pat6xdn3"},
                                    "remote": {"id": "u7ni2w4n"},
                                    "segment": "",
                                    "sequence": "ATCACAAAATACAACAACATAATTCAGAAACTAACTTAACCTGTCGTGAGTACCCATCACATCAAAGCAATGGCTTCAGTGATGATAAGAACTCCTATGGAAAAGTTTTTTTCAGCAAATGACAAGAATGATCAAAAGATCATTCTCACGTCTGGGGTGAATTATGTTAAAAGATTTTGTGATGAGCAGGGTTTACATTTTGCATACTCGGTGGATGAGAGGAAAAAGGCTGCACTGACCAATCTTGGTATTAATTTGCATCCAGTCCCCTTTCTACCTCATTCGCACCCTTTTTGCAAGATCCTTGAAAATAACCAGCTCATTAACATTTTACCAGGGATACTAGGTAGTGGTAGGTGGACGTTTATGTCAATTAAAGAAGGAAAAGTAGAAAGTATAATTAAAAAAAGCGGAGGTGTAAATAATAATATTAGTTTAATCAATAGATGTATATGCGCAAAGGATTTTTCAAGATATGACTTTACTCCCGAAGAGGTTGATTTGAGGACAAATGTCCTCTCTGAAGATCATTTATTTCCTGAAAATCTGATGAGGAGCCTCAAAGGAAAGAAAATATTCATACACGATGAGGTTCATCACTGGGATTCGAAAATTATGATCAACTTTTTAGAGAAAGTTAAACCGAAAATAATCTTTTGCTCAGTTGTTTATCCGCCAGAATTATTAGCTGGCATATTAGAACCTCAGAACAAGAGTTTTTATGACTTTAAGGTGGATGGTAATAAGTTATTCTTTTTCCCTGATGGTAATAGGAGTGAGTTTTATGAACAGCCAAAGGATCTCAGTTGGCTAATGCTCGCAAAAAGATTCAAACTTGATGATTGCAATTACACCGTCAAGTTGATCAGCAGCACCTATTGCCATCATCTGTTTCAAATATCCAGAGGGGAAAAAATAACGGAGTCAAAGAGATTCTTCTCAGACTTTGACACCATTGACCTCAAAGTTATACACAATGAGAGGTTTAGATACTACGATCACATTCCAATAAGAAGAGCACACCTTGAGAAAGTGTACACATATTTGATGTGCTTAAAGAAGCCTGATGTTGAATCGGCTATTGCAAAATTGCGCCAACTTATGGAGGATGAGCAGGACACCAGAGTTGTGGCCTTTTTCTGCAAATTTGCAAGGGATGTGATTGAGAAATTCAAGGGAAAGATACATCTGTATGAAACTGGATGGCTAAGTCAAATTGGAGACAATTTCATACAGATGCTTCCAAATTTTTGGGGGAGAATATTGTCAAGGTGGCATGGGCTTAATCTCTTTGATTTCCTATTTAAGCTTGACAATTTGAGAATTGAAGTTGAGCTGATTGACGTTGATGCAGAGTACTCATCAAGGAATGAGGTACTCAAACGTCTGTTCAAAAAAGACCAATTTGGTGAGAACCTCGATGGGCTAAACACTGAATACCTTAGGACCATTGGTCTTGAGGCTGAAATGGATAATGCATGGGGAAAAGGTTTCTCATCAAAGAAAGATAGCTCAATTCGTGCATGTGTCTCAAAATTTGGCATTGAGAGGGTCTCAAGTAAGGCTTTTCAGAGCAAGCTCGTCTCAAGATTCCATCTCAAAGTTGGAATTCTTGCCCTGCTACATGAGAGAAACAGGAATGAGAAGTTCTTACAAAAAGGGATGTCTGTTGATTTCAATTCCAAATCCCAAGAGAGAAGGGTTTTAATGATCAAGTTCAAGTCGGAGGATAGGGTTGACTCATATCCCGAACCCTTTTTCTTGAATTTGAGAAATTTTTCATCAAAAGAGTGTCCATTCGAGGATCTTAGATGGATGAAAGTGCATAATAAAATTTGGGGTGAAACTTTTTGCACTCCATTGATTCCAAATGAATTTCCATCAGAAAAAGATGAAGATATTGACGTCTGCAGCATTGTGGATGAGTCAGAATGTGATGACAGCAATCACGATGGGCAGTGTCTTGAAAACTCAGGGTCTTTTGGAATTAACAAGACCTCAGATGACCCAAACATTAATGTGGAAATAACTTCAATTGAGACCAGGCAGGGTGATGAAATCGATTGCCGGCTTAATTCAACTGAACCTAGTGAGGTGGAAACATCTGAATTCATGTCTGAGCTAGAGAATTCTGTGTATCTCAGCTTTCATGATGATGAAGTTTTCAATTATTCAAAGGTGCCAATAATAGGGGATGGCAATTGTTTCTTCAGAGCCATTTGTATGGCAGTGCATGGGAATGATCATGGTCACCTTGAAACTAGGAGGAAATTCTCTGAACATGCAAAGAGGATTGGATTCAAATTTAACGCTGAGATTGAGAAGGCAATTGTCGAGAGTGGAACTTTCTCTGACACATGGATGGTCAATCTCTTTGCAAATGTTATGAATGTTAGACTCTTCATTCATGAAACAGAGGATGGTCCTTACTATGAGATTCACCCAACAATCATCAAGTATGATGATCCCCCATTATTTTCAATTAGACTATTATTTGGGGATGCACACTTCACACTTTTGAGGGAAGTGGAAGGTGAATCATGTGAAAAACTTAAAGAAGAGTACATGATTGATTGGGGAGAGAACGAATTCAAGGTCCTCAATGAGTTTGTTGACTCAATAATGGACGAGCAGCATAGGTTCAAGGCTAACAATCTCAGGTCAAGAAAGGCTTTCTTCTTTTCTGAGCACGAGGGTATTGACTACGGGCATGATAAAGTTAAGTACCATCGGAATCAGATTGATTCAATTGACAGTCTTCTGCCCAGAGGAATGAATTGTGGTTTCAATTCAATGCTTGTGCAGGTGTACACTGATGGTGCTGAGCTACCAATGCATAAAGATGATGAGAAGGTCTACGACAATGACAACATTCTCTCTATCAATCTAAGGGGAAGCTGCAACTTCATAATTAATGAGTCAAAAAGAGGAGCTGACAATGCCAGATCAATTGAAATGAAGCCAGGGGCTTACATAGTGATGTTGAGTGGCTTCCAGAAAAAGTTCAAACATGGGGTTTCTGAATGTAGAAATGGGCGTGTGAATGTCACATTCAGAAGGCATGTGAGAAGTATGAGGGGTCATGACTTAATTGATTTTGATCTTTCCAAAATTAAAAATGGGTGTTTAATTAGGTCAATTGCAAATGCTGAATGCAGAGGACTGAATCAAGTTGTCCAGGCCTTGATTAGAAAGGACAGAACCTTCTGGAGTGATTGGATTCACTCAGGGCAGGGGGGAACAATAGATGATCTGGTTAAGGCCGCCACTGAGCTTCACTTCTCATTTGACTTAATCACTGAAAAAGGGTGTGAATCCTTCAAAAATTCTGGGCCAAAGTTCACATTCCAACTCAAAGATGGACATTTCGAAAGCATCAATGAAAGACCATCATGTGTGGAAATGACCTTCCTGAACATGAAATCAAAAGGAAGCAGCAAAGATAGGAGGAGCATTGGAAAGTTGAGGTTTGAACACATGAATGAAACCACTTTTGAGATCGTTGGAGAGTTTGCTGCAATCCTCAAAAGATCATTCATGGAGAGAACAACAGGTCTAATCCTCTCTGAATGTTATGGCTCAGCATGCAAGAACCTTGAAGACTTACAAATAGATCCAAACAGTCAATTTGAAAAAGAAATTGACTTCATATGTGGTTTTGCAGGATCCGGGAAAAGCTTTTCAATTCAATGCAAACTTGCATCGGAACCTAAAGCTGATTTCTTGGTTATATGTCCCAGGAATGAACTTAAAAAAGATTGGCTTGAAAAGGTCAATTGTAATGAGAAGAAAGTGAGGACATTTGAAGTGGCTCTGACACTAAATCTTTCAAAAATTGAACTGATCGTGATAGACGAGCTGGGCTTGTTTCCTAATGGATACCTCGATCTGCTGTGTCTAATGTTGATCAATCAAGGGAATTACTCCTGTCAGGTGATATGTTTGTTCGACCCCTTACAGGCAAGGTACCATAGCGATCTTGATGACTCCCTTCTGGATTTTCAACATGACTGTGATAGGTTGGTCACTGACTGTGAGTATCTGTACCTCGCAGAAAGCAGAAGATTGTCAAGCAAATTCTTTGGGGCCTTTTTCCCAGACATTCACCTACATAACGAGGGGAGGGAGGATTTTGGCATGACAATATATGACAGTGTTGTCGTGGCAGTGAATGAAATGAAGAAGAAGGAAACCCCGCTTGACTTGGTGCTGGTCGCTTCAAGGGATGAAAAAAAAGCATTGGCAACATCCGTTCGAACCTTGACATTTGGAGAAGCACAGGGGCTTACAGTGAACTACGCCTGCATTGTGCTCTCTGAATATTCAGAAAAGCAAGATGACTTACGATGGATGGTGGCGCTAACAAGGGCAAGGATCAAAATAATTTTTGTGTGCATGTATAGAGGTGGTTCAAGCTGCTTTCTACAAAACAATTCATCTAGGTTAATAGGTCTGTTCATGAGACAATCACCCATGACAATAAACAGGATGAAGCTGATGGTCAAGGGCGATTTGATACCTTTCAGAAAGACGATAGGTTGTTCGGACGAGGTGGATAGAGAAGAAAGGCTAGAAGGGGACCCCTTTCTCAAACCACTTATTTTCCTTGGAAGCAGGATCAACTCAGAGCAAGTTGAAGTGCTGGAGCCAGAAGTTGTTGAACCAATTGAAATGACGCATATTCCACTACCTCCAAGTCACTTTGATCAAAGCATCAATTTTGACAGAATCAGAGCTCGTGAGCACAGAGAATTCAAAATGAATTCAATGTGTACAAAACAGTTCTGTGAAGATTTTGAGCATTCAAAGGCCTCAGGAAAACAGATGACGTCAGGCCCTATGCGCTTCGAGGCAATTTACCCAAGACATAAAGCAGATGACGATCTCACCTTCTGGATGGCTGTTAAGAAGAGACTGCGTTTTTCTGAAGAGTTTGTTGAAAGGGCAAAACTCAAAGAGGCAATGGGGGTTGGAGGTCTGTTGTATTCCAATCTTAAAGAGACATTAAATTTGAAATTCAATTGGGATCAGAGCCTCCTTGACGAATGTGTCAATGACTTTGAAGAGAAGAAGCTTAGCAAAAGCAAGGCAACTCTACAAGCTCATAGCTCAAGATCTGACTCAGACTGGAAATTGGACCACATCTTTCTATTTATGAAATCTCAATTGTGTACAAAATATGAGAAGCAGTACGTAGACGCAAAAGCTGGACAGACATTGGCATGTTTTGCGCACTGCATTCTGGTTAAATTTGCACCCTACTGCAGATATATGGAAAAGCAATTGAGGAGTCAATTTCCGGATAACATATACATTCACTCAGGAAAGAACTTCAATGATCTTAATCAGTGGGTTAAAGAGAACATGAAGGGGAAGGAATGTATAGAGTCAGACTATGAAGCGTTCGATGCGAGTCAAGATGAATACATACTGGCCTTTGAGATATGCCTCATGGAGGATATGGGGATGCCAACTTGGTTCATCAATGATTATATAGACCTTAAATGCACACTCGGGTGCAAATTGGGCCATTTTGCCATTATGAGGTTCACTGGGGAGTTTAGCACCTTTCTATTCAACACACTGGCAAACATGGCCTTCACGTATGCCAGATATGATTGTGATGCATCAACTCCAATTGCCTTTGCTGGGGATGACATGTGCATGCTTGATAACTGTGCTGAAACTGACAAATTCGAAGGAATTTTTGAGAAAATATCACTGAAGGCGAAGGTTTTGAGGTCATGTACACCCATGTTTTGTGGGTGGAATTTATGTAAGCATGGGATCTTTAAGGAACCAGCTCTAGTTTACAACAGATTCATGGTGGCTCAGGAAAGAGGTAACGTGGAAGAATGCCTTGAGAACTACGCAATAGAGGTATCCTATGCTTACATGTTAGGTGAGAAGCTCTATGACTTTTTGAAAGAAGAAGAGAGGATTAACTACCATCAAAGTGTTGTGAGGTTCATAATCAAAAGAGCAGATAGACTTAAAACAAAGGTGCGACTTCTGTATACCAGTGATGGCAAAGGCAATTAGGGTCAAAAGTCTCACCAATCGATTGGAGGTTGACAAGTCTTTGCTCAACTCCAATGAGGTCTCAGCTTTGTACGGCGGCGCTTTCGCACCACTAGTATTCAAAGATGAAGTCAAAATGGTGATTCCTGGCAATCTATTAGGTGGGCCAATTCGTTTGCAAGCAAATATACTCACCAAATCGAGACTTGAGAAAATTCGCAGTCAGAAGTTCAAAGGGAATTCCTGTGCCTACCTGCATCTTGGGGTGGTTACTATTGTCATACAATCACTATTGGTGTCCGGAAATGAAAATGTCAAAGGCAGATGCTCACTGGTTGACCTCTCAAGAGGCTCCGAGATAACTGGGCTTATTGACAAATTCAAGTTTAGTTTTACCAAGAGTGAACCATTCGCAGCAAAGATGTTAACAATAAATGCAGCAATTGATATTGATTGCGAGGTATCTGCTGGGAGTATTCAAGCCCTTCTTGAGGTCGAGGGCATTGATGTAAGATCTGAAAGAAGTGTCTTAGCCATCACCACCGGCATAACCTGTATTCCAACCAACTCCATGGTGATGCTACCAGGCTTAAAGAGGGAAACCCCAAAATTTGCAATCGCAAATGTTTACAATGTTCCTGATGAAGACCCGATTGAATGCGAGGCATTCAATAGGCTGTTCGGAGCTGCCAATCCAAAATTGATCGACCTAGGTAGTGAAACTGTATTGGAAGAAGGGAAAAGGTTTGGTCTATGGGGCCCTGTTGTGAAACCAGTGCACAGGAGGAAGCTTGTAACAAAAGGCATCATTAAGGATCATATGAGCCAGATTATGTCAGGCCCTTCCAAAGTTTTGAAAATAGAAGAAGGCTTGAAGAGATCAAACTCATTACGTGTTGAAGATGTCTGCAAAACTAGCGAAGAAGAGGCTGATACACGACGAAGTTTCGGAATGGATTTTCAGGAGCTTCGTGGATCCGGAGAATTCAATGGGGGTTTGGTTGGTGAATGCTGGGAACCAAAGAGTTCAGCTGAATTTAAACCAACAGGAGCAAAAATCAAGAGTTCAAAACAGTCGACTCCGGACGATTTTTGGCAACATAGCAGATCACTCAGCAGGGCCAGCAACAGTGTACCCGTCAATCAGTGTAAGTTATCAAGTGATGAACATTCAGGGAATCGAGGGTGTTGCACAGATGGATGGAAATTTCAATCTGAGAACATTGGTGGAAAATCTGAAGACCTTCCTTCTGACCAGCCAGGATCCTCAGCTCAACACTGCAACATTAAGGGAGGTTTGCCGGAGCTTTGCAAACTACGCCCTTGAGTACTACATGGAAGACCCCGATAGAATGTCGAATCTAGCTGACAAAATGCCACAACTAGCTCTGCAGGCGAGGGAGGTTATGTTTGACTTTTCTGATGGAATAAGTCAGCAATATTTGAGGGGTTTTCCAATGAGGGCTAAGGTGATACAGGAATTGAATAGCAGGCTTCTGCAGTCCACTGGCACCAAGGCTGTGTTTGAAGCAAAGGGGACTATTGAGTCCTCAGTTAATTTGATAGTTTAGAAACTATCTAGGCTTTGTATGTTGAGTGCTAAAAGTTCAACATATACCTCATAAGTCAGATTTATCTGCTCAGGTAAGTTTCAACCTCTTTGTATTTAAAGAGTGGCCGAATGAGTGCATGCTCATGTTCGGAGACCAGCTTCCCAGCTTTATCAAATATTATGACTTAAGTATTAATAGGGATGTCTTTTATGAATATTTATG",
                                }
                            ],
                            "source_name": "16SP042_A",
                            "source_type": "internal",
                        },
                    ],
                    "issues": None,
                    "last_indexed_version": 0,
                    "lower_name": "betaflexivirus from camelia #1",
                    "name": "Betaflexivirus from Camelia #1",
                    "reference": {"id": "pat6xdn3"},
                    "remote": {"id": "5ce8b98a"},
                    "schema": [],
                    "user": {"id": "igboyes"},
                    "verified": True,
                    "version": 0,
                },
                "id": "1wfc5x6e.removed",
                "index": {"id": "s7frhn8n", "version": 1},
                "method_name": "remove",
                "otu": {
                    "id": "1wfc5x6e",
                    "name": "Betaflexivirus from Camelia #1",
                    "version": "removed",
                },
                "reference": {"id": "pat6xdn3"},
                "user": {"administrator": True, "handle": "igboyes", "id": "igboyes"},
            }
        }
