# Contributing to virtio-win

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features

## We Develop with Github
We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [Github Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://guides.github.com/introduction/flow/index.html)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've added new driver, changed usage, or made some nontrivial changes - update the documentation.
4. Ensure the test suite passes.
5. Don't forget to add "Signed-off-by: Your Name <your@email_domain.com>" line in the commit message.
6. If you are a Red Hat contributor, you must include [BZ](https://bugzilla.redhat.com) number in the commit message
7. Prefix commit messages with the affected component. For example: "NetKVM: BZ#1234567: implementing dynamic NDIS version support".
8. Issue that pull request!


## Any contributions you make will be under the BSD 3-Clause License
In short, when you submit code changes, your submissions are understood to be under the same [BSD 3-Clause License](https://github.com/virtio-win/kvm-guest-drivers-windows/blob/master/LICENSE) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using Github's [issues](https://github.com/virtio-win/kvm-guest-drivers-windows/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/virtio-win/kvm-guest-drivers-windows/issues/new); it's that easy!

## Write bug reports with detail, background, and sample code
**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can.
- Driver version or commit hash that was used to build the driver
- QEMU command line
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People *love* thorough bug reports.

## Use a Consistent Coding Style

* We use clang-format tool to check code style.
* In project we have two different code style:
   - Style config file for Windows driver /.clang-format
   - Style config file for VirtIO library /VirtIO/.clang-format
* To run code style check locally on Linux or Windows (with MSYS or cygwin) use `Tools/clang-format-helper.sh` helper
   - on Linux helper uses `clang-format` from PATH
   - on Windows helper uses `clang-format` from EWDK 24H2
   - CLI:
      - For all Windows drivers
      ```bash
      bash Tools/clang-format-helper.sh '.' '' './VirtIO'
      ```
      - For VirtIO library
      ```bash
      bash Tools/clang-format-helper.sh 'VirtIO' '' ''
      ```
* Tools/clang-format-helper.sh uses positional arguments
   1. Directory where needs to check format
   1. Path to .clang-format file (default: `${1}/.clang-format`)
   1. Exclude regexp (default: `^$`)
   1. Include regexp (default: `^.*\.((((c|C)(c|pp|xx|\+\+)?$)|((h|H)h?(pp|xx|\+\+)?$)))$`)

   - To use default just put '' as argument

* **NOTE**

   On Windows clang-format reports problem with several files but changes that needs to be done are not detected by git.

   We are investigating this issue.

## HCK\HLK tests
* The contributions should pass Microsoft certification tests. We are running CI to check that the changes in the pull request can pass. If you submit a lot of PRs, you can setup AutoHCK on your premises to test your code changes: [auto-hck setup](https://github.com/HCK-CI/HCK-CI-DOCS/blob/master/installing-hck-ci-from-scratch.txt)

## License
By contributing, you agree that your contributions will be licensed under BSD 3-Clause License.
