//
// This is a generated file, do not edit!
// Generated by R.swift, see https://github.com/mac-cain13/R.swift
//

import Foundation
import Rswift
import UIKit

/// This `R` struct is generated and contains references to static resources.
struct R: Rswift.Validatable {
  fileprivate static let applicationLocale = hostingBundle.preferredLocalizations.first.flatMap { Locale(identifier: $0) } ?? Locale.current
  fileprivate static let hostingBundle = Bundle(for: R.Class.self)

  /// Find first language and bundle for which the table exists
  fileprivate static func localeBundle(tableName: String, preferredLanguages: [String]) -> (Foundation.Locale, Foundation.Bundle)? {
    // Filter preferredLanguages to localizations, use first locale
    var languages = preferredLanguages
      .map { Locale(identifier: $0) }
      .prefix(1)
      .flatMap { locale -> [String] in
        if hostingBundle.localizations.contains(locale.identifier) {
          if let language = locale.languageCode, hostingBundle.localizations.contains(language) {
            return [locale.identifier, language]
          } else {
            return [locale.identifier]
          }
        } else if let language = locale.languageCode, hostingBundle.localizations.contains(language) {
          return [language]
        } else {
          return []
        }
      }

    // If there's no languages, use development language as backstop
    if languages.isEmpty {
      if let developmentLocalization = hostingBundle.developmentLocalization {
        languages = [developmentLocalization]
      }
    } else {
      // Insert Base as second item (between locale identifier and languageCode)
      languages.insert("Base", at: 1)

      // Add development language as backstop
      if let developmentLocalization = hostingBundle.developmentLocalization {
        languages.append(developmentLocalization)
      }
    }

    // Find first language for which table exists
    // Note: key might not exist in chosen language (in that case, key will be shown)
    for language in languages {
      if let lproj = hostingBundle.url(forResource: language, withExtension: "lproj"),
         let lbundle = Bundle(url: lproj)
      {
        let strings = lbundle.url(forResource: tableName, withExtension: "strings")
        let stringsdict = lbundle.url(forResource: tableName, withExtension: "stringsdict")

        if strings != nil || stringsdict != nil {
          return (Locale(identifier: language), lbundle)
        }
      }
    }

    // If table is available in main bundle, don't look for localized resources
    let strings = hostingBundle.url(forResource: tableName, withExtension: "strings", subdirectory: nil, localization: nil)
    let stringsdict = hostingBundle.url(forResource: tableName, withExtension: "stringsdict", subdirectory: nil, localization: nil)

    if strings != nil || stringsdict != nil {
      return (applicationLocale, hostingBundle)
    }

    // If table is not found for requested languages, key will be shown
    return nil
  }

  /// Load string from Info.plist file
  fileprivate static func infoPlistString(path: [String], key: String) -> String? {
    var dict = hostingBundle.infoDictionary
    for step in path {
      guard let obj = dict?[step] as? [String: Any] else { return nil }
      dict = obj
    }
    return dict?[key] as? String
  }

  static func validate() throws {
    try intern.validate()
  }

  /// This `R.color` struct is generated, and contains static references to 2 colors.
  struct color {
    /// Color `AccentColor`.
    static let accentColor = Rswift.ColorResource(bundle: R.hostingBundle, name: "AccentColor")
    /// Color `LaunchScreenBackgroundColor`.
    static let launchScreenBackgroundColor = Rswift.ColorResource(bundle: R.hostingBundle, name: "LaunchScreenBackgroundColor")

    #if os(iOS) || os(tvOS)
    /// `UIColor(named: "AccentColor", bundle: ..., traitCollection: ...)`
    @available(tvOS 11.0, *)
    @available(iOS 11.0, *)
    static func accentColor(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIColor? {
      return UIKit.UIColor(resource: R.color.accentColor, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIColor(named: "LaunchScreenBackgroundColor", bundle: ..., traitCollection: ...)`
    @available(tvOS 11.0, *)
    @available(iOS 11.0, *)
    static func launchScreenBackgroundColor(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIColor? {
      return UIKit.UIColor(resource: R.color.launchScreenBackgroundColor, compatibleWith: traitCollection)
    }
    #endif

    #if os(watchOS)
    /// `UIColor(named: "AccentColor", bundle: ..., traitCollection: ...)`
    @available(watchOSApplicationExtension 4.0, *)
    static func accentColor(_: Void = ()) -> UIKit.UIColor? {
      return UIKit.UIColor(named: R.color.accentColor.name)
    }
    #endif

    #if os(watchOS)
    /// `UIColor(named: "LaunchScreenBackgroundColor", bundle: ..., traitCollection: ...)`
    @available(watchOSApplicationExtension 4.0, *)
    static func launchScreenBackgroundColor(_: Void = ()) -> UIKit.UIColor? {
      return UIKit.UIColor(named: R.color.launchScreenBackgroundColor.name)
    }
    #endif

    fileprivate init() {}
  }

  /// This `R.entitlements` struct is generated, and contains static references to 7 properties.
  struct entitlements {
    static let comAppleDeveloperSiri = true
    static let comAppleSecurityAppSandbox = true
    static let comAppleSecurityNetworkClient = true
    static let comAppleSecurityPersonalInformationAddressbook = true
    static let comAppleSecurityPersonalInformationCalendars = true
    static let comAppleSecurityPersonalInformationLocation = true

    struct comAppleSecurityApplicationGroups {
      static let groupComVinhnxClendar = infoPlistString(path: ["com.apple.security.application-groups"], key: "group.com.vinhnx.Clendar") ?? "group.com.vinhnx.Clendar"

      fileprivate init() {}
    }

    fileprivate init() {}
  }

  /// This `R.file` struct is generated, and contains static references to 13 files.
  struct file {
    /// Resource file `InfoPlist.xcstrings`.
    static let infoPlistXcstrings = Rswift.FileResource(bundle: R.hostingBundle, name: "InfoPlist", pathExtension: "xcstrings")
    /// Resource file `Localizable.xcstrings`.
    static let localizableXcstrings = Rswift.FileResource(bundle: R.hostingBundle, name: "Localizable", pathExtension: "xcstrings")
    /// Resource file `Settings.bundle`.
    static let settingsBundle = Rswift.FileResource(bundle: R.hostingBundle, name: "Settings", pathExtension: "bundle")
    /// Resource file `icon1_120.png`.
    static let icon1_120Png = Rswift.FileResource(bundle: R.hostingBundle, name: "icon1_120", pathExtension: "png")
    /// Resource file `icon1_180.png`.
    static let icon1_180Png = Rswift.FileResource(bundle: R.hostingBundle, name: "icon1_180", pathExtension: "png")
    /// Resource file `icon2_120.png`.
    static let icon2_120Png = Rswift.FileResource(bundle: R.hostingBundle, name: "icon2_120", pathExtension: "png")
    /// Resource file `icon2_180.png`.
    static let icon2_180Png = Rswift.FileResource(bundle: R.hostingBundle, name: "icon2_180", pathExtension: "png")
    /// Resource file `icon3_120.png`.
    static let icon3_120Png = Rswift.FileResource(bundle: R.hostingBundle, name: "icon3_120", pathExtension: "png")
    /// Resource file `icon3_180.png`.
    static let icon3_180Png = Rswift.FileResource(bundle: R.hostingBundle, name: "icon3_180", pathExtension: "png")
    /// Resource file `icon4_120.png`.
    static let icon4_120Png = Rswift.FileResource(bundle: R.hostingBundle, name: "icon4_120", pathExtension: "png")
    /// Resource file `icon4_180.png`.
    static let icon4_180Png = Rswift.FileResource(bundle: R.hostingBundle, name: "icon4_180", pathExtension: "png")
    /// Resource file `original_120.png`.
    static let original_120Png = Rswift.FileResource(bundle: R.hostingBundle, name: "original_120", pathExtension: "png")
    /// Resource file `original_180.png`.
    static let original_180Png = Rswift.FileResource(bundle: R.hostingBundle, name: "original_180", pathExtension: "png")

    /// `bundle.url(forResource: "InfoPlist", withExtension: "xcstrings")`
    static func infoPlistXcstrings(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.infoPlistXcstrings
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "Localizable", withExtension: "xcstrings")`
    static func localizableXcstrings(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.localizableXcstrings
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "Settings", withExtension: "bundle")`
    static func settingsBundle(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.settingsBundle
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "icon1_120", withExtension: "png")`
    static func icon1_120Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.icon1_120Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "icon1_180", withExtension: "png")`
    static func icon1_180Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.icon1_180Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "icon2_120", withExtension: "png")`
    static func icon2_120Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.icon2_120Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "icon2_180", withExtension: "png")`
    static func icon2_180Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.icon2_180Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "icon3_120", withExtension: "png")`
    static func icon3_120Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.icon3_120Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "icon3_180", withExtension: "png")`
    static func icon3_180Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.icon3_180Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "icon4_120", withExtension: "png")`
    static func icon4_120Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.icon4_120Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "icon4_180", withExtension: "png")`
    static func icon4_180Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.icon4_180Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "original_120", withExtension: "png")`
    static func original_120Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.original_120Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    /// `bundle.url(forResource: "original_180", withExtension: "png")`
    static func original_180Png(_: Void = ()) -> Foundation.URL? {
      let fileResource = R.file.original_180Png
      return fileResource.bundle.url(forResource: fileResource)
    }

    fileprivate init() {}
  }

  /// This `R.image` struct is generated, and contains static references to 11 images.
  struct image {
    /// Image `icon1_120`.
    static let icon1_120 = Rswift.ImageResource(bundle: R.hostingBundle, name: "icon1_120")
    /// Image `icon1_180`.
    static let icon1_180 = Rswift.ImageResource(bundle: R.hostingBundle, name: "icon1_180")
    /// Image `icon2_120`.
    static let icon2_120 = Rswift.ImageResource(bundle: R.hostingBundle, name: "icon2_120")
    /// Image `icon2_180`.
    static let icon2_180 = Rswift.ImageResource(bundle: R.hostingBundle, name: "icon2_180")
    /// Image `icon3_120`.
    static let icon3_120 = Rswift.ImageResource(bundle: R.hostingBundle, name: "icon3_120")
    /// Image `icon3_180`.
    static let icon3_180 = Rswift.ImageResource(bundle: R.hostingBundle, name: "icon3_180")
    /// Image `icon4_120`.
    static let icon4_120 = Rswift.ImageResource(bundle: R.hostingBundle, name: "icon4_120")
    /// Image `icon4_180`.
    static let icon4_180 = Rswift.ImageResource(bundle: R.hostingBundle, name: "icon4_180")
    /// Image `original_120`.
    static let original_120 = Rswift.ImageResource(bundle: R.hostingBundle, name: "original_120")
    /// Image `original_180`.
    static let original_180 = Rswift.ImageResource(bundle: R.hostingBundle, name: "original_180")
    /// Image `spotlight_icon`.
    static let spotlight_icon = Rswift.ImageResource(bundle: R.hostingBundle, name: "spotlight_icon")

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "icon1_120", bundle: ..., traitCollection: ...)`
    static func icon1_120(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.icon1_120, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "icon1_180", bundle: ..., traitCollection: ...)`
    static func icon1_180(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.icon1_180, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "icon2_120", bundle: ..., traitCollection: ...)`
    static func icon2_120(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.icon2_120, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "icon2_180", bundle: ..., traitCollection: ...)`
    static func icon2_180(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.icon2_180, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "icon3_120", bundle: ..., traitCollection: ...)`
    static func icon3_120(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.icon3_120, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "icon3_180", bundle: ..., traitCollection: ...)`
    static func icon3_180(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.icon3_180, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "icon4_120", bundle: ..., traitCollection: ...)`
    static func icon4_120(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.icon4_120, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "icon4_180", bundle: ..., traitCollection: ...)`
    static func icon4_180(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.icon4_180, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "original_120", bundle: ..., traitCollection: ...)`
    static func original_120(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.original_120, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "original_180", bundle: ..., traitCollection: ...)`
    static func original_180(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.original_180, compatibleWith: traitCollection)
    }
    #endif

    #if os(iOS) || os(tvOS)
    /// `UIImage(named: "spotlight_icon", bundle: ..., traitCollection: ...)`
    static func spotlight_icon(compatibleWith traitCollection: UIKit.UITraitCollection? = nil) -> UIKit.UIImage? {
      return UIKit.UIImage(resource: R.image.spotlight_icon, compatibleWith: traitCollection)
    }
    #endif

    fileprivate init() {}
  }

  /// This `R.info` struct is generated, and contains static references to 2 properties.
  struct info {
    struct nsUserActivityTypes {
      static let comVinhnxClendarSiriShortcutAddEvent = infoPlistString(path: ["NSUserActivityTypes"], key: "com.vinhnx.Clendar.SiriShortcut.addEvent") ?? "com.vinhnx.Clendar.SiriShortcut.addEvent"
      static let comVinhnxClendarSiriShortcutOpenSettings = infoPlistString(path: ["NSUserActivityTypes"], key: "com.vinhnx.Clendar.SiriShortcut.openSettings") ?? "com.vinhnx.Clendar.SiriShortcut.openSettings"
      static let comVinhnxClendarSiriShortcutOpenShortcuts = infoPlistString(path: ["NSUserActivityTypes"], key: "com.vinhnx.Clendar.SiriShortcut.openShortcuts") ?? "com.vinhnx.Clendar.SiriShortcut.openShortcuts"
      static let configurationIntent = infoPlistString(path: ["NSUserActivityTypes"], key: "ConfigurationIntent") ?? "ConfigurationIntent"

      fileprivate init() {}
    }

    struct uiApplicationSceneManifest {
      static let _key = "UIApplicationSceneManifest"
      static let uiApplicationSupportsMultipleScenes = true

      struct uiSceneConfigurations {
        static let _key = "UISceneConfigurations"

        fileprivate init() {}
      }

      fileprivate init() {}
    }

    fileprivate init() {}
  }

  /// This `R.nib` struct is generated, and contains static references to 1 nibs.
  struct nib {
    /// Nib `AppIconItemCell`.
    static let appIconItemCell = _R.nib._AppIconItemCell()

    #if os(iOS) || os(tvOS)
    /// `UINib(name: "AppIconItemCell", in: bundle)`
    @available(*, deprecated, message: "Use UINib(resource: R.nib.appIconItemCell) instead")
    static func appIconItemCell(_: Void = ()) -> UIKit.UINib {
      return UIKit.UINib(resource: R.nib.appIconItemCell)
    }
    #endif

    static func appIconItemCell(owner ownerOrNil: AnyObject?, options optionsOrNil: [UINib.OptionsKey : Any]? = nil) -> AppIconItemCell? {
      return R.nib.appIconItemCell.instantiate(withOwner: ownerOrNil, options: optionsOrNil)[0] as? AppIconItemCell
    }

    fileprivate init() {}
  }

  fileprivate struct intern: Rswift.Validatable {
    fileprivate static func validate() throws {
      // There are no resources to validate
    }

    fileprivate init() {}
  }

  fileprivate class Class {}

  fileprivate init() {}
}

struct _R {
  #if os(iOS) || os(tvOS)
  struct nib {
    struct _AppIconItemCell: Rswift.NibResourceType {
      let bundle = R.hostingBundle
      let name = "AppIconItemCell"

      func firstView(owner ownerOrNil: AnyObject?, options optionsOrNil: [UINib.OptionsKey : Any]? = nil) -> AppIconItemCell? {
        return instantiate(withOwner: ownerOrNil, options: optionsOrNil)[0] as? AppIconItemCell
      }

      fileprivate init() {}
    }

    fileprivate init() {}
  }
  #endif

  fileprivate init() {}
}
