//
//  Collection+Extensions.swift
//  Clendar
//
//  Created by Vinh Nguyen on 24/3/19.
//  Copyright © 2019 Vinh Nguyen. All rights reserved.
//

import Foundation

extension Collection {
	/// Returns the element at the specified index iff it is within bounds, otherwise nil.
	/// Reference: http://stackoverflow.com/a/30593673/1477298
	subscript(safe index: Index) -> Iterator.Element? {
		index >= startIndex && index < endIndex ? self[index] : nil
	}
}
