const Utils = {
  /**
   * 是否为闫年
   * @return {Boolse} true|false
   */
  isLeapYear(y: number): boolean {
    return (y % 4 === 0 && y % 100 !== 0) || y % 400 === 0;
  },

  /**
   * 返回星期数
   * @return {String}
   */
  getWhatDay(year: number, month: number, day: number): string {
    const date = new Date(`${year}/${month}/${day}`);
    const index = date.getDay();
    const dayNames = ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'];
    return dayNames[index];
  },

  /**
   * 返回星期数
   * @return {Number}
   */
  getMonthPreDay(year: number, month: number): number {
    const date = new Date(`${year}/${month}/01`);
    let day = date.getDay();
    if (day === 0) {
      day = 7;
    }
    return day;
  },

  /**
   * 返回月份天数
   * @return {Number}
   */
  getMonthDays(year: string, month: string): number {
    let value = month;
    if (/^0/.test(month)) {
      value = month.split('')[1];
    }
    return (
      [
        0,
        31,
        this.isLeapYear(Number(year)) ? 29 : 28,
        31,
        30,
        31,
        30,
        31,
        31,
        30,
        31,
        30,
        31,
      ] as number[]
    )[value as any];
  },

  /**
   * 补齐数字位数
   * @return {string}
   */
  getNumTwoBit(n: number): string {
    return (Number(n) > 9 ? '' : '0') + Number(n);
  },

  /**
   * 日期对象转成字符串
   * @return {string}
   */
  date2Str(date: Date, split = '-'): string {
    const y = date.getFullYear();
    const m = this.getNumTwoBit(date.getMonth() + 1);
    const d = this.getNumTwoBit(date.getDate());
    return [y, m, d].join(split);
  },

  /**
   * 返回日期格式字符串
   * @param {Number} 0返回今天的日期、1返回明天的日期，2返回后天得日期，依次类推
   * @return {string} '2014-12-31'
   */
  getDay(i = 0): string {
    let date = new Date();
    const diff = i * (1000 * 60 * 60 * 24);
    date = new Date(date.getTime() + diff);
    return this.date2Str(date);
  },

  /**
   * 时间比较
   * @return {Boolean}
   */
  compareDate(date1: string, date2: string): boolean {
    const startTime = new Date(date1.replace('-', '/').replace('-', '/'));
    const endTime = new Date(date2.replace('-', '/').replace('-', '/'));
    if (startTime >= endTime) {
      return false;
    }
    return true;
  },

  /**
   * 时间是否相等
   * @return {Boolean}
   */
  isEqual(date1: string, date2: string): boolean {
    const startTime = new Date(date1).getTime();
    const endTime = new Date(date2).getTime();
    if (startTime === endTime) {
      return true;
    }
    return false;
  },
};

export default Utils;
