import { mount } from '@vue/test-utils';
import Divider from '../index.vue';

test('slot: html should contain customer text', () => {
  const wrapper = mount(Divider, {
    slots: {
      default: 'customer text',
    },
  });
  expect(wrapper.html()).toContain('customer text');
  expect(wrapper.html()).toMatchSnapshot();
});

test('content-position props: classes should contain vin-divider-left', () => {
  const wrapper = mount(Divider, {
    props: {
      contentPosition: 'left',
    },
    slots: {
      default: 'customer text',
    },
  });
  const divider: any = wrapper.find('.vin-divider');
  expect(divider.classes()).toContain('vin-divider-left');
});

test('dashed props: classes should contain vin-divider-dashed', () => {
  const wrapper = mount(Divider, {
    props: {
      dashed: true,
    },
    slots: {
      default: 'customer text',
    },
  });

  const divider: any = wrapper.find('.vin-divider');
  expect(divider.classes()).toContain('vin-divider-dashed');
});

test('customer style: element color should be rgb(25, 137, 250) etc', () => {
  const wrapper = mount(Divider, {
    props: {
      style: {
        color: '#1989fa',
        borderColor: '#1989fa',
        padding: '0 16px',
      },
    },
  });
  const divider: any = wrapper.find('.vin-divider');
  expect((divider.element as HTMLElement).style.color).toBe('rgb(25, 137, 250)');
  expect((divider.element as HTMLElement).style.borderColor).toBe('#1989fa');
  expect((divider.element as HTMLElement).style.padding).toBe('0px 16px');
});

test('hairline props: classes should contain vin-divider-hairline default, after set hairline false, vin-divider-hairline disappear', async () => {
  const wrapper = mount(Divider);

  const divider: any = wrapper.find('.vin-divider');
  expect(divider.classes()).toContain('vin-divider-hairline');
  await wrapper.setProps({ hairline: false });
  expect(wrapper.classes('vin-divider-hairline')).toBe(false);
});
