# List 虚拟列表

### 介绍

在正常的列表展示以及上拉加载中，我们通常使用 `VinUI` 提供的 [滚动加载](/docs/components/infiniteloading/index.html) 组件，那如果我们加载的数据量非常大时，则可能会产生严重的性能问题，导致视图无法响应操作一段时间，这时候我们就用到了虚拟列表组件 `List`，它可以保证只渲染当前可视区域，其他部分在用户滚动到可视区域内之后再渲染。保证了页面流程度，提升性能。

### 基础用法

```html
<template>
  <view class="demo">
    <h2>基础用法</h2>
    <vin-cell>
      <vin-list :height="50" :listData="count" @scroll="handleScroll">
        <template v-slot="{ item }">
          <view class="list-item"> {{ item }} </view>
        </template>
      </vin-list>
    </vin-cell>
  </view>
</template>
<script lang="ts">
  import { onMounted, reactive, toRefs } from 'vue';
  export default {
    props: {},
    setup() {
      const state = reactive({
        count: new Array(100).fill(0),
      });

      const handleScroll = () => {
        let arr = new Array(100).fill(0);
        const len = state.count.length;
        state.count = state.count.concat(arr.map((item: number, index: number) => len + index + 1));
      };

      onMounted(() => {
        state.count = state.count.map((item: number, index: number) => index + 1);
      });

      return { ...toRefs(state), handleScroll };
    },
  };
</script>
```

## API

### Props

| 参数             | 说明         | 类型   | 默认值       |
| ---------------- | ------------ | ------ | ------------ |
| height           | 列表项的高度 | Number | `50`         |
| list-data        | 列表数据     | any[]  | `[]`         |
| container-height | 容器高度     | Number | `可视区高度` |

### Slot

| 参数  | 说明       | 类型   |
| ----- | ---------- | ------ |
| item  | 列表项数据 | Object |
| index | 索引       | Number |

### Events

| 事件名 | 说明       | 回调参数 |
| ------ | ---------- | -------- |
| scroll | 滚动时触发 | -        |
