
## 🚀 React Native Messenger

[![React Native](https://img.shields.io/badge/React%20Native-v0.57.8-blue.svg)](https://facebook.github.io/react-native/)
[![React Navigation V2](https://img.shields.io/badge/React%20Navigation-v3..0.9-blue.svg)](https://reactnavigation.org/)



Facebook Messenger Implementation using react-native. This is a Work in Progress!  

## UPDATE:
* [Watermelon Messenger](https://github.com/victorkvarghese/WatermelonMessenger)
* Based on [React Native BoilerPlate](https://github.com/victorkvarghese/react-native-boilerplate)




## Build Status

| Platform      | Build Status (Master)  |
| ------------- |:-------------:|
| Android       | [![Build status](https://build.appcenter.ms/v0.1/apps/2ba8e70c-2f79-4430-89f4-f032d16003da/branches/master/badge)](https://appcenter.ms) |
| iOS           | [![Build status](https://build.appcenter.ms/v0.1/apps/c007d029-6181-4e0a-9779-0392250d6a66/branches/master/badge)](https://appcenter.ms)     |

## Features

* [React Navigation](https://reactnavigation.org/)
* [Redux](https://redux.js.org/)
* [Redux Saga](https://redux-saga.js.org/)
* [React Native Paper](https://callstack.github.io/react-native-paper/)
* [Lottie React Native](https://github.com/react-community/lottie-react-native/)
* [React Native Camera](https://github.com/react-native-community/react-native-camera)
* [React Native Vector Icons](https://github.com/oblador/react-native-vector-icons)
* [Jest](https://facebook.github.io/jest/)
* [Eslint](http://eslint.org/) ([Airbnb config](https://github.com/airbnb/javascript/tree/master/packages/eslint-config-airbnb))

## Prerequisites

* [Node](https://nodejs.org) v8.10 (it is recommended to install it via [NVM](https://github.com/creationix/nvm))
* [Yarn](https://yarnpkg.com/)
* A development machine set up for React Native by following [these instructions](https://facebook.github.io/react-native/docs/getting-started.html)

## Getting Started

1. Clone this repo, `git clone https://github.com/victorkvarghese/react-native-messenger.git `
2. Go to project's root directory, `cd <your project name>`
3. Run `yarn` or `npm install` to install dependencies
4. Connect a mobile device to your development machine
5. Run the test application:
  * On Android:
    * Run `react-native run-android`
  * On iOS:
    * Open `ios/Messenger.xcodeproj` in Xcode
    * Hit `Run` after selecting the desired device
6. Enjoy!!!

## Read More 
https://medium.com/@victorvarghese/building-facebook-messenger-clone-in-react-native-6d0f77bcd926

## Sample APK
Download here : [Messenger Sample APK v1.2](https://drive.google.com/file/d/1WoBxeqRcw9sUEmEkk2v6ckL-CoS185Sa/view?usp=sharing) - Updated facebook reactions

## Screenshots

Active Screen              |  Groups Screen
:-------------------------:|:-------------------------:
![](https://user-images.githubusercontent.com/15869386/42648284-15525324-8624-11e8-9f81-a20e202b7124.png)  |  ![](https://user-images.githubusercontent.com/15869386/42648337-39681032-8624-11e8-8fec-a33750d67215.png)

Calls Screen              |  Camera Screen
:-------------------------:|:-------------------------:
![](https://user-images.githubusercontent.com/15869386/42648339-3b468e56-8624-11e8-877e-a06b7bf57c4d.png)  |  ![](https://user-images.githubusercontent.com/15869386/42648341-3cd95c26-8624-11e8-9976-6117736922ed.png)


![](https://user-images.githubusercontent.com/15869386/43475979-fd16b340-9514-11e8-9388-7b073af4578c.gif)



## Contributing
PRs are welcome.
