# android-udp-bus

Android application to create UDP forwarders, hubs and other tools. To aid building VPNs, video streaming and other tricky network uses.

![First screenshot](screenshot1.png) ![Second screenshot](screenshot2.png)

Build it using `./gradlew cargoBuild && ./gradlew assembleDebug`.

# Download

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="80">](https://f-droid.org/packages/org.vi_server.androidudpbus/)

or get the APK from the [Releases Section](https://github.com/vi/android-udp-bus/releases/latest).

# Features

* Binding UDP socket on specified port and exchanging traffic between all known peers
* Exchanging traffic between multiple UDP sockets
* Remembering specified number of peers that have sent us some datagram, with optional expiration policy
* Directly specifying peers to send datagrams to. Combined with remembering, it allows using the application as UDP forwarder.
* Joining multicast groups, setting TTL, TOS, read and write buffer sizes and other socket options.
* Periodical sending of hardcoded datagrams to specified peers (e.g. to keep NAT open)
* Displaying of detailed statistics of the traffic
* Starting multiple isolated hubs, each with distinct set of ports. Can even act as a simplistic load balancer due to `SO_REUSEPORT`.

The application does not send datagrams back to sender.

# Limitation

* UI is not user-friendly.
* Not all features are exposed in GUI - you may want to add some undocumented fields to the JSON manually.
* Not very optimised for speed or latency. It may be slightly slower than `socat udp4-l udp`.
* Not everything is tested yet

# Configuration

GUI has a button to simplify appending a JSON snippet for a port to the first hub. There is no removal function - you are expected to edit JSON youself to access to edit config or to access advanced features. It may make sense to use clipboard to copy the config out or into the application. Config JSON is not saved as a file to filesystem ("Save" button saves to Android preferences).

For a trickier setup it can also make sense to prepare a config outside mobile device. For this, you may want to use [JSON schema](schema.json) of the configuration file. There are descriptions of all options in the schema (autogenerated from [this source code file](udphub/src/config.rs)). Prepared config file may be transferred to the application e.g. by QR code (using external QR scanner app and the clipboard). 
