from pyrsistent import freeze

_STOPWORDS = {
    'bg': {
        'а',
        'автентичен',
        'аз',
        'ако',
        'ала',
        'бе',
        'без',
        'беше',
        'би',
        'бивш',
        'бивша',
        'бившо',
        'бил',
        'била',
        'били',
        'било',
        'благодаря',
        'близо',
        'бъдат',
        'бъде',
        'бяха',
        'в',
        'вас',
        'ваш',
        'ваша',
        'вероятно',
        'вече',
        'взема',
        'ви',
        'вие',
        'винаги',
        'внимава',
        'време',
        'все',
        'всеки',
        'всички',
        'всичко',
        'всяка',
        'във',
        'въпреки',
        'върху',
        'г',
        'ги',
        'главен',
        'главна',
        'главно',
        'глас',
        'го',
        'година',
        'години',
        'годишен',
        'д',
        'да',
        'дали',
        'два',
        'двама',
        'двамата',
        'две',
        'двете',
        'ден',
        'днес',
        'дни',
        'до',
        'добра',
        'добре',
        'добро',
        'добър',
        'докато',
        'докога',
        'дори',
        'досега',
        'доста',
        'друг',
        'друга',
        'други',
        'е',
        'евтин',
        'едва',
        'един',
        'една',
        'еднаква',
        'еднакви',
        'еднакъв',
        'едно',
        'екип',
        'ето',
        'живот',
        'за',
        'забавям',
        'зад',
        'заедно',
        'заради',
        'засега',
        'заспал',
        'затова',
        'защо',
        'защото',
        'и',
        'из',
        'или',
        'им',
        'има',
        'имат',
        'иска',
        'й',
        'каза',
        'как',
        'каква',
        'какво',
        'както',
        'какъв',
        'като',
        'кога',
        'когато',
        'което',
        'които',
        'кой',
        'който',
        'колко',
        'която',
        'къде',
        'където',
        'към',
        'лесен',
        'лесно',
        'ли',
        'лош',
        'м',
        'май',
        'малко',
        'ме',
        'между',
        'мек',
        'мен',
        'месец',
        'ми',
        'много',
        'мнозина',
        'мога',
        'могат',
        'може',
        'мокър',
        'моля',
        'момента',
        'му',
        'н',
        'на',
        'над',
        'назад',
        'най',
        'направи',
        'напред',
        'например',
        'нас',
        'не',
        'него',
        'нещо',
        'нея',
        'ни',
        'ние',
        'никой',
        'нито',
        'нищо',
        'но',
        'нов',
        'нова',
        'нови',
        'новина',
        'някои',
        'някой',
        'няколко',
        'няма',
        'обаче',
        'около',
        'освен',
        'особено',
        'от',
        'отгоре',
        'отново',
        'още',
        'пак',
        'по',
        'повече',
        'повечето',
        'под',
        'поне',
        'поради',
        'после',
        'почти',
        'прави',
        'пред',
        'преди',
        'през',
        'при',
        'пък',
        'първата',
        'първи',
        'първо',
        'пъти',
        'равен',
        'равна',
        'с',
        'са',
        'сам',
        'само',
        'се',
        'сега',
        'си',
        'син',
        'скоро',
        'след',
        'следващ',
        'сме',
        'смях',
        'според',
        'сред',
        'срещу',
        'сте',
        'съм',
        'със',
        'също',
        'т',
        'тази',
        'така',
        'такива',
        'такъв',
        'там',
        'твой',
        'те',
        'тези',
        'ти',
        'т.н.',
        'то',
        'това',
        'тогава',
        'този',
        'той',
        'толкова',
        'точно',
        'три',
        'трябва',
        'тук',
        'тъй',
        'тя',
        'тях',
        'у',
        'утре',
        'харесва',
        'хиляди',
        'ч',
        'часа',
        'че',
        'често',
        'чрез',
        'ще',
        'щом',
        'юмрук',
        'я',
        'як',
    },
    'cs': {
        'a',
        'aby',
        'aby',
        'aj',
        'ale',
        'ani',
        'aniž',
        'ano',
        'asi',
        'az',
        'až',
        'bez',
        'bude',
        'budem',
        'budes',
        'budeš',
        'by',
        'byl',
        'byla',
        'byli',
        'bylo',
        'byt',
        'být',
        'ci',
        'či',
        'clanek',
        'článek',
        'clanku',
        'článku',
        'clanky',
        'články',
        'co',
        'coz',
        'což',
        'cz',
        'dalsi',
        'další',
        'design',
        'dnes',
        'do',
        'email',
        'ho',
        'i',
        'já',
        'jak',
        'jako',
        'je',
        'jeho',
        'jej',
        'jeji',
        'její',
        'jejich',
        'jen',
        'jenž',
        'jeste',
        'ještě',
        'ji',
        'jine',
        'jiné',
        'jiz',
        'již',
        'jsem',
        'jses',
        'jseš',
        'jsme',
        'jsou',
        'jste',
        'jšte',
        'k',
        'kam',
        'každý',
        'kde',
        'kdo',
        'kdyz',
        'když',
        'ke',
        'ktera',
        'která',
        'ktere',
        'které',
        'kteri',
        'kteři',
        'kterou',
        'ktery',
        'který',
        'ku',
        'ma',
        'mate',
        'máte',
        'me',
        'mě',
        'mezi',
        'mi',
        'mit',
        'mít',
        'mně',
        'mnou',
        'muj',
        'můj',
        'muze',
        'může',
        'my',
        'na',
        'ná',
        'nad',
        'nam',
        'nám',
        'napiste',
        'napište',
        'nas',
        'náš',
        'nasi',
        'naši',
        'ne',
        'nebo',
        'nechť',
        'nejsou',
        'neni',
        'není',
        'nez',
        'než',
        'ní',
        'nic',
        'nove',
        'nové',
        'novy',
        'nový',
        'o',
        'od',
        'ode',
        'on',
        'pak',
        'po',
        'pod',
        'podle',
        'pokud',
        'pouze',
        'prave',
        'práve',
        'pred',
        'před',
        'přede',
        'pres',
        'přes',
        'pri',
        'při',
        'pro',
        'proc',
        'proč',
        'proto',
        'protoze',
        'protože',
        'prvni',
        'první',
        'pta',
        're',
        's',
        'se',
        'si',
        'sice',
        'strana',
        'sve',
        'své',
        'svůj',
        'svych',
        'svých',
        'svym',
        'svým',
        'svymi',
        'svými',
        'ta',
        'tak',
        'take',
        'také',
        'takze',
        'takže',
        'tato',
        'te',
        'tě',
        'tedy',
        'tema',
        'těma',
        'ten',
        'tento',
        'teto',
        'této',
        'tim',
        'tím',
        'timto',
        'tímto',
        'tipy',
        'to',
        'tohle',
        'toho',
        'tohoto',
        'tom',
        'tomto',
        'tomuto',
        'toto',
        'tu',
        'tuto',
        'tvůj',
        'ty',
        'tyto',
        'u',
        'uz',
        'už',
        'v',
        'vam',
        'vám',
        'vas',
        'váš',
        'vase',
        'vaše',
        've',
        'vice',
        'více',
        'vsak',
        'však',
        'všechen',
        'vy',
        'z',
        'za',
        'zda',
        'zde',
        'že',
        'ze',
        'zpet',
        'zpět',
        'zpravy',
        'zprávy',
    },
    'da': {
        'af',
        'alle',
        'andet',
        'andre',
        'at',
        'begge',
        'da',
        'de',
        'den',
        'denne',
        'der',
        'deres',
        'det',
        'dette',
        'dig',
        'din',
        'dog',
        'du',
        'ej',
        'eller',
        'en',
        'end',
        'ene',
        'eneste',
        'enhver',
        'et',
        'fem',
        'fire',
        'flere',
        'fleste',
        'for',
        'fordi',
        'forrige',
        'fra',
        'få',
        'før',
        'god',
        'han',
        'hans',
        'har',
        'hendes',
        'her',
        'hun',
        'hvad',
        'hvem',
        'hver',
        'hvilken',
        'hvis',
        'hvor',
        'hvordan',
        'hvorfor',
        'hvornår',
        'i',
        'ikke',
        'ind',
        'ingen',
        'intet',
        'jeg',
        'jeres',
        'kan',
        'kom',
        'kommer',
        'lav',
        'lidt',
        'lille',
        'man',
        'mand',
        'mange',
        'med',
        'meget',
        'men',
        'mens',
        'mere',
        'mig',
        'ned',
        'ni',
        'nogen',
        'noget',
        'ny',
        'nyt',
        'nær',
        'næste',
        'næsten',
        'og',
        'op',
        'otte',
        'over',
        'på',
        'se',
        'seks',
        'ses',
        'som',
        'stor',
        'store',
        'syv',
        'ti',
        'til',
        'to',
        'tre',
        'ud',
        'var',
    },
    'de': {
        'ab',
        'aber',
        'alle',
        'allein',
        'allem',
        'allen',
        'aller',
        'allerdings',
        'allerlei',
        'alles',
        'allmählich',
        'allzu',
        'als',
        'alsbald',
        'also',
        'am',
        'an',
        'and',
        'ander',
        'andere',
        'anderem',
        'anderen',
        'anderer',
        'andererseits',
        'anderes',
        'anderm',
        'andern',
        'andernfalls',
        'anders',
        'anstatt',
        'auch',
        'auf',
        'aus',
        'ausgenommen',
        'ausser',
        'ausserdem',
        'außer',
        'außerdem',
        'außerhalb',
        'bald',
        'bei',
        'beide',
        'beiden',
        'beiderlei',
        'beides',
        'beim',
        'beinahe',
        'bereits',
        'besonders',
        'besser',
        'beträchtlich',
        'bevor',
        'bezüglich',
        'bin',
        'bis',
        'bisher',
        'bislang',
        'bist',
        'bloß',
        'bsp.',
        'bzw',
        'ca',
        'ca.',
        'content',
        'da',
        'dabei',
        'dadurch',
        'dafür',
        'dagegen',
        'daher',
        'dahin',
        'damals',
        'damit',
        'danach',
        'daneben',
        'dann',
        'daran',
        'darauf',
        'daraus',
        'darin',
        'darum',
        'darunter',
        'darüber',
        'darüberhinaus',
        'das',
        'dass',
        'dasselbe',
        'davon',
        'davor',
        'dazu',
        'daß',
        'dein',
        'deine',
        'deinem',
        'deinen',
        'deiner',
        'deines',
        'dem',
        'demnach',
        'demselben',
        'den',
        'denen',
        'denn',
        'dennoch',
        'denselben',
        'der',
        'derart',
        'derartig',
        'derem',
        'deren',
        'derer',
        'derjenige',
        'derjenigen',
        'derselbe',
        'derselben',
        'derzeit',
        'des',
        'deshalb',
        'desselben',
        'dessen',
        'desto',
        'deswegen',
        'dich',
        'die',
        'diejenige',
        'dies',
        'diese',
        'dieselbe',
        'dieselben',
        'diesem',
        'diesen',
        'dieser',
        'dieses',
        'diesseits',
        'dir',
        'direkt',
        'direkte',
        'direkten',
        'direkter',
        'doch',
        'dort',
        'dorther',
        'dorthin',
        'drauf',
        'drin',
        'drunter',
        'drüber',
        'du',
        'dunklen',
        'durch',
        'durchaus',
        'eben',
        'ebenfalls',
        'ebenso',
        'eher',
        'eigenen',
        'eigenes',
        'eigentlich',
        'ein',
        'eine',
        'einem',
        'einen',
        'einer',
        'einerseits',
        'eines',
        'einfach',
        'einführen',
        'einführte',
        'einführten',
        'eingesetzt',
        'einig',
        'einige',
        'einigem',
        'einigen',
        'einiger',
        'einigermaßen',
        'einiges',
        'einmal',
        'eins',
        'einseitig',
        'einseitige',
        'einseitigen',
        'einseitiger',
        'einst',
        'einstmals',
        'einzig',
        'entsprechend',
        'entweder',
        'er',
        'erst',
        'es',
        'etc',
        'etliche',
        'etwa',
        'etwas',
        'euch',
        'euer',
        'eure',
        'eurem',
        'euren',
        'eurer',
        'eures',
        'falls',
        'fast',
        'ferner',
        'folgende',
        'folgenden',
        'folgender',
        'folgendes',
        'folglich',
        'fuer',
        'für',
        'gab',
        'ganze',
        'ganzem',
        'ganzen',
        'ganzer',
        'ganzes',
        'gar',
        'gegen',
        'gemäss',
        'ggf',
        'gleich',
        'gleichwohl',
        'gleichzeitig',
        'glücklicherweise',
        'gänzlich',
        'hab',
        'habe',
        'haben',
        'haette',
        'hast',
        'hat',
        'hatte',
        'hatten',
        'hattest',
        'hattet',
        'heraus',
        'herein',
        'hier',
        'hier',
        'hinter',
        'hiermit',
        'hiesige',
        'hin',
        'hinein',
        'hinten',
        'hinter',
        'hinterher',
        'http',
        'hätt',
        'hätte',
        'hätten',
        'höchstens',
        'ich',
        'igitt',
        'ihm',
        'ihn',
        'ihnen',
        'ihr',
        'ihre',
        'ihrem',
        'ihren',
        'ihrer',
        'ihres',
        'im',
        'immer',
        'immerhin',
        'in',
        'indem',
        'indessen',
        'infolge',
        'innen',
        'innerhalb',
        'ins',
        'insofern',
        'inzwischen',
        'irgend',
        'irgendeine',
        'irgendwas',
        'irgendwen',
        'irgendwer',
        'irgendwie',
        'irgendwo',
        'ist',
        'ja',
        'je',
        'jed',
        'jede',
        'jedem',
        'jeden',
        'jedenfalls',
        'jeder',
        'jederlei',
        'jedes',
        'jedoch',
        'jemand',
        'jene',
        'jenem',
        'jenen',
        'jener',
        'jenes',
        'jenseits',
        'jetzt',
        'jährig',
        'jährige',
        'jährigen',
        'jähriges',
        'kam',
        'kann',
        'kannst',
        'kaum',
        'kein',
        'keine',
        'keinem',
        'keinen',
        'keiner',
        'keinerlei',
        'keines',
        'keineswegs',
        'klar',
        'klare',
        'klaren',
        'klares',
        'klein',
        'kleinen',
        'kleiner',
        'kleines',
        'koennen',
        'koennt',
        'koennte',
        'koennten',
        'komme',
        'kommen',
        'kommt',
        'konkret',
        'konkrete',
        'konkreten',
        'konkreter',
        'konkretes',
        'können',
        'könnt',
        'künftig',
        'leider',
        'machen',
        'man',
        'manche',
        'manchem',
        'manchen',
        'mancher',
        'mancherorts',
        'manches',
        'manchmal',
        'mehr',
        'mehrere',
        'mein',
        'meine',
        'meinem',
        'meinen',
        'meiner',
        'meines',
        'mich',
        'mir',
        'mit',
        'mithin',
        'muessen',
        'muesst',
        'muesste',
        'muss',
        'musst',
        'musste',
        'mussten',
        'muß',
        'mußt',
        'müssen',
        'müsste',
        'müssten',
        'müßt',
        'müßte',
        'nach',
        'nachdem',
        'nachher',
        'nachhinein',
        'nahm',
        'natürlich',
        'neben',
        'nebenan',
        'nehmen',
        'nein',
        'nicht',
        'nichts',
        'nie',
        'niemals',
        'niemand',
        'nirgends',
        'nirgendwo',
        'noch',
        'nun',
        'nur',
        'nächste',
        'nämlich',
        'nötigenfalls',
        'ob',
        'oben',
        'oberhalb',
        'obgleich',
        'obschon',
        'obwohl',
        'oder',
        'oft',
        'per',
        'plötzlich',
        'schließlich',
        'schon',
        'sehr',
        'sehrwohl',
        'seid',
        'sein',
        'seine',
        'seinem',
        'seinen',
        'seiner',
        'seines',
        'seit',
        'seitdem',
        'seither',
        'selber',
        'selbst',
        'sich',
        'sicher',
        'sicherlich',
        'sie',
        'sind',
        'so',
        'sobald',
        'sodass',
        'sodaß',
        'soeben',
        'sofern',
        'sofort',
        'sogar',
        'solange',
        'solch',
        'solche',
        'solchem',
        'solchen',
        'solcher',
        'solches',
        'soll',
        'sollen',
        'sollst',
        'sollt',
        'sollte',
        'sollten',
        'solltest',
        'somit',
        'sondern',
        'sonst',
        'sonstwo',
        'sooft',
        'soviel',
        'soweit',
        'sowie',
        'sowohl',
        'tatsächlich',
        'tatsächlichen',
        'tatsächlicher',
        'tatsächliches',
        'trotzdem',
        'ueber',
        'um',
        'umso',
        'unbedingt',
        'und',
        'unmöglich',
        'unmögliche',
        'unmöglichen',
        'unmöglicher',
        'uns',
        'unser',
        'unser',
        'unsere',
        'unsere',
        'unserem',
        'unseren',
        'unserer',
        'unseres',
        'unter',
        'usw',
        'viel',
        'viele',
        'vielen',
        'vieler',
        'vieles',
        'vielleicht',
        'vielmals',
        'vom',
        'von',
        'vor',
        'voran',
        'vorher',
        'vorüber',
        'völlig',
        'wann',
        'war',
        'waren',
        'warst',
        'warum',
        'was',
        'weder',
        'weil',
        'weiter',
        'weitere',
        'weiterem',
        'weiteren',
        'weiterer',
        'weiteres',
        'weiterhin',
        'weiß',
        'welche',
        'welchem',
        'welchen',
        'welcher',
        'welches',
        'wem',
        'wen',
        'wenig',
        'wenige',
        'weniger',
        'wenigstens',
        'wenn',
        'wenngleich',
        'wer',
        'werde',
        'werden',
        'werdet',
        'weshalb',
        'wessen',
        'wichtig',
        'wie',
        'wieder',
        'wieso',
        'wieviel',
        'wiewohl',
        'will',
        'willst',
        'wir',
        'wird',
        'wirklich',
        'wirst',
        'wo',
        'wodurch',
        'wogegen',
        'woher',
        'wohin',
        'wohingegen',
        'wohl',
        'wohlweislich',
        'womit',
        'woraufhin',
        'woraus',
        'worin',
        'wurde',
        'wurden',
        'während',
        'währenddessen',
        'wär',
        'wäre',
        'wären',
        'würde',
        'würden',
        'z.B.',
        'zB',
        'zahlreich',
        'zeitweise',
        'zu',
        'zudem',
        'zuerst',
        'zufolge',
        'zugleich',
        'zuletzt',
        'zum',
        'zumal',
        'zur',
        'zurück',
        'zusammen',
        'zuviel',
        'zwar',
        'zwischen',
        'ähnlich',
        'übel',
        'über',
        'überall',
        'überallhin',
        'überdies',
        'übermorgen',
        'übrig',
        'übrigens',
    },
    'el': {
        'ἀλλ’',
        'ἀλλά',
        'ἄλλοσ',
        'ἄν',
        'ἀπό',
        'ἄρα',
        'αὐτόσ',
        'γα^',
        'γάρ',
        'γε',
        'δ’',
        'δαί',
        'δαίσ',
        'δέ',
        'δή',
        'διά',
        'ἐάν',
        'ἑαυτοῦ',
        'ἐγώ',
        'εἰ',
        'εἰμί',
        'εἴμι',
        'εἰσ',
        'ἐκ',
        'ἐμόσ',
        'ἐν',
        'ἐπί',
        'ἔτι',
        'ἤ',
        'ἡ',
        'καί',
        'κατά',
        'μέν',
        'μετά',
        'μή',
        'μή',
        'ὁ',
        'ὅδε',
        'οἱ',
        'ὅσ',
        'ὅστισ',
        'ὅτι',
        'οὐ',
        'οὐδέ',
        'οὐδείσ',
        'οὐκ',
        'οὖν',
        'οὔτε',
        'οὗτοσ',
        'οὕτωσ',
        'παρά',
        'περί',
        'πρόσ',
        'σόσ',
        'σύ',
        'σύν',
        'τά',
        'τε',
        'τῇ',
        'τήν',
        'τῆσ',
        'τι',
        'τί',
        'τισ',
        'τίσ',
        'τό',
        'τοί',
        'τοιοῦτοσ',
        'τόν',
        'τοῦ',
        'τούσ',
        'τῷ',
        'τῶν',
        'ὑμόσ',
        'ὑπέρ',
        'ὑπό',
        'ὦ',
        'ὡσ',
        'ὥστε',
    },
    'en': {
        'a',
        "a's",
        'able',
        'about',
        'above',
        'according',
        'accordingly',
        'across',
        'actually',
        'after',
        'afterwards',
        'again',
        'against',
        "ain't",
        'all',
        'allow',
        'allows',
        'almost',
        'alone',
        'along',
        'already',
        'also',
        'although',
        'always',
        'am',
        'among',
        'amongst',
        'an',
        'and',
        'another',
        'any',
        'anybody',
        'anyhow',
        'anyone',
        'anything',
        'anyway',
        'anyways',
        'anywhere',
        'apart',
        'appear',
        'appreciate',
        'appropriate',
        'are',
        "aren't",
        'around',
        'as',
        'aside',
        'ask',
        'asking',
        'associated',
        'at',
        'available',
        'away',
        'awfully',
        'b',
        'be',
        'became',
        'because',
        'become',
        'becomes',
        'becoming',
        'been',
        'before',
        'beforehand',
        'behind',
        'being',
        'believe',
        'below',
        'beside',
        'besides',
        'best',
        'better',
        'between',
        'beyond',
        'both',
        'brief',
        'but',
        'by',
        'c',
        "c'mon",
        "c's",
        'came',
        'can',
        "can't",
        'cannot',
        'cant',
        'cause',
        'causes',
        'certain',
        'certainly',
        'changes',
        'clearly',
        'co',
        'com',
        'come',
        'comes',
        'concerning',
        'consequently',
        'consider',
        'considering',
        'contain',
        'containing',
        'contains',
        'corresponding',
        'could',
        "couldn't",
        'course',
        'currently',
        'd',
        'definitely',
        'described',
        'despite',
        'did',
        "didn't",
        'different',
        'do',
        'does',
        "doesn't",
        'doing',
        "don't",
        'done',
        'down',
        'downwards',
        'during',
        'e',
        'each',
        'edu',
        'eg',
        'eight',
        'either',
        'else',
        'elsewhere',
        'enough',
        'entirely',
        'especially',
        'et',
        'etc',
        'even',
        'ever',
        'every',
        'everybody',
        'everyone',
        'everything',
        'everywhere',
        'ex',
        'exactly',
        'example',
        'except',
        'f',
        'far',
        'few',
        'fifth',
        'first',
        'five',
        'followed',
        'following',
        'follows',
        'for',
        'former',
        'formerly',
        'forth',
        'four',
        'from',
        'further',
        'furthermore',
        'g',
        'get',
        'gets',
        'getting',
        'given',
        'gives',
        'go',
        'goes',
        'going',
        'gone',
        'got',
        'gotten',
        'greetings',
        'h',
        'had',
        "hadn't",
        'happens',
        'hardly',
        'has',
        "hasn't",
        'have',
        "haven't",
        'having',
        'he',
        "he's",
        'hello',
        'help',
        'hence',
        'her',
        'here',
        "here's",
        'hereafter',
        'hereby',
        'herein',
        'hereupon',
        'hers',
        'herself',
        'hi',
        'him',
        'himself',
        'his',
        'hither',
        'hopefully',
        'how',
        'howbeit',
        'however',
        'i',
        "i'd",
        "i'll",
        "i'm",
        "i've",
        'ie',
        'if',
        'ignored',
        'immediate',
        'in',
        'inasmuch',
        'inc',
        'include',
        'including',
        'indeed',
        'indicate',
        'indicated',
        'indicates',
        'inner',
        'insofar',
        'instead',
        'into',
        'inward',
        'is',
        "isn't",
        'it',
        "it'd",
        "it'll",
        "it's",
        'its',
        'itself',
        'j',
        'just',
        'k',
        'keep',
        'keeps',
        'kept',
        'know',
        'knows',
        'known',
        'l',
        'last',
        'lately',
        'later',
        'latter',
        'latterly',
        'least',
        'less',
        'lest',
        'let',
        "let's",
        'like',
        'liked',
        'likely',
        'little',
        'look',
        'looking',
        'looks',
        'ltd',
        'm',
        'mainly',
        'many',
        'may',
        'maybe',
        'me',
        'mean',
        'meanwhile',
        'merely',
        'might',
        'more',
        'moreover',
        'most',
        'mostly',
        'much',
        'must',
        'my',
        'myself',
        'n',
        'name',
        'namely',
        'nd',
        'near',
        'nearly',
        'necessary',
        'need',
        'needs',
        'neither',
        'never',
        'nevertheless',
        'new',
        'next',
        'nine',
        'no',
        'nobody',
        'non',
        'none',
        'noone',
        'nor',
        'normally',
        'not',
        'nothing',
        'novel',
        'now',
        'nowhere',
        'o',
        'obviously',
        'of',
        'off',
        'often',
        'oh',
        'ok',
        'okay',
        'old',
        'on',
        'once',
        'one',
        'ones',
        'only',
        'onto',
        'or',
        'other',
        'others',
        'otherwise',
        'ought',
        'our',
        'ours',
        'ourselves',
        'out',
        'outside',
        'over',
        'overall',
        'own',
        'p',
        'page',
        'particular',
        'particularly',
        'per',
        'perhaps',
        'placed',
        'please',
        'plus',
        'possible',
        'presumably',
        'probably',
        'provides',
        'q',
        'que',
        'quite',
        'qv',
        'r',
        'rather',
        'rd',
        're',
        'really',
        'reasonably',
        'regarding',
        'regardless',
        'regards',
        'relatively',
        'respectively',
        'right',
        's',
        'said',
        'same',
        'saw',
        'say',
        'saying',
        'says',
        'second',
        'secondly',
        'see',
        'seeing',
        'seem',
        'seemed',
        'seeming',
        'seems',
        'seen',
        'self',
        'selves',
        'sensible',
        'sent',
        'serious',
        'seriously',
        'seven',
        'several',
        'shall',
        'she',
        'should',
        "shouldn't",
        'since',
        'six',
        'so',
        'some',
        'somebody',
        'somehow',
        'someone',
        'something',
        'sometime',
        'sometimes',
        'somewhat',
        'somewhere',
        'soon',
        'sorry',
        'specified',
        'specify',
        'specifying',
        'still',
        'sub',
        'such',
        'sup',
        'sure',
        't',
        "t's",
        'take',
        'taken',
        'tell',
        'tends',
        'th',
        'than',
        'thank',
        'thanks',
        'thanx',
        'that',
        "that's",
        'thats',
        'the',
        'their',
        'theirs',
        'them',
        'themselves',
        'then',
        'thence',
        'there',
        "there's",
        'thereafter',
        'thereby',
        'therefore',
        'therein',
        'theres',
        'thereupon',
        'these',
        'they',
        "they'd",
        "they'll",
        "they're",
        "they've",
        'think',
        'third',
        'this',
        'thorough',
        'thoroughly',
        'those',
        'though',
        'three',
        'through',
        'throughout',
        'thru',
        'thus',
        'to',
        'together',
        'too',
        'took',
        'toward',
        'towards',
        'tried',
        'tries',
        'truly',
        'try',
        'trying',
        'twice',
        'two',
        'u',
        'un',
        'under',
        'unfortunately',
        'unless',
        'unlikely',
        'until',
        'unto',
        'up',
        'upon',
        'us',
        'use',
        'used',
        'useful',
        'uses',
        'using',
        'usually',
        'uucp',
        'v',
        'value',
        'various',
        'very',
        'via',
        'viz',
        'vs',
        'w',
        'want',
        'wants',
        'was',
        "wasn't",
        'way',
        'we',
        "we'd",
        "we'll",
        "we're",
        "we've",
        'website',
        'welcome',
        'well',
        'went',
        'were',
        "weren't",
        'what',
        "what's",
        'whatever',
        'when',
        'whence',
        'whenever',
        'where',
        "where's",
        'whereafter',
        'whereas',
        'whereby',
        'wherein',
        'whereupon',
        'wherever',
        'whether',
        'which',
        'while',
        'whither',
        'who',
        "who's",
        'whoever',
        'whole',
        'whom',
        'whose',
        'why',
        'will',
        'willing',
        'wish',
        'with',
        'within',
        'without',
        "won't",
        'would',
        'would',
        "wouldn't",
        'x',
        'y',
        'yes',
        'yet',
        'you',
        "you'd",
        "you'll",
        "you're",
        "you've",
        'your',
        'yours',
        'yourself',
        'yourselves',
        'z',
        'zero',
    },
    'es': {
        'a',
        'á',
        'acerca',
        'además',
        'adonde',
        'al',
        'algo',
        'algún',
        'alguna',
        'algunas',
        'alguno',
        'algunos',
        'allende',
        'ambos',
        'amén',
        'ampleamos',
        'ante',
        'antes',
        'aquel',
        'aquellas',
        'aquellos',
        'aqui',
        'arriba',
        'atras',
        'aun',
        'bajo',
        'bastante',
        'bien',
        'cabe',
        'cabo',
        'cada',
        'cierta',
        'ciertas',
        'cierto',
        'ciertos',
        'circa',
        'como',
        'con',
        'conmigo',
        'connosco',
        'conseguimos',
        'conseguir',
        'consigo',
        'consigue',
        'consiguen',
        'consigues',
        'contigo',
        'contra',
        'convosco',
        'convusco',
        'cual',
        'cuando',
        'de',
        'dejante',
        'del',
        'delas',
        'dentro',
        'desde',
        'después',
        'donde',
        'dos',
        'durante',
        'e',
        'el',
        'él',
        'ella',
        'ellas',
        'ellos',
        'empleais',
        'emplean',
        'emplear',
        'empleas',
        'empleo',
        'en',
        'encima',
        'entonces',
        'entre',
        'era',
        'erais',
        'eramos',
        'éramos',
        'eran',
        'erar',
        'eras',
        'eres',
        'es',
        'esa',
        'esas',
        'ese',
        'eso',
        'esos',
        'esta',
        'está',
        'estaba',
        'estabais',
        'estábamos',
        'estaban',
        'estabas',
        'estad',
        'estada',
        'estadas',
        'estado',
        'estados',
        'estais',
        'estáis',
        'estamos',
        'estan',
        'están',
        'estando',
        'estar',
        'estará',
        'estarán',
        'estarás',
        'estaré',
        'estaréis',
        'estaremos',
        'estaría',
        'estaríais',
        'estaríamos',
        'estarían',
        'estarías',
        'estas',
        'estás',
        'este',
        'esté',
        'estéis',
        'estemos',
        'estén',
        'estés',
        'esto',
        'estos',
        'estoy',
        'estuve',
        'estuviera',
        'estuvierais',
        'estuviéramos',
        'estuvieran',
        'estuvieras',
        'estuvieron',
        'estuviese',
        'estuvieseis',
        'estuviésemos',
        'estuviesen',
        'estuvieses',
        'estuvimos',
        'estuviste',
        'estuvisteis',
        'estuvo',
        'excepto',
        'fin',
        'fue',
        'fuera',
        'fuerais',
        'fuéramos',
        'fueran',
        'fueras',
        'fueron',
        'fuerza',
        'fuese',
        'fueseis',
        'fuésemos',
        'fuesen',
        'fueses',
        'fui',
        'fuimos',
        'fuiste',
        'fuisteis',
        'gueno',
        'ha',
        'habéis',
        'haber',
        'había',
        'habíais',
        'habíamos',
        'habían',
        'habías',
        'habida',
        'habidas',
        'habido',
        'habidos',
        'habiendo',
        'habrá',
        'habrán',
        'habrás',
        'habré',
        'habréis',
        'habremos',
        'habría',
        'habríais',
        'habríamos',
        'habrían',
        'habrías',
        'hace',
        'haceis',
        'hacemos',
        'hacen',
        'hacer',
        'haces',
        'hacia',
        'hago',
        'han',
        'has',
        'hasta',
        'hay',
        'haya',
        'hayáis',
        'hayamos',
        'hayan',
        'hayas',
        'haz',
        'he',
        'hemo',
        'hemos',
        'hube',
        'hubiera',
        'hubierais',
        'hubiéramos',
        'hubieran',
        'hubieras',
        'hubieron',
        'hubiese',
        'hubieseis',
        'hubiésemos',
        'hubiesen',
        'hubieses',
        'hubimos',
        'hubiste',
        'hubisteis',
        'hubo',
        'incluso',
        'intenta',
        'intentais',
        'intentamos',
        'intentan',
        'intentar',
        'intentas',
        'intento',
        'ir',
        'la',
        'largo',
        'las',
        'le',
        'les',
        'lo',
        'los',
        'más',
        'me',
        'mediante',
        'menos',
        'mi',
        'mí',
        'mía',
        'miar',
        'mías',
        'mientras',
        'mio',
        'mío',
        'míos',
        'mis',
        'modode',
        'mucho',
        'muchos',
        'muy',
        'na',
        'nada',
        'ni',
        'no',
        'nos',
        'nosotras',
        'nosotros',
        'nuestra',
        'nuestras',
        'nuestro',
        'nuestros',
        'nunca',
        'o',
        'os',
        'otra',
        'otras',
        'otro',
        'otros',
        'pa',
        'pa\'',
        'par',
        'para',
        'pero',
        'poco',
        'podeis',
        'podemos',
        'poder',
        'podria',
        'podriais',
        'podriamos',
        'podrian',
        'podrias',
        'por',
        'porque',
        'primero',
        'pro',
        'puede',
        'pueden',
        'puedo',
        'pues',
        'que',
        'qué',
        'quien',
        'quienes',
        'sabe',
        'sabeis',
        'sabemos',
        'saben',
        'saber',
        'sabes',
        'salvo',
        'se',
        'sea',
        'seáis',
        'seamos',
        'sean',
        'seas',
        'según',
        'sentid',
        'sentida',
        'sentidas',
        'sentido',
        'sentidos',
        'sentir',
        'ser',
        'será',
        'serán',
        'serás',
        'seré',
        'seréis',
        'seremos',
        'sería',
        'seríais',
        'seríamos',
        'serían',
        'serías',
        'si',
        'sí',
        'sido',
        'siendo',
        'siente',
        'sin',
        'sintiendo',
        'so',
        'sobre',
        'sois',
        'solamente',
        'solo',
        'somos',
        'son',
        'soy',
        'su',
        'sus',
        'suya',
        'suyas',
        'suyo',
        'suyos',
        'también',
        'tanto',
        'te',
        'tendrá',
        'tendrán',
        'tendrás',
        'tendré',
        'tendréis',
        'tendremos',
        'tendría',
        'tendríais',
        'tendríamos',
        'tendrían',
        'tendrías',
        'tened',
        'teneis',
        'tenéis',
        'tenemos',
        'tener',
        'tenga',
        'tengáis',
        'tengamos',
        'tengan',
        'tengas',
        'tengo',
        'tenía',
        'teníais',
        'teníamos',
        'tenían',
        'tenías',
        'tenida',
        'tenidas',
        'tenido',
        'tenidos',
        'teniendo',
        'ti',
        'tiempo',
        'tiene',
        'tienen',
        'tienes',
        'todo',
        'todos',
        'trabaja',
        'trabajais',
        'trabajamos',
        'trabajan',
        'trabajar',
        'trabajas',
        'trabajo',
        'tras',
        'tu',
        'tú',
        'tus',
        'tuve',
        'tuviera',
        'tuvierais',
        'tuviéramos',
        'tuvieran',
        'tuvieras',
        'tuvieron',
        'tuviese',
        'tuvieseis',
        'tuviésemos',
        'tuviesen',
        'tuvieses',
        'tuvimos',
        'tuviste',
        'tuvisteis',
        'tuvo',
        'tuya',
        'tuyas',
        'tuyo',
        'tuyos',
        'ultimar',
        'ultimo',
        '﻿un',
        'un',
        'una',
        'unas',
        'uno',
        'unos',
        'usa',
        'usais',
        'usamos',
        'usan',
        'usar',
        'usas',
        'uso',
        'va',
        'vais',
        'valor',
        'vamos',
        'van',
        'vaya',
        'verdad',
        'verdadera',
        'verdadero',
        'versus',
        'vía',
        'vosostras',
        'vosostros',
        'vosotras',
        'vosotros',
        'voy',
        'vuestra',
        'vuestras',
        'vuestro',
        'vuestros',
        'vusco',
        'y',
        'ya',
        'yo',
    },
    'fa': {
        'اتفاقا', 'احتراما', 'احتمالا', 'اري', 'آري', 'از', 'ازجمله',
        'اساسا', 'است', 'اش', 'اشكارا', 'آشكارا',
        'اصلا', 'اصولا', 'اغلب', 'اكثرا', 'اكنون', 'الان', 'الآن', 'البته',
        'ام', 'اما', 'امد', 'آمد', 'امدم', 'آمد',
        'امدن', 'آمدن', 'امدند', 'آمدند', 'امده', 'آمده', 'امدي', 'آمدی',
        'امديد', 'آمدید', 'امديم', 'آمدیم',
        'امروزه', 'امسال', 'امشب', 'ان', 'آن', 'اند', 'انشاالله', 'انصافا',
        'انطور', 'آنطور', 'انقدر', 'آنقدر',
        'انها', 'آنها', 'انچنان', 'آنچنان', 'انگار', 'او', 'اورد', 'آورد',
        'اوردم', 'آوردم', 'اوردن', 'آوردن',
        'اوردند', 'آوردند', 'اورده', 'آورده', 'اوردي', 'آوردی', 'اورديد',
        'آوردید', 'اورديم', 'آوردیم', 'اورم',
        'آورم', 'اورند', 'آورند', 'اوري', 'آوری', 'اوريد', 'آورید',
        'اوريم', 'آوری', 'اولا', 'اي', 'آی', 'ايا',
        'آیا', 'ايد', 'ايشان', 'ايم', 'اين', 'ايند', 'آيند', 'اينطور',
        'اينقدر', 'اينك', 'اينها', 'اينچنين',
        'اينگونه', 'ايي', 'آیی', 'اييد', 'آیید', 'اييم', 'آییم', 'اگر',
        'با', 'بار', 'بارها', 'باز', 'بازهم', 'باش',
        'باشد', 'باشم', 'باشند', 'باشي', 'باشيد', 'باشيم', 'بالاخره',
        'بالطبع', 'بايد', 'بتوان', 'بتواند', 'بتواني',
        'بتوانيم', 'بخواه', 'بخواهد', 'بخواهم', 'بخواهند', 'بخواهي',
        'بخواهيد', 'بخواهيم', 'بد', 'بدون', 'بر',
        'براحتي', 'براستي', 'براي', 'برعكس', 'بزودي', 'بسا', 'بسيار',
        'بعدا', 'بعدها', 'بعضا', 'بكن', 'بكند', 'بكنم',
        'بكنند', 'بكني', 'بكنيد', 'بكنيم', 'بلافاصله', 'بلي', 'به', 'بهتر',
        'بود', 'بودم', 'بودن', 'بودند', 'بوده',
        'بودي', 'بوديد', 'بوديم', 'بويژه', 'بي', 'بيا', 'بياب', 'بيابد',
        'بيابم', 'بيابند', 'بيابي', 'بيابيد',
        'بيابيم', 'بياور', 'بياورد', 'بياورم', 'بياورند', 'بياوري',
        'بياوريد', 'بياوريم', 'بيايد', 'بيايم', 'بيايند',
        'بيايي', 'بياييد', 'بياييم', 'بيشتر', 'بيشتري', 'بين', 'بگو',
        'بگويد', 'بگويم', 'بگويند', 'بگويي', 'بگوييد',
        'بگوييم', 'بگير', 'بگيرد', 'بگيرم', 'بگيرند', 'بگيري', 'بگيريد',
        'بگيريم', 'ت', 'تا', 'تاكنون', 'تان', 'تحت',
        'تر', 'تقريبا', 'تلويحا', 'تماما', 'تنها', 'تو', 'تواند', 'توانست',
        'توانستم', 'توانستن', 'توانستند',
        'توانسته', 'توانستي', 'توانستيم', 'توانم', 'توانند', 'تواني',
        'توانيد', 'توانيم', 'ثانيا', 'جمعا', 'حالا',
        'حتما', 'حتي', 'حداكثر', 'حدودا', 'خب', 'خصوصا', 'خلاصه', 'خواست',
        'خواستم', 'خواستن', 'خواستند', 'خواسته',
        'خواستي', 'خواستيد', 'خواستيم', 'خواهد', 'خواهم', 'خواهند',
        'خواهي', 'خواهيد', 'خواهيم', 'خوب', 'خود',
        'خودت', 'خودتان', 'خودش', 'خودشان', 'خودم', 'خودمان', 'خوشبختانه',
        'خويش', 'خويشتن', 'خير', 'داد', 'دادم',
        'دادند', 'داده', 'دادي', 'داديد', 'داديم', 'دار', 'دارد', 'دارم',
        'دارند', 'داري', 'داريد', 'داريم', 'داشت',
        'داشتم', 'داشتن', 'داشتند', 'داشته', 'داشتي', 'داشتيد', 'داشتيم',
        'دايم', 'دائم', 'دايما', 'دائما', 'در',
        'درباره', 'درمجموع', 'دريغ', 'دقيقا', 'دهد', 'دهم', 'دهند', 'دهي',
        'دهيد', 'دهيم', 'دو', 'دوباره', 'دير',
        'ديروز', 'ديگر', 'ديگري', 'را', 'راحت', 'راسا', 'رأسا', 'راستي',
        'رسما', 'رو', 'روزانه', 'روي', 'زود', 'زير',
        'سالانه', 'ساليانه', 'سرانجام', 'سريعا', 'سپس', 'شان', 'شايد',
        'شخصا', 'شد', 'شدم', 'شدن', 'شدند', 'شده',
        'شدي', 'شديد', 'شديدا', 'شديم', 'شما', 'شود', 'شوم', 'شوند',
        'شونده', 'شوي', 'شويد', 'شويم', 'صرفا', 'ضمن',
        'طبعا', 'طبيعتا', 'طور', 'طي', 'ظاهرا', 'عمدا', 'عمدتا', 'عملا',
        'غالبا', 'فردا', 'فعلا', 'فقط', 'قبلا',
        'قدري', 'قطعا', 'كاش', 'كاملا', 'كتبا', 'كجا', 'كرد', 'كردم', 'كردن',
        'كردند', 'كرده', 'كردي', 'كرديد',
        'كرديم', 'كس', 'كسي', 'كلا', 'كم', 'كماكان', 'كمتر', 'كمتري', 'كمي',
        'كن', 'كند', 'كنم', 'كنند', 'كننده',
        'كنون', 'كني', 'كنيد', 'كنيم', 'كه', 'كو', 'كي', 'لااقل', 'لطفا',
        'م', 'ما', 'مان', 'مانند', 'مبادا',
        'متاسفانه', 'متعاقبا', 'مثل', 'مثلا', 'مجاني', 'مجددا', 'مجموعا',
        'مدام', 'مستقيما', 'مسلما', 'مطمينا',
        'مطمئنا', 'معمولا', 'من', 'موقتا', 'مي', 'مگر', 'ناگاه', 'ناگهان',
        'ناگهاني', 'نبايد', 'نخواهد', 'نخواهم',
        'نخواهند', 'نخواهي', 'نخواهيد', 'نخواهيم', 'ندارد', 'ندارم',
        'ندارند', 'نداري', 'نداريد', 'نداريم', 'نداشت',
        'نداشتم', 'نداشتند', 'نداشتي', 'نداشتيد', 'نداشتيم', 'نسبتا',
        'نشده', 'نظير', 'نمي', 'نه', 'نهايتا', 'نيز',
        'نيست', 'ها', 'هاي', 'هايي', 'هر', 'هرچه', 'هست', 'هستم', 'هستند',
        'هستي', 'هستيد', 'هستيم', 'هم', 'همان',
        'همه', 'همواره', 'هميشه', 'همين', 'همچنان', 'همچنين', 'هنوز',
        'هيچ', 'هيچگاه', 'و', 'واقعا', 'ولي', 'وي',
        'ي', 'يا', 'يابد', 'يابم', 'يابند', 'يابي', 'يابيد', 'يابيم',
        'يافت', 'يافتم', 'يافتن', 'يافته', 'يافتي',
        'يافتيد', 'يافتيم', 'يقينا', 'يك', 'پارسال', 'پس', 'پيش',
        'پيشاپيش', 'پيشتر', 'چرا', 'چطور', 'چقدر', 'چنان',
        'چنانكه', 'چنانچه', 'چند', 'چنين', 'چه', 'چو', 'چون', 'چيز',
        'چگونه', 'گاه', 'گاهي', 'گرفت', 'گرفتم',
        'گرفتن', 'گرفتند', 'گرفته', 'گرفتي', 'گرفتيد', 'گرفتيم', 'گفت',
        'گفتم', 'گفتن', 'گفتند', 'گفته', 'گفتي',
        'گفتيد', 'گفتيم', 'گه', 'گهگاه', 'گه\u200cگاه', 'گو', 'گويا',
        'گويد', 'گويم', 'گويند', 'گويي', 'گوييد',
        'گوييم', 'گيرد', 'گيرم', 'گيرند', 'گيري', 'گيريد', 'گيري',
    },
    'fi': {
        'aiemmin',
        'aika',
        'aikaa',
        'aikaan',
        'aikaisemmin',
        'aikaisin',
        'aikajen',
        'aikana',
        'aikoina',
        'aikoo',
        'aikovat',
        'aina',
        'ainakaan',
        'ainakin',
        'ainoa',
        'ainoat',
        'aiomme',
        'aion',
        'aiotte',
        'aist',
        'aivan',
        'ajan',
        'älä',
        'alas',
        'alemmas',
        'älköön',
        'alkuisin',
        'alkuun',
        'alla',
        'alle',
        'aloitamme',
        'aloitan',
        'aloitat',
        'aloitatte',
        'aloitattivat',
        'aloitettava',
        'aloitettevaksi',
        'aloitettu',
        'aloitimme',
        'aloitin',
        'aloitit',
        'aloititte',
        'aloittaa',
        'aloittamatta',
        'aloitti',
        'aloittivat',
        'alta',
        'aluksi',
        'alussa',
        'alusta',
        'annettavaksi',
        'annetteva',
        'annettu',
        'antaa',
        'antamatta',
        'antoi',
        'aoua',
        'apu',
        'asia',
        'asiaa',
        'asian',
        'asiasta',
        'asiat',
        'asioiden',
        'asioihin',
        'asioita',
        'asti',
        'avuksi',
        'avulla',
        'avun',
        'avutta',
        'edellä',
        'edelle',
        'edelleen',
        'edeltä',
        'edemmäs',
        'edes',
        'edessä',
        'edestä',
        'ehkä',
        'ei',
        'eikä',
        'eilen',
        'eivät',
        'eli',
        'ellei',
        'elleivät',
        'ellemme',
        'ellen',
        'ellet',
        'ellette',
        'emme',
        'en',
        'enää',
        'enemmän',
        'eniten',
        'ennen',
        'ensi',
        'ensimmäinen',
        'ensimmäiseksi',
        'ensimmäisen',
        'ensimmäisenä',
        'ensimmäiset',
        'ensimmäisiä',
        'ensimmäisiksi',
        'ensimmäisinä',
        'ensimmäistä',
        'ensin',
        'entinen',
        'entisen',
        'entisiä',
        'entistä',
        'entisten',
        'eräät',
        'eräiden',
        'eräs',
        'eri',
        'erittäin',
        'erityisesti',
        'esi',
        'esiin',
        'esillä',
        'esimerkiksi',
        'et',
        'eteen',
        'etenkin',
        'että',
        'ette',
        'ettei',
        'halua',
        'haluaa',
        'haluamatta',
        'haluamme',
        'haluan',
        'haluat',
        'haluatte',
        'haluavat',
        'halunnut',
        'halusi',
        'halusimme',
        'halusin',
        'halusit',
        'halusitte',
        'halusivat',
        'halutessa',
        'haluton',
        'hän',
        'häneen',
        'hänellä',
        'hänelle',
        'häneltä',
        'hänen',
        'hänessä',
        'hänestä',
        'hänet',
        'he',
        'hei',
        'heidän',
        'heihin',
        'heille',
        'heiltä',
        'heissä',
        'heistä',
        'heitä',
        'helposti',
        'heti',
        'hetkellä',
        'hieman',
        'huolimatta',
        'huomenna',
        'hyvä',
        'hyvää',
        'hyvät',
        'hyviä',
        'hyvien',
        'hyviin',
        'hyviksi',
        'hyville',
        'hyviltä',
        'hyvin',
        'hyvinä',
        'hyvissä',
        'hyvistä',
        'ihan',
        'ilman',
        'ilmeisesti',
        'itse',
        'itseään',
        'itsensä',
        'ja',
        'jää',
        'jälkeen',
        'jälleen',
        'jo',
        'johon',
        'joiden',
        'joihin',
        'joiksi',
        'joilla',
        'joille',
        'joilta',
        'joissa',
        'joista',
        'joita',
        'joka',
        'jokainen',
        'jokin',
        'joko',
        'joku',
        'jolla',
        'jolle',
        'jolloin',
        'jolta',
        'jompikumpi',
        'jonka',
        'jonkin',
        'jonne',
        'joo',
        'jopa',
        'jos',
        'joskus',
        'jossa',
        'josta',
        'jota',
        'jotain',
        'joten',
        'jotenkin',
        'jotenkuten',
        'jotka',
        'jotta',
        'jouduimme',
        'jouduin',
        'jouduit',
        'jouduitte',
        'joudumme',
        'joudun',
        'joudutte',
        'joukkoon',
        'joukossa',
        'joukosta',
        'joutua',
        'joutui',
        'joutuivat',
        'joutumaan',
        'joutuu',
        'joutuvat',
        'juuri',
        'kahdeksan',
        'kahdeksannen',
        'kahdella',
        'kahdelle',
        'kahdelta',
        'kahden',
        'kahdessa',
        'kahdesta',
        'kahta',
        'kahteen',
        'kai',
        'kaiken',
        'kaikille',
        'kaikilta',
        'kaikkea',
        'kaikki',
        'kaikkia',
        'kaikkiaan',
        'kaikkialla',
        'kaikkialle',
        'kaikkialta',
        'kaikkien',
        'kaikkin',
        'kaksi',
        'kannalta',
        'kannattaa',
        'kanssa',
        'kanssaan',
        'kanssamme',
        'kanssani',
        'kanssanne',
        'kanssasi',
        'kauan',
        'kauemmas',
        'kautta',
        'kehen',
        'keiden',
        'keihin',
        'keiksi',
        'keillä',
        'keille',
        'keiltä',
        'keinä',
        'keissä',
        'keistä',
        'keitä',
        'keittä',
        'keitten',
        'keneen',
        'keneksi',
        'kenellä',
        'kenelle',
        'keneltä',
        'kenen',
        'kenenä',
        'kenessä',
        'kenestä',
        'kenet',
        'kenettä',
        'kennessästä',
        'kerran',
        'kerta',
        'kertaa',
        'kesken',
        'keskimäärin',
        'ketä',
        'ketkä',
        'kiitos',
        'kohti',
        'koko',
        'kokonaan',
        'kolmas',
        'kolme',
        'kolmen',
        'kolmesti',
        'koska',
        'koskaan',
        'kovin',
        'kuin',
        'kuinka',
        'kuitenkaan',
        'kuitenkin',
        'kuka',
        'kukaan',
        'kukin',
        'kumpainen',
        'kumpainenkaan',
        'kumpi',
        'kumpikaan',
        'kumpikin',
        'kun',
        'kuten',
        'kuuden',
        'kuusi',
        'kuutta',
        'kyllä',
        'kymmenen',
        'kyse',
        'lähekkäin',
        'lähellä',
        'lähelle',
        'läheltä',
        'lähemmäs',
        'lähes',
        'lähinnä',
        'lähtien',
        'läpi',
        'liian',
        'liki',
        'lisää',
        'lisäksi',
        'luo',
        'mahdollisimman',
        'mahdollista',
        'me',
        'meidän',
        'meillä',
        'meille',
        'melkein',
        'melko',
        'menee',
        'meneet',
        'menemme',
        'menen',
        'menet',
        'menette',
        'menevät',
        'meni',
        'menimme',
        'menin',
        'menit',
        'menivät',
        'mennessä',
        'mennyt',
        'menossa',
        'mihin',
        'mikä',
        'mikään',
        'mikäli',
        'mikin',
        'miksi',
        'milloin',
        'minä',
        'minne',
        'minun',
        'minut',
        'missä',
        'mistä',
        'mitä',
        'mitään',
        'miten',
        'moi',
        'molemmat',
        'mones',
        'monesti',
        'monet',
        'moni',
        'moniaalla',
        'moniaalle',
        'moniaalta',
        'monta',
        'muassa',
        'muiden',
        'muita',
        'muka',
        'mukaan',
        'mukaansa',
        'mukana',
        'mutta',
        'muu',
        'muualla',
        'muualle',
        'muualta',
        'muuanne',
        'muulloin',
        'muun',
        'muut',
        'muuta',
        'muutama',
        'muutaman',
        'muuten',
        'myöhemmin',
        'myös',
        'myöskään',
        'myöskin',
        'myötä',
        'näiden',
        'näin',
        'näissä',
        'näissähin',
        'näissälle',
        'näissältä',
        'näissästä',
        'näitä',
        'nämä',
        'ne',
        'neljä',
        'neljää',
        'neljän',
        'niiden',
        'niin',
        'niistä',
        'niitä',
        'noin',
        'nopeammin',
        'nopeasti',
        'nopeiten',
        'nro',
        'nuo',
        'nyt',
        'ohi',
        'oikein',
        'ole',
        'olemme',
        'olen',
        'olet',
        'olette',
        'oleva',
        'olevan',
        'olevat',
        'oli',
        'olimme',
        'olin',
        'olisi',
        'olisimme',
        'olisin',
        'olisit',
        'olisitte',
        'olisivat',
        'olit',
        'olitte',
        'olivat',
        'olla',
        'olleet',
        'olli',
        'ollut',
        'oma',
        'omaa',
        'omaan',
        'omaksi',
        'omalle',
        'omalta',
        'oman',
        'omassa',
        'omat',
        'omia',
        'omien',
        'omiin',
        'omiksi',
        'omille',
        'omilta',
        'omissa',
        'omista',
        'on',
        'onkin',
        'onko',
        'ovat',
        'päälle',
        'paikoittain',
        'paitsi',
        'pakosti',
        'paljon',
        'paremmin',
        'parempi',
        'parhaillaan',
        'parhaiten',
        'peräti',
        'perusteella',
        'pian',
        'pieneen',
        'pieneksi',
        'pienellä',
        'pienelle',
        'pieneltä',
        'pienempi',
        'pienestä',
        'pieni',
        'pienin',
        'puolesta',
        'puolestaan',
        'runsaasti',
        'saakka',
        'sadam',
        'sama',
        'samaa',
        'samaan',
        'samalla',
        'samallalta',
        'samallassa',
        'samallasta',
        'saman',
        'samat',
        'samoin',
        'sata',
        'sataa',
        'satojen',
        'se',
        'seitsemän',
        'sekä',
        'sen',
        'seuraavat',
        'siellä',
        'sieltä',
        'siihen',
        'siinä',
        'siis',
        'siitä',
        'sijaan',
        'siksi',
        'sillä',
        'silloin',
        'silti',
        'sinä',
        'sinne',
        'sinua',
        'sinulle',
        'sinulta',
        'sinun',
        'sinussa',
        'sinusta',
        'sinut',
        'sisäkkäin',
        'sisällä',
        'sitä',
        'siten',
        'sitten',
        'suoraan',
        'suuntaan',
        'suuren',
        'suuret',
        'suuri',
        'suuria',
        'suurin',
        'suurten',
        'taa',
        'täällä',
        'täältä',
        'taas',
        'taemmas',
        'tähän',
        'tahansa',
        'tai',
        'takaa',
        'takaisin',
        'takana',
        'takia',
        'tällä',
        'tällöin',
        'tämä',
        'tämän',
        'tänä',
        'tänään',
        'tänne',
        'tapauksessa',
        'tässä',
        'tästä',
        'tätä',
        'täten',
        'tavalla',
        'tavoitteena',
        'täysin',
        'täytyvät',
        'täytyy',
        'te',
        'tietysti',
        'todella',
        'toinen',
        'toisaalla',
        'toisaalle',
        'toisaalta',
        'toiseen',
        'toiseksi',
        'toisella',
        'toiselle',
        'toiselta',
        'toisemme',
        'toisen',
        'toisensa',
        'toisessa',
        'toisesta',
        'toista',
        'toistaiseksi',
        'toki',
        'tosin',
        'tuhannen',
        'tuhat',
        'tule',
        'tulee',
        'tulemme',
        'tulen',
        'tulet',
        'tulette',
        'tulevat',
        'tulimme',
        'tulin',
        'tulisi',
        'tulisimme',
        'tulisin',
        'tulisit',
        'tulisitte',
        'tulisivat',
        'tulit',
        'tulitte',
        'tulivat',
        'tulla',
        'tulleet',
        'tullut',
        'tuntuu',
        'tuo',
        'tuolla',
        'tuolloin',
        'tuolta',
        'tuonne',
        'tuskin',
        'tykö',
        'usea',
        'useasti',
        'useimmiten',
        'usein',
        'useita',
        'uudeksi',
        'uudelleen',
        'uuden',
        'uudet',
        'uusi',
        'uusia',
        'uusien',
        'uusinta',
        'uuteen',
        'uutta',
        'vaan',
        'vähän',
        'vähemmän',
        'vähintään',
        'vähiten',
        'vai',
        'vaiheessa',
        'vaikea',
        'vaikean',
        'vaikeat',
        'vaikeilla',
        'vaikeille',
        'vaikeilta',
        'vaikeissa',
        'vaikeista',
        'vaikka',
        'vain',
        'välillä',
        'varmasti',
        'varsin',
        'varsinkin',
        'varten',
        'vasta',
        'vastaan',
        'vastakkain',
        'verran',
        'vielä',
        'vierekkäin',
        'vieri',
        'viiden',
        'viime',
        'viimeinen',
        'viimeisen',
        'viimeksi',
        'viisi',
        'voi',
        'voidaan',
        'voimme',
        'voin',
        'voisi',
        'voit',
        'voitte',
        'voivat',
        'vuoden',
        'vuoksi',
        'vuosi',
        'vuosien',
        'vuosina',
        'vuotta',
        'yhä',
        'yhdeksän',
        'yhden',
        'yhdessä',
        'yhtä',
        'yhtäällä',
        'yhtäälle',
        'yhtäältä',
        'yhtään',
        'yhteen',
        'yhteensä',
        'yhteydessä',
        'yhteyteen',
        'yksi',
        'yksin',
        'yksittäin',
        'yleensä',
        'ylemmäs',
        'yli',
        'ylös',
        'ympäri',
    },
    'fr': {
        'a',
        'à',
        'ai',
        'aie',
        'aient',
        'aies',
        'ait',
        'alors',
        'amp',
        'après',
        'as',
        'attendu',
        'au',
        'aucuns',
        'auec',
        'aura',
        'aurai',
        'auraient',
        'aurais',
        'aurait',
        'auras',
        'aurez',
        'auriez',
        'aurions',
        'aurons',
        'auront',
        'aussi',
        'autre',
        'autres',
        'aux',
        'avaient',
        'avais',
        'avait',
        'avant',
        'avec',
        'avez',
        'aviez',
        'avions',
        'avoir',
        'avoir',
        'avons',
        'ayant',
        'ayante',
        'ayantes',
        'ayants',
        'ayez',
        'ayons',
        'bien',
        'bon',
        'c',
        'c.',
        'c\'',
        'ca',
        'ça',
        'ca.',
        'car',
        'ce',
        'ceci',
        'cela',
        'celà',
        'ces',
        'cet',
        'cette',
        'ceux',
        'chaque',
        'chez',
        'chose',
        'choses',
        'ci',
        'circa',
        'comme',
        'comment',
        'concernant',
        'contre',
        'd',
        'd\'',
        'dans',
        'de',
        'début',
        'dedans',
        'dehors',
        'dello',
        'depuis',
        'derrière',
        'des',
        'dès',
        'dessous',
        'dessus',
        'deux',
        'devant',
        'devers',
        'devrait',
        'dire',
        'dixit',
        'doit',
        'donc',
        'dont',
        'dos',
        'droite',
        'du',
        'durant',
        'elle',
        'elles',
        'emmi',
        'en',
        'encore',
        'endéans',
        'entenant',
        'entre',
        'envers',
        'environ',
        'es',
        'ès',
        'essai',
        'est',
        'estre',
        'et',
        'étaient',
        'étais',
        'était',
        'étant',
        'étante',
        'étantes',
        'étants',
        'état',
        'été',
        'étée',
        'étées',
        'étés',
        'êtes',
        'étiez',
        'étions',
        'être',
        'êtreau',
        'eu',
        'eue',
        'eues',
        'eûmes',
        'eurent',
        'eus',
        'eusse',
        'eussent',
        'eusses',
        'eussiez',
        'eussions',
        'eut',
        'eût',
        'eûtes',
        'eux',
        'excepté',
        'faire',
        'fait',
        'faites',
        'faut',
        'fois',
        'font',
        'force',
        'fors',
        'fûmes',
        'furent',
        'fus',
        'fusse',
        'fussent',
        'fusses',
        'fussiez',
        'fussions',
        'fut',
        'fût',
        'fûtes',
        'grande',
        'haut',
        'hormis',
        'hors',
        'ici',
        'ie',
        'il',
        'ils',
        'im',
        'j',
        'je',
        'joignant',
        'jouxte',
        'jusque',
        'juste',
        'l',
        'l\'',
        'la',
        'là',
        'le',
        'les',
        'lès',
        'leur',
        'leurs',
        'lez',
        'lors',
        'lui',
        'luy',
        'm',
        'ma',
        'maintenant',
        'mais',
        'malgré',
        'me',
        'même',
        'mes',
        'mesme',
        'mine',
        'moi',
        'moins',
        'mon',
        'mot',
        'moyennant',
        'n',
        'n\'',
        'ne',
        'ni',
        'nommés',
        'nonobstant',
        'nos',
        'notre',
        'nous',
        'nouveaux',
        'on',
        'ont',
        'or',
        'ou',
        'où',
        'outre',
        'par',
        'par-devant',
        'parce',
        'parmi',
        'parole',
        'pas',
        'passé',
        'pendant',
        'personnes',
        'peu',
        'peut',
        'pièce',
        'plein',
        'plupart',
        'plus',
        'plusieurs',
        'point',
        'pour',
        'pourquoi',
        'pourquoy',
        'puis',
        'qu',
        'qu\'',
        'quand',
        'que',
        'quel',
        'quelle',
        'quelles',
        'quels',
        'question',
        'qui',
        'quoy',
        'rez',
        's',
        's.v.',
        's/s',
        'sa',
        'sans',
        'sauf',
        'se',
        'selon',
        'sera',
        'serai',
        'seraient',
        'serais',
        'serait',
        'seras',
        'serez',
        'seriez',
        'serions',
        'serons',
        'seront',
        'ses',
        'seulement',
        'si',
        'sien',
        'soi',
        'soient',
        'sois',
        'soit',
        'sommes',
        'son',
        'sont',
        'sous',
        'soyez',
        'soyons',
        'sub',
        'suis',
        'suivant',
        'sujet',
        'sur',
        't',
        'ta',
        'tandis',
        'te',
        'tellement',
        'tels',
        'tes',
        'toi',
        'ton',
        'touchant',
        'tous',
        'tout',
        'toute',
        'toutes',
        'très',
        'trop',
        'tu',
        'un',
        'une',
        'valeur',
        'vers',
        'versus',
        'via',
        'vn',
        'vne',
        'voici',
        'voie',
        'voient',
        'voilà',
        'vont',
        'vos',
        'votre',
        'vous',
        'vs',
        'vu',
        'y',
    },
    'ga': {
        'a',
        'ach',
        'ag',
        'agus',
        'an',
        'aon',
        'ar',
        'arna',
        'as',
        "b'",
        'ba',
        'beirt',
        'bhúr',
        'caoga',
        'ceathair',
        'ceathrar',
        'chomh',
        'chtó',
        'chuig',
        'chun',
        'cois',
        'céad',
        'cúig',
        'cúigear',
        "d'",
        'daichead',
        'dar',
        'de',
        'deich',
        'deichniúr',
        'den',
        'dhá',
        'do',
        'don',
        'dtí',
        'dá',
        'dár',
        'dó',
        'faoi',
        'faoin',
        'faoina',
        'faoinár',
        'fara',
        'fiche',
        'gach',
        'gan',
        'go',
        'gur',
        'haon',
        'hocht',
        'i',
        'iad',
        'idir',
        'in',
        'ina',
        'ins',
        'inár',
        'is',
        'le',
        'leis',
        'lena',
        'lenár',
        "m'",
        'mar',
        'mo',
        'mé',
        'na',
        'nach',
        'naoi',
        'naonúr',
        'ná',
        'ní',
        'níor',
        'nó',
        'nócha',
        'ocht',
        'ochtar',
        'os',
        'roimh',
        'sa',
        'seacht',
        'seachtar',
        'seachtó',
        'seasca',
        'seisear',
        'siad',
        'sibh',
        'sinn',
        'sna',
        'sé',
        'sí',
        'tar',
        'thar',
        'thú',
        'triúr',
        'trí',
        'trína',
        'trínár',
        'tríocha',
        'tú',
        'um',
        'ár',
        'é',
        'éis',
        'í',
        'ó',
        'ón',
        'óna',
        'ónár',
    },
    'hr': {
        'a',
        'ako',
        'ali',
        'bi',
        'bih',
        'bila',
        'bili',
        'bilo',
        'bio',
        'bismo',
        'biste',
        'biti',
        'bumo',
        'da',
        'do',
        'duž',
        'ga',
        'hoće',
        'hoćemo',
        'hoćete',
        'hoćeš',
        'hoću',
        'i',
        'iako',
        'ih',
        'ili',
        'iz',
        'ja',
        'je',
        'jedna',
        'jedne',
        'jedno',
        'jer',
        'jesam',
        'jesi',
        'jesmo',
        'jest',
        'jeste',
        'jesu',
        'jim',
        'joj',
        'još',
        'ju',
        'kada',
        'kako',
        'kao',
        'koja',
        'koje',
        'koji',
        'kojima',
        'koju',
        'kroz',
        'li',
        'me',
        'mene',
        'meni',
        'mi',
        'mimo',
        'moj',
        'moja',
        'moje',
        'mu',
        'na',
        'nad',
        'nakon',
        'nam',
        'nama',
        'nas',
        'naš',
        'naša',
        'naše',
        'našeg',
        'ne',
        'nego',
        'neka',
        'neki',
        'nekog',
        'neku',
        'nema',
        'netko',
        'neće',
        'nećemo',
        'nećete',
        'nećeš',
        'neću',
        'nešto',
        'ni',
        'nije',
        'nikoga',
        'nikoje',
        'nikoju',
        'nisam',
        'nisi',
        'nismo',
        'niste',
        'nisu',
        'njega',
        'njegov',
        'njegova',
        'njegovo',
        'njemu',
        'njezin',
        'njezina',
        'njezino',
        'njih',
        'njihov',
        'njihova',
        'njihovo',
        'njim',
        'njima',
        'njoj',
        'nju',
        'no',
        'o',
        'od',
        'odmah',
        'on',
        'ona',
        'oni',
        'ono',
        'ova',
        'pa',
        'pak',
        'po',
        'pod',
        'pored',
        'prije',
        's',
        'sa',
        'sam',
        'samo',
        'se',
        'sebe',
        'sebi',
        'si',
        'smo',
        'ste',
        'su',
        'sve',
        'svi',
        'svog',
        'svoj',
        'svoja',
        'svoje',
        'svom',
        'ta',
        'tada',
        'taj',
        'tako',
        'te',
        'tebe',
        'tebi',
        'ti',
        'to',
        'toj',
        'tome',
        'tu',
        'tvoj',
        'tvoja',
        'tvoje',
        'u',
        'uz',
        'vam',
        'vama',
        'vas',
        'vaš',
        'vaša',
        'vaše',
        'već',
        'vi',
        'vrlo',
        'za',
        'zar',
        'će',
        'ćemo',
        'ćete',
        'ćeš',
        'ću',
        'što',
    },
    'hu': {
        'a',
        'át',
        'az',
        'be',
        'csak',
        'de',
        'egy',
        'el',
        'én',
        'és',
        'fel',
        'hát',
        'hogy',
        'ide',
        'igen',
        'ki',
        'le',
        'lesz',
        'meg',
        'mi',
        'mint',
        'nem',
        'õ',
        'oda',
        'õk',
        'ön',
        'össze',
        'rá',
        'szét',
        'te',
        'ti',
        'vagy',
        'van',
        'vissza',
        'volt',
    },
    'id': {
        'ada',
        'adanya',
        'adalah',
        'adapun',
        'agak',
        'agaknya',
        'agar',
        'akan',
        'akankah',
        'akhirnya',
        'aku',
        'akulah',
        'amat',
        'amatlah',
        'anda',
        'andalah',
        'antar',
        'diantaranya',
        'antara',
        'antaranya',
        'diantara',
        'apa',
        'apaan',
        'mengapa',
        'apabila',
        'apakah',
        'apalagi',
        'apatah',
        'atau',
        'ataukah',
        'ataupun',
        'bagai',
        'bagaikan',
        'sebagai',
        'sebagainya',
        'bagaimana',
        'bagaimanapun',
        'sebagaimana',
        'bagaimanakah',
        'bagi',
        'bahkan',
        'bahwa',
        'bahwasanya',
        'sebaliknya',
        'banyak',
        'sebanyak',
        'beberapa',
        'seberapa',
        'begini',
        'beginian',
        'beginikah',
        'beginilah',
        'sebegini',
        'begitu',
        'begitukah',
        'begitulah',
        'begitupun',
        'sebegitu',
        'belum',
        'belumlah',
        'sebelum',
        'sebelumnya',
        'sebenarnya',
        'berapa',
        'berapakah',
        'berapalah',
        'berapapun',
        'betulkah',
        'sebetulnya',
        'biasa',
        'biasanya',
        'bila',
        'bilakah',
        'bisa',
        'bisakah',
        'sebisanya',
        'boleh',
        'bolehkah',
        'bolehlah',
        'buat',
        'bukan',
        'bukankah',
        'bukanlah',
        'bukannya',
        'cuma',
        'percuma',
        'dahulu',
        'dalam',
        'dan',
        'dapat',
        'dari',
        'daripada',
        'dekat',
        'demi',
        'demikian',
        'demikianlah',
        'sedemikian',
        'dengan',
        'depan',
        'di',
        'dia',
        'dialah',
        'dini',
        'diri',
        'dirinya',
        'terdiri',
        'dong',
        'dulu',
        'enggak',
        'enggaknya',
        'entah',
        'entahlah',
        'terhadap',
        'terhadapnya',
        'hal',
        'hampir',
        'hanya',
        'hanyalah',
        'harus',
        'haruslah',
        'harusnya',
        'seharusnya',
        'hendak',
        'hendaklah',
        'hendaknya',
        'hingga',
        'sehingga',
        'ia',
        'ialah',
        'ibarat',
        'ingin',
        'inginkah',
        'inginkan',
        'ini',
        'inikah',
        'inilah',
        'itu',
        'itukah',
        'itulah',
        'jangan',
        'jangankan',
        'janganlah',
        'jika',
        'jikalau',
        'juga',
        'justru',
        'kala',
        'kalau',
        'kalaulah',
        'kalaupun',
        'kalian',
        'kami',
        'kamilah',
        'kamu',
        'kamulah',
        'kan',
        'kapan',
        'kapankah',
        'kapanpun',
        'dikarenakan',
        'karena',
        'karenanya',
        'ke',
        'kecil',
        'kemudian',
        'kenapa',
        'kepada',
        'kepadanya',
        'ketika',
        'seketika',
        'khususnya',
        'kini',
        'kinilah',
        'kiranya',
        'sekiranya',
        'kita',
        'kitalah',
        'kok',
        'lagi',
        'lagian',
        'selagi',
        'lah',
        'lain',
        'lainnya',
        'melainkan',
        'selaku',
        'lalu',
        'melalui',
        'terlalu',
        'lama',
        'lamanya',
        'selama',
        'selama',
        'selamanya',
        'lebih',
        'terlebih',
        'bermacam',
        'macam',
        'semacam',
        'maka',
        'makanya',
        'makin',
        'malah',
        'malahan',
        'mampu',
        'mampukah',
        'mana',
        'manakala',
        'manalagi',
        'masih',
        'masihkah',
        'semasih',
        'masing',
        'mau',
        'maupun',
        'semaunya',
        'memang',
        'mereka',
        'merekalah',
        'meski',
        'meskipun',
        'semula',
        'mungkin',
        'mungkinkah',
        'nah',
        'namun',
        'nanti',
        'nantinya',
        'nyaris',
        'oleh',
        'olehnya',
        'seorang',
        'seseorang',
        'pada',
        'padanya',
        'padahal',
        'paling',
        'sepanjang',
        'pantas',
        'sepantasnya',
        'sepantasnyalah',
        'para',
        'pasti',
        'pastilah',
        'per',
        'pernah',
        'pula',
        'pun',
        'merupakan',
        'rupanya',
        'serupa',
        'saat',
        'saatnya',
        'sesaat',
        'saja',
        'sajalah',
        'saling',
        'bersama',
        'sama',
        'sesama',
        'sambil',
        'sampai',
        'sana',
        'sangat',
        'sangatlah',
        'saya',
        'sayalah',
        'se',
        'sebab',
        'sebabnya',
        'sebuah',
        'tersebut',
        'tersebutlah',
        'sedang',
        'sedangkan',
        'sedikit',
        'sedikitnya',
        'segala',
        'segalanya',
        'segera',
        'sesegera',
        'sejak',
        'sejenak',
        'sekali',
        'sekalian',
        'sekalipun',
        'sesekali',
        'sekaligus',
        'sekarang',
        'sekarang',
        'sekitar',
        'sekitarnya',
        'sela',
        'selain',
        'selalu',
        'seluruh',
        'seluruhnya',
        'semakin',
        'sementara',
        'sempat',
        'semua',
        'semuanya',
        'sendiri',
        'sendirinya',
        'seolah',
        'seperti',
        'sepertinya',
        'sering',
        'seringnya',
        'serta',
        'siapa',
        'siapakah',
        'siapapun',
        'disini',
        'disinilah',
        'sini',
        'sinilah',
        'sesuatu',
        'sesuatunya',
        'suatu',
        'sesudah',
        'sesudahnya',
        'sudah',
        'sudahkah',
        'sudahlah',
        'supaya',
        'tadi',
        'tadinya',
        'tak',
        'tanpa',
        'setelah',
        'telah',
        'tentang',
        'tentu',
        'tentulah',
        'tentunya',
        'tertentu',
        'seterusnya',
        'tapi',
        'tetapi',
        'setiap',
        'tiap',
        'setidaknya',
        'tidak',
        'tidakkah',
        'tidaklah',
        'toh',
        'waduh',
        'wah',
        'wahai',
        'sewaktu',
        'walau',
        'walaupun',
        'wong',
        'yaitu',
        'yakni',
        'yang',
    },
    'it': {
        'a',
        'a mezzo',
        'accanto',
        'ad',
        'agli',
        'ai',
        'al',
        'alcun',
        'alcuno',
        'all\'',
        'alla',
        'alle',
        'allo',
        'altra',
        'altre',
        'altri',
        'altro',
        'appo',
        'assai',
        'avere',
        'avverso',
        'bene',
        'c\'',
        'ch\'',
        'che',
        'chi',
        'ci',
        'cio',
        'co\'',
        'cogli',
        'coi',
        'col',
        'colla',
        'colle',
        'collo',
        'come',
        'con',
        'contro',
        'cosi',
        'd\'',
        'da',
        'dai',
        'dal',
        'dall\'',
        'dalla',
        'dalle',
        'dallo',
        'de',
        'de\'',
        'degli',
        'dei',
        'del',
        'dell\'',
        'della',
        'delle',
        'dello',
        'dentro',
        'di',
        'dopo',
        'duo',
        'durante',
        'e',
        'eccetto',
        'ed',
        'egli',
        'entro',
        'essere',
        'et',
        'fino',
        'fra',
        'fuori',
        'gia',
        'gia',
        'gli',
        'gran',
        'grande',
        'i',
        'il',
        'in',
        'indi',
        'infra',
        'io',
        'l\'',
        'la',
        'le',
        'li',
        'lo',
        'ma',
        'maggior',
        'maggiore',
        'mai',
        'malgrado',
        'meco',
        'mio',
        'molto',
        'ne',
        'ne\'',
        'negli',
        'nei',
        'nel',
        'nell\'',
        'nella',
        'nelle',
        'nello',
        'non',
        'nonostante',
        'o',
        'ogn\'',
        'ogni',
        'oh',
        'oltre',
        'oue',
        'ove',
        'pegli',
        'pei',
        'pel',
        'pella',
        'pello',
        'per',
        'perche',
        'piu',
        'piu',
        'poco',
        'poi',
        'puo',
        'pur',
        'qual',
        'qualche',
        'qualcun',
        'qualcuno',
        'quale',
        'qualmente',
        'quanta',
        'quante',
        'quanti',
        'quanto',
        'quasi',
        'quella',
        'quelle',
        'quelli',
        'quello',
        'questa',
        'queste',
        'questi',
        'questo',
        'qui',
        's\'',
        'salvo',
        'se',
        'seco',
        'secondo',
        'sempre',
        'senza',
        'si',
        'sopra',
        'sotto',
        'su',
        'sù',
        'sua',
        'sue',
        'sugli',
        'sui',
        'sul',
        'sulla',
        'sulle',
        'sullo',
        'suo',
        'tal',
        'tanta',
        'tante',
        'tanti',
        'tanto',
        'teco',
        'tra',
        'tramite',
        'tranne',
        'tre',
        'tutta',
        'tutte',
        'tutti',
        'tutto',
        'un',
        'una',
        'uno',
        'verso',
        'vn',
        'vna',
        'vno',
    },
    'lt': {
        'á',
        'ákypai',
        'ástriþai',
        'ðájá',
        'ðalia',
        'ðe',
        'ðiàjà',
        'ðiàja',
        'ðiàsias',
        'ðiøjø',
        'ðiøjø',
        'ði',
        'ðiaisiais',
        'ðiajai',
        'ðiajam',
        'ðiajame',
        'ðiapus',
        'ðiedvi',
        'ðieji',
        'ðiesiems',
        'ðioji',
        'ðiojo',
        'ðiojoje',
        'ðiokia',
        'ðioks',
        'ðiosiomis',
        'ðiosioms',
        'ðiosios',
        'ðiosios',
        'ðiosiose',
        'ðis',
        'ðisai',
        'ðit',
        'ðita',
        'ðitas',
        'ðitiedvi',
        'ðitokia',
        'ðitoks',
        'ðituodu',
        'ðiuodu',
        'ðiuoju',
        'ðiuosiuose',
        'ðiuosius',
        'ðtai',
        'þemiau',
        'að',
        'abi',
        'abidvi',
        'abiejø',
        'abiejose',
        'abiejuose',
        'abiem',
        'abigaliai',
        'abipus',
        'abu',
        'abudu',
        'ai',
        'anàjà',
        'anàjá',
        'anàja',
        'anàsias',
        'anøjø',
        'anøjø',
        'ana',
        'ana',
        'anaiptol',
        'anaisiais',
        'anajai',
        'anajam',
        'anajame',
        'anapus',
        'anas',
        'anasai',
        'anasis',
        'anei',
        'aniedvi',
        'anieji',
        'aniesiems',
        'anoji',
        'anojo',
        'anojoje',
        'anokia',
        'anoks',
        'anosiomis',
        'anosioms',
        'anosios',
        'anosios',
        'anosiose',
        'anot',
        'ant',
        'antai',
        'anuodu',
        'anuoju',
        'anuosiuose',
        'anuosius',
        'apie',
        'aplink',
        'ar',
        'ar',
        'arba',
        'argi',
        'arti',
        'aukðèiau',
        'be',
        'be',
        'bei',
        'beje',
        'bemaþ',
        'bent',
        'bet',
        'betgi',
        'beveik',
        'dëka',
        'dël',
        'dëlei',
        'dëlto',
        'dar',
        'dargi',
        'daugmaþ',
        'deja',
        'ech',
        'et',
        'gal',
        'galbût',
        'galgi',
        'gan',
        'gana',
        'gi',
        'greta',
        'ið',
        'iðilgai',
        'iðvis',
        'idant',
        'iki',
        'iki',
        'ir',
        'irgi',
        'it',
        'itin',
        'jàjà',
        'jàja',
        'jàsias',
        'jájá',
        'jøjø',
        'jøjø',
        'jûsø',
        'jûs',
        'jûsiðkë',
        'jûsiðkis',
        'jaisiais',
        'jajai',
        'jajam',
        'jajame',
        'jei',
        'jeigu',
        'ji',
        'jiedu',
        'jiedvi',
        'jieji',
        'jiesiems',
        'jinai',
        'jis',
        'jisai',
        'jog',
        'joji',
        'jojo',
        'jojoje',
        'jokia',
        'joks',
        'josiomis',
        'josioms',
        'josios',
        'josios',
        'josiose',
        'judu',
        'judvi',
        'juk',
        'jumis',
        'jums',
        'jumyse',
        'juodu',
        'juoju',
        'juosiuose',
        'juosius',
        'jus',
        'kaþin',
        'kaþkas',
        'kaþkatra',
        'kaþkatras',
        'kaþkokia',
        'kaþkoks',
        'kaþkuri',
        'kaþkuris',
        'kad',
        'kada',
        'kadangi',
        'kai',
        'kaip',
        'kaip',
        'kaipgi',
        'kas',
        'katra',
        'katras',
        'katriedvi',
        'katruodu',
        'kiaurai',
        'kiek',
        'kiekvienas',
        'kieno',
        'kita',
        'kitas',
        'kitokia',
        'kitoks',
        'kodël',
        'kokia',
        'koks',
        'kol',
        'kolei',
        'kone',
        'kuomet',
        'kur',
        'kurgi',
        'kuri',
        'kuriedvi',
        'kuris',
        'kuriuodu',
        'lai',
        'lig',
        'ligi',
        'link',
        'lyg',
        'mûsø',
        'mûsiðkë',
        'mûsiðkis',
        'maþdaug',
        'maþne',
        'manàjà',
        'manàjá',
        'manàja',
        'manàsias',
        'manæs',
        'manøjø',
        'manøjø',
        'man',
        'manaisiais',
        'manajai',
        'manajam',
        'manajame',
        'manas',
        'manasai',
        'manasis',
        'mane',
        'maniðkë',
        'maniðkis',
        'manieji',
        'maniesiems',
        'manim',
        'manimi',
        'mano',
        'manoji',
        'manojo',
        'manojoje',
        'manosiomis',
        'manosioms',
        'manosios',
        'manosios',
        'manosiose',
        'manuoju',
        'manuosiuose',
        'manuosius',
        'manyje',
        'mat',
        'mes',
        'mudu',
        'mudvi',
        'mumis',
        'mums',
        'mumyse',
        'mus',
        'në',
        'na',
        'nagi',
        'ne',
        'nebe',
        'nebent',
        'nebent',
        'negi',
        'negu',
        'nei',
        'nei',
        'nejau',
        'nejaugi',
        'nekaip',
        'nelyginant',
        'nes',
        'net',
        'netgi',
        'netoli',
        'neva',
        'nors',
        'nors',
        'nuo',
        'o',
        'ogi',
        'ogi',
        'oi',
        'paèiø',
        'paèiais',
        'paèiam',
        'paèiame',
        'paèiu',
        'paèiuose',
        'paèius',
        'paeiliui',
        'pagal',
        'pakeliui',
        'palaipsniui',
        'palei',
        'pas',
        'pasak',
        'paskos',
        'paskui',
        'paskum',
        'patá',
        'pat',
        'pati',
        'patiems',
        'paties',
        'pats',
        'patys',
        'per',
        'per',
        'pernelyg',
        'pirm',
        'pirma',
        'pirmiau',
        'po',
        'prieð',
        'prieðais',
        'prie',
        'pro',
        'pusiau',
        'rasi',
        'rodos',
        'sau',
        'savàjà',
        'savàjá',
        'savàja',
        'savàsias',
        'savæs',
        'savøjø',
        'savøjø',
        'savaisiais',
        'savajai',
        'savajam',
        'savajame',
        'savas',
        'savasai',
        'savasis',
        'save',
        'saviðkë',
        'saviðkis',
        'savieji',
        'saviesiems',
        'savimi',
        'savo',
        'savoji',
        'savojo',
        'savojoje',
        'savosiomis',
        'savosioms',
        'savosios',
        'savosios',
        'savosiose',
        'savuoju',
        'savuosiuose',
        'savuosius',
        'savyje',
        'skersai',
        'skradþiai',
        'staèiai',
        'su',
        'sulig',
        'tàjà',
        'tàjá',
        'tàja',
        'tàsias',
        'tøjø',
        'tøjø',
        'tûlas',
        'taèiau',
        'ta',
        'tad',
        'tai',
        'tai',
        'taigi',
        'taigi',
        'taip',
        'taipogi',
        'taisiais',
        'tajai',
        'tajam',
        'tajame',
        'tamsta',
        'tarp',
        'tarsi',
        'tarsi',
        'tartum',
        'tartum',
        'tarytum',
        'tas',
        'tasai',
        'tau',
        'tavàjà',
        'tavàjá',
        'tavàja',
        'tavàsias',
        'tavæs',
        'tavøjø',
        'tavøjø',
        'tavaisiais',
        'tavajai',
        'tavajam',
        'tavajame',
        'tavas',
        'tavasai',
        'tavasis',
        'tave',
        'taviðkë',
        'taviðkis',
        'tavieji',
        'taviesiems',
        'tavimi',
        'tavo',
        'tavoji',
        'tavojo',
        'tavojoje',
        'tavosiomis',
        'tavosioms',
        'tavosios',
        'tavosios',
        'tavosiose',
        'tavuoju',
        'tavuosiuose',
        'tavuosius',
        'tavyje',
        'te',
        'tegu',
        'tegu',
        'tegul',
        'tegul',
        'tiedvi',
        'tieji',
        'ties',
        'tiesiems',
        'tiesiog',
        'tik',
        'tik',
        'tikriausiai',
        'tiktai',
        'tiktai',
        'toji',
        'tojo',
        'tojoje',
        'tokia',
        'toks',
        'tol',
        'tolei',
        'toliau',
        'tosiomis',
        'tosioms',
        'tosios',
        'tosios',
        'tosiose',
        'tu',
        'tuodu',
        'tuoju',
        'tuosiuose',
        'tuosius',
        'turbût',
        'uþ',
        'uþtat',
        'uþvis',
        'vël',
        'vëlgi',
        'va',
        'vai',
        'viduj',
        'vidury',
        'vien',
        'vienas',
        'vienokia',
        'vienoks',
        'vietoj',
        'virð',
        'virðuj',
        'virðum',
        'vis',
        'vis dëlto',
        'visa',
        'visas',
        'visgi',
        'visokia',
        'visoks',
        'vos',
        'vos',
        'ypaè',
    },
    'lv': {
        'ārpus',
        'šaipus',
        'aiz',
        'ap',
        'apakš',
        'apakšpus',
        'arī',
        'ar',
        'ar',
        'augšpus',
        'būšu',
        'būs',
        'būsi',
        'būsiet',
        'būsim',
        'būt',
        'bet',
        'bez',
        'bijām',
        'bijāt',
        'bija',
        'biji',
        'biju',
        'caur',
        'dēļ',
        'diemžēl',
        'diezin',
        'droši',
        'esam',
        'esat',
        'esi',
        'esmu',
        'gan',
        'gar',
        'iekām',
        'iekāms',
        'iekš',
        'iekšpus',
        'iekam',
        'iekams',
        'ik',
        'ir',
        'it',
        'itin',
        'iz',
        'jā',
        'ja',
        'jau',
        'jebšu',
        'jeb',
        'jel',
        'jo',
        'kā',
        'kļūšu',
        'kļūs',
        'kļūsi',
        'kļūsiet',
        'kļūsim',
        'kļūst',
        'kļūstam',
        'kļūstat',
        'kļūsti',
        'kļūstu',
        'kļūt',
        'kļuvām',
        'kļuvāt',
        'kļuva',
        'kļuvi',
        'kļuvu',
        'ka',
        'kamēr',
        'kaut',
        'kolīdz',
        'kopš',
        'līdz',
        'līdzko',
        'labad',
        'lai',
        'lejpus',
        'nē',
        'ne',
        'nebūt',
        'nedz',
        'nekā',
        'nevis',
        'nezin',
        'no',
        'nu',
        'otrpus',
        'pār',
        'pēc',
        'pa',
        'par',
        'pat',
        'pie',
        'pirms',
        'pret',
        'priekš',
        'starp',
        'tā',
        'tādēļ',
        'tālab',
        'tāpēc',
        'taču',
        'tad',
        'tak',
        'tapāt',
        'tapšu',
        'tapi',
        'taps',
        'tapsi',
        'tapsiet',
        'tapsim',
        'tapt',
        'te',
        'tiec',
        'tiek',
        'tiekam',
        'tiekat',
        'tieku',
        'tikām',
        'tikāt',
        'tikšu',
        'tik',
        'tika',
        'tikai',
        'tiki',
        'tikko',
        'tiklīdz',
        'tiklab',
        'tiks',
        'tiksiet',
        'tiksim',
        'tikt',
        'tiku',
        'tikvien',
        'tomēr',
        'topat',
        'turpretī',
        'turpretim',
        'un',
        'uz',
        'vai',
        'varēšu',
        'varējām',
        'varējāt',
        'varēja',
        'varēji',
        'varēju',
        'varēs',
        'varēsi',
        'varēsiet',
        'varēsim',
        'varēt',
        'var',
        'varat',
        'viņpus',
        'vien',
        'vien',
        'virs',
        'virspus',
        'vis',
        'zem',
    },
    'nl': {
        'aan',
        'af',
        'al',
        'als',
        'bij',
        'dan',
        'dat',
        'die',
        'dit',
        'een',
        'en',
        'er',
        'had',
        'heb',
        'hem',
        'het',
        'hij',
        'hoe',
        'hun',
        'ik',
        'in',
        'is',
        'je',
        'kan',
        'me',
        'men',
        'met',
        'mij',
        'nog',
        'nu',
        'of',
        'ons',
        'ook',
        'te',
        'tot',
        'uit',
        'van',
        'was',
        'wat',
        'we',
        'wel',
        'wij',
        'zal',
        'ze',
        'zei',
        'zij',
        'zo',
        'zou',
    },
    'no': {
        'Å',
        'alle',
        'andre',
        'arbeid',
        'av',
        'begge',
        'bort',
        'bra',
        'bruke',
        'da',
        'denne',
        'der',
        'deres',
        'det',
        'din',
        'disse',
        'du',
        'eller',
        'en',
        'ene',
        'eneste',
        'enhver',
        'enn',
        'er',
        'et',
        'fÅ',
        'folk',
        'for',
        'fordi',
        'forsÛke',
        'fra',
        'fÛr',
        'fÛrst',
        'gÅ',
        'gjorde',
        'gjÛre',
        'god',
        'ha',
        'hadde',
        'han',
        'hans',
        'hennes',
        'her',
        'hva',
        'hvem',
        'hver',
        'hvilken',
        'hvis',
        'hvor',
        'hvordan',
        'hvorfor',
        'i',
        'ikke',
        'inn',
        'innen',
        'kan',
        'kunne',
        'lage',
        'lang',
        'lik',
        'like',
        'mÅ',
        'makt',
        'mange',
        'mÅte',
        'med',
        'meg',
        'meget',
        'men',
        'mens',
        'mer',
        'mest',
        'min',
        'mye',
        'nÅ',
        'nÅr',
        'navn',
        'nei',
        'ny',
        'og',
        'ogsÅ',
        'om',
        'opp',
        'oss',
        'over',
        'pÅ',
        'part',
        'punkt',
        'rett',
        'riktig',
        'sÅ',
        'samme',
        'sant',
        'si',
        'siden',
        'sist',
        'skulle',
        'slik',
        'slutt',
        'som',
        'start',
        'stille',
        'tid',
        'til',
        'tilbake',
        'tilstand',
        'under',
        'ut',
        'uten',
        'var',
        'vÅr',
        'ved',
        'verdi',
        'vi',
        'vil',
        'ville',
        'vite',
        'vÖre',
        'vÖrt',
    },
    'pl': {
        'a',
        'aby',
        'ach',
        'acz',
        'aczkolwiek',
        'aj',
        'albo',
        'ale',
        'ależ',
        'aż',
        'bardziej',
        'bardzo',
        'będą',
        'będzie',
        'bez',
        'bo',
        'bowiem',
        'by',
        'być',
        'był',
        'była',
        'byli',
        'było',
        'były',
        'bynajmniej',
        'cała',
        'cali',
        'cały',
        'ci',
        'cię',
        'ciebie',
        'co',
        'cokolwiek',
        'coś',
        'czasami',
        'czasem',
        'czemu',
        'czy',
        'czyli',
        'daleko',
        'dla',
        'dlaczego',
        'dlatego',
        'do',
        'dobrze',
        'dokąd',
        'dość',
        'dużo',
        'dwa',
        'dwaj',
        'dwie',
        'dwoje',
        'dziś',
        'dzisiaj',
        'gdy',
        'gdyby',
        'gdyż',
        'gdzie',
        'gdziekolwiek',
        'gdzieś',
        'go',
        'i',
        'ich',
        'ile',
        'im',
        'inna',
        'inne',
        'inny',
        'innych',
        'iż',
        'ja',
        'ją',
        'jak',
        'jakaś',
        'jakby',
        'jaki',
        'jakichś',
        'jakie',
        'jakiś',
        'jakiż',
        'jakkolwiek',
        'jako',
        'jakoś',
        'je',
        'jeden',
        'jedna',
        'jednak',
        'jednakże',
        'jedno',
        'jego',
        'jej',
        'jemu',
        'jeśli',
        'jest',
        'jestem',
        'jeszcze',
        'jeżeli',
        'już',
        'każdy',
        'kiedy',
        'kierunku',
        'kilka',
        'kimś',
        'kto',
        'ktokolwiek',
        'która',
        'które',
        'którego',
        'której',
        'który',
        'których',
        'którym',
        'którzy',
        'ktoś',
        'ku',
        'lat',
        'lecz',
        'lub',
        'ma',
        'mają',
        'mam',
        'mi',
        'między',
        'mimo',
        'mną',
        'mnie',
        'mogą',
        'moi',
        'moim',
        'mój',
        'moja',
        'moje',
        'może',
        'możliwe',
        'można',
        'mu',
        'musi',
        'my',
        'na',
        'nad',
        'nam',
        'nami',
        'nas',
        'nasi',
        'nasz',
        'nasza',
        'nasze',
        'naszego',
        'naszych',
        'natomiast',
        'natychmiast',
        'nawet',
        'nią',
        'nic',
        'nich',
        'nie',
        'niego',
        'niej',
        'niemu',
        'nigdy',
        'nim',
        'nimi',
        'niż',
        'no',
        'o',
        'obok',
        'od',
        'około',
        'on',
        'ona',
        'one',
        'oni',
        'ono',
        'oraz',
        'owszem',
        'pan',
        'pana',
        'pani',
        'po',
        'pod',
        'podczas',
        'pomimo',
        'ponad',
        'ponieważ',
        'powinien',
        'powinna',
        'powinni',
        'powinno',
        'poza',
        'prawie',
        'przecież',
        'przed',
        'przede',
        'przedtem',
        'przez',
        'przy',
        'roku',
        'również',
        'są',
        'sam',
        'sama',
        'się',
        'skąd',
        'sobą',
        'sobie',
        'sposób',
        'swoje',
        'ta',
        'tak',
        'taka',
        'taki',
        'takie',
        'także',
        'tam',
        'te',
        'tego',
        'tej',
        'ten',
        'teraz',
        'też',
        'to',
        'tobą',
        'tobie',
        'toteż',
        'totobą',
        'trzeba',
        'tu',
        'tutaj',
        'twoi',
        'twoim',
        'twój',
        'twoja',
        'twoje',
        'twym',
        'ty',
        'tych',
        'tylko',
        'tym',
        'u',
        'w',
        'wam',
        'wami',
        'was',
        'wasi',
        'wasz',
        'wasza',
        'wasze',
        'we',
        'według',
        'więc',
        'więcej',
        'wiele',
        'wielu',
        'właśnie',
        'wszyscy',
        'wszystkich',
        'wszystkie',
        'wszystkim',
        'wszystko',
        'wtedy',
        'wy',
        'z',
        'za',
        'żaden',
        'żadna',
        'żadne',
        'żadnych',
        'zapewne',
        'zawsze',
        'że',
        'żeby',
        'zeznowu',
        'znów',
        'został',
    },
    'pt': {
        'a',
        'afora',
        'ante',
        'após',
        'até',
        'cara',
        'com',
        'como',
        'connosco',
        'consoante',
        'contra',
        'de',
        'desde',
        'diante',
        'durante',
        'em',
        'entre',
        'escontra',
        'excepto',
        'exceto',
        'fora',
        'in',
        'inté',
        'malgrado',
        'mediante',
        'menos',
        'para',
        'per',
        'pera',
        'perante',
        'por',
        'pra',
        'prà',
        'salvante',
        'salvo',
        'segundo',
        'sem',
        'senão',
        'sob',
        'sobre',
        'suso',
        'tirante',
        'trás',
        'via',
        'está',
        'estamos',
        'estão',
        'estive',
        'esteve',
        'estivemos',
        'estiveram',
        'estava',
        'estávamos',
        'estavam',
        'estivera',
        'estivéramos',
        'esteja',
        'estejamos',
        'estejam',
        'estivesse',
        'estivéssemos',
        'estivessem',
        'estiver',
        'estivermos',
        'estiverem',
        'hei',
        'há',
        'havemos',
        'hão',
        'houve',
        'houvemos',
        'houveram',
        'houvera',
        'houvéramos',
        'haja',
        'hajamos',
        'hajam',
        'houvesse',
        'houvéssemos',
        'houvessem',
        'houver',
        'houvermos',
        'houverem',
        'houverei',
        'houverá',
        'houveremos',
        'houverão',
        'houveria',
        'houveríamos',
        'houveriam',
        'sou',
        'somos',
        'são',
        'era',
        'éramos',
        'eram',
        'fui',
        'foi',
        'fomos',
        'foram',
        'fora',
        'fôramos',
        'seja',
        'sejamos',
        'sejam',
        'fosse',
        'fôssemos',
        'fossem',
        'for',
        'formos',
        'forem',
        'serei',
        'será',
        'seremos',
        'serão',
        'seria',
        'seríamos',
        'seriam',
        'tenho',
        'tem',
        'temos',
        'tém',
        'tinha',
        'tínhamos',
        'tinham',
        'tive',
        'teve',
        'tivemos',
        'tiveram',
        'tivera',
        'tivéramos',
        'tenha',
        'tenhamos',
        'tenham',
        'tivesse',
        'tivéssemos',
        'tivessem',
        'tiver',
        'tivermos',
        'tiverem',
        'terei',
        'terá',
        'teremos',
        'terão',
        'teria',
        'teríamos',
        'teriam',
    },
    'ro': {
        'acea',
        'aceasta',
        'această',
        'aceea',
        'acei',
        'aceia',
        'acel',
        'acela',
        'acele',
        'acelea',
        'acest',
        'acesta',
        'aceste',
        'acestea',
        'aceşti',
        'aceştia',
        'acolo',
        'acord',
        'acum',
        'ai',
        'aia',
        'aibă',
        'aici',
        'al',
        'ăla',
        'ale',
        'alea',
        'ălea',
        'altceva',
        'altcineva',
        'am',
        'ar',
        'are',
        'aş',
        'aşadar',
        'asemenea',
        'asta',
        'ăsta',
        'astăzi',
        'astea',
        'ăstea',
        'ăştia',
        'asupra',
        'aţi',
        'au',
        'avea',
        'avem',
        'aveţi',
        'azi',
        'bine',
        'bucur',
        'bună',
        'ca',
        'că',
        'căci',
        'când',
        'care',
        'cărei',
        'căror',
        'cărui',
        'cât',
        'câte',
        'câţi',
        'către',
        'câtva',
        'caut',
        'ce',
        'cel',
        'ceva',
        'chiar',
        'cinci',
        'cînd',
        'cine',
        'cineva',
        'cît',
        'cîte',
        'cîţi',
        'cîtva',
        'contra',
        'cu',
        'cum',
        'cumva',
        'curând',
        'curînd',
        'da',
        'dă',
        'dacă',
        'dar',
        'dată',
        'datorită',
        'dau',
        'de',
        'deci',
        'deja',
        'deoarece',
        'departe',
        'deşi',
        'din',
        'dinaintea',
        'dintr-',
        'dintre',
        'doi',
        'doilea',
        'două',
        'drept',
        'după',
        'ea',
        'ei',
        'el',
        'ele',
        'eram',
        'este',
        'eşti',
        'eu',
        'face',
        'fără',
        'fata',
        'fi',
        'fie',
        'fiecare',
        'fii',
        'fim',
        'fiţi',
        'fiu',
        'frumos',
        'graţie',
        'halbă',
        'iar',
        'ieri',
        'îi',
        'îl',
        'îmi',
        'împotriva',
        'în',
        'înainte',
        'înaintea',
        'încât',
        'încît',
        'încotro',
        'între',
        'întrucât',
        'întrucît',
        'îţi',
        'la',
        'lângă',
        'le',
        'li',
        'lîngă',
        'lor',
        'lui',
        'mă',
        'mai',
        'mâine',
        'mea',
        'mei',
        'mele',
        'mereu',
        'meu',
        'mi',
        'mie',
        'mîine',
        'mine',
        'mult',
        'multă',
        'mulţi',
        'mulţumesc',
        'ne',
        'nevoie',
        'nicăieri',
        'nici',
        'nimeni',
        'nimeri',
        'nimic',
        'nişte',
        'noastră',
        'noastre',
        'noi',
        'noroc',
        'noştri',
        'nostru',
        'nouă',
        'nu',
        'opt',
        'ori',
        'oricând',
        'oricare',
        'oricât',
        'orice',
        'oricînd',
        'oricine',
        'oricît',
        'oricum',
        'oriunde',
        'până',
        'patra',
        'patru',
        'patrulea',
        'pe',
        'pentru',
        'peste',
        'pic',
        'pînă',
        'poate',
        'pot',
        'prea',
        'prima',
        'primul',
        'prin',
        'puţin',
        'puţina',
        'puţină',
        'rog',
        'sa',
        'să',
        'săi',
        'sale',
        'şapte',
        'şase',
        'sau',
        'său',
        'se',
        'şi',
        'sînt',
        'sîntem',
        'sînteţi',
        'spate',
        'spre',
        'ştiu',
        'sub',
        'sunt',
        'suntem',
        'sunteţi',
        'sută',
        'ta',
        'tăi',
        'tale',
        'tău',
        'te',
        'ţi',
        'ţie',
        'timp',
        'tine',
        'toată',
        'toate',
        'tot',
        'toţi',
        'totuşi',
        'trei',
        'treia',
        'treilea',
        'tu',
        'un',
        'una',
        'unde',
        'undeva',
        'unei',
        'uneia',
        'unele',
        'uneori',
        'unii',
        'unor',
        'unora',
        'unu',
        'unui',
        'unuia',
        'unul',
        'vă',
        'vi',
        'voastră',
        'voastre',
        'voi',
        'voştri',
        'vostru',
        'vouă',
        'vreme',
        'vreo',
        'vreun',
        'zece',
        'zero',
        'zi',
        'zice',
    },
    'ru': {
        'а',
        'алло',
        'без',
        'близко',
        'более',
        'больше',
        'будем',
        'будет',
        'будете',
        'будешь',
        'будто',
        'буду',
        'будут',
        'будь',
        'бы',
        'бывает',
        'бывь',
        'был',
        'была',
        'были',
        'было',
        'быть',
        'в',
        'важная',
        'важное',
        'важные',
        'важный',
        'вам',
        'вами',
        'вас',
        'ваш',
        'ваша',
        'ваше',
        'ваши',
        'вверх',
        'вдали',
        'вдруг',
        'ведь',
        'везде',
        'весь',
        'вниз',
        'внизу',
        'во',
        'вокруг',
        'вон',
        'восемнадцатый',
        'восемнадцать',
        'восемь',
        'восьмой',
        'вот',
        'впрочем',
        'времени',
        'время',
        'все',
        'всё',
        'всегда',
        'всего',
        'всем',
        'всеми',
        'всему',
        'всех',
        'всею',
        'всю',
        'всюду',
        'вся',
        'второй',
        'вы',
        'г',
        'где',
        'говорил',
        'говорит',
        'год',
        'года',
        'году',
        'да',
        'давно',
        'даже',
        'далеко',
        'дальше',
        'даром',
        'два',
        'двадцатый',
        'двадцать',
        'две',
        'двенадцатый',
        'двенадцать',
        'двух',
        'девятнадцатый',
        'девятнадцать',
        'девятый',
        'девять',
        'действительно',
        'дел',
        'день',
        'десятый',
        'десять',
        'для',
        'до',
        'довольно',
        'долго',
        'должно',
        'другая',
        'другие',
        'других',
        'друго',
        'другое',
        'другой',
        'е',
        'его',
        'ее',
        'её',
        'ей',
        'ему',
        'если',
        'есть',
        'еще',
        'ещё',
        'ею',
        'ж',
        'же',
        'жизнь',
        'за',
        'занят',
        'занята',
        'занято',
        'заняты',
        'затем',
        'зато',
        'зачем',
        'здесь',
        'значит',
        'и',
        'из',
        'или',
        'им',
        'именно',
        'иметь',
        'ими',
        'имя',
        'иногда',
        'их',
        'к',
        'каждая',
        'каждое',
        'каждые',
        'каждый',
        'кажется',
        'как',
        'какая',
        'какой',
        'кем',
        'когда',
        'кого',
        'ком',
        'кому',
        'конечно',
        'которая',
        'которого',
        'которой',
        'которые',
        'который',
        'которых',
        'кроме',
        'кругом',
        'кто',
        'куда',
        'лет',
        'ли',
        'лишь',
        'лучше',
        'люди',
        'м',
        'мало',
        'между',
        'меля',
        'менее',
        'меньше',
        'меня',
        'миллионов',
        'мимо',
        'мира',
        'мне',
        'много',
        'многочисленная',
        'многочисленное',
        'многочисленные',
        'многочисленный',
        'мной',
        'мною',
        'мог',
        'могут',
        'моё',
        'мож',
        'может',
        'можно',
        'можхо',
        'мои',
        'мой',
        'мор',
        'мочь',
        'моя',
        'мы',
        'на',
        'наверху',
        'над',
        'надо',
        'назад',
        'наиболее',
        'наконец',
        'нам',
        'нами',
        'нас',
        'начала',
        'наш',
        'наша',
        'наше',
        'наши',
        'не',
        'него',
        'недавно',
        'недалеко',
        'нее',
        'неё',
        'ней',
        'нельзя',
        'нем',
        'немного',
        'нему',
        'непрерывно',
        'нередко',
        'несколько',
        'нет',
        'нею',
        'ни',
        'нибудь',
        'ниже',
        'низко',
        'никогда',
        'никуда',
        'ними',
        'них',
        'ничего',
        'но',
        'ну',
        'нужно',
        'нх',
        'о',
        'об',
        'оба',
        'обычно',
        'один',
        'одиннадцатый',
        'одиннадцать',
        'однажды',
        'однако',
        'одного',
        'одной',
        'около',
        'он',
        'она',
        'они',
        'оно',
        'опять',
        'особенно',
        'от',
        'отовсюду',
        'отсюда',
        'очень',
        'первый',
        'перед',
        'по',
        'под',
        'пожалуйста',
        'позже',
        'пока',
        'пор',
        'пора',
        'после',
        'посреди',
        'потом',
        'потому',
        'почему',
        'почти',
        'прекрасно',
        'при',
        'про',
        'просто',
        'против',
        'процентов',
        'пятнадцатый',
        'пятнадцать',
        'пятый',
        'пять',
        'раз',
        'разве',
        'рано',
        'раньше',
        'рядом',
        'с',
        'сам',
        'сама',
        'сами',
        'самим',
        'самими',
        'самих',
        'само',
        'самого',
        'самой',
        'самом',
        'самому',
        'саму',
        'свое',
        'своего',
        'своей',
        'свои',
        'своих',
        'свою',
        'сеаой',
        'себе',
        'себя',
        'сегодня',
        'седьмой',
        'сейчас',
        'семнадцатый',
        'семнадцать',
        'семь',
        'сих',
        'сказал',
        'сказала',
        'сказать',
        'сколько',
        'слишком',
        'сначала',
        'снова',
        'со',
        'собой',
        'собою',
        'совсем',
        'спасибо',
        'стал',
        'суть',
        'т',
        'та',
        'так',
        'такая',
        'также',
        'такие',
        'такое',
        'такой',
        'там',
        'твоё',
        'твой',
        'твоя',
        'те',
        'тебе',
        'тебя',
        'тем',
        'теми',
        'теперь',
        'тех',
        'то',
        'тобой',
        'тобою',
        'тогда',
        'того',
        'тоже',
        'только',
        'том',
        'тому',
        'тот',
        'тою',
        'третий',
        'три',
        'тринадцатый',
        'тринадцать',
        'ту',
        'туда',
        'тут',
        'ты',
        'тысяч',
        'у',
        'уж',
        'уже',
        'уметь',
        'хорошо',
        'хотеть',
        'хоть',
        'хотя',
        'хочешь',
        'часто',
        'чаще',
        'чего',
        'человек',
        'чем',
        'чему',
        'через',
        'четвертый',
        'четыре',
        'четырнадцатый',
        'четырнадцать',
        'что',
        'чтоб',
        'чтобы',
        'чуть',
        'шестнадцатый',
        'шестнадцать',
        'шестой',
        'шесть',
        'эта',
        'эти',
        'этим',
        'этими',
        'этих',
        'это',
        'этого',
        'этой',
        'этом',
        'этому',
        'этот',
        'эту',
        'я',
    },
    'sk': {
        'a',
        'aby',
        'aj',
        'ak',
        'ako',
        'ale',
        'alebo',
        'and',
        'ani',
        'áno',
        'asi',
        'až',
        'bez',
        'bol',
        'bola',
        'boli',
        'bolo',
        'buď',
        'bude',
        'budem',
        'budeme',
        'budeš',
        'budete',
        'budú',
        'by',
        'byť',
        'cez',
        'či',
        'čo',
        'ďalší',
        'ďalšia',
        'ďalšie',
        'dnes',
        'do',
        'ešte',
        'for',
        'ho',
        'i',
        'iba',
        'ich',
        'iné',
        'iný',
        'ja',
        'je',
        'jeho',
        'jej',
        'ju',
        'k',
        'kam',
        'každá',
        'každé',
        'každí',
        'každý',
        'kde',
        'keď',
        'kto',
        'ktorá',
        'ktoré',
        'ktorí',
        'ktorou',
        'ktorý',
        'ku',
        'lebo',
        'len',
        'ma',
        'má',
        'mať',
        'máte',
        'medzi',
        'menej',
        'mi',
        'mna',
        'mne',
        'mnou',
        'môcť',
        'môj',
        'moja',
        'moje',
        'môže',
        'musieť',
        'my',
        'na',
        'nad',
        'nám',
        'náš',
        'naši',
        'nech',
        'než',
        'nič',
        'nie',
        'niektorý',
        'nová',
        'nové',
        'noví',
        'nový',
        'o',
        'od',
        'odo',
        'of',
        'on',
        'ona',
        'oni',
        'ono',
        'ony',
        'po',
        'pod',
        'podľa',
        'pokiaľ',
        'potom',
        'práve',
        'pre',
        'prečo',
        'pred',
        'predo',
        'preto',
        'pretože',
        'pri',
        'prvá',
        'prvé',
        'prví',
        'prvý',
        'pýta',
        's',
        'sa',
        'si',
        'sme',
        'so',
        'som',
        'späť',
        'ste',
        'sú',
        'svoj',
        'svoje',
        'svojich',
        'svojím',
        'svojími',
        'ta',
        'tá',
        'tak',
        'takže',
        'tam',
        'táto',
        'te',
        'tě',
        'teda',
        'ten',
        'tento',
        'the',
        'tieto',
        'tiež',
        'to',
        'toho',
        'tohoto',
        'tom',
        'tomto',
        'tomuto',
        'toto',
        'tu',
        'tú',
        'túto',
        'tvoj',
        'tvojími',
        'ty',
        'tým',
        'týmto',
        'už',
        'v',
        'vám',
        'váš',
        'vaše',
        'viac',
        'vo',
        'však',
        'všetok',
        'vy',
        'z',
        'za',
        'že',
        'zo',
    },
    'sv': {
        'aderton',
        'adertonde',
        'adjö',
        'aldrig',
        'alla',
        'allas',
        'allt',
        'alltid',
        'alltså',
        'än',
        'andra',
        'andras',
        'annan',
        'annat',
        'ännu',
        'artonde',
        'artonn',
        'åtminstone',
        'att',
        'åtta',
        'åttio',
        'åttionde',
        'åttonde',
        'av',
        'även',
        'båda',
        'bådas',
        'bakom',
        'bara',
        'bäst',
        'bättre',
        'behöva',
        'behövas',
        'behövde',
        'behövt',
        'beslut',
        'beslutat',
        'beslutit',
        'bland',
        'blev',
        'bli',
        'blir',
        'blivit',
        'bort',
        'borta',
        'bra',
        'då',
        'dag',
        'dagar',
        'dagarna',
        'dagen',
        'där',
        'därför',
        'de',
        'del',
        'delen',
        'dem',
        'den',
        'deras',
        'dess',
        'det',
        'detta',
        'dig',
        'din',
        'dina',
        'dit',
        'ditt',
        'dock',
        'du',
        'efter',
        'eftersom',
        'elfte',
        'eller',
        'elva',
        'en',
        'enkel',
        'enkelt',
        'enkla',
        'enligt',
        'er',
        'era',
        'ert',
        'ett',
        'ettusen',
        'få',
        'fanns',
        'får',
        'fått',
        'fem',
        'femte',
        'femtio',
        'femtionde',
        'femton',
        'femtonde',
        'fick',
        'fin',
        'finnas',
        'finns',
        'fjärde',
        'fjorton',
        'fjortonde',
        'fler',
        'flera',
        'flesta',
        'följande',
        'för',
        'före',
        'förlåt',
        'förra',
        'första',
        'fram',
        'framför',
        'från',
        'fyra',
        'fyrtio',
        'fyrtionde',
        'gå',
        'gälla',
        'gäller',
        'gällt',
        'går',
        'gärna',
        'gått',
        'genast',
        'genom',
        'gick',
        'gjorde',
        'gjort',
        'god',
        'goda',
        'godare',
        'godast',
        'gör',
        'göra',
        'gott',
        'ha',
        'hade',
        'haft',
        'han',
        'hans',
        'har',
        'här',
        'heller',
        'hellre',
        'helst',
        'helt',
        'henne',
        'hennes',
        'hit',
        'hög',
        'höger',
        'högre',
        'högst',
        'hon',
        'honom',
        'hundra',
        'hundraen',
        'hundraett',
        'hur',
        'i',
        'ibland',
        'idag',
        'igår',
        'igen',
        'imorgon',
        'in',
        'inför',
        'inga',
        'ingen',
        'ingenting',
        'inget',
        'innan',
        'inne',
        'inom',
        'inte',
        'inuti',
        'ja',
        'jag',
        'jämfört',
        'kan',
        'kanske',
        'knappast',
        'kom',
        'komma',
        'kommer',
        'kommit',
        'kr',
        'kunde',
        'kunna',
        'kunnat',
        'kvar',
        'länge',
        'längre',
        'långsam',
        'långsammare',
        'långsammast',
        'långsamt',
        'längst',
        'långt',
        'lätt',
        'lättare',
        'lättast',
        'legat',
        'ligga',
        'ligger',
        'lika',
        'likställd',
        'likställda',
        'lilla',
        'lite',
        'liten',
        'litet',
        'man',
        'många',
        'måste',
        'med',
        'mellan',
        'men',
        'mer',
        'mera',
        'mest',
        'mig',
        'min',
        'mina',
        'mindre',
        'minst',
        'mitt',
        'mittemot',
        'möjlig',
        'möjligen',
        'möjligt',
        'möjligtvis',
        'mot',
        'mycket',
        'någon',
        'någonting',
        'något',
        'några',
        'när',
        'nästa',
        'ned',
        'nederst',
        'nedersta',
        'nedre',
        'nej',
        'ner',
        'ni',
        'nio',
        'nionde',
        'nittio',
        'nittionde',
        'nitton',
        'nittonde',
        'nödvändig',
        'nödvändiga',
        'nödvändigt',
        'nödvändigtvis',
        'nog',
        'noll',
        'nr',
        'nu',
        'nummer',
        'och',
        'också',
        'ofta',
        'oftast',
        'olika',
        'olikt',
        'om',
        'oss',
        'över',
        'övermorgon',
        'överst',
        'övre',
        'på',
        'rakt',
        'rätt',
        'redan',
        'så',
        'sade',
        'säga',
        'säger',
        'sagt',
        'samma',
        'sämre',
        'sämst',
        'sedan',
        'senare',
        'senast',
        'sent',
        'sex',
        'sextio',
        'sextionde',
        'sexton',
        'sextonde',
        'sig',
        'sin',
        'sina',
        'sist',
        'sista',
        'siste',
        'sitt',
        'sjätte',
        'sju',
        'sjunde',
        'sjuttio',
        'sjuttionde',
        'sjutton',
        'sjuttonde',
        'ska',
        'skall',
        'skulle',
        'slutligen',
        'små',
        'smått',
        'snart',
        'som',
        'stor',
        'stora',
        'större',
        'störst',
        'stort',
        'tack',
        'tidig',
        'tidigare',
        'tidigast',
        'tidigt',
        'till',
        'tills',
        'tillsammans',
        'tio',
        'tionde',
        'tjugo',
        'tjugoen',
        'tjugoett',
        'tjugonde',
        'tjugotre',
        'tjugotvå',
        'tjungo',
        'tolfte',
        'tolv',
        'tre',
        'tredje',
        'trettio',
        'trettionde',
        'tretton',
        'trettonde',
        'två',
        'tvåhundra',
        'under',
        'upp',
        'ur',
        'ursäkt',
        'ut',
        'utan',
        'utanför',
        'ute',
        'vad',
        'vänster',
        'vänstra',
        'var',
        'vår',
        'vara',
        'våra',
        'varför',
        'varifrån',
        'varit',
        'varken',
        'värre',
        'varsågod',
        'vart',
        'vårt',
        'vem',
        'vems',
        'verkligen',
        'vi',
        'vid',
        'vidare',
        'viktig',
        'viktigare',
        'viktigast',
        'viktigt',
        'vilka',
        'vilken',
        'vilket',
        'vill',
    },
    'tr': {
        'acaba',
        'altmýþ',
        'altý',
        'ama',
        'bana',
        'bazý',
        'belki',
        'ben',
        'benden',
        'beni',
        'benim',
        'beþ',
        'bin',
        'bir',
        'biri',
        'birkaç',
        'birkez',
        'birþey',
        'birþeyi',
        'biz',
        'bizden',
        'bizi',
        'bizim',
        'bu',
        'buna',
        'bunda',
        'bundan',
        'bunu',
        'bunun',
        'da',
        'daha',
        'dahi',
        'de',
        'defa',
        'diye',
        'doksan',
        'dokuz',
        'dört',
        'elli',
        'en',
        'gibi',
        'hem',
        'hep',
        'hepsi',
        'her',
        'hiç',
        'iki',
        'ile',
        'INSERmi',
        'ise',
        'için',
        'katrilyon',
        'kez',
        'ki',
        'kim',
        'kimden',
        'kime',
        'kimi',
        'kýrk',
        'milyar',
        'milyon',
        'mu',
        'mü',
        'mý',
        'nasýl',
        'ne',
        'neden',
        'nerde',
        'nerede',
        'nereye',
        'niye',
        'niçin',
        'on',
        'ona',
        'ondan',
        'onlar',
        'onlardan',
        'onlari',
        'onlarýn',
        'onu',
        'otuz',
        'sanki',
        'sekiz',
        'seksen',
        'sen',
        'senden',
        'seni',
        'senin',
        'siz',
        'sizden',
        'sizi',
        'sizin',
        'trilyon',
        'tüm',
        've',
        'veya',
        'ya',
        'yani',
        'yedi',
        'yetmiþ',
        'yirmi',
        'yüz',
        'çok',
        'çünkü',
        'üç',
        'þey',
        'þeyden',
        'þeyi',
        'þeyler',
        'þu',
        'þuna',
        'þunda',
        'þundan',
        'þunu',
    },
    'uk': {
        'a',
        'або',
        'адже',
        'аж',
        'але',
        'ало',
        'б',
        'багато',
        'без',
        'безперервно',
        'більш',
        'більше',
        'близько',
        'був',
        'буває',
        'буде',
        'будемо',
        'будете',
        'будеш',
        'буду',
        'будуть',
        'будь',
        'будь',
        'була',
        'були',
        'було',
        'бути',
        'в',
        'важлива',
        'важливе',
        'важливий',
        'важливі',
        'вам',
        'вами',
        'вас',
        'ваш',
        'ваша',
        'ваше',
        'ваші',
        'вгору',
        'вдалині',
        'весь',
        'вже',
        'ви',
        'від',
        'відсотків',
        'він',
        'вісім',
        'вісімнадцятий',
        'вісімнадцять',
        'вміти',
        'вниз',
        'внизу',
        'вона',
        'вони',
        'воно',
        'восьмий',
        'все',
        'всею',
        'всім',
        'всіх',
        'всього',
        'всьому',
        'всю',
        'вся',
        'втім',
        'г',
        'геть',
        'говорив',
        'давно',
        'далеко',
        'далі',
        'даром',
        'два',
        'двадцятий',
        'двадцять',
        'дванадцятий',
        'дванадцять',
        'дві',
        'двох',
        'де',
        'дев\'ятий',
        'дев\'ятнадцятий',
        'дев\'ятнадцять',
        'дев\'ять',
        'день',
        'десятий',
        'десять',
        'дійсно',
        'для',
        'до',
        'добре',
        'довго',
        'досить',
        'другий',
        'друго',
        'дуже',
        'дякую',
        'е',
        'є',
        'ж',
        'життя',
        'з',
        'за',
        'завжди',
        'зазвичай',
        'зайнята',
        'зайнятий',
        'зайняті',
        'зайнято',
        'занадто',
        'зараз',
        'зате',
        'звичайно',
        'звідси',
        'звідусіль',
        'здається',
        'зі',
        'значить',
        'знову',
        'зовсім',
        'і',
        'її',
        'їй',
        'їм',
        'ім\'я',
        'іноді',
        'інша',
        'інше',
        'інший',
        'інших',
        'інші',
        'їх',
        'його',
        'йому',
        'каже',
        'какая',
        'ким',
        'кілька',
        'кого',
        'кожен',
        'кожна',
        'кожне',
        'кожні',
        'коли',
        'кому',
        'краще',
        'крім',
        'кругом',
        'куди',
        'ледве',
        'лише',
        'люди',
        'людина',
        'м',
        'майже',
        'мало',
        'мати',
        'мене',
        'мені',
        'менше',
        'ми',
        'миру',
        'міг',
        'між',
        'мій',
        'мільйонів',
        'мною',
        'могти',
        'моє',
        'мож',
        'може',
        'можна',
        'можна',
        'можуть',
        'мої',
        'моя',
        'на',
        'навіть',
        'навіщо',
        'навколо',
        'нагорі',
        'над',
        'назад',
        'найбільш',
        'нам',
        'нами',
        'нарешті',
        'нас',
        'наш',
        'наша',
        'наше',
        'наші',
        'не',
        'небудь',
        'недалеко',
        'неї',
        'немає',
        'нерідко',
        'нещодавно',
        'нею',
        'нижче',
        'низько',
        'ними',
        'них',
        'ні',
        'ніби',
        'ніж',
        'ній',
        'ніколи',
        'нікуди',
        'нічого',
        'ну',
        'нх',
        'нього',
        'обидва',
        'один',
        'одинадцятий',
        'одинадцять',
        'однак',
        'однієї',
        'одного',
        'одногоразу',
        'особливо',
        'ось',
        'п\'ятий',
        'п\'ятнадцятий',
        'п\'ятнадцять',
        'п\'ять',
        'перед',
        'перший',
        'під',
        'пізніше',
        'пір',
        'після',
        'по',
        'повинно',
        'поки',
        'пора',
        'поруч',
        'посеред',
        'потім',
        'потрібно',
        'початку',
        'прекрасно',
        'при',
        'про',
        'просто',
        'проти',
        'раз',
        'раніше',
        'рано',
        'раптом',
        'рік',
        'років',
        'року',
        'році',
        'сам',
        'сама',
        'саме',
        'самим',
        'самими',
        'самих',
        'самі',
        'самій',
        'самого',
        'самому',
        'саму',
        'свого',
        'своє',
        'своєї',
        'свої',
        'своїх',
        'свою',
        'себе',
        'сих',
        'сім',
        'сімнадцятий',
        'сімнадцять',
        'сказав',
        'сказала',
        'сказати',
        'скільки',
        'скрізь',
        'собі',
        'собою',
        'спасибі',
        'спочатку',
        'справ',
        'став',
        'сторінка',
        'суть',
        'сьогодні',
        'сьомий',
        'т',
        'та',
        'так',
        'така',
        'таке',
        'такий',
        'такі',
        'також',
        'там',
        'твій',
        'твоє',
        'твоя',
        'тебе',
        'теж',
        'тепер',
        'ти',
        'тим',
        'тими',
        'тисяч',
        'тих',
        'ті',
        'тільки',
        'то',
        'тобі',
        'тобою',
        'того',
        'тоді',
        'той',
        'тому',
        'тою',
        'треба',
        'третій',
        'три',
        'тринадцятий',
        'тринадцять',
        'трохи',
        'ту',
        'туди',
        'тут',
        'у',
        'усіма',
        'усюди',
        'хіба',
        'хотіти',
        'хоч',
        'хоча',
        'хочеш',
        'хто',
        'це',
        'цей',
        'цим',
        'цими',
        'цих',
        'ці',
        'цієї',
        'цього',
        'цьому',
        'цю',
        'ця',
        'час',
        'частіше',
        'часто',
        'часу',
        'через',
        'четвертий',
        'чи',
        'численна',
        'численне',
        'численний',
        'численні',
        'чого',
        'чому',
        'чотири',
        'чотирнадцятий',
        'чотирнадцять',
        'чудово',
        'шістнадцятий',
        'шістнадцять',
        'шість',
        'шостий',
        'ще',
        'що',
        'щоб',
        'я',
        'як',
        'яка',
        'який',
        'яких',
        'які',
        'якого',
        'якої',
        'якщо',
    },
}

_STOPWORDS.update({'bs': _STOPWORDS['hr']})

STOPWORDS = freeze(_STOPWORDS)
