/*
 *    Copyright 2024 Han Li and contributors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package shim

// Shim is a struct that contains the binary path and output path which is used to generate the shim.
type Shim struct {
	BinaryPath string
	OutputPath string
}

// NewShim creates a new Shim instance.
func NewShim(binaryPath, outputPath string) *Shim {
	return &Shim{
		BinaryPath: binaryPath,
		OutputPath: outputPath,
	}
}
