/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { securityGetFirewallConfig } from "../funcs/securityGetFirewallConfig.js";
import { securityPutFirewallConfig } from "../funcs/securityPutFirewallConfig.js";
import { securityUpdateAttackChallengeMode } from "../funcs/securityUpdateAttackChallengeMode.js";
import { securityUpdateFirewallConfig } from "../funcs/securityUpdateFirewallConfig.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import {
  GetFirewallConfigRequest,
  GetFirewallConfigResponseBody,
} from "../models/operations/getfirewallconfig.js";
import {
  PutFirewallConfigRequest,
  PutFirewallConfigResponseBody,
} from "../models/operations/putfirewallconfig.js";
import {
  UpdateAttackChallengeModeRequest,
  UpdateAttackChallengeModeResponseBody,
} from "../models/operations/updateattackchallengemode.js";
import {
  UpdateFirewallConfigRequest,
  UpdateFirewallConfigResponseBody,
} from "../models/operations/updatefirewallconfig.js";
import { unwrapAsync } from "../types/fp.js";

export class Security extends ClientSDK {
  /**
   * Update Attack Challenge mode
   *
   * @remarks
   * Update the setting for determining if the project has Attack Challenge mode enabled.
   */
  async updateAttackChallengeMode(
    request: UpdateAttackChallengeModeRequest,
    options?: RequestOptions,
  ): Promise<UpdateAttackChallengeModeResponseBody> {
    return unwrapAsync(securityUpdateAttackChallengeMode(
      this,
      request,
      options,
    ));
  }

  /**
   * Put Firewall Configuration
   *
   * @remarks
   * Set the firewall configuration to provided rules and settings. Creates or overwrite the existing firewall configuration.
   */
  async putFirewallConfig(
    request: PutFirewallConfigRequest,
    options?: RequestOptions,
  ): Promise<PutFirewallConfigResponseBody> {
    return unwrapAsync(securityPutFirewallConfig(
      this,
      request,
      options,
    ));
  }

  /**
   * Update Firewall Configuration
   *
   * @remarks
   * Process updates to modify the existing firewall config for a project
   */
  async updateFirewallConfig(
    request: UpdateFirewallConfigRequest,
    options?: RequestOptions,
  ): Promise<UpdateFirewallConfigResponseBody> {
    return unwrapAsync(securityUpdateFirewallConfig(
      this,
      request,
      options,
    ));
  }

  /**
   * Read Firewall Configuration
   *
   * @remarks
   * Retrieve the specified firewall configuration for a project. The deployed configVersion will be `active`
   */
  async getFirewallConfig(
    request: GetFirewallConfigRequest,
    options?: RequestOptions,
  ): Promise<GetFirewallConfigResponseBody> {
    return unwrapAsync(securityGetFirewallConfig(
      this,
      request,
      options,
    ));
  }
}
