/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { projectMembersAddProjectMember } from "../funcs/projectMembersAddProjectMember.js";
import { projectMembersGetProjectMembers } from "../funcs/projectMembersGetProjectMembers.js";
import { projectMembersRemoveProjectMember } from "../funcs/projectMembersRemoveProjectMember.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import {
  AddProjectMemberRequest,
  AddProjectMemberResponseBody,
} from "../models/operations/addprojectmember.js";
import {
  GetProjectMembersRequest,
  GetProjectMembersResponseBody,
} from "../models/operations/getprojectmembers.js";
import {
  RemoveProjectMemberRequest,
  RemoveProjectMemberResponseBody,
} from "../models/operations/removeprojectmember.js";
import { unwrapAsync } from "../types/fp.js";

export class ProjectMembers extends ClientSDK {
  /**
   * List project members
   *
   * @remarks
   * Lists all members of a project.
   */
  async getProjectMembers(
    request: GetProjectMembersRequest,
    options?: RequestOptions,
  ): Promise<GetProjectMembersResponseBody> {
    return unwrapAsync(projectMembersGetProjectMembers(
      this,
      request,
      options,
    ));
  }

  /**
   * Adds a new member to a project.
   *
   * @remarks
   * Adds a new member to the project.
   */
  async addProjectMember(
    request: AddProjectMemberRequest,
    options?: RequestOptions,
  ): Promise<AddProjectMemberResponseBody> {
    return unwrapAsync(projectMembersAddProjectMember(
      this,
      request,
      options,
    ));
  }

  /**
   * Remove a Project Member
   *
   * @remarks
   * Remove a member from a specific project
   */
  async removeProjectMember(
    request: RemoveProjectMemberRequest,
    options?: RequestOptions,
  ): Promise<RemoveProjectMemberResponseBody> {
    return unwrapAsync(projectMembersRemoveProjectMember(
      this,
      request,
      options,
    ));
  }
}
