/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { integrationsDeleteConfiguration } from "../funcs/integrationsDeleteConfiguration.js";
import { integrationsGetConfiguration } from "../funcs/integrationsGetConfiguration.js";
import { integrationsGetConfigurations } from "../funcs/integrationsGetConfigurations.js";
import { integrationsGitNamespaces } from "../funcs/integrationsGitNamespaces.js";
import { integrationsSearchRepo } from "../funcs/integrationsSearchRepo.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import { DeleteConfigurationRequest } from "../models/operations/deleteconfiguration.js";
import {
  GetConfigurationRequest,
  GetConfigurationResponseBody,
} from "../models/operations/getconfiguration.js";
import {
  GetConfigurationsRequest,
  GetConfigurationsResponseBody,
} from "../models/operations/getconfigurations.js";
import {
  GitNamespacesRequest,
  GitNamespacesResponseBody,
} from "../models/operations/gitnamespaces.js";
import {
  SearchRepoRequest,
  SearchRepoResponseBody,
} from "../models/operations/searchrepo.js";
import { unwrapAsync } from "../types/fp.js";

export class Integrations extends ClientSDK {
  /**
   * Get configurations for the authenticated user or team
   *
   * @remarks
   * Allows to retrieve all configurations for an authenticated integration. When the `project` view is used, configurations generated for the authorization flow will be filtered out of the results.
   */
  async getConfigurations(
    request: GetConfigurationsRequest,
    options?: RequestOptions,
  ): Promise<GetConfigurationsResponseBody> {
    return unwrapAsync(integrationsGetConfigurations(
      this,
      request,
      options,
    ));
  }

  /**
   * Retrieve an integration configuration
   *
   * @remarks
   * Allows to retrieve a the configuration with the provided id in case it exists. The authenticated user or team must be the owner of the config in order to access it.
   */
  async getConfiguration(
    request: GetConfigurationRequest,
    options?: RequestOptions,
  ): Promise<GetConfigurationResponseBody> {
    return unwrapAsync(integrationsGetConfiguration(
      this,
      request,
      options,
    ));
  }

  /**
   * Delete an integration configuration
   *
   * @remarks
   * Allows to remove the configuration with the `id` provided in the parameters. The configuration and all of its resources will be removed. This includes Webhooks, LogDrains and Project Env variables.
   */
  async deleteConfiguration(
    request: DeleteConfigurationRequest,
    options?: RequestOptions,
  ): Promise<void> {
    return unwrapAsync(integrationsDeleteConfiguration(
      this,
      request,
      options,
    ));
  }

  /**
   * List git namespaces by provider
   *
   * @remarks
   * Lists git namespaces for a supported provider. Supported providers are `github`, `gitlab` and `bitbucket`. If the provider is not provided, it will try to obtain it from the user that authenticated the request.
   */
  async gitNamespaces(
    request: GitNamespacesRequest,
    options?: RequestOptions,
  ): Promise<Array<GitNamespacesResponseBody>> {
    return unwrapAsync(integrationsGitNamespaces(
      this,
      request,
      options,
    ));
  }

  /**
   * List git repositories linked to namespace by provider
   *
   * @remarks
   * Lists git repositories linked to a namespace `id` for a supported provider. A specific namespace `id` can be obtained via the `git-namespaces`  endpoint. Supported providers are `github`, `gitlab` and `bitbucket`. If the provider or namespace is not provided, it will try to obtain it from the user that authenticated the request.
   */
  async searchRepo(
    request: SearchRepoRequest,
    options?: RequestOptions,
  ): Promise<SearchRepoResponseBody> {
    return unwrapAsync(integrationsSearchRepo(
      this,
      request,
      options,
    ));
  }
}
