/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { domainsBuyDomain } from "../funcs/domainsBuyDomain.js";
import { domainsCheckDomainPrice } from "../funcs/domainsCheckDomainPrice.js";
import { domainsCheckDomainStatus } from "../funcs/domainsCheckDomainStatus.js";
import { domainsCreateOrTransferDomain } from "../funcs/domainsCreateOrTransferDomain.js";
import { domainsDeleteDomain } from "../funcs/domainsDeleteDomain.js";
import { domainsGetDomain } from "../funcs/domainsGetDomain.js";
import { domainsGetDomainConfig } from "../funcs/domainsGetDomainConfig.js";
import { domainsGetDomains } from "../funcs/domainsGetDomains.js";
import { domainsGetDomainTransfer } from "../funcs/domainsGetDomainTransfer.js";
import { domainsPatchDomain } from "../funcs/domainsPatchDomain.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import {
  BuyDomainRequest,
  BuyDomainResponse,
} from "../models/operations/buydomain.js";
import {
  CheckDomainPriceRequest,
  CheckDomainPriceResponseBody,
} from "../models/operations/checkdomainprice.js";
import {
  CheckDomainStatusRequest,
  CheckDomainStatusResponseBody,
} from "../models/operations/checkdomainstatus.js";
import {
  CreateOrTransferDomainRequest,
  CreateOrTransferDomainResponseBody,
} from "../models/operations/createortransferdomain.js";
import {
  DeleteDomainRequest,
  DeleteDomainResponseBody,
} from "../models/operations/deletedomain.js";
import {
  GetDomainRequest,
  GetDomainResponseBody,
} from "../models/operations/getdomain.js";
import {
  GetDomainConfigRequest,
  GetDomainConfigResponseBody,
} from "../models/operations/getdomainconfig.js";
import {
  GetDomainsRequest,
  GetDomainsResponseBody,
} from "../models/operations/getdomains.js";
import {
  GetDomainTransferRequest,
  GetDomainTransferResponseBody,
} from "../models/operations/getdomaintransfer.js";
import {
  PatchDomainRequest,
  PatchDomainResponseBody,
} from "../models/operations/patchdomain.js";
import { unwrapAsync } from "../types/fp.js";

export class Domains extends ClientSDK {
  /**
   * Purchase a domain
   *
   * @remarks
   * Allows to purchase the specified domain.
   */
  async buyDomain(
    request: BuyDomainRequest,
    options?: RequestOptions,
  ): Promise<BuyDomainResponse> {
    return unwrapAsync(domainsBuyDomain(
      this,
      request,
      options,
    ));
  }

  /**
   * Check the price for a domain
   *
   * @remarks
   * Check the price to purchase a domain and how long a single purchase period is.
   */
  async checkDomainPrice(
    request: CheckDomainPriceRequest,
    options?: RequestOptions,
  ): Promise<CheckDomainPriceResponseBody> {
    return unwrapAsync(domainsCheckDomainPrice(
      this,
      request,
      options,
    ));
  }

  /**
   * Check a Domain Availability
   *
   * @remarks
   * Check if a domain name is available for purchase.
   */
  async checkDomainStatus(
    request: CheckDomainStatusRequest,
    options?: RequestOptions,
  ): Promise<CheckDomainStatusResponseBody> {
    return unwrapAsync(domainsCheckDomainStatus(
      this,
      request,
      options,
    ));
  }

  /**
   * Get domain transfer info.
   *
   * @remarks
   * Fetch domain transfer availability or transfer status if a transfer is in progress.
   */
  async getDomainTransfer(
    request: GetDomainTransferRequest,
    options?: RequestOptions,
  ): Promise<GetDomainTransferResponseBody> {
    return unwrapAsync(domainsGetDomainTransfer(
      this,
      request,
      options,
    ));
  }

  /**
   * Get a Domain's configuration
   *
   * @remarks
   * Get a Domain's configuration.
   */
  async getDomainConfig(
    request: GetDomainConfigRequest,
    options?: RequestOptions,
  ): Promise<GetDomainConfigResponseBody> {
    return unwrapAsync(domainsGetDomainConfig(
      this,
      request,
      options,
    ));
  }

  /**
   * Get Information for a Single Domain
   *
   * @remarks
   * Get information for a single domain in an account or team.
   */
  async getDomain(
    request: GetDomainRequest,
    options?: RequestOptions,
  ): Promise<GetDomainResponseBody> {
    return unwrapAsync(domainsGetDomain(
      this,
      request,
      options,
    ));
  }

  /**
   * List all the domains
   *
   * @remarks
   * Retrieves a list of domains registered for the authenticated user or team. By default it returns the last 20 domains if no limit is provided.
   */
  async getDomains(
    request: GetDomainsRequest,
    options?: RequestOptions,
  ): Promise<GetDomainsResponseBody> {
    return unwrapAsync(domainsGetDomains(
      this,
      request,
      options,
    ));
  }

  /**
   * Register or transfer-in a new Domain
   *
   * @remarks
   * This endpoint is used for adding a new apex domain name with Vercel for the authenticating user. Can also be used for initiating a domain transfer request from an external Registrar to Vercel.
   */
  async createOrTransferDomain(
    request: CreateOrTransferDomainRequest,
    options?: RequestOptions,
  ): Promise<CreateOrTransferDomainResponseBody> {
    return unwrapAsync(domainsCreateOrTransferDomain(
      this,
      request,
      options,
    ));
  }

  /**
   * Update or move apex domain
   *
   * @remarks
   * Update or move apex domain.
   */
  async patchDomain(
    request: PatchDomainRequest,
    options?: RequestOptions,
  ): Promise<PatchDomainResponseBody> {
    return unwrapAsync(domainsPatchDomain(
      this,
      request,
      options,
    ));
  }

  /**
   * Remove a domain by name
   *
   * @remarks
   * Delete a previously registered domain name from Vercel. Deleting a domain will automatically remove any associated aliases.
   */
  async deleteDomain(
    request: DeleteDomainRequest,
    options?: RequestOptions,
  ): Promise<DeleteDomainResponseBody> {
    return unwrapAsync(domainsDeleteDomain(
      this,
      request,
      options,
    ));
  }
}
